/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.tydic.contract.ability.bo.ContractSignatureRecordBO;
import com.tydic.contract.busi.ContractQrySignatureRecordBusiService;
import com.tydic.contract.busi.bo.ContractQrySignatureRecordBusiReqBO;
import com.tydic.contract.busi.bo.ContractQrySignatureRecordBusiRspBO;
import com.tydic.contract.dao.CContractSignOperLogMapper;
import com.tydic.contract.po.CContractSignOperLogPO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractQrySignatureRecordBusiServiceImpl
implements ContractQrySignatureRecordBusiService {
    @Autowired
    private CContractSignOperLogMapper contractSignOperLogMapper;

    @Override
    public ContractQrySignatureRecordBusiRspBO qrySignatureRecord(ContractQrySignatureRecordBusiReqBO reqBO) {
        ContractQrySignatureRecordBusiRspBO rspBO = new ContractQrySignatureRecordBusiRspBO();
        List<CContractSignOperLogPO> signOperLogPOS = this.contractSignOperLogMapper.selectByContractId(reqBO.getContractId());
        if (CollectionUtils.isEmpty(signOperLogPOS)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        List<ContractSignatureRecordBO> collect = signOperLogPOS.stream().map(item -> {
            ContractSignatureRecordBO recordBO = new ContractSignatureRecordBO();
            BeanUtils.copyProperties((Object)item, (Object)recordBO);
            return recordBO;
        }).collect(Collectors.toList());
        this.getProcessTime(collect);
        rspBO.setSignatureRecordBOList(collect);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void getProcessTime(List<ContractSignatureRecordBO> collect) {
        for (int i = 0; i < collect.size(); ++i) {
            ContractSignatureRecordBO bo = collect.get(i);
            if (i >= collect.size() - 1) continue;
            Date date = collect.get(i + 1).getOperTime();
            long time = date.getTime() - bo.getOperTime().getTime();
            long hours = time / 3600000L;
            long lestMinutes = time % 3600000L;
            long minutes = lestMinutes / 60000L;
            long lestS = lestMinutes % 60000L;
            long s = lestS / 1000L;
            String str = "";
            if (hours > 0L) {
                str = hours + "\u5c0f\u65f6";
            }
            if (minutes > 0L) {
                str = str + minutes + "\u5206";
            } else if (StringUtils.isNotBlank((String)str)) {
                str = str + "0\u5206";
            }
            if (s > 0L) {
                str = str + s + "\u79d2";
            } else if (StringUtils.isNotBlank((String)str)) {
                str = str + "0\u79d2";
            }
            collect.get(i + 1).setProcessTimeStr(str);
            collect.get(i + 1).setProcessTime(Long.valueOf(time));
        }
    }
}

