/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.atom.ContractQueryErpAgrDetailsAtomService;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.bo.ContractQueryErpAgrDetailsAtomReqBO;
import com.tydic.contract.atom.bo.ContractQueryErpAgrDetailsAtomRspBO;
import com.tydic.contract.atom.bo.ContractQueryErpAgrDetailsContractItemInfoBO;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.busi.ContractTimingSynSelectErpBusiService;
import com.tydic.contract.busi.bo.ContractAddNewBusiReqBO;
import com.tydic.contract.busi.bo.ContractTimingSynSelectErpBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractErpImportInfoMapper;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractErpImportInfoPO;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcLegalConversionBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractTimingSynSelectErpBusiServiceImpl
implements ContractTimingSynSelectErpBusiService {
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    @Autowired
    CContractErpImportInfoMapper cContractErpImportInfoMapper;
    @Autowired
    ContractQueryErpAgrDetailsAtomService contractQueryErpAgrDetailsAtomService;
    @Autowired
    ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    private CContractInfoExtMapper cContractInfoExtMapper;

    @Override
    public ContractTimingSynSelectErpBusiRspBO updateContractTimingSynSelect(List<CContractErpImportInfoPO> req) {
        ContractTimingSynSelectErpBusiRspBO rspBO = new ContractTimingSynSelectErpBusiRspBO();
        if (!CollectionUtils.isEmpty(req)) {
            ArrayList<Long> syncPlanIds = new ArrayList<Long>();
            for (CContractErpImportInfoPO cContractErpImportInfoPO : req) {
                CContractErpImportInfoPO po = new CContractErpImportInfoPO();
                po.setUpdateTime(new Date());
                po.setId(cContractErpImportInfoPO.getId());
                try {
                    if (null != cContractErpImportInfoPO.getContractCode()) {
                        List buynerErpNos;
                        ContractInfoPO contractInfoPO = new ContractInfoPO();
                        contractInfoPO.setContractCode(cContractErpImportInfoPO.getContractCode());
                        List<ContractInfoPO> list = this.contractInfoMapper.getList(contractInfoPO);
                        Map<Object, Object> contractCodeMap = new HashMap();
                        if (!CollectionUtils.isEmpty(list) && (contractCodeMap = list.stream().collect(Collectors.groupingBy(ContractInfoPO::getContractCode))).keySet().contains(cContractErpImportInfoPO.getContractCode()) && (buynerErpNos = ((List)contractCodeMap.get(cContractErpImportInfoPO.getContractCode())).stream().filter(e -> !StringUtils.isEmpty((Object)e.getBuynerErpNo())).map(ContractInfoPO::getBuynerErpNo).collect(Collectors.toList())).contains(cContractErpImportInfoPO.getBusiOrgCode())) {
                            throw new ZTBusinessException("\u91cd\u590d\u7684\u5408\u540c\u7f16\u53f7!");
                        }
                    }
                    ContractQueryErpAgrDetailsAtomReqBO reqBO = new ContractQueryErpAgrDetailsAtomReqBO();
                    reqBO.setAgreementCode(cContractErpImportInfoPO.getContractCode());
                    reqBO.setBusiOrgCode(cContractErpImportInfoPO.getBusiOrgCode());
                    ContractQueryErpAgrDetailsAtomRspBO contractQueryErpAgrDetailsAtomRspBO = this.contractQueryErpAgrDetailsAtomService.queryErpAgrDetails(reqBO);
                    if (null != contractQueryErpAgrDetailsAtomRspBO && contractQueryErpAgrDetailsAtomRspBO.getRespCode().equals("0000")) {
                        ContractAddNewBusiReqBO contractAddNewBusiReqBO = (ContractAddNewBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)contractQueryErpAgrDetailsAtomRspBO)), ContractAddNewBusiReqBO.class));
                        long contractId = Sequence.getInstance().nextId();
                        contractAddNewBusiReqBO.setContractId(contractId);
                        ContractInfoPO insertContractPo = this.addContractInfo(contractAddNewBusiReqBO);
                        this.dealItemInfo(contractQueryErpAgrDetailsAtomRspBO.getContractItemInfoBOList(), contractAddNewBusiReqBO);
                        this.recordContractNodeOperLog(contractAddNewBusiReqBO);
                        po.setSyncStatus(1);
                        po.setSyncRemark("\u540c\u6b65\u6210\u529f");
                        if (insertContractPo != null && (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(insertContractPo.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(insertContractPo.getContractType()) && insertContractPo.getPushErpFlag() != null && insertContractPo.getPushErpFlag() == 1)) {
                            syncPlanIds.add(contractId);
                        }
                    } else {
                        po.setSyncStatus(2);
                        po.setSyncRemark(ObjectUtils.isEmpty((Object)((Object)contractQueryErpAgrDetailsAtomRspBO)) ? null : contractQueryErpAgrDetailsAtomRspBO.getRespDesc());
                    }
                }
                catch (Exception e2) {
                    po.setSyncStatus(2);
                    po.setSyncRemark(e2.getMessage());
                }
                this.cContractErpImportInfoMapper.updateByPrimaryKeySelective(po);
            }
            rspBO.setSyncPlanIds(syncPlanIds);
        }
        return rspBO;
    }

    @Override
    public void updateErpImportInfoStatus(List<CContractErpImportInfoPO> result) {
        if (!CollectionUtils.isEmpty(result)) {
            this.cContractErpImportInfoMapper.updateErpImportInfoStatus(result);
        }
    }

    private ContractInfoPO addContractInfo(ContractAddNewBusiReqBO reqBO) {
        ContractInfoPO insertContractPo = new ContractInfoPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)insertContractPo);
        insertContractPo.setUpdateUserId(reqBO.getUserId());
        insertContractPo.setUpdateUserName(reqBO.getUsername());
        insertContractPo.setUpdateTime(new Date());
        insertContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
        insertContractPo.setContractVersion(1);
        ArrayList<Integer> unitContractTypes = new ArrayList<Integer>();
        unitContractTypes.add(ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT);
        unitContractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
        unitContractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
        unitContractTypes.add(ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT);
        unitContractTypes.add(ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT);
        if (unitContractTypes.contains(insertContractPo.getContractType())) {
            insertContractPo.setContractOrgType("1");
        } else {
            insertContractPo.setContractOrgType("0");
        }
        if (null != reqBO.getContractAmount()) {
            insertContractPo.setContractAmount(MoneyUtils.yuanToHaoToLong(reqBO.getContractAmount()));
        }
        if (null != reqBO.getAmountLimit()) {
            insertContractPo.setAmountLimit(MoneyUtils.yuanToHaoToLong(reqBO.getAmountLimit()));
        }
        if (null != reqBO.getDiscussAmount()) {
            insertContractPo.setDiscussAmount(MoneyUtils.yuanToHaoToLong(reqBO.getDiscussAmount()));
        }
        if (null != reqBO.getMinAmount()) {
            insertContractPo.setMinAmount(MoneyUtils.yuanToHaoToLong(reqBO.getMinAmount()));
        }
        if (null != reqBO.getContractDeposit()) {
            insertContractPo.setContractDeposit(MoneyUtils.yuanToHaoToLong(reqBO.getContractDeposit()));
        }
        UmcEnterpriseOrgQryDetailAbilityReqBO bo = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        if (ContractConstant.ContractType.ORDER_CONTRACT.equals(reqBO.getContractType())) {
            if (StringUtils.isEmpty((Object)reqBO.getBuyerDeptCode())) {
                throw new ZTBusinessException("\u4e70\u65b9\u5355\u4f4d\u7f16\u7801\u4e3a\u7a7a!");
            }
            bo.setOrgCode(reqBO.getBuyerDeptCode());
        } else {
            if (StringUtils.isEmpty((Object)reqBO.getCreateDeptCode())) {
                throw new ZTBusinessException("\u5236\u5355\u5355\u4f4d\u7f16\u7801\u4e3a\u7a7a!");
            }
            bo.setOrgCode(reqBO.getCreateDeptCode());
        }
        UmcEnterpriseOrgQryDetailAbilityRspBO detailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(bo);
        if ("0000".equals(detailAbilityRspBO.getRespCode())) {
            if (null != detailAbilityRspBO.getUmcEnterpriseOrgDetailBO()) {
                insertContractPo.setPushLegalFlag(detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getContractPushLegalFlag());
                if (ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(reqBO.getContractType())) {
                    insertContractPo.setPushErpFlag(detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getContractPushErpFlag());
                }
                if (!CollectionUtils.isEmpty((Collection)detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getPushLegalMaterialCategorys())) {
                    List materialCategoryList = detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getPushLegalMaterialCategorys().stream().filter(e -> !StringUtils.isEmpty((Object)e.getCode())).map(UmcLegalConversionBO::getCode).collect(Collectors.toList());
                    insertContractPo.setExtFiled2(materialCategoryList.toString());
                }
                if (detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getContractCodeConfig() != null) {
                    insertContractPo.setContractCodeConfig(detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getContractCodeConfig());
                } else {
                    insertContractPo.setContractCodeConfig(1);
                }
            }
        } else {
            throw new ZTBusinessException("\u67e5\u8be2\u673a\u6784\u8be6\u60c5\u5931\u8d25" + detailAbilityRspBO.getRespDesc());
        }
        if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(reqBO.getContractType())) {
            UmcEnterpriseOrgQryDetailAbilityReqBO buyerBo = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            if (!StringUtils.isEmpty((Object)reqBO.getBuyerNo())) {
                buyerBo.setOrgCode(reqBO.getBuyerNo());
                UmcEnterpriseOrgQryDetailAbilityRspBO buyerRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(buyerBo);
                if ("0000".equals(buyerRspBO.getRespCode()) && buyerRspBO.getUmcEnterpriseOrgDetailBO() != null) {
                    Integer isPushWms = buyerRspBO.getUmcEnterpriseOrgDetailBO().getIsPushWms();
                    reqBO.setIsPushWms(isPushWms);
                }
            }
        }
        insertContractPo.setSignatureFlag(1);
        int addContractResult = this.contractInfoMapper.insertSelective(insertContractPo);
        CContractInfoExtPO infoExtPO = new CContractInfoExtPO();
        infoExtPO.setId(Sequence.getInstance().nextId());
        infoExtPO.setRelateId(reqBO.getContractId());
        infoExtPO.setCreateTime(new Date());
        infoExtPO.setCreateUserId(reqBO.getUserId());
        infoExtPO.setCreateUserCode(reqBO.getUsername());
        infoExtPO.setCreateUserName(reqBO.getName());
        infoExtPO.setUpdateTime(new Date());
        infoExtPO.setUpdateUserId(reqBO.getUserId());
        infoExtPO.setUpdateUserCode(reqBO.getUsername());
        infoExtPO.setUpdateUserName(reqBO.getName());
        infoExtPO.setIsPushWms(reqBO.getIsPushWms());
        this.cContractInfoExtMapper.insert(infoExtPO);
        return insertContractPo;
    }

    private void dealItemInfo(List<ContractQueryErpAgrDetailsContractItemInfoBO> reqBO, ContractAddNewBusiReqBO contractAddNewBusiReqBO) {
        ArrayList<ContractInfoItemTmpPO> contractInfoItemTmpPOS = new ArrayList<ContractInfoItemTmpPO>();
        ArrayList<ContractInfoItemPO> contractInfoItemPOS = new ArrayList<ContractInfoItemPO>();
        for (ContractQueryErpAgrDetailsContractItemInfoBO contractQueryErpAgrDetailsContractItemInfoBO : reqBO) {
            ContractInfoItemPO contractInfoItemPO = new ContractInfoItemPO();
            BeanUtils.copyProperties((Object)contractQueryErpAgrDetailsContractItemInfoBO, (Object)contractInfoItemPO);
            if (!StringUtils.isEmpty((Object)contractQueryErpAgrDetailsContractItemInfoBO.getMaterialDesc())) {
                contractInfoItemPO.setModel(contractQueryErpAgrDetailsContractItemInfoBO.getMaterialDesc());
            }
            if (!StringUtils.isEmpty((Object)contractQueryErpAgrDetailsContractItemInfoBO.getMaterialSpec())) {
                contractInfoItemPO.setSpec(contractQueryErpAgrDetailsContractItemInfoBO.getMaterialSpec());
            }
            contractInfoItemPO.setItemId(Sequence.getInstance().nextId());
            contractInfoItemPO.setRelateId(contractAddNewBusiReqBO.getContractId());
            contractInfoItemPO.setMaterialLongName(contractQueryErpAgrDetailsContractItemInfoBO.getMaterialDesc());
            contractInfoItemPO.setBuyerNo(contractAddNewBusiReqBO.getBuyerNo());
            contractInfoItemPO.setBuyerId(Long.valueOf(contractAddNewBusiReqBO.getBuyerNo()));
            contractInfoItemPO.setBuyerName(contractAddNewBusiReqBO.getBuyerName());
            contractInfoItemPO.setPushErpExist(1);
            contractInfoItemPOS.add(contractInfoItemPO);
        }
        if (!CollectionUtils.isEmpty(contractInfoItemPOS)) {
            int count = this.contractInfoItemMapper.insertBatch(contractInfoItemPOS);
            for (ContractInfoItemPO e : contractInfoItemPOS) {
                long saleItemId = Sequence.getInstance().nextId();
                ContractInfoItemTmpPO contractInfoItemTmpPO = (ContractInfoItemTmpPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)e), ContractInfoItemTmpPO.class);
                contractInfoItemTmpPO.setUuid(Sequence.getInstance().nextId());
                contractInfoItemTmpPO.setRelateId(contractAddNewBusiReqBO.getContractId());
                contractInfoItemTmpPO.setItemId(saleItemId);
                contractInfoItemTmpPO.setAwardNumId(null);
                contractInfoItemTmpPO.setRelateItemId(e.getItemId());
                contractInfoItemTmpPO.setDelFlag("0");
                if (contractInfoItemTmpPO.getTaxUnitPrice() != null) {
                    contractInfoItemTmpPO.setTaxUnitPrice(contractInfoItemTmpPO.getTaxUnitPrice().setScale(2, 4));
                    if (null != e.getAmount()) {
                        contractInfoItemTmpPO.setTaxAmount(contractInfoItemTmpPO.getTaxUnitPrice().multiply(new BigDecimal(e.getAmount().toString())).setScale(2, 4));
                        contractInfoItemTmpPO.setNotIncludingTaxAmount(contractInfoItemTmpPO.getUnitPriceExcludingTax().multiply(new BigDecimal(e.getAmount().toString())).setScale(2, 4));
                    }
                }
                contractInfoItemTmpPOS.add(contractInfoItemTmpPO);
            }
            if (!CollectionUtils.isEmpty(contractInfoItemTmpPOS)) {
                this.contractInfoItemTmpMapper.insertBatch(contractInfoItemTmpPOS);
            }
        }
    }

    private void recordContractNodeOperLog(ContractAddNewBusiReqBO reqBO) {
        ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
        contractRecordContractNodeOperLogAtomReqBO.setContractId(reqBO.getContractId());
        contractRecordContractNodeOperLogAtomReqBO.setNodeCode("CREATE_CONTRACT");
        contractRecordContractNodeOperLogAtomReqBO.setNodeName("\u65b0\u5efa\u5408\u540c");
        contractRecordContractNodeOperLogAtomReqBO.setOperUserId(reqBO.getUserId());
        contractRecordContractNodeOperLogAtomReqBO.setOperUserName(reqBO.getUsername());
        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
    }
}

