/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.CceContractSettlementAbilityService;
import com.tydic.contract.ability.bo.CceContractSettlementReqBO;
import com.tydic.contract.ability.bo.CceContractSettlementRspBO;
import com.tydic.contract.ability.bo.ContractSettlementDetailBo;
import com.tydic.contract.busi.bo.ContractDetailInfoBO;
import com.tydic.contract.dao.ContractHtSettlementDetailMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSettlementDetailMapper;
import com.tydic.contract.po.ContractHtSettlementDetailPO;
import com.tydic.contract.po.ContractSettlementDetailPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.CceContractSettlementAbilityService"})
public class CceContractSettlementAbilityServiceImpl
implements CceContractSettlementAbilityService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractSettlementDetailMapper contractSettlementDetailMapper;
    @Autowired
    private ContractHtSettlementDetailMapper contractHtSettlementDetailMapper;

    @PostMapping(value={"qryContractSettlement"})
    public CceContractSettlementRspBO qryContractSettlement(@RequestBody CceContractSettlementReqBO reqBO) {
        BigDecimal contractAmount;
        CceContractSettlementRspBO rspBO = new CceContractSettlementRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractDetailInfoBO contractDetailInfoBO = new ContractDetailInfoBO();
        contractDetailInfoBO.setContractId(reqBO.getContractId());
        ContractDetailInfoBO contractDetailInfo = this.contractInfoMapper.selectContractDetailInfo(contractDetailInfoBO);
        if (null == contractDetailInfo) {
            throw new ZTBusinessException("\u5408\u540c\u4e0d\u5b58\u5728");
        }
        List settlementDetailBos = new ArrayList();
        BigDecimal bigDecimal = contractAmount = null == contractDetailInfo.getContractAmount() ? BigDecimal.ZERO : BigDecimal.valueOf(contractDetailInfo.getContractAmount());
        if (null == contractDetailInfo.getOutContractId()) {
            ContractSettlementDetailPO detailPO = new ContractSettlementDetailPO();
            detailPO.setRelateId(reqBO.getContractId());
            List<ContractSettlementDetailPO> list = this.contractSettlementDetailMapper.getList(detailPO);
            if (CollectionUtils.isNotEmpty(list)) {
                settlementDetailBos = JSONArray.parseArray((String)JSONObject.toJSONString(list), ContractSettlementDetailBo.class);
                settlementDetailBos.forEach(e -> {
                    e.setContractName(contractDetailInfo.getContractName());
                    e.setContractCode(contractDetailInfo.getContractCode());
                    if (contractAmount.compareTo(BigDecimal.ZERO) > 0) {
                        e.setContractDetailAmount(contractAmount.multiply(e.getPayPercent().divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP));
                    } else {
                        e.setContractDetailAmount(BigDecimal.ZERO);
                    }
                });
                rspBO.setSettlementDetailBos(settlementDetailBos);
                return rspBO;
            }
        } else {
            ContractHtSettlementDetailPO po = new ContractHtSettlementDetailPO();
            po.setRelateId(reqBO.getContractId());
            List<ContractHtSettlementDetailPO> contractHtSettlementDetailPOList = this.contractHtSettlementDetailMapper.getList(po);
            if (contractHtSettlementDetailPOList != null && !contractHtSettlementDetailPOList.isEmpty()) {
                for (ContractHtSettlementDetailPO settlementDetailPo : contractHtSettlementDetailPOList) {
                    if (StrUtil.isEmpty((CharSequence)settlementDetailPo.getPaymentType())) continue;
                    Integer moneyType = null;
                    switch (settlementDetailPo.getPaymentType()) {
                        case "YUFK": {
                            moneyType = 0;
                            break;
                        }
                        case "ZBJ": {
                            moneyType = 1;
                            break;
                        }
                        case "YINGFK": {
                            moneyType = 2;
                        }
                    }
                    settlementDetailPo.setMoneyType(moneyType);
                }
                settlementDetailBos = JSON.parseArray((String)JSON.toJSONString(contractHtSettlementDetailPOList), ContractSettlementDetailBo.class);
                settlementDetailBos.forEach(e -> {
                    e.setContractName(contractDetailInfo.getContractName());
                    e.setContractCode(contractDetailInfo.getContractCode());
                    if (contractAmount.compareTo(BigDecimal.ZERO) > 0) {
                        e.setContractDetailAmount(contractAmount.multiply(e.getPayPercent().divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP));
                    } else {
                        e.setContractDetailAmount(BigDecimal.ZERO);
                    }
                });
            }
        }
        rspBO.setSettlementDetailBos(settlementDetailBos);
        return rspBO;
    }
}

