/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractAffirmRevocationAbilityService;
import com.tydic.contract.ability.ContractBusinessToDoComAbilityService;
import com.tydic.contract.ability.bo.ContractAffirmRevocationAbilityReqBO;
import com.tydic.contract.ability.bo.ContractAffirmRevocationAbilityRspBO;
import com.tydic.contract.ability.bo.ContractTodoBusinessWaitDoneDealAbilityReqBo;
import com.tydic.contract.busi.ContractAffirmRevocationBusiService;
import com.tydic.contract.busi.bo.ContractFreezeStatusSyncAgrBo;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractAgrMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractAgrPO;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoPO;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractAffirmRevocationAbilityService"})
public class ContractAffirmRevocationAbilityServiceImpl
implements ContractAffirmRevocationAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractAffirmRevocationAbilityServiceImpl.class);
    @Autowired
    private ContractAffirmRevocationBusiService contractAffirmRevocationBusiService;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Resource(name="syncContractFreezeStatusProvider")
    private ProxyMessageProducer syncContractFreezeStatusProvider;
    @Autowired
    private CContractAgrMapper cContractAgrMapper;
    @Value(value="${CONTRACT_FREEZE_SYNC_TOPIC}")
    private String topic;
    @Value(value="${CONTRACT_FREEZE_SYNC_TAG}")
    private String tag;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractBusinessToDoComAbilityService contractBusinessToDoComService;
    @Autowired
    private ContractBusinessToDoComAbilityService contracBusiToDoComService;
    private List<Integer> CG_KJ_XY = Arrays.asList(12, 13);
    private List<Integer> CG_HT = Arrays.asList(11, 20, 21);

    @PostMapping(value={"updateContractAffirmRevoca"})
    public ContractAffirmRevocationAbilityRspBO updateContractAffirmRevoca(@RequestBody ContractAffirmRevocationAbilityReqBO reqBO) {
        ContractInfoChangePO contractInfoChangePO1;
        this.verify(reqBO);
        ContractInfoPO contractInfoPO = null;
        if (reqBO.getRecallTypeId() == 0) {
            contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
        }
        ContractAffirmRevocationAbilityRspBO rspBO = this.contractAffirmRevocationBusiService.updateContractAffirmRevoca(reqBO);
        if (reqBO.getRecallTypeId() == 1 && (contractInfoChangePO1 = this.contractInfoChangeMapper.selectByPrimaryKey(reqBO.getContractId())) != null) {
            ContractFreezeStatusSyncAgrBo contractFreezeStatusSyncAgrBo = new ContractFreezeStatusSyncAgrBo();
            try {
                CContractAgrPO cContractAgrPO = new CContractAgrPO();
                cContractAgrPO.setRelateId(contractInfoChangePO1.getContractId());
                List<CContractAgrPO> cContractAgrPOS = this.cContractAgrMapper.getList(cContractAgrPO);
                if (!CollectionUtils.isEmpty(cContractAgrPOS)) {
                    contractFreezeStatusSyncAgrBo.setContractId(contractInfoChangePO1.getContractId());
                    contractFreezeStatusSyncAgrBo.setAgrId(cContractAgrPOS.get(0).getAgreementId());
                    contractFreezeStatusSyncAgrBo.setDealType(2);
                    log.info("\u53d1\u9001\u534f\u8bae\u51bb\u7ed3\u6d88\u606f\uff1a" + JSON.toJSONString((Object)contractFreezeStatusSyncAgrBo));
                    this.syncContractFreezeStatusProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)contractFreezeStatusSyncAgrBo)));
                }
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u534f\u8bae\u51bb\u7ed3\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)contractFreezeStatusSyncAgrBo));
            }
        }
        if (reqBO.getRecallTypeId() == 0 && "0000".equals(rspBO.getRespCode())) {
            try {
                this.dealWaitDone(reqBO, contractInfoPO);
            }
            catch (Exception e) {
                log.error("\u64a4\u56de\u53d6\u6d88\u5f85\u529e", (Throwable)e);
            }
            try {
                this.dealBusinessWaitDone(reqBO, contractInfoPO);
            }
            catch (Exception e) {
                log.error("\u64a4\u56de\u53d6\u6d88\u5f85\u529e", (Throwable)e);
            }
        }
        return rspBO;
    }

    private void dealBusinessWaitDone(ContractAffirmRevocationAbilityReqBO reqBO, ContractInfoPO contractInfoPO) {
        try {
            ContractTodoBusinessWaitDoneDealAbilityReqBo dealBusinessWaitDoneReqBo = new ContractTodoBusinessWaitDoneDealAbilityReqBo();
            dealBusinessWaitDoneReqBo.setDealTime(new Date());
            dealBusinessWaitDoneReqBo.setObjId(contractInfoPO.getContractId().toString());
            dealBusinessWaitDoneReqBo.setHandleUserNo(reqBO.getOccupation());
            dealBusinessWaitDoneReqBo.setDealUserNo(reqBO.getOccupation());
            dealBusinessWaitDoneReqBo.setDealUserName(reqBO.getName());
            if (contractInfoPO.getIsNeedSupplierConfirm() == 0 && (ContractConstant.ContractType.SPOT_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.FUNCTION_SPOTS_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_TRADE_ORDER_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_NO_TRADE_ORDER_CONTRACT.equals(contractInfoPO.getContractType()))) {
                dealBusinessWaitDoneReqBo.setBusiCode("6024");
            } else if (contractInfoPO.getIsNeedSupplierConfirm() == 0 && (ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.DEVELOPMENT_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(contractInfoPO.getContractType()))) {
                dealBusinessWaitDoneReqBo.setBusiCode("6025");
            }
            log.error("\u5f53\u524d\u63a8\u9001\u5f85\u529e\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)dealBusinessWaitDoneReqBo));
            if (!StringUtils.isEmpty((Object)dealBusinessWaitDoneReqBo.getBusiCode())) {
                this.contracBusiToDoComService.dealWaitDone(dealBusinessWaitDoneReqBo);
            }
        }
        catch (Exception e) {
            log.error("------------------->\u5904\u7406\u4e1a\u52a1\u5f85\u529e\u63a8\u9001\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    private void dealWaitDone(ContractAffirmRevocationAbilityReqBO reqBO, ContractInfoPO contractInfoPO) {
        if (ContractConstant.ContractStatus.CONTRACT_PENDING_PUSH_LEGAL.equals(contractInfoPO.getContractStatus())) {
            ContractTodoBusinessWaitDoneDealAbilityReqBo contractTodoBusinessWaitDoneDealAbilityReqBo = new ContractTodoBusinessWaitDoneDealAbilityReqBo();
            if (this.CG_HT.contains(contractInfoPO.getContractType())) {
                contractTodoBusinessWaitDoneDealAbilityReqBo.setBusiCode("6029");
            } else if (this.CG_KJ_XY.contains(contractInfoPO.getContractType())) {
                contractTodoBusinessWaitDoneDealAbilityReqBo.setBusiCode("6030");
            } else {
                return;
            }
            contractTodoBusinessWaitDoneDealAbilityReqBo.setHandleUserNo(reqBO.getOccupation());
            contractTodoBusinessWaitDoneDealAbilityReqBo.setDealUserNo(reqBO.getOccupation());
            contractTodoBusinessWaitDoneDealAbilityReqBo.setDealUserName(reqBO.getName());
            contractTodoBusinessWaitDoneDealAbilityReqBo.setObjId(contractInfoPO.getContractId() + "");
            this.contractBusinessToDoComService.dealWaitDone(contractTodoBusinessWaitDoneDealAbilityReqBo);
        }
    }

    private void verify(ContractAffirmRevocationAbilityReqBO reqBO) {
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRecallTypeId() == null) {
            throw new ZTBusinessException("\u64a4\u56de\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

