/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.tydic.contract.ability.ContractContractValidTimeInitAbilityService;
import com.tydic.contract.ability.bo.ContractContractValidTimeInitAbilityReqBO;
import com.tydic.contract.ability.bo.ContractContractValidTimeInitAbilityRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractContractValidTimeInitAbilityService"})
public class ContractContractValidTimeInitAbilityServiceImpl
implements ContractContractValidTimeInitAbilityService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"iniTContractValidTime"})
    public ContractContractValidTimeInitAbilityRspBO iniTContractValidTime(@RequestBody ContractContractValidTimeInitAbilityReqBO reqBO) {
        ArrayList<Integer> contractTypes = new ArrayList<Integer>();
        contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
        List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getValidTimeInitList(contractTypes, ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
        ArrayList<ContractInfoPO> upadatePOS = new ArrayList<ContractInfoPO>();
        if (!CollectionUtils.isEmpty(contractInfoPOS)) {
            Calendar c = Calendar.getInstance();
            for (ContractInfoPO contractInfoPO : contractInfoPOS) {
                if (contractInfoPO.getValidaNum() == null || contractInfoPO.getValidaType() == null || contractInfoPO.getContractSignDate() == null) continue;
                ContractInfoPO updatePO = new ContractInfoPO();
                updatePO.setContractId(contractInfoPO.getContractId());
                c.setTime(contractInfoPO.getContractSignDate());
                if (ContractConstant.TermOfValidityType.MONTHS.equals(contractInfoPO.getValidaType())) {
                    c.add(2, contractInfoPO.getValidaNum());
                } else if (ContractConstant.TermOfValidityType.YEARS.equals(contractInfoPO.getValidaType())) {
                    c.add(1, contractInfoPO.getValidaNum());
                } else if (ContractConstant.TermOfValidityType.DAY.equals(contractInfoPO.getValidaType())) {
                    c.add(5, contractInfoPO.getValidaNum());
                }
                updatePO.setContractEndDate(c.getTime());
                updatePO.setContractValidTime(c.getTime());
                upadatePOS.add(updatePO);
            }
        }
        if (!CollectionUtils.isEmpty(upadatePOS)) {
            this.contractInfoMapper.updateBatchValidTime(upadatePOS);
        }
        ContractContractValidTimeInitAbilityRspBO rspBO = new ContractContractValidTimeInitAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

