/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.ContractExecutionTaskAbilityService;
import com.tydic.contract.ability.bo.ContractConvertNoticeUrlBO;
import com.tydic.contract.ability.bo.ContractExecutionTaskAbilityReqBO;
import com.tydic.contract.ability.bo.ContractExecutionTaskAbilityRspBO;
import com.tydic.contract.ability.bo.ContractExecutionTaskLogBO;
import com.tydic.contract.atom.ContractSendNotificationExtAtomService;
import com.tydic.contract.atom.bo.ContractSendNotificationExtAtomReqBO;
import com.tydic.contract.busi.ContractExecutionTaskBusiService;
import com.tydic.contract.busi.bo.ContractExecutionTaskBusiReqBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractExecutionTaskLogMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractExecutionTaskLogPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.xwgl.ability.api.XwgLSaveLogAbilityService;
import com.tydic.xwgl.ability.api.XwglRuleGetNoauthDetailAbilityService;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBo;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBoXwglLogs;
import com.tydic.xwgl.ability.bo.XwgLSaveLogRspBo;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailReqBo;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractExecutionTaskAbilityService"})
public class ContractExecutionTaskAbilityServiceImpl
implements ContractExecutionTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractExecutionTaskAbilityServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractExecutionTaskBusiService contractExecutionTaskBusiService;
    @Autowired
    private ContractExecutionTaskLogMapper contractExecutionTaskLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private ContractSendNotificationExtAtomService contractSendNotificationExtAtomService;
    @Autowired
    private XwglRuleGetNoauthDetailAbilityService xwglRuleGetNoauthDetailAbilityService;
    @Autowired
    private XwgLSaveLogAbilityService xwgLSaveLogAbilityService;
    @Value(value="${convertNoticeUrlString:convertNoticeUrlString}")
    private String convertNoticeUrlString;
    private static final String CONTRACT_TYPE_CONTRACT_ID = "CONTRACT_ID";
    private static final String CONTRACT_TYPE_UPDATE_APPLY_ID = "UPDATE_APPLY_ID";
    @Value(value="${APPROVE_ENTRUST_NOTICE_JUMP_URL_IP:http://172.20.175.3}")
    private String approveEntrustNoticeJumpUrlIp;
    @Value(value="${contract.exp.ruleNo:HTZX-HT-00010}")
    private String ppRuleNo;
    @Value(value="${contract.limit.ruleNo:HTZX-HT-00011}")
    private String limitRuleNo;

    @PostMapping(value={"executionTask"})
    public ContractExecutionTaskAbilityRspBO executionTask(@RequestBody ContractExecutionTaskAbilityReqBO reqBO) {
        block25: {
            Page page;
            Date nowDate = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(nowDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            nowDate = calendar.getTime();
            calendar.add(2, 4);
            Date changeAfter = calendar.getTime();
            XwglRuleGetNoauthDetailReqBo ruleReqBo = new XwglRuleGetNoauthDetailReqBo();
            log.debug("executionTask-\u5230\u671f\u9884\u8b66\u6821\u9a8c\u5f00\u59cb\u4e86");
            ruleReqBo.setRuleNo(this.ppRuleNo);
            XwglRuleGetNoauthDetailRspBo expRuleRspBo = this.xwglRuleGetNoauthDetailAbilityService.getNoauthDetail(ruleReqBo);
            log.debug("executionTask-\u5230\u671f\u9884\u8b66\u6821\u9a8c\u8fd4\u56de" + JSONObject.toJSONString((Object)expRuleRspBo));
            if (!"0000".equals(expRuleRspBo.getRespCode())) {
                log.error("\u5230\u671f\u9650\u989d\u9884\u8b66\u62a5\u9519");
                return null;
            }
            XwgLSaveLogReqBoXwglLogs explogs = new XwgLSaveLogReqBoXwglLogs();
            BeanUtils.copyProperties((Object)expRuleRspBo, (Object)explogs);
            explogs.setRulId(expRuleRspBo.getRuleId());
            log.debug("executionTask-\u9650\u989d\u9884\u8b66\u6821\u9a8c\u5f00\u59cb\u4e86");
            ruleReqBo.setRuleNo(this.limitRuleNo);
            XwglRuleGetNoauthDetailRspBo limitRuleRspBo = this.xwglRuleGetNoauthDetailAbilityService.getNoauthDetail(ruleReqBo);
            log.debug("executionTask-\u9650\u989d\u9884\u8b66\u6821\u9a8c\u8fd4\u56de" + JSONObject.toJSONString((Object)limitRuleRspBo));
            if (!"0000".equals(limitRuleRspBo.getRespCode())) {
                log.error("\u67e5\u8be2\u9650\u989d\u9884\u8b66\u62a5\u9519");
                return null;
            }
            XwgLSaveLogReqBoXwglLogs limitLogs = new XwgLSaveLogReqBoXwglLogs();
            BeanUtils.copyProperties((Object)limitRuleRspBo, (Object)limitLogs);
            limitLogs.setRulId(limitRuleRspBo.getRuleId());
            ArrayList<Integer> contractTypeList = new ArrayList<Integer>();
            contractTypeList.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
            contractTypeList.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
            Integer contractStatus = ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT;
            Integer pageSize = 100;
            Integer pageNo = 1;
            String url = "";
            HashMap<Integer, String> contractTypeNoticeUrlMap = new HashMap<Integer, String>();
            try {
                List convertNoticeUrlBOSc = JSONObject.parseArray((String)this.convertNoticeUrlString, ContractConvertNoticeUrlBO.class);
                log.debug("executionTask-\u901a\u77e5url" + this.convertNoticeUrlString);
                for (ContractConvertNoticeUrlBO contractConvertNoticeUrlBO : convertNoticeUrlBOSc) {
                    if (contractConvertNoticeUrlBO.getNoticeType() != 0) continue;
                    for (Integer contractType : contractConvertNoticeUrlBO.getContractTypeList()) {
                        contractTypeNoticeUrlMap.put(contractType, contractConvertNoticeUrlBO.getUr());
                    }
                }
            }
            catch (Exception convertNoticeUrlBOSc) {
                // empty catch block
            }
            log.debug("executionTask-\u901a\u77e5urlMap" + JSONObject.toJSONString(contractTypeNoticeUrlMap));
            ContractInfoPO wherePo = new ContractInfoPO();
            wherePo.setContractStatus(contractStatus);
            do {
                log.debug("executionTask-\u67e5\u8be2\u6761\u4ef6" + JSONObject.toJSONString((Object)wherePo));
                page = PageHelper.startPage((int)pageNo, (int)pageSize).doSelectPage(() -> this.contractInfoMapper.getExpList(wherePo));
                List contractInfoPOS = page.getResult();
                log.debug("executionTask-\u67e5\u8be2\u9875\u6570\u8fd4\u56de\u6761\u4ef6" + JSONObject.toJSONString((Object)page));
                log.debug("executionTask-\u5f85\u5904\u7406\u5408\u540c\u67e5\u8be2\u7ed3\u679c" + JSONObject.toJSONString((Object)contractInfoPOS));
                if (CollectionUtils.isEmpty((Collection)contractInfoPOS)) {
                    log.debug("executionTask-\u672a\u67e5\u8be2\u5230\u5408\u540c\u6570\u636e" + JSONObject.toJSONString((Object)contractInfoPOS));
                    break block25;
                }
                List<Long> contractIds = contractInfoPOS.stream().map(ContractInfoPO::getContractId).collect(Collectors.toList());
                List<ContractExecutionTaskLogPO> taskLogPOS = this.contractExecutionTaskLogMapper.selectListByContractIds(contractIds);
                log.debug("executionTask-\u67e5\u8be2\u5230\u53d1\u9001\u8fc7\u9884\u8b66\u7684\u5408\u540c " + JSONObject.toJSONString(taskLogPOS));
                ArrayList<ContractExecutionTaskLogBO> updateBOS = new ArrayList<ContractExecutionTaskLogBO>();
                ArrayList<ContractExecutionTaskLogBO> addBOS = new ArrayList<ContractExecutionTaskLogBO>();
                Map<Object, Object> contractIdMap = new HashMap();
                if (!CollectionUtils.isEmpty(taskLogPOS)) {
                    contractIdMap = taskLogPOS.stream().collect(Collectors.toMap(ContractExecutionTaskLogPO::getContractId, o -> o));
                }
                for (ContractInfoPO contractInfoPO : contractInfoPOS) {
                    ContractExecutionTaskLogPO taskLogPO = null;
                    Boolean needCheckAmount = true;
                    taskLogPO = (ContractExecutionTaskLogPO)contractIdMap.get(contractInfoPO.getContractId());
                    if (contractIdMap.containsKey(contractInfoPO.getContractId()) && (ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType()))) {
                        log.debug("executionTask-\u5224\u65ad\u9650\u989d\u9884\u8b66 " + JSONObject.toJSONString((Object)contractInfoPO));
                        if (taskLogPO.getAmountLimit() == null && contractInfoPO.getAmountLimit() == null || taskLogPO.getAmountLimit() != null && contractInfoPO.getAmountLimit() != null && taskLogPO.getAmountLimit().equals(contractInfoPO.getAmountLimit())) {
                            needCheckAmount = false;
                            log.debug("executionTask-\u5224\u65ad\u9650\u989d\u9884\u8b66\u7ed3\u679c " + needCheckAmount);
                        }
                    }
                    Boolean executionStatusNotFlag = false;
                    if (contractInfoPO.getContractValidTime() != null || contractInfoPO.getContractEffectiveDate() != null) {
                        executionStatusNotFlag = true;
                    }
                    Boolean executionStatusDraftFlag = false;
                    if (needCheckAmount.booleanValue() && contractInfoPO.getAmountLimit() != null && contractInfoPO.getOrderAmount() != null && (ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType()))) {
                        BigDecimal amountLimit = MoneyUtils.haoToYuan(contractInfoPO.getAmountLimit());
                        BigDecimal orderAmount = MoneyUtils.haoToYuan(contractInfoPO.getOrderAmount());
                        if (amountLimit.multiply(new BigDecimal("0.7")).compareTo(orderAmount) < 0) {
                            executionStatusDraftFlag = true;
                            log.debug("executionTask-\u5224\u65ad\u9650\u989d\u8d85\u989d\u7ed3\u679c " + executionStatusDraftFlag);
                        }
                    }
                    if (taskLogPO != null) {
                        if (executionStatusNotFlag.booleanValue() && taskLogPO.getContractValidTime() != null && contractInfoPO.getContractValidTime() != null && taskLogPO.getContractValidTime().getTime() == contractInfoPO.getContractValidTime().getTime()) {
                            executionStatusNotFlag = false;
                            log.debug("executionTask-\u6709\u6548\u65f6\u95f4\u6ca1\u6709\u53d8\u52a8 " + executionStatusDraftFlag);
                        }
                        if (executionStatusDraftFlag.booleanValue() && taskLogPO.getAmountLimit() != null && contractInfoPO.getAmountLimit() != null && taskLogPO.getAmountLimit().equals(contractInfoPO.getAmountLimit())) {
                            executionStatusDraftFlag = false;
                            log.debug("executionTask-\u9650\u989d\u6ca1\u6709\u53d8\u52a8 " + executionStatusDraftFlag);
                        }
                    }
                    if (!executionStatusNotFlag.booleanValue() && !executionStatusDraftFlag.booleanValue()) continue;
                    ContractExecutionTaskLogBO bo = new ContractExecutionTaskLogBO();
                    bo.setContractId(contractInfoPO.getContractId());
                    bo.setAmountLimit(contractInfoPO.getAmountLimit());
                    bo.setContractValidTime(contractInfoPO.getContractValidTime());
                    ArrayList<Long> receiveIds = new ArrayList<Long>();
                    receiveIds.add(contractInfoPO.getCreateUserId());
                    try {
                        if (executionStatusNotFlag.booleanValue()) {
                            log.debug("executionTask-\u5224\u65ad\u8d85\u671f\u901a\u77e5 " + executionStatusNotFlag + "\u5408\u540c\u7f16\u53f7" + contractInfoPO.getContractCode());
                            this.checkContractExpiry(contractInfoPO, nowDate, receiveIds, explogs, contractTypeNoticeUrlMap);
                        }
                        if (executionStatusDraftFlag.booleanValue()) {
                            log.debug("executionTask-\u53d1\u9001\u9650\u989d\u901a\u77e5 " + executionStatusDraftFlag + "\u5408\u540c\u7f16\u53f7" + contractInfoPO.getContractCode());
                            String noticeUrl = "";
                            if (contractTypeNoticeUrlMap.containsKey(contractInfoPO.getContractType())) {
                                noticeUrl = ((String)contractTypeNoticeUrlMap.get(contractInfoPO.getContractType())).replace(CONTRACT_TYPE_CONTRACT_ID, contractInfoPO.getContractId().toString());
                            }
                            String noticeText = "\u60a8\u7684\u5408\u540c" + contractInfoPO.getContractName() + contractInfoPO.getContractCode() + "\u5f53\u524d\u534f\u8bae\u53ef\u6267\u884c\u4f59\u989d\u4e0d\u8db330%\uff0c\u8bf7\u77e5\u6089";
                            String text = "<a href=\"" + noticeUrl + "\">" + noticeText + "</a>";
                            this.sendNotification(text, "\u5408\u540c\u9650\u989d\u63d0\u9192", receiveIds, 1L);
                            this.saveXwgl(contractInfoPO, limitLogs, contractTypeNoticeUrlMap);
                        }
                        if (taskLogPO == null) {
                            bo.setLogId(Long.valueOf(this.uccBatchSequence.nextId()));
                            bo.setCreateTime(new Date());
                            addBOS.add(bo);
                            continue;
                        }
                        bo.setLogId(taskLogPO.getLogId());
                        bo.setUpdateTime(new Date());
                        updateBOS.add(bo);
                    }
                    catch (Exception e) {
                        log.error("\u53d1\u9001\u901a\u77e5\u5f02\u5e38\uff1a", (Throwable)e);
                    }
                }
                if (!CollectionUtils.isEmpty(updateBOS) || !CollectionUtils.isEmpty(addBOS)) {
                    ContractExecutionTaskBusiReqBO busiReqBO = new ContractExecutionTaskBusiReqBO();
                    busiReqBO.setAddBOS(addBOS);
                    busiReqBO.setUpdateBOS(updateBOS);
                    this.contractExecutionTaskBusiService.dealExecutionTask(busiReqBO);
                }
                Integer n = pageNo;
                Integer n2 = pageNo = Integer.valueOf(pageNo + 1);
                log.debug("executionTask-\u4e0b\u4e00\u6b21\u67e5\u8be2\u9875\u6570 " + pageNo);
            } while (pageNo <= page.getPages());
            log.debug("executionTask-\u9875\u6570\u5927\u4e8e\u603b\u9875\u6570 " + page.getPages());
        }
        ContractExecutionTaskAbilityRspBO rspBO = new ContractExecutionTaskAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendNotification(String text, String titel, List<Long> receiveIds, Long userId) {
        ContractSendNotificationExtAtomReqBO extAtomReqBO = new ContractSendNotificationExtAtomReqBO();
        extAtomReqBO.setText(text);
        extAtomReqBO.setReceiveIds(receiveIds);
        extAtomReqBO.setTitel(titel);
        extAtomReqBO.setUserId(userId);
        this.contractSendNotificationExtAtomService.sendNotification(extAtomReqBO);
    }

    private void checkContractExpiry(ContractInfoPO contractInfoPO, Date nowDate, List<Long> receiveIds, XwgLSaveLogReqBoXwglLogs logs, Map<Integer, String> contractTypeNoticeUrlMap) {
        String text;
        String noticeText;
        Calendar contractCalendar = Calendar.getInstance();
        contractCalendar.set(11, 0);
        contractCalendar.set(12, 0);
        contractCalendar.set(13, 0);
        contractCalendar.set(14, 0);
        Date contractValidTime = contractInfoPO.getContractValidTime();
        if (contractInfoPO.getContractValidTime() == null) {
            contractCalendar.setTime(contractInfoPO.getContractEffectiveDate());
            if (ContractConstant.TermOfValidityType.MONTHS.equals(contractInfoPO.getValidaType())) {
                contractCalendar.add(2, contractInfoPO.getValidaNum());
            } else if (ContractConstant.TermOfValidityType.YEARS.equals(contractInfoPO.getValidaType())) {
                contractCalendar.add(1, contractInfoPO.getValidaNum());
            } else if (ContractConstant.TermOfValidityType.DAY.equals(contractInfoPO.getValidaType())) {
                contractCalendar.add(5, contractInfoPO.getValidaNum());
            }
            contractValidTime = contractCalendar.getTime();
            log.debug("executionTask-\u8ba1\u7b97\u5408\u540c\u5230\u671f\u65f6\u95f4 " + contractValidTime);
        }
        long diffInMillies = contractValidTime.getTime() - nowDate.getTime();
        long diffInDays = diffInMillies / 86400000L;
        log.debug("executionTask-\u5408\u540cID" + contractInfoPO.getContractId() + "\u5408\u540c\u540d\u79f0 " + contractInfoPO.getContractName() + "\u5408\u540c\u5230\u671f\u65f6\u95f4 " + contractValidTime.getTime());
        log.debug("executionTask-\u5408\u540cID" + contractInfoPO.getContractId() + "\u5408\u540c\u540d\u79f0 " + contractInfoPO.getContractName() + "\u5f53\u524d\u65f6\u95f4 " + nowDate.getTime());
        log.debug("executionTask-\u5408\u540cID" + contractInfoPO.getContractId() + "\u5408\u540c\u540d\u79f0 " + contractInfoPO.getContractName() + "\u5230\u671f\u65f6\u95f4 " + diffInDays);
        String noticeUrl = "";
        if (diffInDays == 120L) {
            if (contractTypeNoticeUrlMap.containsKey(contractInfoPO.getContractType())) {
                noticeUrl = contractTypeNoticeUrlMap.get(contractInfoPO.getContractType()).replace(CONTRACT_TYPE_CONTRACT_ID, contractInfoPO.getContractId().toString());
            }
            noticeText = "\u60a8\u7684\u5408\u540c " + contractInfoPO.getContractName() + "\uff08" + contractInfoPO.getContractCode() + "\uff09 \u5373\u5c06\u5728 4\u4e2a\u6708 \u5185\u5230\u671f\uff0c\u8bf7\u77e5\u6089";
            text = "<a href=\"" + noticeUrl + "\">" + noticeText + "</a>";
            this.sendNotification(text, "\u5408\u540c\u5373\u5c06\u5230\u671f\u63d0\u9192", receiveIds, 1L);
            this.saveXwgl(contractInfoPO, logs, contractTypeNoticeUrlMap);
        }
        if (diffInDays == 30L) {
            if (contractTypeNoticeUrlMap.containsKey(contractInfoPO.getContractType())) {
                noticeUrl = contractTypeNoticeUrlMap.get(contractInfoPO.getContractType()).replace(CONTRACT_TYPE_CONTRACT_ID, contractInfoPO.getContractId().toString());
            }
            noticeText = "\u60a8\u7684\u5408\u540c " + contractInfoPO.getContractName() + " \uff08" + contractInfoPO.getContractCode() + "\uff09 \u5373\u5c06\u5728 30 \u5929\u5185\u5230\u671f\uff0c\u8bf7\u77e5\u6089";
            text = "<a href=\"" + noticeUrl + "\">" + noticeText + "</a>";
            this.sendNotification(text, "\u5408\u540c\u5373\u5c06\u5230\u671f\u63d0\u9192", receiveIds, 1L);
            this.saveXwgl(contractInfoPO, logs, contractTypeNoticeUrlMap);
        } else if (diffInDays == 15L) {
            if (contractTypeNoticeUrlMap.containsKey(contractInfoPO.getContractType())) {
                noticeUrl = contractTypeNoticeUrlMap.get(contractInfoPO.getContractType()).replace(CONTRACT_TYPE_CONTRACT_ID, contractInfoPO.getContractId().toString());
            }
            noticeText = "\u60a8\u7684\u5408\u540c " + contractInfoPO.getContractName() + " \uff08" + contractInfoPO.getContractCode() + "\uff09\u5373\u5c06\u5728 15 \u5929\u5185\u5230\u671f\uff0c\u8bf7\u77e5\u6089";
            text = "<a href=\"" + noticeUrl + "\">" + noticeText + "</a>";
            this.sendNotification(text, "\u5408\u540c\u5373\u5c06\u5230\u671f\u63d0\u9192", receiveIds, 1L);
            this.saveXwgl(contractInfoPO, logs, contractTypeNoticeUrlMap);
        } else if (diffInDays == 3L) {
            if (contractTypeNoticeUrlMap.containsKey(contractInfoPO.getContractType())) {
                noticeUrl = contractTypeNoticeUrlMap.get(contractInfoPO.getContractType()).replace(CONTRACT_TYPE_CONTRACT_ID, contractInfoPO.getContractId().toString());
            }
            noticeText = "\u60a8\u7684\u5408\u540c " + contractInfoPO.getContractName() + " \uff08" + contractInfoPO.getContractCode() + "\uff09 \u5373\u5c06\u5728 3 \u5929\u5185\u5230\u671f\uff0c\u8bf7\u77e5\u6089";
            text = "<a href=\"" + noticeUrl + "\">" + noticeText + "</a>";
            this.sendNotification(text, "\u5408\u540c\u5373\u5c06\u5230\u671f\u63d0\u9192", receiveIds, 1L);
            this.saveXwgl(contractInfoPO, logs, contractTypeNoticeUrlMap);
        }
    }

    private void saveXwgl(ContractInfoPO contractInfoPO, XwgLSaveLogReqBoXwglLogs logs, Map<Integer, String> contractTypeNoticeUrlMap) {
        try {
            XwgLSaveLogReqBo reqBo = new XwgLSaveLogReqBo();
            ArrayList<XwgLSaveLogReqBoXwglLogs> xwglLogs = new ArrayList<XwgLSaveLogReqBoXwglLogs>();
            XwgLSaveLogReqBoXwglLogs x = new XwgLSaveLogReqBoXwglLogs();
            BeanUtils.copyProperties((Object)logs, (Object)x);
            x.setBusinessName(contractInfoPO.getContractName());
            x.setBusinessId(contractInfoPO.getContractId() + "");
            x.setBusinessCode(contractInfoPO.getContractCode());
            x.setIsZj(Integer.valueOf(1));
            if (contractTypeNoticeUrlMap.containsKey(contractInfoPO.getContractType())) {
                String noticeUrl = contractTypeNoticeUrlMap.get(contractInfoPO.getContractType()).replace(CONTRACT_TYPE_CONTRACT_ID, contractInfoPO.getContractId().toString());
                x.setBusinessUrl(noticeUrl);
            }
            x.setRulId(logs.getRulId());
            x.setManagerId(contractInfoPO.getCreateUserId());
            x.setManagerName(contractInfoPO.getCreateUserName());
            x.setCompanyId(contractInfoPO.getCreateDeptCode());
            x.setDeptId(contractInfoPO.getCreateDeptCode());
            x.setCompanyName(contractInfoPO.getCreateDeptName());
            x.setDeptName(contractInfoPO.getCreateDeptName());
            xwglLogs.add(x);
            reqBo.setXwglLogs(xwglLogs);
            reqBo.setUserId(contractInfoPO.getCreateUserId());
            reqBo.setName(contractInfoPO.getCreateDeptName());
            log.debug("executionTask-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)reqBo));
            XwgLSaveLogRspBo rspBo = this.xwgLSaveLogAbilityService.saveXwglLog(reqBo);
            log.debug("executionTask-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)rspBo));
        }
        catch (Exception e) {
            log.error("\u9884\u8b66\u4e8b\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

