/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractGetBusinessBidListAbilityService;
import com.tydic.contract.ability.bo.ContractGetBusinessBidListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractGetBusinessBidListAbilityRspBO;
import com.tydic.contract.atom.InterFaceContractGetBusinessBidListAtomService;
import com.tydic.contract.atom.bo.InterFaceContractGetBusinessBidListAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractGetBusinessBidListAtomRspBO;
import com.tydic.contract.dao.ContractInfoChangeItemMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.dyc.ssc.service.scheme.SchemeTenderReportListService;
import com.tydic.dyc.ssc.service.scheme.bo.SchemePurchaseQuotationRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeSPurchaseQuotationReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractGetBusinessBidListAbilityService"})
public class ContractGetBusinessBidListAbilityServiceImpl
implements ContractGetBusinessBidListAbilityService {
    @Autowired
    private InterFaceContractGetBusinessBidListAtomService interFaceContractGetBusinessBidListAtomService;
    @Autowired
    private ContractInfoChangeItemMapper contractInfoChangeItemMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Value(value="${NO_RECRUIT_URL}")
    private String noRecruitUrl;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    private SchemeTenderReportListService schemeTenderReportListService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"getBusinessBidList"})
    public ContractGetBusinessBidListAbilityRspBO getBusinessBidList(@RequestBody ContractGetBusinessBidListAbilityReqBO reqBO) {
        List itemPOS;
        Page page;
        ContractGetBusinessBidListAbilityRspBO rspBO = new ContractGetBusinessBidListAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getContractId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5c06\u8981\u67e5\u8be2\u7684\u5408\u540cid");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getAuthToken())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("token\u4e3a\u7a7a\uff0c\u8bf7\u767b\u5f55");
            return rspBO;
        }
        ArrayList<String> goodTypeIds = new ArrayList();
        ContractInfoItemTmpPO seachPO = new ContractInfoItemTmpPO();
        seachPO.setRelateId(reqBO.getContractId());
        seachPO.setUpdateApplyId(reqBO.getUpdateApplyId());
        seachPO.setIsPurchasePlanItem(1);
        if (reqBO.getIsQryContractChange() != null && reqBO.getIsQryContractChange() == 1) {
            seachPO.setIsCheckAwardNumId(1);
            page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemTmpMapper.getList(seachPO));
            itemPOS = page.getResult();
            if (!CollectionUtils.isEmpty((Collection)itemPOS)) {
                seachPO.setIsPurchasePlanItemQryTemp(1);
            }
            page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemTmpMapper.contractItemChangeQuery(seachPO, null));
        } else {
            seachPO.setIsCheckAwardNumId(1);
            seachPO.setIsOutUpdateApplyId(1);
            page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemTmpMapper.getList(seachPO));
            itemPOS = page.getResult();
            if (!CollectionUtils.isEmpty((Collection)itemPOS)) {
                seachPO.setIsPurchasePlanItemQryTemp(1);
            }
            page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemTmpMapper.contractItemQuery(seachPO, null));
        }
        List changeItemPOS = page.getResult();
        rspBO.setPageNo(Integer.valueOf(page.getPageNum()));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setRecordsTotal(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
        if (!CollectionUtils.isEmpty((Collection)changeItemPOS)) {
            goodTypeIds = changeItemPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getAwardNumId())).map(ContractInfoItemTmpPO::getAwardNumId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(goodTypeIds)) return rspBO;
        try {
            if (!StringUtils.isEmpty((Object)reqBO.getQueryType())) return this.xYPurchaseQuotation(goodTypeIds, reqBO.getQueryType());
            InterFaceContractGetBusinessBidListAtomReqBO atomReqBO = new InterFaceContractGetBusinessBidListAtomReqBO();
            atomReqBO.setGoodTypeIds(goodTypeIds);
            atomReqBO.setToken(reqBO.getAuthToken());
            InterFaceContractGetBusinessBidListAtomRspBO atomRspBO = this.interFaceContractGetBusinessBidListAtomService.getBusinessBidList(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) throw new ZTBusinessException(atomRspBO.getRespDesc());
            rspBO = (ContractGetBusinessBidListAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)atomRspBO)), ContractGetBusinessBidListAbilityRspBO.class);
            if (CollectionUtils.isEmpty((Collection)rspBO.getRows())) return rspBO;
            rspBO.getRows().forEach(e -> {
                if (e.getBusinessType() != null && e.getBusinessType() == 9) {
                    e.setBusinessCodeUrl(this.noRecruitUrl + "/pmjt-buyer/buyer/pc/quaere/view/showUnderLineBusiness.do?businessId=" + e.getBusinessId());
                    e.setShowBusinessUrl(this.noRecruitUrl + "/pmjt-buyer/buyer/pc/quaere/view/showUnderLineBusiness.do?businessId=" + e.getBusinessId());
                } else {
                    e.setBusinessCodeUrl(this.noRecruitUrl + "/pmjt-buyer/buyer/pc/quaere/view/showBusiness.do?businessId=" + e.getBusinessId());
                    e.setShowBusinessUrl(this.noRecruitUrl + "/pmjt-buyer/buyer/pc/quaere/view/showBusiness.do?businessId=" + e.getBusinessId());
                }
                e.setArticleCodeUrl(this.noRecruitUrl + "/pmjt-buyer/buyer/pc/quaere/view/showComfirmNotice.do?nohead=true&businessId=" + e.getBusinessId());
                e.setBidCodeUrl(this.noRecruitUrl + "/pmjt-buyer/buyer/pc/quaere/sign/enterBidInfo.do?bidId=" + e.getBidId());
                e.setFirmCodeUrl(this.noRecruitUrl + "/pmjt-supplier-manage/buyer/firm/common/detail/detail.do?companyId=" + e.getFirmId());
                e.setAuditStepUrl(this.noRecruitUrl + "/pmjt-supplier-manage/buyer/firm/common/info/auditStep.do?taskId=" + e.getBusinessId());
                e.setAwardResultReportUrl(this.noRecruitUrl + "/pmjt-buyer/buyer/pc/quaere/award/awardResultReport.do?businessId=" + e.getBusinessId() + "&type=7");
                e.setComparisonUrl(this.noRecruitUrl + "/pmjt-buyer/buyer/pc/quaere/award/awardResultReport.do?businessId=" + e.getBusinessId() + "&type=3");
            });
            return rspBO;
        }
        catch (Exception e2) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e2.getMessage());
            return rspBO;
        }
    }

    private ContractGetBusinessBidListAbilityRspBO xYPurchaseQuotation(List<String> goodTypeIds, Integer queryType) {
        ContractGetBusinessBidListAbilityRspBO rspBO = new ContractGetBusinessBidListAbilityRspBO();
        SscSchemeSPurchaseQuotationReqBO sscSchemeSPurchaseQuotationReqBO = new SscSchemeSPurchaseQuotationReqBO();
        sscSchemeSPurchaseQuotationReqBO.setGoodTypeIds(goodTypeIds);
        sscSchemeSPurchaseQuotationReqBO.setQueryType(queryType);
        SchemePurchaseQuotationRspBO purchaseQuotation = this.schemeTenderReportListService.getPurchaseQuotation(sscSchemeSPurchaseQuotationReqBO);
        if ("0000".equals(purchaseQuotation.getRespCode())) {
            rspBO = (ContractGetBusinessBidListAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseQuotation), ContractGetBusinessBidListAbilityRspBO.class);
            if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
                rspBO.getRows().forEach(e -> e.setFirmCodeUrl(this.noRecruitUrl + "/pmjt-supplier-manage/buyer/firm/common/detail/detail.do?companyId=" + e.getFirmId()));
            }
        } else {
            throw new ZTBusinessException(purchaseQuotation.getRespDesc());
        }
        return rspBO;
    }
}

