/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.contract.ability.ContractHtFileConvertAbilityService;
import com.tydic.contract.ability.bo.ContractHtFileConvertAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtFileConvertAbilityRspBO;
import com.tydic.contract.busi.ContractHtFileConvertBusiService;
import com.tydic.contract.busi.bo.ContractHtFileConvertBusiBO;
import com.tydic.contract.busi.bo.ContractHtFileConvertBusiReqBO;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.FileHelper;
import com.tydic.contract.utils.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractHtFileConvertAbilityService"})
public class ContractHtFileConvertAbilityServiceImpl
implements ContractHtFileConvertAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractHtFileConvertAbilityServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Value(value="${FILE_START_URL:https://ego.chinacoal.com/}")
    private String fileStartUrl;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "contract/pdf";
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Autowired
    private ContractHtFileConvertBusiService contractHtFileConvertBusiService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealConvert"})
    public ContractHtFileConvertAbilityRspBO dealConvert(@RequestBody ContractHtFileConvertAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getContractIds())) {
            throw new ZTBusinessException("\u5165\u53c2\u5408\u540cId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Long contractId : reqBO.getContractIds()) {
            String fileExtension;
            ContractHtFileConvertBusiReqBO busiReqBO = new ContractHtFileConvertBusiReqBO();
            ContractInfoPO infoPO = this.contractInfoMapper.selectByPrimaryKey(contractId);
            if (!(StringUtils.isEmpty((Object)infoPO.getContractDocUrl()) || StringUtils.isEmpty((Object)infoPO.getContractDocName()) || infoPO.getContractDocUrl().startsWith(this.fileStartUrl) || StringUtils.isEmpty((Object)(fileExtension = "." + this.getFileExtension(infoPO.getContractDocUrl()))))) {
                File file = null;
                String localFileName = null;
                try {
                    localFileName = Sequence.getInstance().nextId() + fileExtension;
                    HttpUtil.httpDownload(infoPO.getContractDocUrl(), localFileName);
                    file = new File(localFileName);
                    String exportUrl = this.uploading(localFileName);
                    if (!StringUtils.isEmpty((Object)exportUrl)) {
                        busiReqBO.setContractId(contractId);
                        busiReqBO.setContractDocUrl(exportUrl);
                    }
                }
                catch (Exception e) {
                    log.info("\u8f6c\u6362\u6587\u4ef6\u5931\u8d25" + e.getMessage());
                }
                finally {
                    if (ObjectUtils.isEmpty((Object)file)) {
                        log.error("pdfFile\u5bf9\u8c61\u662f\u7a7a\u7684");
                    } else if (!file.exists()) {
                        log.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + localFileName + "\u4e0d\u5b58\u5728\uff01");
                    } else if (file.isFile()) {
                        if (file.delete()) {
                            log.info("\u5220\u9664\u6587\u4ef6" + localFileName + "\u6210\u529f\uff01");
                        } else {
                            log.info("\u5220\u9664\u6587\u4ef6" + localFileName + "\u5931\u8d25\uff01");
                        }
                    }
                }
            }
            ContractAccessoryPo searchPO = new ContractAccessoryPo();
            searchPO.setRelateId(contractId);
            List<ContractAccessoryPo> accessoryPos = this.contractAccessoryMapper.qryByCondition(searchPO);
            if (!CollectionUtils.isEmpty(accessoryPos)) {
                ArrayList<ContractHtFileConvertBusiBO> fileList = new ArrayList<ContractHtFileConvertBusiBO>();
                for (ContractAccessoryPo accessoryPo : accessoryPos) {
                    if (StringUtils.isEmpty((Object)accessoryPo.getAcceessoryUrl()) || accessoryPo.getAcceessoryUrl().startsWith(this.fileStartUrl)) continue;
                    File file = null;
                    String localFileName = null;
                    String fileExtension2 = "." + this.getFileExtension(accessoryPo.getAcceessoryUrl());
                    if (StringUtils.isEmpty((Object)fileExtension2)) continue;
                    try {
                        localFileName = Sequence.getInstance().nextId() + fileExtension2;
                        HttpUtil.httpDownload(accessoryPo.getAcceessoryUrl(), localFileName);
                        file = new File(localFileName);
                        String exportUrl = this.uploading(localFileName);
                        if (StringUtils.isEmpty((Object)exportUrl)) continue;
                        ContractHtFileConvertBusiBO contractHtFileConvertBusiBO = new ContractHtFileConvertBusiBO();
                        contractHtFileConvertBusiBO.setAcceessoryId(accessoryPo.getAcceessoryId());
                        contractHtFileConvertBusiBO.setAcceessoryUrl(exportUrl);
                        fileList.add(contractHtFileConvertBusiBO);
                    }
                    catch (Exception e) {
                        log.info("\u8f6c\u6362\u6587\u4ef6\u5931\u8d25" + e.getMessage());
                    }
                    finally {
                        if (ObjectUtils.isEmpty((Object)file)) {
                            log.error("pdfFile\u5bf9\u8c61\u662f\u7a7a\u7684");
                            continue;
                        }
                        if (!file.exists()) {
                            log.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + localFileName + "\u4e0d\u5b58\u5728\uff01");
                            continue;
                        }
                        if (!file.isFile()) continue;
                        if (file.delete()) {
                            log.info("\u5220\u9664\u6587\u4ef6" + localFileName + "\u6210\u529f\uff01");
                            continue;
                        }
                        log.info("\u5220\u9664\u6587\u4ef6" + localFileName + "\u5931\u8d25\uff01");
                    }
                }
                busiReqBO.setFileList(fileList);
            }
            this.contractHtFileConvertBusiService.dealConvert(busiReqBO);
        }
        ContractHtFileConvertAbilityRspBO rspBO = new ContractHtFileConvertAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String uploading(String uploadingName) {
        String exportUrl;
        block4: {
            try {
                byte[] bytes = FileHelper.getBytes(uploadingName);
                ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                String path = this.fileClient.uploadFileByInputStream(PATH, uploadingName, (InputStream)input);
                if (FILE_TYPE_OSS.equals(this.fileType)) {
                    exportUrl = this.ossFileUrl + path;
                    break block4;
                }
                if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                    FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                    exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                    break block4;
                }
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            }
        }
        return exportUrl;
    }

    private String getFileExtension(String url) {
        if (url == null || url.isEmpty()) {
            return "";
        }
        int lastDotIndex = url.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return "";
        }
        return url.substring(lastDotIndex + 1);
    }
}

