/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractItemAcceessUpdateAbilityService;
import com.tydic.contract.ability.bo.ContractItemAcceessUpdateAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemAcceessUpdateAbilityRspBO;
import com.tydic.contract.ability.impl.ContractItemAcceessThread;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.umc.general.ability.api.UmcUserDownloadRecordQryListPageAbilityService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractItemAcceessUpdateAbilityService"})
public class ContractItemAcceessUpdateAbilityServiceImpl
implements ContractItemAcceessUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemAcceessUpdateAbilityServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private UmcUserDownloadRecordQryListPageAbilityService umcUserDownloadRecordQryListPageAbilityService;
    @Value(value="${fsc.url}")
    private String fscUrl;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"updateContractItemAcceess"})
    public ContractItemAcceessUpdateAbilityRspBO updateContractItemAcceess(@RequestBody ContractItemAcceessUpdateAbilityReqBO reqBO) {
        ContractItemAcceessUpdateAbilityRspBO rspBO = new ContractItemAcceessUpdateAbilityRspBO();
        if (reqBO.getContractId() != null && !StringUtils.isEmpty((Object)reqBO.getDownloadTaskId())) {
            ContractInfoPO oldContractInfoPo = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
            if (oldContractInfoPo == null) throw new ZTBusinessException("\u5408\u540c\u4e0d\u5b58\u5728");
            ContractInfoPO updatePO = new ContractInfoPO();
            BeanUtils.copyProperties((Object)oldContractInfoPo, (Object)updatePO);
            updatePO.setDownloadTaskId(reqBO.getDownloadTaskId());
            updatePO.setItemAccessoryName("\u5408\u540c\u7269\u8d44\u660e\u7ec6\u9644\u4ef6.xlsx");
            updatePO.setDownloadIsProcess(0);
            updatePO.setItemAccessoryUrl(null);
            updatePO.setItemAccessoryFailInfo(null);
            updatePO.setItemAccessoryGenerateState(1);
            this.contractInfoMapper.updateDirectAssignment(updatePO);
        } else if (reqBO.getUpdateApplyId() != null && !StringUtils.isEmpty((Object)reqBO.getDownloadTaskId())) {
            ContractInfoChangePO oldContractInfoChangePO = this.contractInfoChangeMapper.selectByPrimaryKey(reqBO.getUpdateApplyId());
            if (oldContractInfoChangePO == null) throw new ZTBusinessException("\u5408\u540c\u4e0d\u5b58\u5728");
            ContractInfoChangePO updatePO = new ContractInfoChangePO();
            BeanUtils.copyProperties((Object)oldContractInfoChangePO, (Object)updatePO);
            updatePO.setDownloadTaskId(reqBO.getDownloadTaskId());
            updatePO.setItemAccessoryName("\u5408\u540c\u7269\u8d44\u660e\u7ec6\u9644\u4ef6.xlsx");
            updatePO.setDownloadIsProcess(0);
            updatePO.setItemAccessoryUrl(null);
            updatePO.setItemAccessoryFailInfo(null);
            updatePO.setItemAccessoryGenerateState(1);
            this.contractInfoChangeMapper.updateDirectAssignment(updatePO);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            String format = sdf.format(new Date());
            ContractInfoPO searchPO = new ContractInfoPO();
            searchPO.setDownloadIsProcess(0);
            List<ContractInfoPO> pos = this.contractInfoMapper.getList(searchPO);
            List<Object> contractIds = new ArrayList();
            List<Object> updateApplyIds = new ArrayList();
            Map<Object, Object> contractIdDownloadTaskIdMap = new HashMap();
            Map<Object, Object> updateApplyIdDownloadTaskIdMap = new HashMap();
            int size = 0;
            if (!CollectionUtils.isEmpty(pos)) {
                contractIds = pos.stream().filter(e -> !StringUtils.isEmpty((Object)e.getDownloadTaskId())).map(ContractInfoPO::getContractId).collect(Collectors.toList());
                contractIdDownloadTaskIdMap = pos.stream().filter(e -> !StringUtils.isEmpty((Object)e.getDownloadTaskId())).collect(Collectors.toMap(ContractInfoPO::getContractId, ContractInfoPO::getDownloadTaskId));
                size += contractIds.size();
            }
            ContractInfoChangePO searchChangePO = new ContractInfoChangePO();
            searchChangePO.setDownloadIsProcess(0);
            List<ContractInfoChangePO> changePOS = this.contractInfoChangeMapper.getList(searchChangePO);
            if (!CollectionUtils.isEmpty(changePOS)) {
                updateApplyIds = changePOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getDownloadTaskId())).map(ContractInfoChangePO::getUpdateApplyId).collect(Collectors.toList());
                updateApplyIdDownloadTaskIdMap = changePOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getDownloadTaskId())).collect(Collectors.toMap(ContractInfoChangePO::getUpdateApplyId, ContractInfoChangePO::getDownloadTaskId));
                size += updateApplyIds.size();
            }
            if (!CollectionUtils.isEmpty(contractIds) || !CollectionUtils.isEmpty(updateApplyIds)) {
                ContractItemAcceessThread itemAcceessThread;
                log.info("\u65f6\u95f4" + format + "\u5f00\u59cb\u7684\u5408\u540c\u660e\u7ec6\u9644\u4ef6\u5904\u7406\u670d\u52a1\u5904\u7406\u63a5\u53e3\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb,\u5904\u7406\u6570\u636e\u7684\u6761\u6570:" + size);
                if (!CollectionUtils.isEmpty(contractIds)) {
                    this.contractInfoMapper.batchUpdateContractDownloadIsProcess(contractIds, 1);
                }
                if (!CollectionUtils.isEmpty(updateApplyIds)) {
                    this.contractInfoChangeMapper.batchUpdateContractDownloadIsProcess(updateApplyIds, 1);
                }
                ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-contract_item_acceess-" + format).build();
                ThreadPoolExecutor fixedAcceessThreadPool = new ThreadPoolExecutor(3, 8, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
                if (!CollectionUtils.isEmpty(contractIds)) {
                    for (Long l : contractIds) {
                        itemAcceessThread = new ContractItemAcceessThread();
                        itemAcceessThread.setContractId(l);
                        itemAcceessThread.setDownloadTaskId((String)contractIdDownloadTaskIdMap.get(l));
                        itemAcceessThread.setUmcUserDownloadRecordQryListPageAbilityService(this.umcUserDownloadRecordQryListPageAbilityService);
                        itemAcceessThread.setFscUrl(this.fscUrl);
                        itemAcceessThread.setFileType(this.fileType);
                        itemAcceessThread.setFastdfsDownloadUrl(this.fastdfsDownloadUrl);
                        itemAcceessThread.setContractInfoMapper(this.contractInfoMapper);
                        fixedAcceessThreadPool.submit(itemAcceessThread);
                    }
                }
                if (!CollectionUtils.isEmpty(updateApplyIds)) {
                    for (Long l : updateApplyIds) {
                        itemAcceessThread = new ContractItemAcceessThread();
                        itemAcceessThread.setUpdateApplyId(l);
                        itemAcceessThread.setDownloadTaskId((String)updateApplyIdDownloadTaskIdMap.get(l));
                        itemAcceessThread.setUmcUserDownloadRecordQryListPageAbilityService(this.umcUserDownloadRecordQryListPageAbilityService);
                        itemAcceessThread.setFscUrl(this.fscUrl);
                        itemAcceessThread.setFileType(this.fileType);
                        itemAcceessThread.setFastdfsDownloadUrl(this.fastdfsDownloadUrl);
                        itemAcceessThread.setContractInfoChangeMapper(this.contractInfoChangeMapper);
                        fixedAcceessThreadPool.submit(itemAcceessThread);
                    }
                }
                fixedAcceessThreadPool.shutdown();
                while (true) {
                    if (fixedAcceessThreadPool.isTerminated()) {
                        log.debug("\u65f6\u95f4" + format + "\u5f00\u59cb\u7684\u5408\u540c\u660e\u7ec6\u9644\u4ef6\u5904\u7406\u670d\u52a1\u5904\u7406\u63a5\u53e3\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u52a1\u7ed3\u675f");
                        break;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception e2) {
                        log.error(e2.getMessage());
                    }
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

