/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.contract.ability.ContractProcNodeQryAbilityService;
import com.tydic.contract.ability.bo.ContractProcNodeQryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractProcNodeQryAbilityRspBO;
import com.tydic.contract.atom.ContractProcNodeQryAtomService;
import com.tydic.contract.atom.bo.ContractProcNodeQryAtomReqBO;
import com.tydic.contract.atom.bo.ContractProcNodeQryAtomRspBO;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractProcNodeQryAbilityService"})
public class ContractProcNodeQryAbilityServiceImpl
implements ContractProcNodeQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractProcNodeQryAbilityServiceImpl.class);
    @Autowired
    private ContractProcNodeQryAtomService contractProcNodeQryAtomService;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;

    @PostMapping(value={"procNodeQry"})
    public ContractProcNodeQryAbilityRspBO procNodeQry(@RequestBody ContractProcNodeQryAbilityReqBO reqBO) {
        Long contractId = null;
        if (reqBO.getContractId() != null) {
            ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
            if (contractInfoPO != null && !StringUtils.isEmpty((Object)contractInfoPO.getContractCode())) {
                ContractInfoPO contractCode = new ContractInfoPO();
                contractCode.setContractCode(contractInfoPO.getContractCode());
                List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getList(contractCode);
                if (contractInfoPOS != null && contractInfoPOS.size() > 0) {
                    for (ContractInfoPO po : contractInfoPOS) {
                        if (po.getContractVersion() == 1) {
                            contractId = po.getContractId();
                            continue;
                        }
                        contractId = reqBO.getContractId();
                    }
                } else {
                    contractId = reqBO.getContractId();
                }
            } else {
                contractId = reqBO.getUpdateApplyId() == null && reqBO.getContractId() != null ? reqBO.getContractId() : reqBO.getUpdateApplyId();
            }
        } else {
            contractId = reqBO.getUpdateApplyId();
        }
        log.info("\u5408\u540cid\uff1a" + contractId);
        ContractProcNodeQryAtomReqBO atomReqBO = new ContractProcNodeQryAtomReqBO();
        atomReqBO.setContractId(contractId);
        ContractProcNodeQryAtomRspBO atomRspBO = this.contractProcNodeQryAtomService.procNodeQry(atomReqBO);
        return (ContractProcNodeQryAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)atomRspBO)), ContractProcNodeQryAbilityRspBO.class);
    }
}

