/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.contract.ability.ContractLegalAuditLogQueryAbilityService;
import com.tydic.contract.ability.ContractQryAuditLogAbilityService;
import com.tydic.contract.ability.bo.CContractLegalSyncAuditLogBO;
import com.tydic.contract.ability.bo.ContractLegalAuditLogQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractLegalAuditLogQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractQryAuditLogAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryAuditLogAbilityRspBO;
import com.tydic.contract.ability.bo.ContractQryAuditLogBO;
import com.tydic.contract.atom.ContractQryAuditLogAtomService;
import com.tydic.contract.atom.bo.ContractQryAuditLogAtomReqBO;
import com.tydic.contract.atom.bo.ContractQryAuditLogAtomRspBO;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoPO;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractQryAuditLogAbilityService"})
public class ContractQryAuditLogAbilityServiceImpl
implements ContractQryAuditLogAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryAuditLogAbilityServiceImpl.class);
    @Autowired
    private ContractQryAuditLogAtomService contractQryAuditLogAtomService;
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractLegalAuditLogQueryAbilityService contractLegalAuditLogQueryAbilityService;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;

    @PostMapping(value={"qryAuditLog"})
    public ContractQryAuditLogAbilityRspBO qryAuditLog(@RequestBody ContractQryAuditLogAbilityReqBO reqBO) {
        log.info("\u5165\u53c2" + reqBO);
        String objId = null;
        String legalUndertakeId = "";
        String legalUndertakeName = "";
        String outContractId = "";
        if (reqBO.getType() == 1) {
            ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(Long.valueOf(reqBO.getObjId()));
            if (contractInfoPO != null) {
                legalUndertakeId = contractInfoPO.getLegalUndertakeId();
                legalUndertakeName = contractInfoPO.getLegalUndertakeName();
                outContractId = contractInfoPO.getOutContractId();
            }
            if (contractInfoPO != null && !StringUtils.isEmpty((String)contractInfoPO.getContractCode())) {
                ContractInfoPO contractInfoCode = new ContractInfoPO();
                contractInfoCode.setContractCode(contractInfoPO.getContractCode());
                List<ContractInfoPO> contractInfoPos = this.contractInfoMapper.getList(contractInfoCode);
                if (contractInfoPos != null && contractInfoPos.size() > 0) {
                    for (ContractInfoPO po : contractInfoPos) {
                        if (po.getContractVersion() == 1) {
                            objId = String.valueOf(po.getContractId());
                            continue;
                        }
                        objId = reqBO.getObjId();
                    }
                } else {
                    objId = reqBO.getObjId();
                }
            } else {
                objId = reqBO.getObjId();
            }
        } else if (reqBO.getType() == 2) {
            objId = reqBO.getObjId();
            ContractInfoChangePO contractInfoChangePO = new ContractInfoChangePO();
            contractInfoChangePO.setUpdateApplyId(Long.valueOf(reqBO.getObjId()));
            List<ContractInfoChangePO> contractInfoChangePOS = this.contractInfoChangeMapper.getList(contractInfoChangePO);
            if (!CollectionUtils.isEmpty(contractInfoChangePOS)) {
                legalUndertakeId = contractInfoChangePOS.get(0).getLegalUndertakeId();
                legalUndertakeName = contractInfoChangePOS.get(0).getLegalUndertakeName();
                Long contractId = contractInfoChangePOS.get(0).getContractId();
                ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(contractId);
                if (contractInfoPO != null) {
                    outContractId = contractInfoPO.getOutContractId();
                }
            }
        }
        log.info("\u5408\u540cid\uff1a" + objId);
        log.info("orgId:" + reqBO.getOrgId());
        if (!StringUtils.isEmpty((String)outContractId)) {
            // empty if block
        }
        ContractQryAuditLogAtomReqBO atomReqBO = new ContractQryAuditLogAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)atomReqBO));
        atomReqBO.setObjId(objId);
        atomReqBO.setOrgId(reqBO.getOrgId());
        ContractQryAuditLogAtomRspBO atomRspBO = this.contractQryAuditLogAtomService.qryAuditLog(atomReqBO);
        List rows = atomRspBO.getRows();
        if (objId != null) {
            ContractLegalAuditLogQueryAbilityReqBO queryAbilityReqBO = new ContractLegalAuditLogQueryAbilityReqBO();
            queryAbilityReqBO.setRelateId(Long.valueOf(objId));
            ContractLegalAuditLogQueryAbilityRspBO queryAbilityRspBO = this.contractLegalAuditLogQueryAbilityService.auditLogQuery(queryAbilityReqBO);
            if (queryAbilityRspBO != null && queryAbilityRspBO.getCContractLegalSyncAuditLogBOList() != null && queryAbilityRspBO.getCContractLegalSyncAuditLogBOList().size() > 0) {
                for (int i = 0; i < queryAbilityRspBO.getCContractLegalSyncAuditLogBOList().size(); ++i) {
                    ContractQryAuditLogBO auditLogBO = new ContractQryAuditLogBO();
                    auditLogBO.setOperName(((CContractLegalSyncAuditLogBO)queryAbilityRspBO.getCContractLegalSyncAuditLogBOList().get(i)).getContractApprovalUserName());
                    auditLogBO.setOperDept(((CContractLegalSyncAuditLogBO)queryAbilityRspBO.getCContractLegalSyncAuditLogBOList().get(i)).getDealOrgName());
                    auditLogBO.setAuditResult(((CContractLegalSyncAuditLogBO)queryAbilityRspBO.getCContractLegalSyncAuditLogBOList().get(i)).getContractApprovalResult());
                    auditLogBO.setAudit(((CContractLegalSyncAuditLogBO)queryAbilityRspBO.getCContractLegalSyncAuditLogBOList().get(i)).getDealDesc());
                    auditLogBO.setAuditAdvice(((CContractLegalSyncAuditLogBO)queryAbilityRspBO.getCContractLegalSyncAuditLogBOList().get(i)).getContractApprovalRemark());
                    auditLogBO.setDealTime(((CContractLegalSyncAuditLogBO)queryAbilityRspBO.getCContractLegalSyncAuditLogBOList().get(i)).getDealTime());
                    rows.add(auditLogBO);
                }
                rows.sort(new Comparator<ContractQryAuditLogBO>(){

                    @Override
                    public int compare(ContractQryAuditLogBO o1, ContractQryAuditLogBO o2) {
                        try {
                            return Long.compare(o1.getDealTime().getTime(), o2.getDealTime().getTime());
                        }
                        catch (Exception e) {
                            log.error("\u6cd5\u52a1\u5ba1\u6279\u4fe1\u606f\u67e5\u8be2\u6392\u5e8f\u5f02\u5e38:{}", (Object)e.getMessage());
                            return 0;
                        }
                    }
                });
            }
            log.info("\u52a0\u4e0a\u6cd5\u52a1\u65b9\u67e5\u8be2\u7ed3\u679c:{}", (Object)rows);
        }
        for (int i = 0; i < rows.size(); ++i) {
            if (i < 1 || "\u8d77\u8349".equals(((ContractQryAuditLogBO)rows.get(i)).getAudit()) || "\u63d0\u4ea4".equals(((ContractQryAuditLogBO)rows.get(i)).getAudit())) continue;
            Date date = ((ContractQryAuditLogBO)rows.get(i - 1)).getDealTime();
            Long time = null;
            String str = "";
            if (((ContractQryAuditLogBO)rows.get(i)).getDealTime() != null && date != null) {
                time = ((ContractQryAuditLogBO)rows.get(i)).getDealTime().getTime() - date.getTime();
                str = this.getStr(time);
            }
            ((ContractQryAuditLogBO)rows.get(i)).setProcessTimeStr(str);
            ((ContractQryAuditLogBO)rows.get(i)).setProcessTime(time);
        }
        atomRspBO.setRows(rows);
        ContractQryAuditLogAbilityRspBO rspBO = (ContractQryAuditLogAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)atomRspBO)), ContractQryAuditLogAbilityRspBO.class);
        rspBO.setLegalUndertakeId(legalUndertakeId);
        rspBO.setLegalUndertakeName(legalUndertakeName);
        return rspBO;
    }

    private String getStr(long time) {
        long hours = time / 3600000L;
        long lestMinutes = time % 3600000L;
        long minutes = lestMinutes / 60000L;
        long lestS = lestMinutes % 60000L;
        long s = lestS / 1000L;
        String str = "";
        if (hours > 0L) {
            str = hours + "\u5c0f\u65f6";
        }
        if (minutes > 0L) {
            str = str + minutes + "\u5206";
        } else if (StringUtils.isNotBlank((String)str)) {
            str = str + "0\u5206";
        }
        if (s > 0L) {
            str = str + s + "\u79d2";
        } else if (StringUtils.isNotBlank((String)str)) {
            str = str + "0\u79d2";
        }
        return str;
    }
}

