/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.contract.ability.FscFinanceSelectContractAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractReqBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractRspBo;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.FscFinanceSelectContractAbilityService"})
public class FscFinanceSelectContractAbilityServiceImpl
implements FscFinanceSelectContractAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceSelectContractAbilityServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"selectContractPage"})
    public FscFinanceSelectContractRspBo selectContractPage(@RequestBody FscFinanceSelectContractReqBo reqBo) {
        FscFinanceSelectContractRspBo rspBo = new FscFinanceSelectContractRspBo();
        if (null == reqBo.getBuyerId()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u4e70\u53d7\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (null == reqBo.getSupplierId()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        PageInfo pageInfo = PageHelper.startPage((int)reqBo.getPageNo(), (int)reqBo.getPageSize()).doSelectPageInfo(() -> this.contractInfoMapper.selectContracts(reqBo));
        pageInfo.getList().forEach(e -> {
            e.setContractTypeStr(ContractTransFieldUtil.transContractType(e.getContractType()));
            if (StringUtils.isNotEmpty((CharSequence)e.getContractSignDate())) {
                DateUtils.dateToStrAsFormat(DateUtils.strToDate(e.getContractSignDate()), "yyyy-MM-dd");
            }
            try {
                e.setContractAmount(MoneyUtils.Long2BigDecimal((Long)Long.valueOf(e.getContractAmount())).toString());
            }
            catch (Exception ex) {
                log.error("\u91d1\u989d\u8f6c\u5316\u51fa\u9519\uff1a" + ex.getMessage());
            }
        });
        rspBo.setRows(pageInfo.getList());
        rspBo.setPageNo(Integer.valueOf(pageInfo.getPageNum()));
        rspBo.setTotal(Integer.valueOf(pageInfo.getPageSize()));
        rspBo.setRecordsTotal(Integer.valueOf((int)pageInfo.getTotal()));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

