/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.contract.ability.FscFinanceSelectContractAmountAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountReqBO;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBoList;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.MoneyUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.FscFinanceSelectContractAmountAbilityService"})
public class FscFinanceSelectContractAmountAbilityServiceImpl
implements FscFinanceSelectContractAmountAbilityService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"selectContractAmount"})
    public FscFinanceSelectContractAmountRspBo selectContractAmount(@RequestBody FscFinanceSelectContractAmountReqBO reqBO) {
        FscFinanceSelectContractAmountRspBo rspBo = new FscFinanceSelectContractAmountRspBo();
        if (Objects.isNull(reqBO) || CollectionUtil.isEmpty((Collection)reqBO.getContractIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        ContractInfoPO contractInfoPO = new ContractInfoPO();
        contractInfoPO.setContractIds(reqBO.getContractIds());
        List<ContractInfoPO> contractInfoPOList = this.contractInfoMapper.selectContractAmountList(contractInfoPO);
        List list = JSON.parseArray((String)JSON.toJSONString(contractInfoPOList), FscFinanceSelectContractAmountRspBoList.class);
        list.forEach(e -> {
            e.setContractAmount(MoneyUtils.haoToYuan(e.getContractAmount()));
            if (e.getMaterialCategory() != null) {
                e.setMaterialCategoryStr(ContractTransFieldUtil.transMaterialCategory2(e.getMaterialCategory()));
            }
        });
        rspBo.setRows(list);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

