/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.contract.atom.ContractPurchaseSyncSaleContractAtomiService;
import com.tydic.contract.busi.bo.ContractPurchaseSyncSaleContractBusiReqBO;
import com.tydic.contract.busi.bo.ContractPurchaseSyncSaleContractBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoItemLogMapper;
import com.tydic.contract.dao.CContractInfoLogMapper;
import com.tydic.contract.dao.CRelBuySaleContractMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSettlementDetailMapper;
import com.tydic.contract.po.CContractInfoItemLogPO;
import com.tydic.contract.po.CContractInfoLogPO;
import com.tydic.contract.po.CRelBuySaleContractPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemSyncInfoVO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractSettlementDetailPO;
import com.tydic.contract.po.ContractSyncInfoVO;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.UacQryAuditOrderAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelRspBO;
import com.tydic.uac.ability.bo.UacQryAuditOrderReqBO;
import com.tydic.uac.ability.bo.UacQryAuditOrderRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractPurchaseSyncSaleContractAtomiServiceImpl
implements ContractPurchaseSyncSaleContractAtomiService {
    @Autowired
    private CRelBuySaleContractMapper cRelBuySaleContractMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private CContractInfoItemLogMapper cContractInfoItemLogMapper;
    @Autowired
    private CContractInfoLogMapper cContractInfoLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private UacQryAuditOrderAbilityService qryAuditOrderAbilityService;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    private ContractSettlementDetailMapper contractSettlementDetailMapper;
    @Value(value="${update.max.count:500}")
    private Integer maxCount;

    /*
     * WARNING - void declaration
     */
    @Override
    public ContractPurchaseSyncSaleContractBusiRspBO purchaseSyncSaleContract(ContractPurchaseSyncSaleContractBusiReqBO reqBO) {
        ContractPurchaseSyncSaleContractBusiRspBO rspBO = new ContractPurchaseSyncSaleContractBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getContractId() == null || reqBO.getOperationType() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        CRelBuySaleContractPO seachPO = new CRelBuySaleContractPO();
        seachPO.setBuyContractId(reqBO.getContractId());
        List<CRelBuySaleContractPO> relBuySaleContractPOS = this.cRelBuySaleContractMapper.getList(seachPO);
        if (CollectionUtils.isEmpty(relBuySaleContractPOS)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6ca1\u6709\u5173\u8054\u7684\u9500\u552e\u5408\u540c");
            return rspBO;
        }
        Set saleContractIds = relBuySaleContractPOS.stream().map(CRelBuySaleContractPO::getSaleContractId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(saleContractIds) || saleContractIds.size() > 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5173\u8054\u7684\u9500\u552e\u5408\u540c\u5f02\u5e38,\u4e00\u4e2a\u91c7\u8d2d\u5408\u540c\u53ea\u80fd\u5173\u8054\u4e00\u4e2a\u9500\u552e\u5408\u540c");
            return rspBO;
        }
        Long saleContractId = relBuySaleContractPOS.get(0).getSaleContractId();
        ContractInfoPO saleContractInfoPO = this.contractInfoMapper.selectByPrimaryKey(saleContractId);
        if (saleContractInfoPO == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u9500\u552e\u5408\u540c\u5df2\u4e0d\u5b58\u5728");
            return rspBO;
        }
        if (reqBO.getOperationType() == 1) {
            if (saleContractInfoPO != null) {
                Integer oldStatus = saleContractInfoPO.getContractStatus();
                ContractInfoPO updatePO = new ContractInfoPO();
                updatePO.setContractId(saleContractId);
                updatePO.setExtFiled1(oldStatus.toString());
                updatePO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_FREEZE);
                int count = this.contractInfoMapper.updateByPrimaryKeySelective(updatePO);
                if (count == 0) {
                    throw new ZTBusinessException("\u91c7\u8d2d\u5408\u540c\u540c\u6b65\u5931\u8d25");
                }
            }
        } else if (reqBO.getOperationType() == 2) {
            List<ContractInfoItemPO> purchaseContractInfoItemPOS;
            List<ContractInfoItemPO> saleContractInfoItemPOS;
            UacQryAuditOrderReqBO qryAuditOrderReqBO = new UacQryAuditOrderReqBO();
            qryAuditOrderReqBO.setObjId(saleContractInfoPO.getContractId().toString());
            qryAuditOrderReqBO.setIsToBeAudit(Boolean.valueOf(true));
            UacQryAuditOrderRspBO qryAuditOrderRspBO = this.qryAuditOrderAbilityService.qryAuditOrders(qryAuditOrderReqBO);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)qryAuditOrderRspBO.getApprovalOrders()) && qryAuditOrderRspBO.getApprovalOrders().size() > 1) {
                UacNoTaskAuditCancelReqBO uacNoTaskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
                uacNoTaskAuditCancelReqBO.setObjId(saleContractInfoPO.getContractId().toString());
                uacNoTaskAuditCancelReqBO.setObjType(Integer.valueOf(1));
                uacNoTaskAuditCancelReqBO.setOperDept(saleContractInfoPO.getCreateDeptName());
                uacNoTaskAuditCancelReqBO.setOperId(reqBO.getUserId().toString());
                uacNoTaskAuditCancelReqBO.setCancelOperId(reqBO.getUserId().toString());
                uacNoTaskAuditCancelReqBO.setCancelReason("\u9500\u552e\u5408\u540c\u53d8\u6210\u5f85\u63d0\u4ea4\u751f\u6548");
                UacNoTaskAuditCancelRspBO uacNoTaskAuditCancelRspBO = this.uacNoTaskAuditCancelAbilityService.auditCancel(uacNoTaskAuditCancelReqBO);
                if (!"0000".equals(uacNoTaskAuditCancelRspBO.getRespCode())) {
                    throw new BusinessException("8888", uacNoTaskAuditCancelRspBO.getRespDesc());
                }
            }
            CContractInfoLogPO cContractInfoLogPO = new CContractInfoLogPO();
            BeanUtils.copyProperties((Object)saleContractInfoPO, (Object)cContractInfoLogPO);
            CContractInfoLogPO deletePO = new CContractInfoLogPO();
            deletePO.setContractId(saleContractId);
            this.cContractInfoLogMapper.deleteBy(deletePO);
            this.cContractInfoLogMapper.insert(cContractInfoLogPO);
            ContractInfoPO purchaseContractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
            ContractSyncInfoVO contractSyncInfoVO = new ContractSyncInfoVO();
            BeanUtils.copyProperties((Object)purchaseContractInfoPO, (Object)contractSyncInfoVO);
            BeanUtils.copyProperties((Object)contractSyncInfoVO, (Object)saleContractInfoPO);
            saleContractInfoPO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_PENDING_SUBMISSION);
            this.contractInfoMapper.updateByPrimaryKeySelective(saleContractInfoPO);
            ContractSettlementDetailPO contractSettlementDetailPO = new ContractSettlementDetailPO();
            contractSettlementDetailPO.setRelateId(saleContractInfoPO.getContractId());
            contractSettlementDetailPO.setExtField1("1");
            this.contractSettlementDetailMapper.deleteBy(contractSettlementDetailPO);
            ContractSettlementDetailPO qryPo = new ContractSettlementDetailPO();
            qryPo.setRelateId(purchaseContractInfoPO.getContractId());
            List<ContractSettlementDetailPO> contractSettlementDetailPOS = this.contractSettlementDetailMapper.getList(qryPo);
            if (!CollectionUtils.isEmpty(contractSettlementDetailPOS)) {
                for (ContractSettlementDetailPO settlementDetailPO : contractSettlementDetailPOS) {
                    settlementDetailPO.setId(Sequence.getInstance().nextId());
                    settlementDetailPO.setRelateId(saleContractInfoPO.getContractId());
                    settlementDetailPO.setExtField1("1");
                }
                this.contractSettlementDetailMapper.insertBatch(contractSettlementDetailPOS);
            }
            if (!CollectionUtils.isEmpty(saleContractInfoItemPOS = this.contractInfoItemMapper.selectItemByContractId(saleContractId))) {
                List itemLogPOS = JSONObject.parseArray((String)JSONObject.toJSONString(saleContractInfoItemPOS), CContractInfoItemLogPO.class);
                List<Long> itemIds = itemLogPOS.stream().map(CContractInfoItemLogPO::getItemId).collect(Collectors.toList());
                CContractInfoItemLogPO deleteItemPO = new CContractInfoItemLogPO();
                deleteItemPO.setItemIds(itemIds);
                this.cContractInfoItemLogMapper.deleteBy(deleteItemPO);
                this.cContractInfoItemLogMapper.insertBatch(itemLogPOS);
            }
            if (!CollectionUtils.isEmpty(purchaseContractInfoItemPOS = this.contractInfoItemMapper.selectItemByContractId(reqBO.getContractId()))) {
                ArrayList<ContractInfoItemPO> addSaleContractInfoItemPOS = new ArrayList<ContractInfoItemPO>();
                ArrayList<ContractInfoItemPO> updateSaleContractInfoItemPOS = new ArrayList<ContractInfoItemPO>();
                ArrayList<CRelBuySaleContractPO> addsaleContractPOS = new ArrayList<CRelBuySaleContractPO>();
                Map<Long, List<ContractInfoItemPO>> purchaseItemIdMap = purchaseContractInfoItemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getItemId));
                Map<Long, List<CRelBuySaleContractPO>> relItemIdMap = relBuySaleContractPOS.stream().collect(Collectors.groupingBy(CRelBuySaleContractPO::getBuyItemId));
                Map<Long, List<ContractInfoItemPO>> saleItemIdMap = saleContractInfoItemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getItemId));
                Set<Long> purchaseItemIds = purchaseItemIdMap.keySet();
                for (Long l : purchaseItemIds) {
                    if (relItemIdMap.containsKey(l)) {
                        Long saleItemId = relItemIdMap.get(l).get(0).getSaleItemId();
                        ContractInfoItemPO updateSaleItemPO = saleItemIdMap.get(saleItemId).get(0);
                        ContractInfoItemPO purchaseItemPO = purchaseItemIdMap.get(l).get(0);
                        ContractInfoItemSyncInfoVO contractInfoItemSyncInfoVO = new ContractInfoItemSyncInfoVO();
                        BeanUtils.copyProperties((Object)purchaseItemPO, (Object)contractInfoItemSyncInfoVO);
                        BeanUtils.copyProperties((Object)contractInfoItemSyncInfoVO, (Object)updateSaleItemPO);
                        BigDecimal purchaseItemtaxUnitPrice = purchaseItemPO.getTaxUnitPrice().setScale(2, 4);
                        if (updateSaleItemPO.getAddRate() == null) {
                            updateSaleItemPO.setAddRate(0);
                        }
                        if (updateSaleItemPO.getRate() == null) {
                            updateSaleItemPO.setRate(0);
                        }
                        BigDecimal addRate = new BigDecimal(String.valueOf(1.0f + (float)updateSaleItemPO.getAddRate().intValue() / 100.0f));
                        BigDecimal tax = new BigDecimal(String.valueOf(1.0f + (float)updateSaleItemPO.getRate().intValue() / 100.0f));
                        updateSaleItemPO.setTaxUnitPrice(purchaseItemtaxUnitPrice.multiply(addRate).setScale(2, 4));
                        updateSaleItemPO.setUnitPriceExcludingTax(updateSaleItemPO.getTaxUnitPrice().divide(tax, 2, 4).multiply(new BigDecimal("1")).setScale(2, 4));
                        updateSaleItemPO.setTaxAmount(updateSaleItemPO.getTaxUnitPrice().multiply(new BigDecimal(updateSaleItemPO.getAmount().toString())).setScale(2, 4));
                        updateSaleItemPO.setNotIncludingTaxAmount(updateSaleItemPO.getUnitPriceExcludingTax().multiply(new BigDecimal(updateSaleItemPO.getAmount().toString())).setScale(2, 4));
                        updateSaleItemPO.setTax(updateSaleItemPO.getTaxAmount().subtract(updateSaleItemPO.getNotIncludingTaxAmount()).setScale(2, 4));
                        updateSaleItemPO.setAwardNumId(null);
                        updateSaleItemPO.setRelateItemId(l);
                        updateSaleContractInfoItemPOS.add(updateSaleItemPO);
                        continue;
                    }
                    List<ContractInfoItemPO> contractInfoItemPOS = purchaseItemIdMap.get(l);
                    Long buyItemId = contractInfoItemPOS.get(0).getItemId();
                    ContractInfoItemPO addSaleContractInfoItemPO = contractInfoItemPOS.get(0);
                    long saleItemId = this.uccBatchSequence.nextId();
                    addSaleContractInfoItemPO.setItemId(saleItemId);
                    addSaleContractInfoItemPO.setRelateId(saleContractInfoPO.getContractId());
                    addSaleContractInfoItemPO.setRelateCode(saleContractInfoPO.getContractCode());
                    addSaleContractInfoItemPO.setAwardNumId(null);
                    addSaleContractInfoItemPO.setRelateItemId(l);
                    addSaleContractInfoItemPOS.add(addSaleContractInfoItemPO);
                    CRelBuySaleContractPO addsaleContractPO = new CRelBuySaleContractPO();
                    addsaleContractPO.setId(this.uccBatchSequence.nextId());
                    addsaleContractPO.setBuyContractId(reqBO.getContractId());
                    addsaleContractPO.setBuyItemId(buyItemId);
                    addsaleContractPO.setSaleContractId(saleContractInfoPO.getContractId());
                    addsaleContractPO.setSaleItemId(saleItemId);
                    addsaleContractPOS.add(addsaleContractPO);
                }
                if (!CollectionUtils.isEmpty(addSaleContractInfoItemPOS)) {
                    this.contractInfoItemMapper.insertBatch(addSaleContractInfoItemPOS);
                    List list = JSONObject.parseArray((String)JSONObject.toJSONString(addSaleContractInfoItemPOS), ContractInfoItemTmpPO.class);
                    list.forEach(e -> {
                        e.setUuid(Sequence.getInstance().nextId());
                        e.setDelFlag("0");
                    });
                    this.contractInfoItemTmpMapper.insertBatch(list);
                }
                if (!CollectionUtils.isEmpty(addsaleContractPOS)) {
                    this.cRelBuySaleContractMapper.insertBatch(addsaleContractPOS);
                }
                if (!CollectionUtils.isEmpty(updateSaleContractInfoItemPOS)) {
                    if (updateSaleContractInfoItemPOS.size() > this.maxCount) {
                        ArrayList<ContractInfoItemPO> updateItem = new ArrayList<ContractInfoItemPO>();
                        for (ContractInfoItemPO updateContractItemPo : updateSaleContractInfoItemPOS) {
                            if (updateItem.size() < this.maxCount) {
                                updateItem.add(updateContractItemPo);
                                continue;
                            }
                            updateItem.add(updateContractItemPo);
                            this.contractInfoItemMapper.updateBatch(updateItem);
                            updateItem = new ArrayList();
                        }
                        if (!CollectionUtils.isEmpty(updateItem)) {
                            this.contractInfoItemMapper.updateBatch(updateItem);
                        }
                    } else {
                        this.contractInfoItemMapper.updateBatch(updateSaleContractInfoItemPOS);
                    }
                    List updateSaleContractInfoItemTempPOS = JSONObject.parseArray((String)JSONObject.toJSONString(updateSaleContractInfoItemPOS), ContractInfoItemTmpPO.class);
                    if (updateSaleContractInfoItemTempPOS.size() > this.maxCount) {
                        void var27_37;
                        ArrayList arrayList = new ArrayList();
                        for (ContractInfoItemTmpPO updateContractItemPo : updateSaleContractInfoItemTempPOS) {
                            if (var27_37.size() < this.maxCount) {
                                var27_37.add(updateContractItemPo);
                                continue;
                            }
                            var27_37.add(updateContractItemPo);
                            this.contractInfoItemTmpMapper.updateBatch((List<ContractInfoItemTmpPO>)var27_37);
                            ArrayList arrayList2 = new ArrayList();
                        }
                        if (!CollectionUtils.isEmpty((Collection)var27_37)) {
                            this.contractInfoItemTmpMapper.updateBatch((List<ContractInfoItemTmpPO>)var27_37);
                        }
                    } else {
                        this.contractInfoItemTmpMapper.updateBatch(updateSaleContractInfoItemTempPOS);
                    }
                }
            }
        } else if (reqBO.getOperationType() == 3) {
            if (saleContractInfoPO != null) {
                String extFiled1 = saleContractInfoPO.getExtFiled1();
                if (StringUtils.isEmpty((Object)extFiled1)) {
                    return rspBO;
                }
                ContractInfoPO updatePO = new ContractInfoPO();
                updatePO.setContractId(saleContractId);
                updatePO.setContractStatus(Integer.valueOf(extFiled1));
                int count = this.contractInfoMapper.updateByPrimaryKeySelective(updatePO);
                if (count == 0) {
                    throw new ZTBusinessException("\u91c7\u8d2d\u5408\u540c\u540c\u6b65\u5931\u8d25");
                }
            }
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u5b9a\u4e49\u7684\u64cd\u4f5c\u7c7b\u578b");
            return rspBO;
        }
        rspBO.setSaleContractId(saleContractId);
        return rspBO;
    }
}

