/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.cfc.ability.api.CfcUniteParamQryListDetailForContractAbilityService;
import com.tydic.contract.ability.bo.ContractExpressRelationBO;
import com.tydic.contract.ability.bo.ContractNoTaskAuditOrderAuditNoticeBO;
import com.tydic.contract.ability.bo.ContractSealRecordBO;
import com.tydic.contract.atom.ContractDealerCheckAtomService;
import com.tydic.contract.atom.ContractOrderCheckAtomService;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.ContractStartApprovalProcessAtomService;
import com.tydic.contract.atom.InterFaceContractGetCanOrderNumAtomService;
import com.tydic.contract.atom.InterFaceContractUpdateOrderItemAtomService;
import com.tydic.contract.atom.bo.ContractDealerCheckAtomReqBO;
import com.tydic.contract.atom.bo.ContractDealerCheckAtomRspBO;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.atom.bo.ContractStartApprovalProcessAtomReqBO;
import com.tydic.contract.atom.bo.ContractStartApprovalProcessAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractUpdateOrderItemAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractUpdateOrderItemAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractUpdateOrderItemBO;
import com.tydic.contract.busi.ContractAddNewOtherBusiService;
import com.tydic.contract.busi.bo.ContractAddNewBusiReqBO;
import com.tydic.contract.busi.bo.ContractAddNewOtherBusiReqBO;
import com.tydic.contract.busi.bo.ContractAddNewOtherBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractDemanderUnitMapper;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.CContractInfoItemDeleteLogMapper;
import com.tydic.contract.dao.CContractInfoItemTmpDeleteLogMapper;
import com.tydic.contract.dao.CContractOrderInfoMapper;
import com.tydic.contract.dao.CRelBuySaleContractMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractRelSignConfigItemMapper;
import com.tydic.contract.dao.ContractRelSignConfigMapper;
import com.tydic.contract.dao.ContractSealRecordMapper;
import com.tydic.contract.dao.ContractSettlementDetailMapper;
import com.tydic.contract.dao.ContractSignConfigItemMapper;
import com.tydic.contract.dao.ContractSignConfigMapper;
import com.tydic.contract.po.CContractDemanderUnitPO;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.CContractInfoItemDeleteLogPO;
import com.tydic.contract.po.CContractInfoItemTmpDeleteLogPO;
import com.tydic.contract.po.CContractOrderInfoPO;
import com.tydic.contract.po.CRelBuySaleContractPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractRelSignConfigItemPO;
import com.tydic.contract.po.ContractRelSignConfigPO;
import com.tydic.contract.po.ContractSealRecordPO;
import com.tydic.contract.po.ContractSettlementDetailPO;
import com.tydic.contract.po.ContractSignConfigItemPO;
import com.tydic.contract.po.ContractSignConfigPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateUtils;
import com.tydic.contract.utils.FileHelper;
import com.tydic.contract.utils.HttpUtil;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.contract.utils.WordToPdf;
import com.tydic.umc.general.ability.api.UmcContractQueryBuyerInfoAbilityService;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubBO;
import com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractAddNewOtherBusiServiceImpl
implements ContractAddNewOtherBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractAddNewOtherBusiServiceImpl.class);
    public static final String FIELD_CONTRACT_ID = "contractId";
    public static final String FIELD_CONTRACT_CODE = "contractCode";
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    CContractDemanderUnitMapper cContractDemanderUnitMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    @Autowired
    private InterFaceContractGetCanOrderNumAtomService interFaceContractGetCanOrderNumAtomService;
    @Autowired
    private InterFaceContractUpdateOrderItemAtomService interFaceContractUpdateOrderItemAtomService;
    @Autowired
    private ContractStartApprovalProcessAtomService contractStartApprovalProcessAtomService;
    @Autowired
    private CRelBuySaleContractMapper cRelBuySaleContractMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private CContractOrderInfoMapper cContractOrderInfoMapper;
    @Autowired
    private PebUpdateOrderAbilityService pebUpdateOrderAbilityService;
    @Autowired
    private ContractDealerCheckAtomService contractDealerCheckAtomService;
    @Autowired
    private CfcUniteParamQryListDetailForContractAbilityService cfcUniteParamQryListDetailForContractAbilityService;
    @Autowired
    private ContractSealRecordMapper contractSealRecordMapper;
    @Autowired
    private ContractOrderCheckAtomService contractOrderCheckAtomService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Resource(name="mqContractPushDealFwOrderFileProvider")
    private ProxyMessageProducer mqContractPushDealFwOrderFileProvider;
    @Value(value="${CONTRACT_PUSH_DEAL_FW_ORDER_FILE_TOPIC:CONTRACT_PUSH_DEAL_FW_ORDER_FILE_TOPIC}")
    private String topic;
    @Value(value="${CONTRACT_PUSH_ERP_TAG:*}")
    private String tag;
    @Autowired
    UmcContractQueryBuyerInfoAbilityService umcContractQueryBuyerInfoAbilityService;
    private InterFaceContractUpdateOrderItemAtomReqBO rollBackInterFaceContractUpdateOrderItemAtomReqBO;
    @Autowired
    private ContractSettlementDetailMapper contractSettlementDetailMapper;
    @Autowired
    private CContractInfoItemDeleteLogMapper cContractInfoItemDeleteLogMapper;
    @Autowired
    private CContractInfoItemTmpDeleteLogMapper cContractInfoItemTmpDeleteLogMapper;
    @Autowired
    private ContractRelSignConfigItemMapper contractRelSignConfigItemMapper;
    @Autowired
    private ContractRelSignConfigMapper contractRelSignConfigMapper;
    @Autowired
    private ContractSignConfigItemMapper contractSignConfigItemMapper;
    @Autowired
    private ContractSignConfigMapper contractSignConfigMapper;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "contract/pdf";
    @Autowired
    CContractInfoExtMapper cContractInfoExtMapper;

    @Override
    public ContractAddNewOtherBusiRspBO addContractNewOther(ContractAddNewOtherBusiReqBO reqBO) {
        List<ContractSealRecordBO> collect;
        List<ContractInfoPO> contractInfoPOS;
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("\u5408\u540cid\u5fc5\u4f20");
        }
        ContractAddNewOtherBusiRspBO rspBO = new ContractAddNewOtherBusiRspBO();
        if (!(StringUtils.isEmpty((Object)reqBO.getContractCode()) || CollectionUtils.isEmpty(contractInfoPOS = this.contractInfoMapper.qryByContractCode(reqBO.getContractCode())) || CollectionUtils.isEmpty(collect = contractInfoPOS.stream().filter(e -> e.getContractStatus() != null && !e.getContractStatus().equals(10) && !e.getContractId().equals(reqBO.getContractId())).collect(Collectors.toList())))) {
            throw new ZTBusinessException("\u5408\u540c\u7f16\u53f7\u5df2\u91cd\u590d");
        }
        Integer multiDealerFlag = null;
        if (reqBO.getMultiDealerFlag() == null) {
            ContractInfoPO po = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
            if (po != null) {
                multiDealerFlag = po.getMultiDealerFlag();
            }
        } else {
            multiDealerFlag = reqBO.getMultiDealerFlag();
        }
        if (multiDealerFlag == null) {
            multiDealerFlag = 0;
        }
        this.translationContractDocToPdfUrl(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getSealRecordBOList())) {
            collect = reqBO.getSealRecordBOList().stream().filter(e -> e.getSealNum() != null && e.getSealType() != null).collect(Collectors.toList());
            reqBO.setSealRecordBOList(collect);
        }
        try {
            if ("0".equals(reqBO.getOperType())) {
                Map<String, Object> resultMap = this.addContract(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u5408\u540c\u6210\u529f");
                rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                return rspBO;
            }
            if ("1".equals(reqBO.getOperType())) {
                this.saveContract(reqBO, rspBO);
                rspBO.setContractId(reqBO.getContractId());
                rspBO.setContractCode(reqBO.getContractCode());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u4fdd\u5b58\u5408\u540c\u6210\u529f");
                return rspBO;
            }
            if ("2".equals(reqBO.getOperType())) {
                reqBO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_IN_CONFIRM);
                this.saveContract(reqBO, rspBO);
                this.isNullCheckout(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u4fdd\u5b58\u5408\u540c\u6210\u529f");
                return rspBO;
            }
            rspBO.setRespCode("1007");
            rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b");
            return rspBO;
        }
        catch (Exception e2) {
            log.error("\u5e38\u5904\u7406\u60c5\u51b5\u7684 \u5bf9 \u5df2\u7ecf\u6263\u51cf\u975e\u62db\u660e\u7ec6\u7684\u56de\u6eda\u64cd\u4f5c" + e2.getMessage());
            if (reqBO.getRollBackInterFaceContractUpdateOrderItemAtomReqBO() != null && !CollectionUtils.isEmpty(reqBO.getRollBackInterFaceContractUpdateOrderItemAtomReqBO().getOrderItem()) && !StringUtils.isEmpty((Object)reqBO.getRollBackInterFaceContractUpdateOrderItemAtomReqBO().getToken())) {
                for (InterFaceContractUpdateOrderItemBO itemBO : reqBO.getRollBackInterFaceContractUpdateOrderItemAtomReqBO().getOrderItem()) {
                    if (itemBO.getOperateType() == 1) {
                        itemBO.setOperateType(0);
                        continue;
                    }
                    if (itemBO.getOperateType() != 0) continue;
                    itemBO.setOperateType(1);
                }
                this.interFaceContractUpdateOrderItemAtomService.updateOrderItem(reqBO.getRollBackInterFaceContractUpdateOrderItemAtomReqBO());
            }
            throw new ZTBusinessException(e2.getMessage());
        }
    }

    private void isNullCheckout(ContractAddNewOtherBusiReqBO reqBO) {
        ContractInfoPO oldContractInfoPo = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
        ContractInfoItemTmpPO contractInfoItemTmpPo = new ContractInfoItemTmpPO();
        contractInfoItemTmpPo.setRelateId(reqBO.getContractId());
        contractInfoItemTmpPo.setJumpChangeStatus(1);
        List<ContractInfoItemTmpPO> contractInfoItemTmpPOList = this.contractInfoItemTmpMapper.getList(contractInfoItemTmpPo);
        if (null != oldContractInfoPo) {
            if (!StringUtils.isEmpty((Object)oldContractInfoPo.getContractType()) && oldContractInfoPo.getContractType().equals(5)) {
                if (!CollectionUtils.isEmpty(contractInfoItemTmpPOList)) {
                    contractInfoItemTmpPOList.forEach(e -> {
                        if (StringUtils.isEmpty((Object)e.getGuaranteePeriod())) {
                            throw new ZTBusinessException("\u8d28\u4fdd\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isEmpty((Object)e.getSupplyCycle())) {
                            throw new ZTBusinessException("\u4f9b\u8d27\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                    });
                }
            } else {
                this.contractInfoItemTmpMapper.updateInItSupplyCycleAndGuaranteePeriodDate(reqBO.getContractId());
                this.contractInfoItemMapper.updateInItSupplyCycleAndGuaranteePeriodDateByContractId(reqBO.getContractId());
            }
        }
    }

    private void saveAfter(ContractAddNewOtherBusiReqBO reqBO, List<String> awardIds, List<String> allAwardIds, Integer multiDealerFlag) {
        if (!CollectionUtils.isEmpty(allAwardIds)) {
            ContractDealerCheckAtomReqBO checkAtomReqBO = new ContractDealerCheckAtomReqBO();
            checkAtomReqBO.setToken(reqBO.getAuthToken());
            checkAtomReqBO.setOperationType(3);
            checkAtomReqBO.setAwardIds(awardIds);
            checkAtomReqBO.setAllAwardIds(allAwardIds);
            checkAtomReqBO.setDealerFlag(multiDealerFlag);
            if (!(ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT.equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT.equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT.equals(reqBO.getContractType()))) {
                try {
                    ContractDealerCheckAtomRspBO atomRspBO = this.contractDealerCheckAtomService.contractDealerCheckAwardIds(checkAtomReqBO);
                    if (!"0000".equals(atomRspBO.getRespCode())) {
                        throw new ZTBusinessException(atomRspBO.getRespDesc());
                    }
                }
                catch (Exception e) {
                    throw new ZTBusinessException(e.getMessage());
                }
            }
        }
    }

    private Map<String, Object> addContract(ContractAddNewOtherBusiReqBO reqBO) {
        Map<String, Object> addContractResultMap = this.addContractInfo(reqBO);
        this.saveContractInfoExt(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getSealRecordBOList())) {
            this.addSealRecord(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getAccessoryList())) {
            this.addContractAccessoryInfo(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getBasicAccessoryList())) {
            this.addContractBasicAccessoryInfo(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getFwOrderFileAccessoryBOList())) {
            this.addContractFwOrderFileAccessoryInfo(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getSupplierAccessoryBOList())) {
            this.addSupplierAccessoryInfo(reqBO);
        }
        this.addSettlementDetail(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getBaseOtherAccessoryBOList())) {
            this.addContractbaseOtherAccessoryInfo(reqBO);
        }
        this.recordContractNodeOperLog(reqBO);
        return addContractResultMap;
    }

    private void saveContractInfoExt(ContractAddNewOtherBusiReqBO reqBO) {
        if (ObjectUtil.isNotEmpty((Object)reqBO.getContractInfoExtBO())) {
            CContractInfoExtPO infoExtPO = new CContractInfoExtPO();
            BeanUtils.copyProperties((Object)reqBO.getContractInfoExtBO(), (Object)infoExtPO);
            infoExtPO.setId(Sequence.getInstance().nextId());
            infoExtPO.setRelateId(reqBO.getContractId());
            infoExtPO.setCreateTime(new Date());
            infoExtPO.setCreateUserId(reqBO.getUserId());
            infoExtPO.setCreateUserCode(reqBO.getUsername());
            infoExtPO.setCreateUserName(reqBO.getName());
            infoExtPO.setUpdateTime(new Date());
            infoExtPO.setUpdateUserId(reqBO.getUserId());
            infoExtPO.setUpdateUserCode(reqBO.getUsername());
            infoExtPO.setUpdateUserName(reqBO.getName());
            infoExtPO.setMainBody(reqBO.getMainBody());
            this.cContractInfoExtMapper.insert(infoExtPO);
        }
    }

    private void saveContract(ContractAddNewOtherBusiReqBO reqBO, ContractAddNewOtherBusiRspBO rspBO) {
        this.saveContractInfo(reqBO, rspBO);
        this.updateContractInfExt(reqBO);
        this.updateContractAccessoryInfo(reqBO);
        this.updateSealRecord(reqBO);
        this.addSettlementDetail(reqBO);
        this.saveContractInfoSignConfig(reqBO);
    }

    private void updateContractInfExt(ContractAddNewOtherBusiReqBO reqBO) {
        CContractInfoExtPO qryPo = new CContractInfoExtPO();
        qryPo.setRelateId(reqBO.getContractId());
        CContractInfoExtPO contractInfoExt = this.cContractInfoExtMapper.getModelBy(qryPo);
        if (ObjectUtil.isNotEmpty((Object)contractInfoExt)) {
            CContractInfoExtPO setUpdatePo = new CContractInfoExtPO();
            BeanUtils.copyProperties((Object)reqBO.getContractInfoExtBO(), (Object)setUpdatePo);
            setUpdatePo.setUpdateTime(new Date());
            setUpdatePo.setUpdateUserId(reqBO.getUserId());
            setUpdatePo.setUpdateUserCode(reqBO.getUsername());
            setUpdatePo.setUpdateUserName(reqBO.getName());
            setUpdatePo.setCreateUserId(contractInfoExt.getCreateUserId());
            setUpdatePo.setCreateUserName(contractInfoExt.getCreateUserName());
            setUpdatePo.setCreateUserCode(contractInfoExt.getCreateUserCode());
            setUpdatePo.setCreateTime(contractInfoExt.getCreateTime());
            setUpdatePo.setMainBody(reqBO.getMainBody());
            CContractInfoExtPO wherePo = new CContractInfoExtPO();
            wherePo.setId(contractInfoExt.getId());
            this.cContractInfoExtMapper.updateBy(setUpdatePo, wherePo);
        } else {
            this.saveContractInfoExt(reqBO);
        }
    }

    private void saveContractInfo(ContractAddNewOtherBusiReqBO reqBO, ContractAddNewOtherBusiRspBO rspBO) {
        ContractInfoPO oldContractInfoPo;
        if (reqBO.getSupplierId() != null) {
            UmcEnterpriseOrgQryDetailAbilityReqBO bo = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            bo.setOrgIdWeb(reqBO.getSupplierId());
            UmcEnterpriseOrgQryDetailAbilityRspBO detailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(bo);
            if ("0000".equals(detailAbilityRspBO.getRespCode()) && detailAbilityRspBO.getUmcEnterpriseOrgDetailBO() != null && "01".equals(detailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDelStatus())) {
                reqBO.setVendorStatus(0);
            }
        }
        UmcEnterpriseOrgQryDetailAbilityReqBO buyerBo = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        if (!StringUtils.isEmpty((Object)reqBO.getBuyerNo())) {
            buyerBo.setOrgCode(reqBO.getBuyerNo());
            UmcEnterpriseOrgQryDetailAbilityRspBO buyerRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(buyerBo);
            if ("0000".equals(buyerRspBO.getRespCode()) && buyerRspBO.getUmcEnterpriseOrgDetailBO() != null) {
                reqBO.setOrgTaxFlag(buyerRspBO.getUmcEnterpriseOrgDetailBO().getTaxInclude());
                if (StringUtils.isEmpty((Object)reqBO.getOrgTaxFlag())) {
                    reqBO.setOrgTaxFlag("0");
                }
            }
        }
        if ((oldContractInfoPo = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId())) != null) {
            ContractInfoPO updateContractInfoPo = new ContractInfoPO();
            BeanUtils.copyProperties((Object)oldContractInfoPo, (Object)updateContractInfoPo);
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateContractInfoPo);
            updateContractInfoPo.setUpdateUserId(reqBO.getUserId());
            updateContractInfoPo.setUpdateUserName(reqBO.getUsername());
            updateContractInfoPo.setUpdateTime(new Date());
            updateContractInfoPo.setCreateUserId(oldContractInfoPo.getCreateUserId());
            updateContractInfoPo.setCreateUserName(oldContractInfoPo.getCreateUserName());
            updateContractInfoPo.setCreateUserCode(oldContractInfoPo.getCreateUserCode());
            updateContractInfoPo.setCreateDeptId(oldContractInfoPo.getCreateDeptId());
            updateContractInfoPo.setCreateDeptName(oldContractInfoPo.getCreateDeptName());
            updateContractInfoPo.setCreateDeptCode(oldContractInfoPo.getCreateDeptCode());
            if (!StringUtils.isEmpty((Object)reqBO.getDownloadTaskId())) {
                updateContractInfoPo.setDownloadTaskId(reqBO.getDownloadTaskId());
                updateContractInfoPo.setItemAccessoryName("\u5408\u540c\u7269\u8d44\u660e\u7ec6\u9644\u4ef6.xlsx");
                updateContractInfoPo.setDownloadIsProcess(0);
                updateContractInfoPo.setItemAccessoryUrl(null);
                updateContractInfoPo.setItemAccessoryFailInfo(null);
                updateContractInfoPo.setItemAccessoryGenerateState(1);
            } else {
                updateContractInfoPo.setDownloadTaskId(oldContractInfoPo.getDownloadTaskId());
            }
            if (!StringUtils.isEmpty((Object)updateContractInfoPo.getTemplateCode()) && StringUtils.isEmpty((Object)updateContractInfoPo.getContractDocUrl())) {
                updateContractInfoPo.setContractDocUrl(null);
                updateContractInfoPo.setContractDocName(null);
            }
            if (null != reqBO.getContractAmount()) {
                updateContractInfoPo.setContractAmount(MoneyUtils.yuanToHaoToLong(reqBO.getContractAmount()));
            }
            if (null != reqBO.getContractAmountExcludingTax()) {
                updateContractInfoPo.setContractAmountExcludingTax(MoneyUtils.yuanToHaoToLong(reqBO.getContractAmountExcludingTax()));
            }
            if (null != reqBO.getContractTax()) {
                updateContractInfoPo.setContractTax(MoneyUtils.yuanToHaoToLong(reqBO.getContractTax()));
            }
            if (null != reqBO.getMinAmount()) {
                updateContractInfoPo.setMinAmount(MoneyUtils.yuanToHaoToLong(reqBO.getMinAmount()));
            }
            if (null != reqBO.getContractDeposit()) {
                updateContractInfoPo.setContractDeposit(MoneyUtils.yuanToHaoToLong(reqBO.getContractDeposit()));
            }
            if (null != reqBO.getAmountLimit()) {
                updateContractInfoPo.setAmountLimit(MoneyUtils.yuanToHaoToLong(reqBO.getAmountLimit()));
            }
            if (null != reqBO.getDiscussAmount()) {
                updateContractInfoPo.setDiscussAmount(MoneyUtils.yuanToHaoToLong(reqBO.getDiscussAmount()));
            }
            updateContractInfoPo.setIsNeedSupplierConfirm(0);
            if ("2".equals(reqBO.getOperType())) {
                ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(updateContractInfoPo.getContractId());
                if (ContractConstant.ContractType.SALE_CONTRACT.equals(oldContractInfoPo.getContractType()) || ContractConstant.ContractType.ORDER_CONTRACT.equals(oldContractInfoPo.getContractType()) || !StringUtils.isEmpty((Object)reqBO.getIsSupConfirm()) && reqBO.getIsSupConfirm() == 0) {
                    updateContractInfoPo.setIsNeedSupplierConfirm(1);
                    log.info("\u662f\u5426\u4f9b\u5e94\u5546\u786e\u8ba4\u5f00\u59cb******" + (Object)((Object)reqBO), (Object)updateContractInfoPo, (Object)contractInfoPO);
                    this.unitContractStartProcess(reqBO, updateContractInfoPo, contractInfoPO, rspBO);
                } else {
                    if (ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT.equals(oldContractInfoPo.getContractType()) && (reqBO.getIsSupConfirm() == null || reqBO.getIsSupConfirm() != 0)) {
                        updateContractInfoPo.setPurchaseContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_IN_CONFIRM);
                        if (oldContractInfoPo.getPurchaseApprovalId() == null) {
                            updateContractInfoPo.setPurchaseApprovalId(this.uccBatchSequence.nextId());
                        }
                    }
                    if (ContractConstant.ContractType.OTHER_LONG_TERM_PRICING_CONTRACT.equals(oldContractInfoPo.getContractType()) || ContractConstant.ContractType.OTHER_PROMPT_CONTRACT.equals(oldContractInfoPo.getContractType())) {
                        updateContractInfoPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
                        ContractStartApprovalProcessAtomReqBO atomReqBO = new ContractStartApprovalProcessAtomReqBO();
                        log.info("\u67e5\u8be2\u51fa\u6765\u7684\u5408\u540c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)contractInfoPO.getBusiCode()));
                        if (!StringUtils.isEmpty((Object)reqBO.getBusiCode()) && !"-1".equals(reqBO.getBusiCode())) {
                            atomReqBO.setProcDefKey(reqBO.getBusiCode());
                        } else {
                            atomReqBO.setMenuId("M0010030");
                        }
                        atomReqBO.setContractId(oldContractInfoPo.getContractId());
                        atomReqBO.setObjType(1);
                        atomReqBO.setUserId(reqBO.getUserId());
                        atomReqBO.setUsername(reqBO.getName());
                        atomReqBO.setOrgId(reqBO.getCreateDeptId());
                        atomReqBO.setDept(reqBO.getCreateDeptName());
                        log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u5165\u53c2code\uff1a" + JSON.toJSONString((Object)((Object)atomReqBO)));
                        ContractStartApprovalProcessAtomRspBO atomRspBO = this.contractStartApprovalProcessAtomService.startApprovalProcess(atomReqBO);
                        if (!CollectionUtils.isEmpty(atomRspBO.getApprovalInNotice())) {
                            ContractNoTaskAuditOrderAuditNoticeBO noticeBO = new ContractNoTaskAuditOrderAuditNoticeBO();
                            noticeBO.setOrderId(atomReqBO.getContractId());
                            noticeBO.setApprovalInNotice(atomRspBO.getApprovalInNotice());
                            if (CollectionUtils.isEmpty(rspBO.getAuditNoticeList())) {
                                rspBO.setAuditNoticeList(new ArrayList<ContractNoTaskAuditOrderAuditNoticeBO>());
                            }
                            rspBO.getAuditNoticeList().add(noticeBO);
                        }
                        log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2code\uff1a" + atomRspBO.getRespCode());
                        if (!atomRspBO.getRespCode().equals("0000")) {
                            throw new ZTBusinessException(atomRspBO.getRespDesc());
                        }
                        if (StringUtils.isEmpty((Object)atomRspBO.getStepId())) {
                            log.info("\u5ba1\u6279API\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)((Object)atomRspBO)));
                            throw new ZTBusinessException("\u5ba1\u6279\u6d41\u7a0b\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u56fe");
                        }
                        updateContractInfoPo.setStepId(atomRspBO.getStepId());
                    }
                    this.platformContractIsConfirm(reqBO, contractInfoPO, updateContractInfoPo, rspBO);
                }
                ContractInfoPO po = this.contractInfoMapper.selectByPrimaryKey(updateContractInfoPo.getContractId());
                if (ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT.equals(po.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(po.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(po.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT.equals(po.getContractType()) || ContractConstant.ContractType.ORDER_CONTRACT.equals(po.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT.equals(po.getContractType())) {
                    updateContractInfoPo.setAccessoryDealFlag(1);
                }
            }
            CContractDemanderUnitPO delPO = new CContractDemanderUnitPO();
            delPO.setRelateId(updateContractInfoPo.getContractId());
            this.cContractDemanderUnitMapper.deleteBy(delPO);
            if (!CollectionUtils.isEmpty(reqBO.getCContractDemanderUnitS())) {
                List cContractDemanderUnitPOS = Convert.toList(CContractDemanderUnitPO.class, reqBO.getCContractDemanderUnitS());
                cContractDemanderUnitPOS.forEach(cd -> {
                    cd.setId(Sequence.getInstance().nextId());
                    cd.setCreateUserId(reqBO.getUserId());
                    cd.setCreateUserName(reqBO.getUsername());
                    cd.setCreateTime(new Date());
                    cd.setRelateId(updateContractInfoPo.getContractId());
                });
                this.cContractDemanderUnitMapper.insertBatch(cContractDemanderUnitPOS);
            }
            int updateResult = this.contractInfoMapper.updateByPrimaryKeySelective(updateContractInfoPo);
            if (ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL.equals(updateContractInfoPo.getContractStatus())) {
                CContractInfoExtPO extQry = new CContractInfoExtPO();
                extQry.setRelateId(updateContractInfoPo.getContractId());
                CContractInfoExtPO modelBy = this.cContractInfoExtMapper.getModelBy(extQry);
                if (modelBy != null && ObjectUtils.isEmpty((Object)modelBy.getFinalSubmitTime())) {
                    CContractInfoExtPO wherePo = new CContractInfoExtPO();
                    CContractInfoExtPO setUpdatePo = new CContractInfoExtPO();
                    setUpdatePo.setFinalSubmitTime(new Date());
                    wherePo.setId(modelBy.getId());
                    this.cContractInfoExtMapper.updateBy(setUpdatePo, wherePo);
                }
            }
            if (reqBO.getAmountLimit() == null) {
                updateContractInfoPo.setAmountLimit(null);
            }
            if (reqBO.getContractAmount() == null) {
                updateContractInfoPo.setContractAmount(null);
            }
            if (reqBO.getContractDeposit() == null) {
                updateContractInfoPo.setContractDeposit(null);
            }
            if (reqBO.getDiscussAmount() == null) {
                updateContractInfoPo.setDiscussAmount(null);
            }
            if (reqBO.getMinAmount() == null) {
                updateContractInfoPo.setMinAmount(null);
            }
            if (reqBO.getValidaType() == null) {
                updateContractInfoPo.setValidaType(null);
            }
            if (ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT.equals(updateContractInfoPo.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(updateContractInfoPo.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(updateContractInfoPo.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT.equals(updateContractInfoPo.getContractType()) || ContractConstant.ContractType.ORDER_CONTRACT.equals(updateContractInfoPo.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT.equals(updateContractInfoPo.getContractType())) {
                if (StringUtils.isEmpty((Object)reqBO.getContractDocUrl()) && StringUtils.isEmpty((Object)reqBO.getContractDocName()) && StringUtils.isEmpty((Object)reqBO.getTemplateCode())) {
                    this.contractInfoMapper.updateDirectAssignment2(updateContractInfoPo);
                }
                if (reqBO.getItemAccessoryGenerateFlag() != null && reqBO.getItemAccessoryGenerateFlag() == 2) {
                    updateContractInfoPo.setDownloadTaskId(null);
                    updateContractInfoPo.setItemAccessoryName(null);
                    updateContractInfoPo.setDownloadIsProcess(null);
                    updateContractInfoPo.setItemAccessoryUrl(null);
                    updateContractInfoPo.setItemAccessoryFailInfo(null);
                    updateContractInfoPo.setItemAccessoryGenerateState(null);
                }
            }
            this.contractInfoMapper.updateDirectAssignment(updateContractInfoPo);
            if (updateResult != 1) {
                throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u6570\u636e\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u539f\u5408\u540c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    private Map<String, Object> addContractInfo(ContractAddNewOtherBusiReqBO reqBO) {
        if (reqBO.getOrderId() != null && ContractConstant.ContractType.ORDER_CONTRACT.equals(reqBO.getContractType())) {
            ContractInfoPO seachPO = new ContractInfoPO();
            seachPO.setContractType(ContractConstant.ContractType.ORDER_CONTRACT);
            seachPO.setOrderId(reqBO.getOrderId());
            List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getList(seachPO);
            if (!CollectionUtils.isEmpty(contractInfoPOS)) {
                throw new ZTBusinessException("\u5bf9\u5e94\u8ba2\u5355\u5df2\u751f\u6210\u5bf9\u5e94\u5408\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
            CContractOrderInfoPO contractOrderInfoPO = this.cContractOrderInfoMapper.selectByPrimaryKey(reqBO.getOrderId());
            try {
                if (contractOrderInfoPO == null) {
                    CContractOrderInfoPO insertOrderInfoPO = new CContractOrderInfoPO();
                    BeanUtils.copyProperties((Object)((Object)reqBO), (Object)insertOrderInfoPO);
                    this.cContractOrderInfoMapper.insert(insertOrderInfoPO);
                }
            }
            catch (Exception e) {
                log.error("\u8bb0\u5f55\u8df3\u8f6c\u8ba2\u5355\u8be6\u60c5\u6240\u9700\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38");
            }
        }
        ContractInfoPO insertContractPo = new ContractInfoPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)insertContractPo);
        insertContractPo.setUpdateUserId(reqBO.getUserId());
        insertContractPo.setUpdateUserName(reqBO.getUsername());
        insertContractPo.setUpdateTime(new Date());
        insertContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT);
        insertContractPo.setContractVersion(1);
        ArrayList<Integer> unitContractTypes = new ArrayList<Integer>();
        unitContractTypes.add(ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT);
        unitContractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
        unitContractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
        unitContractTypes.add(ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT);
        unitContractTypes.add(ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT);
        if (unitContractTypes.contains(insertContractPo.getContractType())) {
            insertContractPo.setContractOrgType("1");
        } else {
            insertContractPo.setContractOrgType("0");
        }
        if (null != reqBO.getContractAmount()) {
            insertContractPo.setContractAmount(MoneyUtils.yuanToHaoToLong(reqBO.getContractAmount()));
        }
        if (null != reqBO.getContractAmountExcludingTax()) {
            insertContractPo.setContractAmountExcludingTax(MoneyUtils.yuanToHaoToLong(reqBO.getContractAmountExcludingTax()));
        }
        if (null != reqBO.getContractTax()) {
            insertContractPo.setContractTax(MoneyUtils.yuanToHaoToLong(reqBO.getContractTax()));
        }
        if (null != reqBO.getAmountLimit()) {
            insertContractPo.setAmountLimit(MoneyUtils.yuanToHaoToLong(reqBO.getAmountLimit()));
        }
        if (null != reqBO.getDiscussAmount()) {
            insertContractPo.setDiscussAmount(MoneyUtils.yuanToHaoToLong(reqBO.getDiscussAmount()));
        }
        if (null != reqBO.getMinAmount()) {
            insertContractPo.setMinAmount(MoneyUtils.yuanToHaoToLong(reqBO.getMinAmount()));
        }
        if (null != reqBO.getContractDeposit()) {
            insertContractPo.setContractDeposit(MoneyUtils.yuanToHaoToLong(reqBO.getContractDeposit()));
        }
        insertContractPo.setSignatureFlag(1);
        int addContractResult = this.contractInfoMapper.insertSelective(insertContractPo);
        if (1 == addContractResult) {
            if (!CollectionUtils.isEmpty(insertContractPo.getCContractDemanderUnitS())) {
                List cContractDemanderUnitPOS = Convert.toList(CContractDemanderUnitPO.class, insertContractPo.getCContractDemanderUnitS());
                cContractDemanderUnitPOS.forEach(cd -> {
                    cd.setId(Sequence.getInstance().nextId());
                    cd.setCreateUserId(reqBO.getUserId());
                    cd.setCreateUserName(reqBO.getUsername());
                    cd.setCreateTime(new Date());
                    cd.setRelateId(insertContractPo.getContractId());
                });
                CContractDemanderUnitPO delPO = new CContractDemanderUnitPO();
                delPO.setRelateId(insertContractPo.getContractId());
                this.cContractDemanderUnitMapper.deleteBy(delPO);
                this.cContractDemanderUnitMapper.insertBatch(cContractDemanderUnitPOS);
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(FIELD_CONTRACT_ID, insertContractPo.getContractId());
            resultMap.put(FIELD_CONTRACT_CODE, insertContractPo.getContractCode());
            return resultMap;
        }
        throw new ZTBusinessException("\u5408\u540c\u65b0\u589e\u5931\u8d25");
    }

    private void dealItemInfo(ContractAddNewBusiReqBO reqBO) {
        List<ContractInfoItemTmpPO> insertTempPos;
        ContractInfoPO oldContractInfoPo = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
        if (oldContractInfoPo != null) {
            if (reqBO.getContractType() == null) {
                reqBO.setContractType(oldContractInfoPo.getContractType());
            }
            if (reqBO.getMultiDealerFlag() == null) {
                reqBO.setMultiDealerFlag(oldContractInfoPo.getMultiDealerFlag());
            }
        }
        ContractInfoItemTmpPO qryContractInfoItemTmpPo = new ContractInfoItemTmpPO();
        qryContractInfoItemTmpPo.setRelateId(reqBO.getContractId());
        List<ContractInfoItemTmpPO> deleteContractInfoItemTmpPOList = this.contractInfoItemTmpMapper.getList(qryContractInfoItemTmpPo);
        Long logOperUserId = reqBO.getUserId();
        String logOperUserCode = reqBO.getUsername();
        String logOperUserName = reqBO.getName();
        Date logOperTime = new Date();
        if (!CollectionUtils.isEmpty(deleteContractInfoItemTmpPOList)) {
            List logDeleteItemTmpPOS = JSONObject.parseArray((String)JSONObject.toJSONString(deleteContractInfoItemTmpPOList), CContractInfoItemTmpDeleteLogPO.class);
            logDeleteItemTmpPOS.stream().forEach(e -> {
                e.setLogUuid(this.uccBatchSequence.nextId());
                e.setLogOperUserId(logOperUserId);
                e.setLogOperUserCode(logOperUserCode);
                e.setLogOperUserName(logOperUserName);
                e.setLogOperTime(logOperTime);
                e.setLogOperRemark("ContractAddNewBusiService\u4fee\u6539\u5408\u540c\u670d\u52a1\u5220\u9664\u660e\u7ec6\u8868\u6253\u4e86\u5220\u9664\u6807\u8bb0\u7684\u6570\u636e\u4fee\u6539\u65f6\u95f4" + DateUtils.dateToStrYYYYMMddHHmmss(logOperTime));
            });
            this.cContractInfoItemTmpDeleteLogMapper.insertBatch(logDeleteItemTmpPOS);
        }
        ContractInfoItemTmpPO deleteContractInfoItemTmpPo = new ContractInfoItemTmpPO();
        deleteContractInfoItemTmpPo.setRelateId(reqBO.getContractId());
        this.contractInfoItemTmpMapper.deleteBy(deleteContractInfoItemTmpPo);
        if (!CollectionUtils.isEmpty(deleteContractInfoItemTmpPOList) && !CollectionUtils.isEmpty(insertTempPos = deleteContractInfoItemTmpPOList.stream().filter(a -> !"1".equals(a.getDelFlag())).collect(Collectors.toList()))) {
            for (ContractInfoItemTmpPO contractInfoItemPO : insertTempPos) {
                Integer contractType = reqBO.getContractType();
                if (contractType != null) {
                    if (contractInfoItemPO.getSaleStatus() != null && contractInfoItemPO.getSaleStatus() == 3) {
                        contractInfoItemPO.setSaleStatus(1);
                    }
                    if (ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(contractType) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractType) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractType) || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(contractType)) {
                        if (contractInfoItemPO.getSaleStatus() != null && contractInfoItemPO.getSaleStatus() == 2 && contractInfoItemPO.getSaleAmount() == null) {
                            contractInfoItemPO.setSaleAmount(contractInfoItemPO.getAmount());
                        }
                    } else if (contractInfoItemPO.getSaleStatus() != null && contractInfoItemPO.getSaleStatus() == 2) {
                        contractInfoItemPO.setSaleStatus(1);
                        contractInfoItemPO.setSaleAmount(null);
                    }
                }
                if (contractInfoItemPO.getSaleStatus() == null || contractInfoItemPO.getSaleStatus() != 1 && contractInfoItemPO.getSaleStatus() != 3) continue;
                contractInfoItemPO.setSaleAmount(null);
            }
            this.contractInfoItemTmpMapper.insertBatch(insertTempPos);
        }
        ContractInfoItemTmpPO contractInfoItemTmpPo = new ContractInfoItemTmpPO();
        contractInfoItemTmpPo.setRelateId(reqBO.getContractId());
        contractInfoItemTmpPo.setJumpChangeStatus(1);
        List<ContractInfoItemTmpPO> contractInfoItemTmpPOList = this.contractInfoItemTmpMapper.getList(contractInfoItemTmpPo);
        if ("2".equals(reqBO.getOperType())) {
            boolean isCheck = false;
            if (!CollectionUtils.isEmpty(reqBO.getExpressRelationBOS()) && reqBO.getExpressRelationBOS().size() > 0) {
                for (ContractExpressRelationBO relationBO : reqBO.getExpressRelationBOS()) {
                    if (relationBO.getExpressType() == null || relationBO.getExpressType() != 2) continue;
                    isCheck = true;
                    break;
                }
            }
            boolean finalIsCheck = isCheck;
            contractInfoItemTmpPOList.forEach(contractInfoItemTmpPO -> {
                if (contractInfoItemTmpPO.getRate() == null) {
                    throw new ZTBusinessException("\u660e\u7ec6\u7684\u7a0e\u7387\u3010rate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (finalIsCheck && contractInfoItemTmpPO.getMetalContent() == null) {
                    throw new ZTBusinessException("\u91d1\u5c5e\u542b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(oldContractInfoPo.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(oldContractInfoPo.getContractType())) {
                    if (StringUtils.isEmpty((Object)contractInfoItemTmpPO.getErpOrgCode())) {
                        throw new ZTBusinessException("\u660e\u7ec6\u7684\u7a0e\u7387\u3010\u5e93\u5b58\u7ec4\u7ec7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (contractInfoItemTmpPO.getNeedArriveTime() == null) {
                        // empty if block
                    }
                    if (contractInfoItemTmpPO.getFactoryPrice() == null) {
                        throw new ZTBusinessException("\u660e\u7ec6\u7684\u7a0e\u7387\u3010\u5230/\u51fa\u5382\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (!ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT.equals(oldContractInfoPo.getContractType()) || contractInfoItemTmpPO.getNeedArriveTime() == null) {
                    // empty if block
                }
            });
        }
        try {
            ContractInfoPO infoPO;
            if (reqBO.getIsSupplierUpdate() == null && ((infoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId())) == null || infoPO.getMultiDealerFlag() == null || infoPO.getMultiDealerFlag() != 1)) {
                this.operFzItemNum(contractInfoItemTmpPOList, reqBO);
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage());
            throw new ZTBusinessException(e2.getMessage());
        }
        List<ContractInfoItemPO> deleteItemPOS = this.contractInfoItemMapper.getItemsByRelId(reqBO.getContractId());
        if (!CollectionUtils.isEmpty(deleteItemPOS)) {
            int officialSize = deleteItemPOS.size();
            int temporarySize = 0;
            int deleteTemporarySize = 0;
            if (!CollectionUtils.isEmpty(contractInfoItemTmpPOList)) {
                temporarySize = contractInfoItemTmpPOList.size();
            }
            if (!CollectionUtils.isEmpty(deleteContractInfoItemTmpPOList)) {
                deleteTemporarySize = deleteContractInfoItemTmpPOList.size();
            }
            List logDeleteItemPOS = JSONObject.parseArray((String)JSONObject.toJSONString(deleteItemPOS), CContractInfoItemDeleteLogPO.class);
            for (CContractInfoItemDeleteLogPO e3 : logDeleteItemPOS) {
                e3.setUuid(this.uccBatchSequence.nextId());
                e3.setLogOperUserId(logOperUserId);
                e3.setLogOperUserCode(logOperUserCode);
                e3.setLogOperUserName(logOperUserName);
                e3.setLogOperTime(logOperTime);
                e3.setLogOperRemark("ContractAddNewBusiService\u4fee\u6539\u5408\u540c\u670d\u52a1\u6e05\u7a7a\u660e\u7ec6\u8868\u4ece\u4e34\u65f6\u8868\u590d\u5236\u5230\u6b63\u5f0f\u8868\u4fee\u6539\u65f6\u95f4" + DateUtils.dateToStrYYYYMMddHHmmss(logOperTime) + "\u6b63\u5f0f\u8868\u5220\u9664\u6570\u636e\u7684\u957f\u5ea6" + officialSize + "\u5373\u5c06\u590d\u5236\u8fc7\u6765\u7684\u4e34\u65f6\u8868\u6570\u636e\u957f\u5ea6" + temporarySize + "\u5220\u9664\u7684\u4e34\u65f6\u8868\u6570\u636e\u957f\u5ea6" + deleteTemporarySize);
            }
            this.cContractInfoItemDeleteLogMapper.insertBatch(logDeleteItemPOS);
        }
        ContractInfoItemPO deleteContractInfoItemPo = new ContractInfoItemPO();
        deleteContractInfoItemPo.setRelateId(reqBO.getContractId());
        this.contractInfoItemMapper.deleteByCondition(deleteContractInfoItemPo);
        ArrayList<ContractInfoItemPO> contractInfoItemPOS = new ArrayList<ContractInfoItemPO>();
        for (ContractInfoItemTmpPO contractInfoItemTmpPO2 : contractInfoItemTmpPOList) {
            ContractInfoItemPO contractInfoItemPO = new ContractInfoItemPO();
            BeanUtils.copyProperties((Object)contractInfoItemTmpPO2, (Object)contractInfoItemPO);
            contractInfoItemPOS.add(contractInfoItemPO);
        }
        if (!CollectionUtils.isEmpty(contractInfoItemPOS)) {
            if (ContractConstant.ContractType.PURCHASE_CONTRACT.equals(reqBO.getContractType()) && reqBO.getOperType().equals("2")) {
                for (ContractInfoItemPO itemPO : contractInfoItemPOS) {
                    if (itemPO.getTaxUnitPrice() != null) continue;
                    throw new ZTBusinessException("\u8d2d\u5408\u540c\u63d0\u4ea4\u7684\u65f6\u5019\uff0c\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u7269\u8d44\u7f16\u7801\uff1a" + itemPO.getMaterialCode() + "\u660e\u7ec6id\uff1a" + itemPO.getItemId());
                }
            }
            if (ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT.equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT.equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT.equals(reqBO.getContractType())) {
                for (ContractInfoItemPO itemPO : contractInfoItemPOS) {
                    itemPO.setBuyerNo(oldContractInfoPo.getBuyerNo());
                    itemPO.setBuyerName(oldContractInfoPo.getBuyerName());
                }
            }
            Map<Object, Object> oIdMap = new HashMap();
            if (!CollectionUtils.isEmpty(contractInfoItemPOS)) {
                Set erpOrgCodes = contractInfoItemPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getErpOrgCode())).map(ContractInfoItemPO::getErpOrgCode).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(erpOrgCodes)) {
                    UmcContractQueryBuyerInfoAbilityReqBO umcContractQueryBuyerInfoAbilityReqBO = new UmcContractQueryBuyerInfoAbilityReqBO();
                    ArrayList organizationCodes = new ArrayList();
                    organizationCodes.addAll(erpOrgCodes);
                    umcContractQueryBuyerInfoAbilityReqBO.setOrganizationIds(organizationCodes);
                    UmcContractQueryBuyerInfoAbilityRspBO umcContractQueryBuyerInfoAbilityRspBO = this.umcContractQueryBuyerInfoAbilityService.queryContractBuyerInfo(umcContractQueryBuyerInfoAbilityReqBO);
                    if ("0000".equals(umcContractQueryBuyerInfoAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcContractQueryBuyerInfoAbilityRspBO.getRows())) {
                        oIdMap = umcContractQueryBuyerInfoAbilityRspBO.getRows().stream().collect(Collectors.groupingBy(UmcEntityOrgSubBO::getOrganizationId));
                    }
                }
                for (ContractInfoItemPO po : contractInfoItemPOS) {
                    if (oIdMap.containsKey(po.getErpOrgCode())) {
                        UmcEntityOrgSubBO umcEntityOrgSubBO = (UmcEntityOrgSubBO)((List)oIdMap.get(po.getErpOrgCode())).get(0);
                        po.setBuyerId(umcEntityOrgSubBO.getEntityId());
                        if (umcEntityOrgSubBO.getEntityId() != null) {
                            po.setBuyerNo(umcEntityOrgSubBO.getEntityId().toString());
                        }
                        po.setBuyerName(umcEntityOrgSubBO.getEntityName());
                    }
                    if (po.getSaleStatus() == 2) continue;
                    po.setSaleAmount(null);
                }
            }
            int count = this.contractInfoItemMapper.insertBatch(contractInfoItemPOS);
            if (ContractConstant.ContractType.SALE_CONTRACT.equals(reqBO.getContractType()) && count != 0) {
                Long relateItemId = contractInfoItemTmpPOList.get(0).getRelateItemId();
                ContractInfoItemPO purchaseContractInfoItemPO = this.contractInfoItemMapper.selectByPrimaryKey(relateItemId);
                if (purchaseContractInfoItemPO == null || purchaseContractInfoItemPO.getRelateId() == null) {
                    CRelBuySaleContractPO seachPO = new CRelBuySaleContractPO();
                    seachPO.setSaleContractId(reqBO.getContractId());
                    List<CRelBuySaleContractPO> relBuySaleContractMapperList = this.cRelBuySaleContractMapper.getList(seachPO);
                    if (CollectionUtils.isEmpty(relBuySaleContractMapperList) || relBuySaleContractMapperList.size() != contractInfoItemPOS.size()) {
                        throw new ZTBusinessException("\u5173\u8054\u7684\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\u5f02\u5e38");
                    }
                } else {
                    CRelBuySaleContractPO deletePO = new CRelBuySaleContractPO();
                    deletePO.setSaleContractId(reqBO.getContractId());
                    this.cRelBuySaleContractMapper.deleteBy(deletePO);
                    Long purchaseContractId = purchaseContractInfoItemPO.getRelateId();
                    List<CRelBuySaleContractPO> relInsertPOs = contractInfoItemPOS.stream().map(e -> {
                        CRelBuySaleContractPO insertPO = new CRelBuySaleContractPO();
                        insertPO.setId(this.uccBatchSequence.nextId());
                        insertPO.setBuyContractId(purchaseContractId);
                        insertPO.setBuyItemId(e.getRelateItemId());
                        insertPO.setSaleContractId(reqBO.getContractId());
                        insertPO.setSaleItemId(e.getItemId());
                        return insertPO;
                    }).collect(Collectors.toList());
                    try {
                        this.cRelBuySaleContractMapper.insertBatch(relInsertPOs);
                    }
                    catch (Exception e4) {
                        log.error("\u9500\u552e\u5408\u540c\u521b\u5efa\u65f6\u9700\u8bb0\u5f55\u91c7\u9500\u5408\u540c\u5173\u8054\u8868\u5931\u8d25" + e4.getMessage());
                        throw new ZTBusinessException("\u5f53\u524d\u91c7\u8d2d\u5408\u540c\u5df2\u88ab\u5176\u4ed6\u4eba\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u91c7\u8d2d\u5408\u540c");
                    }
                }
            }
        }
    }

    private void updateContractAccessoryInfo(ContractAddNewOtherBusiReqBO reqBO) {
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateId(reqBO.getContractId());
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getAccessoryList())) {
            this.addContractAccessoryInfo(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getBasicAccessoryList())) {
            this.addContractBasicAccessoryInfo(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getFwOrderFileAccessoryBOList())) {
            this.addContractFwOrderFileAccessoryInfo(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getSupplierAccessoryBOList())) {
            this.addSupplierAccessoryInfo(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getBaseOtherAccessoryBOList())) {
            this.addContractbaseOtherAccessoryInfo(reqBO);
        }
    }

    private void addContractAccessoryInfo(ContractAddNewOtherBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getAccessoryList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo contractAccessoryPo : list) {
            contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            contractAccessoryPo.setRelateId(reqBO.getContractId());
            contractAccessoryPo.setRelateCode(reqBO.getContractCode());
            contractAccessoryPo.setCreateUserId(reqBO.getUserId());
            contractAccessoryPo.setCreateUserName(reqBO.getUsername());
            contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT);
        }
        int result = this.contractAccessoryMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void addContractBasicAccessoryInfo(ContractAddNewOtherBusiReqBO reqBO) {
        List accessoryPoList = JSONArray.parseArray((String)JSON.toJSONString(reqBO.getBasicAccessoryList())).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo accessoryPo : accessoryPoList) {
            accessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            accessoryPo.setRelateId(reqBO.getContractId());
            accessoryPo.setRelateCode(reqBO.getContractCode());
            accessoryPo.setCreateUserId(reqBO.getUserId());
            accessoryPo.setCreateUserName(reqBO.getName());
            accessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            accessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT_BASIC);
        }
        int i = this.contractAccessoryMapper.insertBatch(accessoryPoList);
        if (i < 1) {
            throw new ZTBusinessException("\u5408\u540c\u4f9d\u636e\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void addContractFwOrderFileAccessoryInfo(ContractAddNewOtherBusiReqBO reqBO) {
        List accessoryPoList = JSONArray.parseArray((String)JSON.toJSONString(reqBO.getFwOrderFileAccessoryBOList())).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo accessoryPo : accessoryPoList) {
            accessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            accessoryPo.setRelateId(reqBO.getContractId());
            accessoryPo.setRelateCode(reqBO.getContractCode());
            accessoryPo.setCreateUserId(reqBO.getUserId());
            accessoryPo.setCreateUserName(reqBO.getName());
            accessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            accessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT_FW);
        }
        int i = this.contractAccessoryMapper.insertBatch(accessoryPoList);
        if (i < 1) {
            throw new ZTBusinessException("\u5408\u540c\u6cd5\u52a1\u4f9d\u636e\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void addSupplierAccessoryInfo(ContractAddNewOtherBusiReqBO reqBO) {
        List accessoryPoList = JSONArray.parseArray((String)JSON.toJSONString(reqBO.getSupplierAccessoryBOList())).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo accessoryPo : accessoryPoList) {
            accessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            accessoryPo.setRelateId(reqBO.getContractId());
            accessoryPo.setRelateCode(reqBO.getContractCode());
            accessoryPo.setCreateUserId(reqBO.getUserId());
            accessoryPo.setCreateUserName(reqBO.getName());
            accessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            accessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT_SUPPLIER);
        }
        int i = this.contractAccessoryMapper.insertBatch(accessoryPoList);
        if (i < 1) {
            throw new ZTBusinessException("\u5408\u540c\u4f9b\u5e94\u5546\u4e0a\u4f20\u7684\u5176\u5b83\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void addSettlementDetail(ContractAddNewOtherBusiReqBO reqBO) {
        ContractSettlementDetailPO detailPO = new ContractSettlementDetailPO();
        detailPO.setRelateId(reqBO.getContractId());
        this.contractSettlementDetailMapper.deleteBy(detailPO);
        if (!CollectionUtils.isEmpty(reqBO.getSettlementDetailBos())) {
            List settlementDetailPOS = JSONArray.parseArray((String)JSON.toJSONString(reqBO.getSettlementDetailBos())).toJavaList(ContractSettlementDetailPO.class);
            for (ContractSettlementDetailPO contractSettlementDetailPO : settlementDetailPOS) {
                contractSettlementDetailPO.setId(Sequence.getInstance().nextId());
                contractSettlementDetailPO.setRelateId(reqBO.getContractId());
            }
            this.contractSettlementDetailMapper.insertBatch(settlementDetailPOS);
        }
    }

    private void recordContractNodeOperLog(ContractAddNewOtherBusiReqBO reqBO) {
        ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
        contractRecordContractNodeOperLogAtomReqBO.setContractId(reqBO.getContractId());
        contractRecordContractNodeOperLogAtomReqBO.setNodeCode("CREATE_CONTRACT");
        contractRecordContractNodeOperLogAtomReqBO.setNodeName("\u65b0\u5efa\u5408\u540c");
        contractRecordContractNodeOperLogAtomReqBO.setOperUserId(reqBO.getUserId());
        contractRecordContractNodeOperLogAtomReqBO.setOperUserName(reqBO.getUsername());
        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
    }

    private void operFzItemNum(List<ContractInfoItemTmpPO> contractInfoItemTmpPOList, ContractAddNewBusiReqBO reqBO) {
        try {
            List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.getItemsByRelId(reqBO.getContractId());
            Map<Object, Object> oldAwardNumIdAndCount = new HashMap();
            if (!CollectionUtils.isEmpty(contractInfoItemPOS)) {
                oldAwardNumIdAndCount = contractInfoItemPOS.stream().filter(a -> !StringUtils.isEmpty((Object)a.getAwardNumId())).collect(Collectors.toMap(a -> a.getAwardNumId(), b -> b.getAmount(), (first, second) -> first));
            }
            Map<String, BigDecimal> awardNumIdAndCount = contractInfoItemTmpPOList.stream().filter(a -> !StringUtils.isEmpty((Object)a.getAwardNumId())).collect(Collectors.toMap(a -> a.getAwardNumId(), b -> b.getAmount(), (first, second) -> first));
            ArrayList<InterFaceContractUpdateOrderItemBO> operOrderItem = new ArrayList<InterFaceContractUpdateOrderItemBO>();
            for (Map.Entry<Object, Object> each : oldAwardNumIdAndCount.entrySet()) {
                if (awardNumIdAndCount.containsKey(each.getKey())) continue;
                InterFaceContractUpdateOrderItemBO interFaceContractUpdateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                interFaceContractUpdateOrderItemBO.setGoodTypeId((String)each.getKey());
                interFaceContractUpdateOrderItemBO.setType(Integer.valueOf(reqBO.getMaterialSource()));
                interFaceContractUpdateOrderItemBO.setOperateType(0);
                interFaceContractUpdateOrderItemBO.setOrderNum((BigDecimal)each.getValue());
                operOrderItem.add(interFaceContractUpdateOrderItemBO);
            }
            HashMap awardNumIdAndIncy = new HashMap();
            ArrayList<InterFaceContractGetCanOrderNumAtomBO> orderItem = new ArrayList<InterFaceContractGetCanOrderNumAtomBO>();
            for (Map.Entry entry : awardNumIdAndCount.entrySet()) {
                InterFaceContractGetCanOrderNumAtomBO interFaceContractGetCanOrderNumAtomBO = new InterFaceContractGetCanOrderNumAtomBO();
                interFaceContractGetCanOrderNumAtomBO.setType(Integer.valueOf(reqBO.getMaterialSource()));
                interFaceContractGetCanOrderNumAtomBO.setGoodTypeId((String)entry.getKey());
                orderItem.add(interFaceContractGetCanOrderNumAtomBO);
                InterFaceContractUpdateOrderItemBO interFaceContractUpdateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                interFaceContractUpdateOrderItemBO.setGoodTypeId((String)entry.getKey());
                interFaceContractUpdateOrderItemBO.setType(Integer.valueOf(reqBO.getMaterialSource()));
                if (oldAwardNumIdAndCount.containsKey(entry.getKey())) {
                    awardNumIdAndIncy.put(entry.getKey(), ((BigDecimal)entry.getValue()).subtract((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())));
                    if (((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())).compareTo((BigDecimal)entry.getValue()) < 0) {
                        interFaceContractUpdateOrderItemBO.setOperateType(1);
                        interFaceContractUpdateOrderItemBO.setOrderNum(((BigDecimal)entry.getValue()).subtract((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())));
                    } else {
                        interFaceContractUpdateOrderItemBO.setOperateType(0);
                        interFaceContractUpdateOrderItemBO.setOrderNum(((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())).subtract((BigDecimal)entry.getValue()));
                    }
                } else {
                    awardNumIdAndIncy.put(entry.getKey(), (BigDecimal)entry.getValue());
                    interFaceContractUpdateOrderItemBO.setOperateType(1);
                    interFaceContractUpdateOrderItemBO.setOrderNum((BigDecimal)entry.getValue());
                }
                operOrderItem.add(interFaceContractUpdateOrderItemBO);
            }
            if (!CollectionUtils.isEmpty(orderItem)) {
                InterFaceContractGetCanOrderNumAtomReqBO interFaceContractGetCanOrderNumAtomReqBO = new InterFaceContractGetCanOrderNumAtomReqBO();
                interFaceContractGetCanOrderNumAtomReqBO.setOrderItem(orderItem);
                interFaceContractGetCanOrderNumAtomReqBO.setToken(reqBO.getAuthToken());
                InterFaceContractGetCanOrderNumAtomRspBO interFaceContractGetCanOrderNumAtomRspBO = this.interFaceContractGetCanOrderNumAtomService.getCanOrderNum(interFaceContractGetCanOrderNumAtomReqBO);
                if ("0000".equals(interFaceContractGetCanOrderNumAtomRspBO.getRespCode()) && !CollectionUtils.isEmpty(interFaceContractGetCanOrderNumAtomRspBO.getOrderItem())) {
                    Map<String, BigDecimal> resultAwardNumIdAndCount = interFaceContractGetCanOrderNumAtomRspBO.getOrderItem().stream().collect(Collectors.toMap(a -> a.getGoodTypeId(), b -> b.getOrderNum(), (first, second) -> first));
                    for (Map.Entry each : awardNumIdAndIncy.entrySet()) {
                        if (resultAwardNumIdAndCount.containsKey(each.getKey())) {
                            if (((BigDecimal)each.getValue()).compareTo(resultAwardNumIdAndCount.get(each.getKey())) <= 0) continue;
                            throw new ZTBusinessException("\u8be5\u660e\u7ec6:" + (String)each.getKey() + "\u5360\u7528\u6570\u91cf\u5927\u4e8e\u975e\u62db\u660e\u7ec6\u5269\u4f59\u6570\u91cf");
                        }
                        throw new ZTBusinessException("\u975e\u62db\u6570\u636e\u7f3a\u5931\uff1a\u672a\u67e5\u8be2\u5230\u8be5\u660e\u7ec6\u5728\u975e\u62db\u5269\u4f59\u6570\u91cf->" + (String)each.getKey());
                    }
                } else {
                    throw new ZTBusinessException("\u975e\u62db\u67e5\u8be2\u5269\u4f59\u6570\u91cf\u5931\u8d25\uff1a" + interFaceContractGetCanOrderNumAtomRspBO.getRespDesc());
                }
            }
            if (!CollectionUtils.isEmpty(operOrderItem)) {
                InterFaceContractUpdateOrderItemAtomReqBO interFaceContractUpdateOrderItemAtomReqBO = new InterFaceContractUpdateOrderItemAtomReqBO();
                interFaceContractUpdateOrderItemAtomReqBO.setToken(reqBO.getAuthToken());
                interFaceContractUpdateOrderItemAtomReqBO.setOrderItem(operOrderItem);
                InterFaceContractUpdateOrderItemAtomRspBO interFaceContractUpdateOrderItemAtomRspBO = this.interFaceContractUpdateOrderItemAtomService.updateOrderItem(interFaceContractUpdateOrderItemAtomReqBO);
                if (!"0000".equals(interFaceContractUpdateOrderItemAtomRspBO.getRespCode())) {
                    throw new ZTBusinessException("\u975e\u62db\u589e\u51cf\u6570\u91cf\u5931\u8d25\uff1a" + interFaceContractUpdateOrderItemAtomRspBO.getRespDesc());
                }
                reqBO.setRollBackInterFaceContractUpdateOrderItemAtomReqBO(interFaceContractUpdateOrderItemAtomReqBO);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u975e\u62db\u589e\u51cf\u6570\u91cf\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void addSealRecord(ContractAddNewOtherBusiReqBO reqBO) {
        ArrayList<ContractSealRecordPO> sealRecordPOS = new ArrayList<ContractSealRecordPO>();
        for (ContractSealRecordBO sealRecordBO : reqBO.getSealRecordBOList()) {
            ContractSealRecordPO recordPO = new ContractSealRecordPO();
            recordPO.setId(Sequence.getInstance().nextId());
            BeanUtils.copyProperties((Object)sealRecordBO, (Object)recordPO);
            recordPO.setContractId(reqBO.getContractId());
            recordPO.setContractCode(reqBO.getContractCode());
            if (recordPO.getSealType() != null) {
                recordPO.setSealTypeStr(ContractTransFieldUtil.transSealType(recordPO.getSealType()));
            }
            sealRecordPOS.add(recordPO);
        }
        int result = this.contractSealRecordMapper.insertBatch(sealRecordPOS);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u7528\u5370\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void updateSealRecord(ContractAddNewOtherBusiReqBO reqBO) {
        ContractSealRecordPO record = new ContractSealRecordPO();
        record.setContractId(reqBO.getContractId());
        this.contractSealRecordMapper.deleteByCondition(record);
        if (!CollectionUtils.isEmpty(reqBO.getSealRecordBOList())) {
            this.addSealRecord(reqBO);
        }
    }

    private void unitContractStartProcess(ContractAddNewOtherBusiReqBO reqBO, ContractInfoPO updateContractInfoChangePO, ContractInfoPO contractInfoPO, ContractAddNewOtherBusiRspBO rspBO) {
        List<Object> materialCategoryList = new ArrayList();
        if (!StringUtils.isEmpty((Object)contractInfoPO.getExtFiled2())) {
            List codes = JSONObject.parseArray((String)contractInfoPO.getExtFiled2(), String.class);
            materialCategoryList = codes.stream().map(Integer::valueOf).collect(Collectors.toList());
        }
        if (contractInfoPO.getPushLegalFlag() == 1 && materialCategoryList.contains(updateContractInfoChangePO.getMaterialCategory()) && (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT.equals(contractInfoPO.getContractType())) && (StringUtils.isEmpty((Object)reqBO.getBusiCode()) || "-1".equals(reqBO.getBusiCode()))) {
            updateContractInfoChangePO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_PENDING_PUSH_LEGAL);
        } else {
            updateContractInfoChangePO.setContractStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE);
            ContractStartApprovalProcessAtomReqBO atomReqBO = new ContractStartApprovalProcessAtomReqBO();
            if (!StringUtils.isEmpty((Object)contractInfoPO.getContractId())) {
                if ("0".equals(contractInfoPO.getContractOrgType())) {
                    if (!StringUtils.isEmpty((Object)reqBO.getBusiCode()) && !"-1".equals(reqBO.getBusiCode())) {
                        atomReqBO.setProcDefKey(reqBO.getBusiCode());
                    } else if (6 == contractInfoPO.getContractType()) {
                        atomReqBO.setMenuId("M001001");
                    } else if (7 == contractInfoPO.getContractType()) {
                        atomReqBO.setMenuId("M0010011");
                    } else if (8 == contractInfoPO.getContractType()) {
                        atomReqBO.setMenuId("M0010013");
                    } else if (9 == contractInfoPO.getContractType() || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(contractInfoPO.getContractType())) {
                        atomReqBO.setMenuId("M0010015");
                    } else if (10 == contractInfoPO.getContractType()) {
                        atomReqBO.setMenuId("M0010017");
                    } else {
                        atomReqBO.setMenuId("M001005");
                    }
                } else if (!StringUtils.isEmpty((Object)reqBO.getBusiCode()) && !"-1".equals(reqBO.getBusiCode())) {
                    atomReqBO.setProcDefKey(reqBO.getBusiCode());
                } else if (11 == contractInfoPO.getContractType()) {
                    atomReqBO.setMenuId("M0010019");
                } else if (12 == contractInfoPO.getContractType()) {
                    atomReqBO.setMenuId("M0010021");
                } else if (13 == contractInfoPO.getContractType()) {
                    atomReqBO.setMenuId("M0010023");
                } else if (20 == contractInfoPO.getContractType()) {
                    atomReqBO.setMenuId("M0010025");
                } else if (21 == contractInfoPO.getContractType()) {
                    atomReqBO.setMenuId("M0010027");
                } else {
                    atomReqBO.setMenuId("M001003");
                }
            } else {
                throw new ZTBusinessException("\u8be5\u5408\u540c\u6ca1\u6709\u5408\u540c\u673a\u6784\u7c7b\u578b\u6570\u636e");
            }
            atomReqBO.setContractId(reqBO.getContractId());
            atomReqBO.setOrgId(contractInfoPO.getCreateDeptId());
            atomReqBO.setObjType(1);
            atomReqBO.setDept(contractInfoPO.getCreateDeptName());
            atomReqBO.setUserId(contractInfoPO.getCreateUserId());
            atomReqBO.setUsername(contractInfoPO.getCreateUserName());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            if (contractInfoPO.getIsNewSupplier() != null && contractInfoPO.getIsNewSupplier() == 1 || contractInfoPO.getIsNewBrand() != null && contractInfoPO.getIsNewBrand() == 1) {
                variables.put("auditType", "1");
            } else {
                variables.put("auditType", "2");
            }
            variables.put("contractMoney", MoneyUtils.haoToYuan(contractInfoPO.getContractAmount()));
            atomReqBO.setVariables(variables);
            log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u5165\u53c2code\uff1a" + JSON.toJSONString((Object)((Object)atomReqBO)));
            ContractStartApprovalProcessAtomRspBO atomRspBO = this.contractStartApprovalProcessAtomService.startApprovalProcess(atomReqBO);
            if (!CollectionUtils.isEmpty(atomRspBO.getApprovalInNotice())) {
                ContractNoTaskAuditOrderAuditNoticeBO noticeBO = new ContractNoTaskAuditOrderAuditNoticeBO();
                noticeBO.setOrderId(atomReqBO.getContractId());
                noticeBO.setApprovalInNotice(atomRspBO.getApprovalInNotice());
                if (CollectionUtils.isEmpty(rspBO.getAuditNoticeList())) {
                    rspBO.setAuditNoticeList(new ArrayList<ContractNoTaskAuditOrderAuditNoticeBO>());
                }
                rspBO.getAuditNoticeList().add(noticeBO);
            }
            log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2code\uff1a" + atomRspBO.getRespCode() + " \u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2stepId\uff1a" + atomRspBO.getStepId());
            if (!atomRspBO.getRespCode().equals("0000")) {
                throw new ZTBusinessException(atomRspBO.getRespDesc());
            }
            if (StringUtils.isEmpty((Object)atomRspBO.getStepId())) {
                log.info("\u5ba1\u6279API\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)((Object)atomRspBO)));
                throw new ZTBusinessException("\u5ba1\u6279\u6d41\u7a0b\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u56fe");
            }
            updateContractInfoChangePO.setStepId(atomRspBO.getStepId());
        }
    }

    private void addContractbaseOtherAccessoryInfo(ContractAddNewOtherBusiReqBO reqBO) {
        List baseOtherAccessoryPoList = JSONArray.parseArray((String)JSON.toJSONString(reqBO.getBaseOtherAccessoryBOList())).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo accessoryPo : baseOtherAccessoryPoList) {
            accessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            accessoryPo.setRelateId(reqBO.getContractId());
            accessoryPo.setRelateCode(reqBO.getContractCode());
            accessoryPo.setCreateUserId(reqBO.getUserId());
            accessoryPo.setCreateUserName(reqBO.getName());
            accessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            accessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_BASE_OTHER_ACCESSORY);
        }
        int i = this.contractAccessoryMapper.insertBatch(baseOtherAccessoryPoList);
        if (i < 1) {
            throw new ZTBusinessException("\u5408\u540c\u5176\u4ed6\u7b7e\u7f72\u9644\u4ef6\u65b0\u589e\u5931\u8d25");
        }
    }

    private void saveContractInfoSignConfig(ContractAddNewOtherBusiReqBO reqBO) {
        ContractInfoPO po;
        if ("2".equals(reqBO.getOperType()) && reqBO.getContractId() != null && (po = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId())) != null && !StringUtils.isEmpty((Object)po.getBuyerNo())) {
            this.contractRelSignConfigItemMapper.deleteByRelId(reqBO.getContractId());
            this.contractRelSignConfigMapper.deleteByRelId(reqBO.getContractId());
            ContractSignConfigPO searchPO = new ContractSignConfigPO();
            searchPO.setApplicationUnitOrgCode(po.getBuyerNo());
            Object contractSignConfigPOS = this.contractSignConfigMapper.selectListByPO(searchPO);
            if (CollectionUtils.isEmpty(contractSignConfigPOS)) {
                ContractSignConfigPO searchPO1 = new ContractSignConfigPO();
                searchPO1.setApplicationUnitOrgCode(po.getSupplierCode());
                List<ContractSignConfigPO> contractSignConfigPOSSupplier = this.contractSignConfigMapper.selectListByPO(searchPO1);
                if (CollectionUtils.isEmpty(contractSignConfigPOSSupplier)) {
                    if (po.getMultiDealerCode() != null) {
                        ContractSignConfigPO searchPO2 = new ContractSignConfigPO();
                        searchPO2.setApplicationUnitOrgCode(po.getMultiDealerCode());
                        List<ContractSignConfigPO> contractSignConfigPOSMultiDealer = this.contractSignConfigMapper.selectListByPO(searchPO2);
                        if (!CollectionUtils.isEmpty((Collection)contractSignConfigPOSMultiDealer)) {
                            contractSignConfigPOS = contractSignConfigPOSMultiDealer;
                        }
                    }
                } else {
                    contractSignConfigPOS = contractSignConfigPOSSupplier;
                }
            }
            if (!CollectionUtils.isEmpty(contractSignConfigPOS)) {
                ContractSignConfigPO contractSignConfigPO = contractSignConfigPOS.get(0);
                List<ContractSignConfigItemPO> contractSignConfigItemPOS = this.contractSignConfigItemMapper.selectListByRelateId(contractSignConfigPO.getConfigId());
                if (!CollectionUtils.isEmpty(contractSignConfigItemPOS)) {
                    ArrayList<ContractRelSignConfigItemPO> list = new ArrayList<ContractRelSignConfigItemPO>();
                    for (ContractSignConfigItemPO contractSignConfigItemPO : contractSignConfigItemPOS) {
                        ContractRelSignConfigItemPO relSignConfigItemPO = (ContractRelSignConfigItemPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)contractSignConfigItemPO), ContractRelSignConfigItemPO.class);
                        relSignConfigItemPO.setId(this.uccBatchSequence.nextId());
                        relSignConfigItemPO.setRelId(reqBO.getContractId());
                        relSignConfigItemPO.setItemType(contractSignConfigItemPO.getItemType());
                        relSignConfigItemPO.setItemKeyWord(contractSignConfigItemPO.getItemKeyWord());
                        list.add(relSignConfigItemPO);
                    }
                    this.contractRelSignConfigItemMapper.insertBatch(list);
                }
                ContractRelSignConfigPO contractRelSignConfigPO = new ContractRelSignConfigPO();
                contractRelSignConfigPO.setId(this.uccBatchSequence.nextId());
                contractRelSignConfigPO.setRelId(reqBO.getContractId());
                contractRelSignConfigPO.setIsFollowSign(contractSignConfigPO.getIsFollowSign());
                contractRelSignConfigPO.setIsSignPosition(contractSignConfigPO.getIsSignPosition());
                this.contractRelSignConfigMapper.insert(contractRelSignConfigPO);
            } else {
                ContractSignConfigPO searchPO2 = new ContractSignConfigPO();
                searchPO2.setIsException(0);
                List<ContractSignConfigPO> contractSignConfigPOS2 = this.contractSignConfigMapper.selectListByPO(searchPO2);
                if (!CollectionUtils.isEmpty(contractSignConfigPOS2)) {
                    ContractSignConfigPO contractSignConfigPO = contractSignConfigPOS2.get(0);
                    List<ContractSignConfigItemPO> contractSignConfigItemPOS = this.contractSignConfigItemMapper.selectListByRelateId(contractSignConfigPO.getConfigId());
                    if (!CollectionUtils.isEmpty(contractSignConfigItemPOS)) {
                        ArrayList<ContractRelSignConfigItemPO> list = new ArrayList<ContractRelSignConfigItemPO>();
                        for (ContractSignConfigItemPO contractSignConfigItemPO : contractSignConfigItemPOS) {
                            ContractRelSignConfigItemPO relSignConfigItemPO = (ContractRelSignConfigItemPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)contractSignConfigItemPO), ContractRelSignConfigItemPO.class);
                            relSignConfigItemPO.setId(this.uccBatchSequence.nextId());
                            relSignConfigItemPO.setRelId(reqBO.getContractId());
                            relSignConfigItemPO.setItemType(contractSignConfigItemPO.getItemType());
                            relSignConfigItemPO.setItemKeyWord(contractSignConfigItemPO.getItemKeyWord());
                            list.add(relSignConfigItemPO);
                        }
                        this.contractRelSignConfigItemMapper.insertBatch(list);
                    }
                    ContractRelSignConfigPO contractRelSignConfigPO = new ContractRelSignConfigPO();
                    contractRelSignConfigPO.setId(this.uccBatchSequence.nextId());
                    contractRelSignConfigPO.setRelId(reqBO.getContractId());
                    contractRelSignConfigPO.setIsFollowSign(contractSignConfigPO.getIsFollowSign());
                    contractRelSignConfigPO.setIsSignPosition(contractSignConfigPO.getIsSignPosition());
                    this.contractRelSignConfigMapper.insert(contractRelSignConfigPO);
                }
            }
        }
    }

    private void translationContractDocToPdfUrl(ContractAddNewOtherBusiReqBO reqBO) {
        String newContractDocUrl;
        if (ObjectUtil.isNotEmpty((Object)reqBO.getContractDocUrl()) && (reqBO.getContractDocUrl().endsWith(".doc") || reqBO.getContractDocUrl().endsWith(".docx")) && ObjectUtil.isNotEmpty((Object)(newContractDocUrl = this.convFile(reqBO.getContractDocUrl())))) {
            reqBO.setExtFiled3(reqBO.getContractDocUrl());
            reqBO.setContractDocUrl(newContractDocUrl);
        }
    }

    private String convFile(String contractDocUrl) {
        String exportUrl;
        block19: {
            String preName = "signDocument-";
            String fileName = "";
            File wordFile = null;
            File pdfFile = null;
            fileName = contractDocUrl.endsWith(".doc") ? preName + String.valueOf(Sequence.getInstance().nextId() + ".doc") : preName + String.valueOf(Sequence.getInstance().nextId() + ".docx");
            String pdfFileName = preName + String.valueOf(Sequence.getInstance().nextId() + ".pdf");
            HttpUtil.httpDownload(contractDocUrl, fileName);
            log.info("\u5408\u540cword\u6587\u4ef6-\u4e0b\u8f7d\u5230\u672c\u5730");
            try {
                wordFile = new File(fileName);
                WordToPdf.wordToPdf2(fileName, pdfFileName);
                pdfFile = new File(pdfFileName);
                try {
                    byte[] bytes = FileHelper.getBytes(pdfFileName);
                    ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                    String path = this.fileClient.uploadFileByInputStream(PATH, pdfFileName, (InputStream)input);
                    if (FILE_TYPE_OSS.equals(this.fileType)) {
                        exportUrl = this.ossFileUrl + path;
                        break block19;
                    }
                    if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                        FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                        exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                        break block19;
                    }
                    throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
                }
                catch (Exception e) {
                    throw new ZTBusinessException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25" + e.getMessage());
                }
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
                throw new ZTBusinessException("\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
            }
            finally {
                if (pdfFile != null && !pdfFile.exists()) {
                    log.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + pdfFileName + "\u4e0d\u5b58\u5728\uff01");
                } else if (ObjectUtils.isEmpty((Object)pdfFile) && pdfFile.isFile()) {
                    if (pdfFile.delete()) {
                        log.info("\u5220\u9664\u6587\u4ef6" + pdfFileName + "\u6210\u529f\uff01");
                    } else {
                        log.info("\u5220\u9664\u6587\u4ef6" + pdfFileName + "\u5931\u8d25\uff01");
                    }
                }
                if (!wordFile.exists()) {
                    log.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + fileName + "\u4e0d\u5b58\u5728\uff01");
                } else if (wordFile.isFile()) {
                    if (wordFile.delete()) {
                        log.info("\u5220\u9664\u6587\u4ef6" + fileName + "\u6210\u529f\uff01");
                    } else {
                        log.info("\u5220\u9664\u6587\u4ef6" + fileName + "\u5931\u8d25\uff01");
                    }
                }
            }
        }
        return exportUrl;
    }

    private void platformContractIsConfirm(ContractAddNewOtherBusiReqBO reqBO, ContractInfoPO contractInfoPO, ContractInfoPO updateContractInfoPo, ContractAddNewOtherBusiRspBO rspBO) {
        if ("0".equals(contractInfoPO.getContractOrgType()) && ObjectUtil.isNotEmpty((Object)reqBO.getIsSupConfirm()) && ObjectUtil.isNotEmpty((Object)reqBO.getConfirmExt1()) && reqBO.getIsSupConfirm() != 1 && reqBO.getConfirmExt1() != 1) {
            reqBO.setContractStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE);
            ContractStartApprovalProcessAtomReqBO atomReqBO = new ContractStartApprovalProcessAtomReqBO();
            if (!StringUtils.isEmpty((Object)reqBO.getBusiCode()) && !"-1".equals(reqBO.getBusiCode())) {
                atomReqBO.setProcDefKey(reqBO.getBusiCode());
            } else if (6 == contractInfoPO.getContractType()) {
                atomReqBO.setMenuId("M001001");
            } else if (7 == contractInfoPO.getContractType()) {
                atomReqBO.setMenuId("M0010011");
            } else if (8 == contractInfoPO.getContractType()) {
                atomReqBO.setMenuId("M0010013");
            } else if (9 == contractInfoPO.getContractType() || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(contractInfoPO.getContractType())) {
                atomReqBO.setMenuId("M0010015");
            } else if (10 == contractInfoPO.getContractType()) {
                atomReqBO.setMenuId("M0010017");
            } else {
                atomReqBO.setMenuId("M001005");
            }
            atomReqBO.setContractId(reqBO.getContractId());
            atomReqBO.setOrgId(contractInfoPO.getCreateDeptId());
            atomReqBO.setObjType(1);
            atomReqBO.setDept(contractInfoPO.getCreateDeptName());
            atomReqBO.setUserId(contractInfoPO.getCreateUserId());
            atomReqBO.setUsername(contractInfoPO.getCreateUserName());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            if (contractInfoPO.getIsNewSupplier() != null && contractInfoPO.getIsNewSupplier() == 1 || contractInfoPO.getIsNewBrand() != null && contractInfoPO.getIsNewBrand() == 1) {
                variables.put("auditType", "1");
            } else {
                variables.put("auditType", "2");
            }
            variables.put("contractMoney", MoneyUtils.haoToYuan(contractInfoPO.getContractAmount()));
            atomReqBO.setVariables(variables);
            log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u5165\u53c2code\uff1a" + JSON.toJSONString((Object)((Object)atomReqBO)));
            ContractStartApprovalProcessAtomRspBO atomRspBO = this.contractStartApprovalProcessAtomService.startApprovalProcess(atomReqBO);
            if (!CollectionUtils.isEmpty(atomRspBO.getApprovalInNotice())) {
                ContractNoTaskAuditOrderAuditNoticeBO noticeBO = new ContractNoTaskAuditOrderAuditNoticeBO();
                noticeBO.setOrderId(atomReqBO.getContractId());
                noticeBO.setApprovalInNotice(atomRspBO.getApprovalInNotice());
                if (CollectionUtils.isEmpty(rspBO.getAuditNoticeList())) {
                    rspBO.setAuditNoticeList(new ArrayList<ContractNoTaskAuditOrderAuditNoticeBO>());
                }
                rspBO.getAuditNoticeList().add(noticeBO);
            }
            log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2code\uff1a" + atomRspBO.getRespCode() + " \u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2stepId\uff1a" + atomRspBO.getStepId());
            if (!atomRspBO.getRespCode().equals("0000")) {
                throw new ZTBusinessException(atomRspBO.getRespDesc());
            }
            if (StringUtils.isEmpty((Object)atomRspBO.getStepId())) {
                log.info("\u5ba1\u6279API\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)((Object)atomRspBO)));
                throw new ZTBusinessException("\u5ba1\u6279\u6d41\u7a0b\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u56fe");
            }
            updateContractInfoPo.setStepId(atomRspBO.getStepId());
        }
    }
}

