/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractRspBaseBO;
import com.tydic.contract.busi.ContractDelPushLegalBusiService;
import com.tydic.contract.busi.bo.ContractDelPushLegalBusiReqBO;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractPushLogMapper;
import com.tydic.contract.po.ContractPushLogPO;
import com.tydic.contract.utils.HttpUtil;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ContractDelPushLegalBusiServiceImpl
implements ContractDelPushLegalBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractDelPushLegalBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private ContractPushLogMapper contractPushLogMapper;
    @Value(value="${CONTRACT_LEGAL_DELETE_URL}")
    private String contractLegalDeleteUrl;

    @Override
    public ContractRspBaseBO delPushLegalContract(ContractDelPushLegalBusiReqBO reqBO) {
        ContractRspBaseBO rspBaseBO = new ContractRspBaseBO();
        if (!CollectionUtils.isEmpty(reqBO.getPushLegalContractIds())) {
            for (String id : reqBO.getPushLegalContractIds()) {
                ContractPushLogPO pushLogPO = new ContractPushLogPO();
                pushLogPO.setId(Sequence.getInstance().nextId());
                pushLogPO.setType(15);
                pushLogPO.setCreateTime(new Date());
                pushLogPO.setReqJson(id);
                try {
                    String rspStr = HttpUtil.doGet(this.contractLegalDeleteUrl + "?id=" + id);
                    pushLogPO.setRspJson(rspStr);
                    this.contractPushLogMapper.insert(pushLogPO);
                    log.info("\u8c03\u7528\u6cd5\u52a1\u5220\u9664\u5408\u540c\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr + "\uff0c\u5165\u53c2:" + id);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u8c03\u7528\u6cd5\u52a1\u5220\u9664\u5408\u540c\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
        return rspBaseBO;
    }
}

