/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.cfc.ability.api.CfcBuyerAbbreviationConfigQryAbilityService;
import com.tydic.cfc.ability.bo.CfcBuyerAbbreviationConfigQryAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcBuyerAbbreviationConfigQryAbilityRspBO;
import com.tydic.contract.busi.ContractGenerateCodeBusiService;
import com.tydic.contract.busi.bo.ContractGenerateCodeBusiReqBO;
import com.tydic.contract.busi.bo.ContractGenerateCodeBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public class ContractGenerateCodeBusiServiceImpl
implements ContractGenerateCodeBusiService {
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private CfcBuyerAbbreviationConfigQryAbilityService cfcBuyerAbbreviationConfigQryAbilityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContractGenerateCodeBusiRspBO generateCode(ContractGenerateCodeBusiReqBO reqBO) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setIsCheckCall(reqBO.getIsCheckCall());
        ContractGenerateCodeBusiRspBO rspBO = new ContractGenerateCodeBusiRspBO();
        boolean purchFlag = false;
        if (ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT.toString().equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.toString().equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.toString().equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT.toString().equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT.toString().equals(reqBO.getContractType())) {
            purchFlag = true;
            encodedSerialGetServiceReqBO.setContractCodeDiffBuyerFlag("1");
        }
        if (reqBO.getIsCheckCall() != null && reqBO.getIsCheckCall() == 1) {
            if (purchFlag && StringUtils.isEmpty((Object)reqBO.getBuyerCode())) {
                throw new ZTBusinessException("\u5355\u4f4d\u5408\u540c\u83b7\u53d6\u7f16\u7801\u65f6\u4e70\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isEmpty((Object)reqBO.getBuyerCode())) {
                CfcBuyerAbbreviationConfigQryAbilityReqBO buyerQryReqBO = new CfcBuyerAbbreviationConfigQryAbilityReqBO();
                buyerQryReqBO.setId(reqBO.getBuyerCode());
                buyerQryReqBO.setPageNo(Integer.valueOf(1));
                buyerQryReqBO.setPageSize(Integer.valueOf(10));
                CfcBuyerAbbreviationConfigQryAbilityRspBO buyerQryRspBO = this.cfcBuyerAbbreviationConfigQryAbilityService.qryBuyerAbbreviationConfig(buyerQryReqBO);
                if (!buyerQryRspBO.getRespCode().equals("0000") || CollectionUtils.isEmpty((Collection)buyerQryRspBO.getRows())) {
                    throw new ZTBusinessException("\u4e70\u53d7\u4eba\u6ca1\u6709\u914d\u7f6e\u5bf9\u5e94\u7684\u7b80\u79f0\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u8fdb\u884c\u914d\u7f6e\uff01");
                }
            }
        }
        encodedSerialGetServiceReqBO.setCenter("CONTRACT");
        encodedSerialGetServiceReqBO.setRelId(reqBO.getRelId());
        encodedSerialGetServiceReqBO.setEncodedRuleCode(reqBO.getRuleCode());
        encodedSerialGetServiceReqBO.setBuyerCode(reqBO.getBuyerCode());
        if (!StringUtils.isEmpty((Object)reqBO.getBuyerOrgId())) {
            encodedSerialGetServiceReqBO.setRelId(reqBO.getBuyerOrgId());
            encodedSerialGetServiceReqBO.setOrgId(Long.valueOf(reqBO.getBuyerOrgId()));
        } else {
            encodedSerialGetServiceReqBO.setOrgId(reqBO.getOrgId());
        }
        if (StringUtils.isEmpty((Object)reqBO.getBuyerCode()) && purchFlag) {
            throw new ZTBusinessException("\u5355\u4f4d\u5408\u540c\u83b7\u53d6\u7f16\u7801\u65f6\u4e70\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        encodedSerialGetServiceReqBO.setContractType(reqBO.getContractType());
        encodedSerialGetServiceReqBO.setContractClass(reqBO.getContractClass());
        encodedSerialGetServiceReqBO.setMemId(reqBO.getMemId());
        encodedSerialGetServiceReqBO.setExtendFlag(reqBO.getExtendFlag());
        encodedSerialGetServiceReqBO.setOrgTreePath(reqBO.getOrgTreePath());
        encodedSerialGetServiceReqBO.setOrgCheckFlag(reqBO.getOrgCheckFlag());
        encodedSerialGetServiceReqBO.setMaterialCatalog(reqBO.getMaterialCatalog());
        String lockKey = "lock:generateCode:" + reqBO.getBuyerCode();
        Jedis jedis = null;
        boolean locked = false;
        int maxRetries = 10;
        long sleepTime = 500L;
        try {
            jedis = this.jedisPool.getResource();
            for (int retryCount = 0; retryCount < maxRetries; ++retryCount) {
                boolean bl = locked = jedis.setnx(lockKey, "locked") == 1L;
                if (locked) {
                    jedis.expire(lockKey, 5L);
                    break;
                }
                Thread.sleep(sleepTime);
            }
            if (!locked) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u751f\u6210\u5408\u540c\u7f16\u7801\u670d\u52a1\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                ContractGenerateCodeBusiRspBO contractGenerateCodeBusiRspBO = rspBO;
                return contractGenerateCodeBusiRspBO;
            }
            CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
            if (!encodedSerial.getRespCode().equals("0000")) {
                boolean success = false;
                for (int i = 0; i < 5; ++i) {
                    encodedSerial = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
                    if (!encodedSerial.getRespCode().equals("0000")) continue;
                    success = true;
                    break;
                }
                if (!success) {
                    rspBO.setRespCode(encodedSerial.getRespCode());
                    rspBO.setRespDesc(encodedSerial.getRespDesc());
                    ContractGenerateCodeBusiRspBO contractGenerateCodeBusiRspBO = rspBO;
                    return contractGenerateCodeBusiRspBO;
                }
            }
            if (reqBO.getIsCheckCall() != null && reqBO.getIsCheckCall() == 1) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6821\u9a8c\u6210\u529f\uff0c\u4e0d\u62a5\u9519");
                ContractGenerateCodeBusiRspBO contractGenerateCodeBusiRspBO = rspBO;
                return contractGenerateCodeBusiRspBO;
            }
            rspBO.setCode((String)encodedSerial.getSerialNoList().get(0));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u7f16\u7801\u751f\u6210\u6210\u529f");
            ContractGenerateCodeBusiRspBO contractGenerateCodeBusiRspBO = rspBO;
            return contractGenerateCodeBusiRspBO;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZTBusinessException("\u7ebf\u7a0b\u88ab\u4e2d\u65ad\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        finally {
            if (locked && jedis != null) {
                try {
                    jedis.del(lockKey);
                }
                catch (Exception exception) {
                }
                finally {
                    jedis.close();
                }
            }
        }
    }
}

