/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.CceReturnContractReqBO;
import com.tydic.contract.busi.ContractLegalReturnBusiService;
import com.tydic.contract.busi.bo.CceReturnContractBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContracRelPushCodeLogMapper;
import com.tydic.contract.dao.CContractLegalReturnLogMapper;
import com.tydic.contract.dao.CContractLegalSyncAuditLogMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContracRelPushCodeLogPO;
import com.tydic.contract.po.CContractLegalReturnLogPO;
import com.tydic.contract.po.CContractLegalSyncAuditLogPO;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoPO;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ContractLegalReturnBusiServiceImpl
implements ContractLegalReturnBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractLegalReturnBusiServiceImpl.class);
    @Autowired
    private CContractLegalReturnLogMapper cContractLegalReturnLogMapper;
    @Autowired
    private CContracRelPushCodeLogMapper cContracRelPushCodeLogMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private CContractLegalSyncAuditLogMapper cContractLegalSyncAuditLogMapper;

    @Override
    public CceReturnContractBusiRspBO cancelReturnContract(CceReturnContractReqBO reqBO) {
        int i;
        CceReturnContractBusiRspBO rspBO = new CceReturnContractBusiRspBO();
        CContractLegalReturnLogPO cContractLegalReturnLogPO = new CContractLegalReturnLogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)cContractLegalReturnLogPO);
        Date nowDate = new Date();
        cContractLegalReturnLogPO.setLogTime(nowDate);
        if (cContractLegalReturnLogPO.getId() != null) {
            i = this.cContractLegalReturnLogMapper.updateByPrimaryKeySelective(cContractLegalReturnLogPO);
            if (i == 1) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6cd5\u52a1\u5408\u540c\u9000\u56de\u4fee\u6539\u6210\u529f");
            } else {
                rspBO.setRespDesc("\u6cd5\u52a1\u5408\u540c\u9000\u56de\u4fee\u6539\u5931\u8d25");
                rspBO.setRespCode("1019");
            }
        } else {
            cContractLegalReturnLogPO.setId(Sequence.getInstance().nextId());
            i = this.cContractLegalReturnLogMapper.insertSelective(cContractLegalReturnLogPO);
            if (i == 1) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6cd5\u52a1\u5408\u540c\u9000\u56de\u6210\u529f");
            } else {
                rspBO.setRespDesc("\u6cd5\u52a1\u5408\u540c\u9000\u56de\u5931\u8d25");
                rspBO.setRespCode("1018");
            }
        }
        List<CContracRelPushCodeLogPO> cContracRelPushCodeLogPOS = this.cContracRelPushCodeLogMapper.selectListByPushContractCode(reqBO.getContractCode());
        if (!CollectionUtils.isEmpty(cContracRelPushCodeLogPOS)) {
            ContractInfoChangePO contractInfoChangePO;
            Object updatePO;
            ContractInfoPO po;
            CContracRelPushCodeLogPO relPushCodeLogPO = cContracRelPushCodeLogPOS.get(0);
            if (relPushCodeLogPO.getRelateType() == 1 && (po = this.contractInfoMapper.selectByPrimaryKey(relPushCodeLogPO.getRelateId())) != null && ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL.equals(po.getContractStatus())) {
                updatePO = new ContractInfoPO();
                ((ContractInfoPO)updatePO).setContractId(relPushCodeLogPO.getRelateId());
                ((ContractInfoPO)updatePO).setContractStatus(ContractConstant.ContractStatus.CONTRACT_PENDING_PUSH_LEGAL_RETURN);
                this.contractInfoMapper.updateByPrimaryKeySelective((ContractInfoPO)updatePO);
                this.judgeDirectReturn(reqBO, nowDate);
            }
            if (relPushCodeLogPO.getRelateType() == 2 && (contractInfoChangePO = this.contractInfoChangeMapper.selectByPrimaryKey(relPushCodeLogPO.getRelateId())) != null && ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE.equals(contractInfoChangePO.getModifyStatus())) {
                updatePO = new ContractInfoChangePO();
                ((ContractInfoChangePO)updatePO).setUpdateApplyId(relPushCodeLogPO.getRelateId());
                ((ContractInfoChangePO)updatePO).setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_PENDING_PUSH_LEGAL_RETURN);
                this.contractInfoChangeMapper.updateByPrimaryKeySelective((ContractInfoChangePO)updatePO);
                this.judgeDirectReturn(reqBO, nowDate);
            }
            if (relPushCodeLogPO.getRelateType() == 3 && (po = this.contractInfoMapper.selectByPurchaseApprovalId(relPushCodeLogPO.getRelateId())) != null && ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL.equals(po.getPurchaseContractStatus())) {
                updatePO = new ContractInfoPO();
                ((ContractInfoPO)updatePO).setContractId(po.getContractId());
                ((ContractInfoPO)updatePO).setPurchaseContractStatus(ContractConstant.ContractStatus.CONTRACT_PENDING_PUSH_LEGAL_RETURN);
                this.contractInfoMapper.updateByPrimaryKeySelective((ContractInfoPO)updatePO);
                this.judgeDirectReturn(reqBO, nowDate);
            }
            if (relPushCodeLogPO.getRelateType() == 4 && (contractInfoChangePO = this.contractInfoChangeMapper.selectByPurchaseUpdateApplyId(relPushCodeLogPO.getRelateId())) != null && ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE.equals(contractInfoChangePO.getPurchaseModifyStatus())) {
                updatePO = new ContractInfoChangePO();
                ((ContractInfoChangePO)updatePO).setUpdateApplyId(contractInfoChangePO.getUpdateApplyId());
                ((ContractInfoChangePO)updatePO).setPurchaseModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_PENDING_PUSH_LEGAL_RETURN);
                this.contractInfoChangeMapper.updateByPrimaryKeySelective((ContractInfoChangePO)updatePO);
                this.judgeDirectReturn(reqBO, nowDate);
            }
        }
        return rspBO;
    }

    private void judgeDirectReturn(CceReturnContractReqBO reqBO, Date nowDate) {
        try {
            CContractLegalSyncAuditLogPO logPO;
            List<CContractLegalSyncAuditLogPO> logPOS;
            if (!StringUtils.isEmpty((Object)reqBO.getContractCode()) && !CollectionUtils.isEmpty(logPOS = this.cContractLegalSyncAuditLogMapper.selectByContractCode(reqBO.getContractCode())) && "\u8d77\u8349".equals((logPO = logPOS.get(0)).getDealDesc())) {
                CContractLegalSyncAuditLogPO insertLogPO = new CContractLegalSyncAuditLogPO();
                insertLogPO.setId(Sequence.getInstance().nextId());
                insertLogPO.setContractCode(reqBO.getContractCode());
                insertLogPO.setContractApprovalRemark("\u6cd5\u52a1\u9000\u56de");
                insertLogPO.setContractApprovalResult(1);
                insertLogPO.setContractApprovalUserName(reqBO.getDealUserName());
                insertLogPO.setDealOrgName("\u6cd5\u52a1\u7cfb\u7edf");
                insertLogPO.setDealDesc("\u5ba1\u6279");
                insertLogPO.setDealTime(nowDate);
                insertLogPO.setLogTime(nowDate);
                this.cContractLegalSyncAuditLogMapper.insert(insertLogPO);
            }
        }
        catch (Exception e) {
            log.error("\u624b\u52a8\u6dfb\u52a0\u6cd5\u52a1\u9000\u56de\u7684\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
        }
    }
}

