/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.busi.ContractPushArchiveBusiService;
import com.tydic.contract.busi.bo.ContractPushArchiveBusiReqBO;
import com.tydic.contract.busi.bo.ContractPushArchiveBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractArchiveRelMapper;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractArchiveRelPO;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.FtpUtil;
import com.tydic.contract.utils.HttpUtil;
import com.tydic.contract.webService.archive.DocArchiveV5;
import com.tydic.contract.webService.service.ArchiveService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractPushArchiveBusiServiceImpl
implements ContractPushArchiveBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractPushArchiveBusiServiceImpl.class);
    @Value(value="${FTP_URL}")
    private String url;
    @Value(value="${FTP_PORT}")
    private int port;
    @Value(value="${FTP_USERNAME}")
    private String username;
    @Value(value="${FTP_PASSWORD}")
    private String password;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private CContractInfoExtMapper cContractInfoExtMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private CContractArchiveRelMapper cContractArchiveRelMapper;

    @Override
    public ContractPushArchiveBusiRspBO pushArchive(ContractPushArchiveBusiReqBO reqBO) {
        ContractPushArchiveBusiRspBO busiRspBO = new ContractPushArchiveBusiRspBO();
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DocArchiveV5 docArchiveV5 = new DocArchiveV5();
        try {
            ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
            CContractInfoExtPO extPO = new CContractInfoExtPO();
            extPO.setRelateId(reqBO.getContractId());
            CContractInfoExtPO contractInfoExtPO = this.cContractInfoExtMapper.getModelBy(extPO);
            if (contractInfoPO != null) {
                String attachment2;
                docArchiveV5.setAppid("ygjk");
                docArchiveV5.setApptoken("ygjk");
                docArchiveV5.setCompanycode("mtkf");
                docArchiveV5.setFondsname("\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8");
                if (contractInfoExtPO != null) {
                    if ("3".equals(contractInfoExtPO.getMainBody())) {
                        docArchiveV5.setCompanycode("main");
                        docArchiveV5.setFondsname("\u4e2d\u56fd\u4e2d\u7164\u80fd\u6e90\u80a1\u4efd\u6709\u9650\u516c\u53f8");
                    } else if ("4".equals(contractInfoExtPO.getMainBody())) {
                        docArchiveV5.setCompanycode("main");
                        docArchiveV5.setFondsname("\u4e2d\u56fd\u4e2d\u7164\u80fd\u6e90\u96c6\u56e2\u6709\u9650\u516c\u53f8");
                    }
                }
                docArchiveV5.setRid(contractInfoPO.getContractId().toString());
                docArchiveV5.setOwner(contractInfoPO.getCreateUserCode());
                docArchiveV5.setTitle(contractInfoPO.getContractName());
                docArchiveV5.setDocnumber(contractInfoPO.getContractCode());
                String contractType = this.dealContractType(contractInfoPO, contractInfoExtPO);
                if ("".equals(contractType) || StringUtils.isEmpty((Object)contractType)) {
                    busiRspBO.setRespCode("8888");
                    busiRspBO.setRespDesc("\u6b64\u5408\u540c\u4e0d\u63a8\u9001\u6863\u6848\u7cfb\u7edf");
                    reqBO.setReqJson(JSONObject.toJSONString((Object)docArchiveV5));
                    reqBO.setPushLegalReturnInfo("\u6b64\u5408\u540c\u7c7b\u578b\u4e0d\u63a8\u9001\u6863\u6848\u7cfb\u7edf");
                    return busiRspBO;
                }
                docArchiveV5.setAuthor(this.dealAuthor(contractInfoPO));
                SimpleDateFormat docFormat = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat formatYEAR = new SimpleDateFormat("yyyy");
                docArchiveV5.setDocdate(docFormat.format(contractInfoPO.getCreateTime()));
                docArchiveV5.setYear(formatYEAR.format(contractInfoPO.getCreateTime()));
                docArchiveV5.setRetentionperiod("\u6c38\u4e45");
                docArchiveV5.setCreater(contractInfoPO.getCreateUserCode());
                docArchiveV5.setCreatername(contractInfoPO.getCreateUserName());
                SimpleDateFormat createFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                docArchiveV5.setCreatetime(createFormat.format(reqBO.getArchiveTime()));
                docArchiveV5.setExt4(contractInfoPO.getCreateUserName());
                docArchiveV5.setExt5(contractType);
                if (contractInfoExtPO != null) {
                    docArchiveV5.setExt6(contractInfoExtPO.getContractBasis());
                }
                docArchiveV5.setExt7(contractInfoPO.getContractAmount() == null ? "" : contractInfoPO.getContractAmount().toString());
                docArchiveV5.setExt8(contractInfoPO.getCurrency());
                if (!StringUtils.isEmpty((Object)contractInfoPO.getCurrency()) && !"CNY".equals(contractInfoPO.getCurrency())) {
                    docArchiveV5.setExt9(contractInfoPO.getExchangeRate());
                }
                docArchiveV5.setExt10(contractInfoPO.getBuyerNo());
                docArchiveV5.setExt11(contractInfoPO.getBuyerCreditNo());
                docArchiveV5.setExt12(contractInfoPO.getBuyerName());
                docArchiveV5.setExt13(contractInfoPO.getSupplierCode());
                docArchiveV5.setExt14(contractInfoPO.getSupplierCreditNo());
                docArchiveV5.setExt15(contractInfoPO.getSupplierName());
                docArchiveV5.setExt16(contractInfoPO.getMultiDealerCode());
                docArchiveV5.setExt17(contractInfoPO.getThirdCreditNo());
                docArchiveV5.setExt18(contractInfoPO.getMultiDealerName());
                docArchiveV5.setExt19(contractInfoPO.getMatterName());
                if (!StringUtils.isEmpty((Object)contractInfoPO.getPurchaseType())) {
                    docArchiveV5.setExt20(ContractTransFieldUtil.transContractPurchaseType(contractInfoPO.getPurchaseType()));
                }
                ArrayList<String> accessoryStr = new ArrayList<String>();
                if (!StringUtils.isEmpty((Object)contractInfoPO.getContractDocUrl()) && contractInfoPO.getContractDocUrl().endsWith("zip")) {
                    reqBO.setReqJson(JSONObject.toJSONString((Object)docArchiveV5));
                    reqBO.setPushLegalTime(new Date());
                    reqBO.setPushLegalReturnTime(new Date());
                    reqBO.setPushLegalReturnInfo("\u8c03\u7528\u5931\u8d25\uff1a\u6587\u4ef6\u4e0d\u80fd\u4e3azip\u683c\u5f0f");
                    busiRspBO.setRespCode("8888");
                    busiRspBO.setRespDesc("\u8c03\u7528\u5931\u8d25\uff1a\u6587\u4ef6\u4e0d\u80fd\u4e3azip\u683c\u5f0f");
                    return busiRspBO;
                }
                String attachment = this.attachment(contractInfoPO.getContractDocUrl(), contractInfoPO.getContractDocName(), "\u5408\u540c\u6587\u672c");
                if (StringUtils.isEmpty((Object)attachment)) {
                    reqBO.setReqJson(JSONObject.toJSONString((Object)docArchiveV5));
                    reqBO.setPushLegalTime(new Date());
                    reqBO.setPushLegalReturnTime(new Date());
                    reqBO.setPushLegalReturnInfo("\u8c03\u7528\u5931\u8d25\uff1a\u8bf7\u6c42\u5165\u53c2\u4e2d\u6587\u4ef6\u4e3a\u7a7a");
                    busiRspBO.setRespCode("8888");
                    busiRspBO.setRespDesc("\u8c03\u7528\u5931\u8d25\uff1a\u8bf7\u6c42\u5165\u53c2\u4e2d\u6587\u4ef6\u4e3a\u7a7a");
                    return busiRspBO;
                }
                if (attachment != null && !"".equals(attachment)) {
                    accessoryStr.add(attachment);
                }
                ContractAccessoryPo searchAccessoryPO = new ContractAccessoryPo();
                searchAccessoryPO.setRelateId(reqBO.getContractId());
                List<ContractAccessoryPo> contractAccessoryPos = this.contractAccessoryMapper.qryByCondition(searchAccessoryPO);
                if (!CollectionUtils.isEmpty(contractAccessoryPos)) {
                    contractAccessoryPos.forEach(a -> {
                        String attachment1;
                        if ((ContractConstant.RelateType.RELATE_TYPE_CONTRACT.equals(a.getRelateType()) || ContractConstant.RelateType.RELATE_TYPE_BASE_OTHER_ACCESSORY.equals(a.getRelateType())) && (attachment1 = this.attachment(a.getAcceessoryUrl(), a.getAcceessoryName(), "\u5408\u540c\u9644\u4ef6")) != null && !"".equals(attachment1)) {
                            accessoryStr.add(attachment1);
                        }
                    });
                }
                if (contractInfoPO.getItemPdfAccessoryGenerateState() != null && contractInfoPO.getItemPdfAccessoryGenerateState() == 2 && contractInfoPO.getItemPdfAccessoryName() != null && contractInfoPO.getItemPdfAccessoryUrl() != null && (attachment2 = this.attachment(contractInfoPO.getItemPdfAccessoryUrl(), contractInfoPO.getItemPdfAccessoryName(), "\u5408\u540c\u9644\u4ef6")) != null && !"".equals(attachment2)) {
                    accessoryStr.add(attachment2);
                }
                if (!CollectionUtils.isEmpty(accessoryStr)) {
                    docArchiveV5.setAttachment(((Object)accessoryStr).toString());
                }
                try {
                    reqBO.setReqJson(JSONObject.toJSONString((Object)docArchiveV5));
                    reqBO.setPushLegalTime(new Date());
                    String resultVal = this.archiveService.receiveDocArchiveV5(docArchiveV5);
                    reqBO.setPushLegalReturnTime(new Date());
                    reqBO.setPushLegalReturnInfo(resultVal);
                }
                catch (Exception e) {
                    reqBO.setPushLegalReturnInfo("\u8c03\u7528\u63a5\u53e3\u62a5\u9519\u5f02\u5e38" + e.getMessage());
                    log.error("\u5408\u540c\u540c\u6b65\u6863\u6848\u7cfb\u7edf\u5931\u8d25:" + e.getMessage());
                }
            } else {
                reqBO.setReqJson("\u67e5\u8be2\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff1a" + reqBO.getContractId());
            }
        }
        catch (Exception e) {
            reqBO.setReqJson(JSONObject.toJSONString((Object)docArchiveV5));
            reqBO.setPushLegalReturnInfo("\u5408\u540c\u540c\u6b65\u6863\u6848\u7cfb\u7edf\u5931\u8d25:" + e.getMessage());
            busiRspBO.setRespCode("8888");
            busiRspBO.setRespDesc("\u8c03\u7528\u5931\u8d25:" + e.getMessage());
            log.error("\u5408\u540c\u540c\u6b65\u6863\u6848\u7cfb\u7edf\u5931\u8d25:" + e);
        }
        return busiRspBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String attachment(String fileUrl, String fileName, String fileType) {
        if (!StringUtils.isEmpty((Object)fileName) && !StringUtils.isEmpty((Object)fileUrl)) {
            String suffix = fileUrl.substring(fileUrl.lastIndexOf("."));
            HttpUtil.httpDownload(fileUrl, fileName);
            FileOutputStream fos = null;
            FileInputStream in = null;
            File file = null;
            try {
                int temp;
                byte[] bytes = ContractPushArchiveBusiServiceImpl.getBytes(fileName);
                ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                file = new File(fileName);
                fos = new FileOutputStream(file);
                byte[] bt = new byte[10240];
                while ((temp = input.read(bt)) != -1) {
                    fos.write(bt, 0, temp);
                }
                UUID uuid = UUID.randomUUID();
                Calendar calendar = Calendar.getInstance();
                int year = calendar.get(1);
                int month = calendar.get(2) + 1;
                int day = calendar.get(5);
                String directory = "data/ygjk/" + year + "/" + month + "/" + day + "/";
                String path = uuid + suffix;
                String ftpPath = directory + path;
                try {
                    in = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                boolean b = FtpUtil.uploadFile(directory, path, in, this.url, this.port, this.username, this.password);
                log.info("\u4e0a\u4f20\u6587\u4ef6:" + fileName + "\u8fd4\u56de\u7ed3\u679c:" + b);
                if (b) {
                    String ftpAttachment;
                    String string = ftpAttachment = FtpUtil.getFtpAttachment(file, ftpPath, fileType, fileName);
                    return string;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (null != fos) {
                        fos.close();
                    }
                    if (null != in) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (ObjectUtils.isEmpty(file)) {
                    log.info("file\u5bf9\u8c61\u662f\u7a7a\u7684");
                } else if (!file.exists()) {
                    log.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + fileName + "\u4e0d\u5b58\u5728\uff01");
                } else if (file.isFile()) {
                    if (file.delete()) {
                        log.info("\u5220\u9664\u6587\u4ef6" + fileName + "\u6210\u529f\uff01");
                    } else {
                        log.info("\u5220\u9664\u6587\u4ef6" + fileName + "\u5931\u8d25\uff01");
                    }
                }
            }
        }
        return null;
    }

    public String dealAuthor(ContractInfoPO contractInfoPO) {
        if (!(StringUtils.isEmpty((Object)contractInfoPO.getBuyerName()) || StringUtils.isEmpty((Object)contractInfoPO.getSupplierName()) || StringUtils.isEmpty((Object)contractInfoPO.getMultiDealerName()))) {
            return contractInfoPO.getBuyerName() + "\u3001" + contractInfoPO.getSupplierName() + "\u3001" + contractInfoPO.getMultiDealerName();
        }
        if (!StringUtils.isEmpty((Object)contractInfoPO.getBuyerName()) && !StringUtils.isEmpty((Object)contractInfoPO.getSupplierName())) {
            return contractInfoPO.getBuyerName() + "\u3001" + contractInfoPO.getSupplierName();
        }
        if (!StringUtils.isEmpty((Object)contractInfoPO.getBuyerName())) {
            return contractInfoPO.getBuyerName();
        }
        return "";
    }

    public static byte[] getBytes(String filePath) throws IOException {
        File file = new File(filePath);
        FileInputStream fis = null;
        byte[] buffer = null;
        try {
            fis = new FileInputStream(file);
            buffer = new byte[(int)file.length()];
            fis.read(buffer);
        }
        catch (Exception e) {
            throw new IOException("\u83b7\u53d6\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25", e.getCause());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25\uff1a{}", e.getCause());
                }
            }
        }
        return buffer;
    }

    public String dealContractType(ContractInfoPO infoPO, CContractInfoExtPO contractInfoExtPO) {
        List<CContractArchiveRelPO> cContractArchiveRelPOS;
        ArrayList contractTypes = Lists.newArrayList((Object[])new Integer[]{15, 16, 30, 31});
        CContractArchiveRelPO qryPo = new CContractArchiveRelPO();
        qryPo.setContractType(infoPO.getContractType());
        qryPo.setBusinessType(infoPO.getBusinessType());
        if (contractTypes.contains(infoPO.getContractType()) && contractInfoExtPO != null && !StringUtils.isEmpty((Object)contractInfoExtPO.getMainBody())) {
            qryPo.setMainBody(Integer.valueOf(contractInfoExtPO.getMainBody()));
        }
        if (!CollectionUtils.isEmpty(cContractArchiveRelPOS = this.cContractArchiveRelMapper.qryByCondition(qryPo))) {
            return cContractArchiveRelPOS.get(0).getArchiveTypename();
        }
        return "";
    }
}

