/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractSchemeTempBO;
import com.tydic.contract.ability.bo.ContractSchemeTempMqReqBO;
import com.tydic.contract.ability.bo.ContractSchemeTempMqRspBO;
import com.tydic.contract.busi.ContractSchemeTempDealBusiService;
import com.tydic.contract.dao.CContractSchemeTempMapper;
import com.tydic.contract.po.CContractSchemeTempPO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractSchemeTempDealBusiServiceImpl
implements ContractSchemeTempDealBusiService {
    private final Integer DEL = 0;
    private final Integer ADD = 1;
    @Autowired
    private CContractSchemeTempMapper cContractSchemeTempMapper;

    @Override
    public ContractSchemeTempMqRspBO dealSchemeTemp(ContractSchemeTempMqReqBO reqBO) {
        this.val(reqBO);
        if (this.DEL.equals(reqBO.getDealType())) {
            CContractSchemeTempPO delPo = new CContractSchemeTempPO();
            delPo.setResultIds(reqBO.getResultIdList());
            this.cContractSchemeTempMapper.deleteByResultIds(delPo);
        } else {
            ArrayList<CContractSchemeTempPO> batchList = new ArrayList<CContractSchemeTempPO>();
            for (ContractSchemeTempBO bo : reqBO.getTempList()) {
                CContractSchemeTempPO po = new CContractSchemeTempPO();
                po.setId(Sequence.getInstance().nextId());
                po.setPackId(bo.getPackId());
                po.setResultId(bo.getResultId());
                po.setAuditTime(bo.getAuditTime());
                po.setSchemeType(bo.getSchemeType());
                batchList.add(po);
            }
            this.cContractSchemeTempMapper.insertBatch(batchList);
        }
        ContractSchemeTempMqRspBO rspBO = new ContractSchemeTempMqRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(ContractSchemeTempMqReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDealType() == null) {
            throw new BusinessException("8888", "dealType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Integer> dealTypeList = Arrays.asList(this.DEL, this.ADD);
        if (!dealTypeList.contains(reqBO.getDealType())) {
            throw new BusinessException("8888", "dealType\u4e0d\u5408\u6cd5");
        }
        if (this.DEL.equals(reqBO.getDealType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getResultIdList())) {
                throw new BusinessException("8888", "resultIdList\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            if (CollectionUtils.isEmpty((Collection)reqBO.getTempList())) {
                throw new BusinessException("8888", "tempList\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (ContractSchemeTempBO contractSchemeTempBO : reqBO.getTempList()) {
                if (contractSchemeTempBO.getPackId() == null) {
                    throw new BusinessException("8888", "packId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (contractSchemeTempBO.getResultId() == null) {
                    throw new BusinessException("8888", "resultId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (contractSchemeTempBO.getSchemeType() == null) {
                    throw new BusinessException("8888", "schemeType\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (contractSchemeTempBO.getAuditTime() != null) continue;
                throw new BusinessException("8888", "auditTime\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

