/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.GetSignAddressRspBO;
import com.tydic.contract.ability.bo.HttpRspBO;
import com.tydic.contract.ability.bo.OneStepSignRspBO;
import com.tydic.contract.ability.bo.UploadFileToCreateTemplateReqBO;
import com.tydic.contract.ability.bo.UploadFileToCreateTemplateRspBO;
import com.tydic.contract.busi.ContractSignBusiService;
import com.tydic.contract.busi.bo.ContractSignBusiReqBO;
import com.tydic.contract.busi.bo.ContractSignBusiRspBO;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.utils.FileHelper;
import com.tydic.contract.utils.FileUtil;
import com.tydic.contract.utils.HttpHelper;
import com.tydic.contract.utils.HttpUtil;
import com.tydic.contract.utils.RequestType;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ContractSignBusiServiceImpl
implements ContractSignBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractSignBusiServiceImpl.class);
    @Value(value="${ESB_ACCESS_IP}")
    private String esbAddressId;
    private static final String UPLOAD_FILE_CREATE_TEMPLATE_URL = "/OSN/api/getUploadUrl/v1";
    private static final String SIGN_ONE_STEP_URL = "/OSN/api/createFlowOneStep/v1";
    private static final String GET_SIGN_ADDRESS_URL = "/OSN/api/executeUrl/v1";
    private static final String CALL_BACK_URL = "/OSN/api/noticeSigned/v1";
    @Autowired
    private ContractMapper contractMapper;

    @Override
    public ContractSignBusiRspBO dealContractSign(ContractSignBusiReqBO reqBO) {
        int i;
        ContractPo contractPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractPo == null) {
            throw new ZTBusinessException("\u6839\u636e\u5408\u540cid\u6ca1\u6709\u67e5\u5230\u54cd\u5e94\u6570\u636e");
        }
        if (contractPo.getContractDocUrl() == null) {
            throw new ZTBusinessException("\u8be5\u5408\u540c\u6ca1\u6709\u751f\u6210\u5408\u540c\u6587\u4ef6");
        }
        String fileId = this.uploadFile(contractPo.getContractDocUrl());
        String flowId = "";
        String signAddress = "";
        if (reqBO.getOrgId() == null || reqBO.getOrgId().equals("")) {
            flowId = this.oneStepSign(String.valueOf(reqBO.getAccountId()), fileId);
            signAddress = this.getSignAddress(String.valueOf(reqBO.getAccountId()), flowId);
        } else if (reqBO.getOrgId() != null && !reqBO.getOrgId().equals("")) {
            flowId = this.oneStepSignByOrg(reqBO.getAccountId(), reqBO.getOrgId(), fileId);
            signAddress = this.getSignAddressByOrg(reqBO.getAccountId(), reqBO.getOrgId(), flowId);
        }
        ContractPo updateContractPo = new ContractPo();
        updateContractPo.setContractId(reqBO.getContractId());
        updateContractPo.setExternalSignSysFlowId(flowId);
        if (contractPo.getSignStatus() == 0) {
            log.info("\u5408\u540c\u7b7e\u7ae0-\u6807\u8bc6\u54ea\u4e00\u65b9\u5728\u7b7e\u7ea6\u5408\u540c");
            updateContractPo.setSignFlag(reqBO.getContractSignOrder());
        }
        if ((i = this.contractMapper.updateByPrimaryKeySelective(updateContractPo)) != 1) {
            throw new ZTBusinessException("\u4fdd\u5b58\u5408\u540c\u6570\u636e\u5931\u8d25");
        }
        ContractSignBusiRspBO rspBO = new ContractSignBusiRspBO();
        rspBO.setSignUrl(signAddress);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u53d1\u8d77\u7b7e\u7f72\u6210\u529f");
        log.info("\u7b7e\u7f72\u5730\u5740\uff1a" + signAddress);
        return rspBO;
    }

    private String uploadFile(String url) {
        String fileName = String.valueOf(Sequence.getInstance().nextId() + ".pdf");
        HttpUtil.httpDownload(url, fileName);
        log.info("\u5408\u540c\u4e0b\u8f7d\u5230\u672c\u5730");
        Long fileSize = FileUtil.getFileSize(fileName);
        String contentMD5 = FileUtil.getStringContentMD5(fileName);
        UploadFileToCreateTemplateReqBO uploadFileToCreateTemplateBO = new UploadFileToCreateTemplateReqBO();
        uploadFileToCreateTemplateBO.setContentMd5(contentMD5);
        uploadFileToCreateTemplateBO.setContentType("application/pdf");
        uploadFileToCreateTemplateBO.setFileName("\u5408\u540c.pdf");
        uploadFileToCreateTemplateBO.setConvert2Pdf(Boolean.valueOf(false));
        uploadFileToCreateTemplateBO.setFileSize(fileSize);
        String s = HttpUtil.httpClient(this.esbAddressId + UPLOAD_FILE_CREATE_TEMPLATE_URL, JSON.toJSONString((Object)uploadFileToCreateTemplateBO));
        HttpRspBO rspHttpRspBO = (HttpRspBO)JSON.parseObject((String)s, (TypeReference)new TypeReference<HttpRspBO<UploadFileToCreateTemplateRspBO>>(){}, (Feature[])new Feature[0]);
        if (rspHttpRspBO.getCode() != 0) {
            throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u5230\u670d\u52a1\u5668\u521b\u5efa\u6a21\u677f\u5931\u8d25");
        }
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5230\u670d\u52a1\u5668\u521b\u5efa\u6a21\u677f" + rspHttpRspBO);
        UploadFileToCreateTemplateRspBO data = (UploadFileToCreateTemplateRspBO)rspHttpRspBO.getData();
        String uploadUrl = data.getUploadUrl();
        String fileId = data.getFileId();
        try {
            byte[] bytes = FileHelper.getBytes(fileName);
            JSONObject json = HttpHelper.doUploadHttp(RequestType.PUT, uploadUrl, bytes, contentMD5, "application/pdf");
            log.info("\u4e0a\u4f20\u6587\u4ef6\uff1a" + json);
        }
        catch (IOException e) {
            log.error("\u5408\u540c\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519");
            throw new ZTBusinessException("\u5408\u540c\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519:" + e.getMessage());
        }
        HttpUtil.deleteFile(fileName);
        return fileId;
    }

    private String oneStepSignByOrg(String accountId, String orgId, String fileId) {
        String oneStepReq = "{\n \"attachments\":[\n        {\n            \"attachmentName\":\"\u5408\u540c.pdf\",\n            \"fileId\":\"#{fileId}\"\n        }\n    ],\n  \"docs\": [\n    {\n      \"fileId\": \"#{fileId}\"\n    }\n  ],\n  \"copiers\": [\n    {\n      \"copierAccountId\": \"#{orgId}\",\n      \"copierIdentityAccountId\": \"#{orgId}\",\n      \"copierIdentityAccountType\": 1\n    }\n  ],  \n  \"flowInfo\": {\n    \"autoArchive\": true,\n    \"autoInitiate\": true,\n    \"businessScene\": \"\u521b\u5efa\u7b7e\u7f72\u6d41\u7a0b\u6837\u4f8b\",\n    \"flowConfigInfo\": {\n      \"noticeDeveloperUrl\": \"#{noticeUrl}\",\n      \"redirectUrl\": \"\",\n      \"batchDropSeal\":true\n    }\n  },\n  \"signers\": [\n      {\n      \"platformSign\": false,\n      \"signerAccount\" : {\n          \"signerAccountId\" : \"#{accountId}\",\n          \"authorizedAccountId\" : \"#{orgId}\"\n      },\n      \"signOrder\": 1,\n      \"signfields\": [\n        {\n          \"autoExecute\": false,\n          \"actorIndentityType\":2,\n          \"fileId\": \"#{fileId}\",\n          \"sealType\": \"\",\n          \"signDateBean\": {\n              \"fontSize\": 12,\n              \"format\": \"yyyy\u5e74MM\u65e5dd\"\n          },\n          \"signType\": 0,\n          \"width\": 150\n        }\n      ]\n    }\n  ]\n}";
        String reqJson = oneStepReq.replace("#{fileId}", fileId).replace("#{noticeUrl}", this.esbAddressId + CALL_BACK_URL).replace("#{accountId}", accountId).replace("#{orgId}", orgId);
        String s = HttpUtil.httpClient(this.esbAddressId + SIGN_ONE_STEP_URL, reqJson);
        HttpRspBO rspHttpRspBO = (HttpRspBO)JSON.parseObject((String)s, (TypeReference)new TypeReference<HttpRspBO<OneStepSignRspBO>>(){}, (Feature[])new Feature[0]);
        log.info("\u4e00\u6b65\u53d1\u8d77\u7b7e\u7f72\uff1a" + rspHttpRspBO);
        if (rspHttpRspBO.getCode() != 0) {
            throw new ZTBusinessException("\u4e00\u6b65\u53d1\u8d77\u7b7e\u7f72\u5408\u540c\u5931\u8d25");
        }
        return ((OneStepSignRspBO)rspHttpRspBO.getData()).getFlowId();
    }

    private String oneStepSign(String accountId, String fileId) {
        String oneStepReq = "{\n \"attachments\":[\n        {\n            \"attachmentName\":\"\u5408\u540c.pdf\",\n            \"fileId\":\"#{fileId}\"\n        }\n    ],\n  \"docs\": [\n    {\n      \"fileId\": \"#{fileId}\" \n    }\n  ],\n  \"copiers\": [\n    {\n      \"copierAccountId\": \"#{accountId}\",\n      \"copierIdentityAccountType\": 0\n    }\n  ],  \n  \"flowInfo\": {\n    \"autoArchive\": true,\n    \"autoInitiate\": true,\n    \"businessScene\": \"\u5408\u540c\u6d4b\u8bd59\",\n    \"flowConfigInfo\": {\n      \"noticeDeveloperUrl\" : \"#{noticeUrl}\",\n      \"batchDropSeal\":null,\n      \"redirectUrl\" : \"https://www.baidu.com/\"\n    }\n  },\n  \"signers\": [\n      {\n      \"platformSign\": false,\n      \"signerAccount\" : {\n          \"signerAccountId\" : \"#{accountId}\"\n      },\n      \"signfields\": [\n        {\n          \"assignedPosbean\" : null,\n          \"autoExecute\": false,\n          \"actorIndentityType\":0,\n          \"fileId\": \"#{fileId}\",\n          \"signType\": 0,\n          \"signDateBean\": {\n              \"fontSize\": 12,\n              \"format\": \"yyyy\u5e74MM\u65e5dd\"\n          }\n        }\n      ]\n    }\n  ]\n}";
        String fileIdReplace = oneStepReq.replace("#{fileId}", fileId).replace("#{noticeUrl}", this.esbAddressId + CALL_BACK_URL);
        String accountIdReplace = fileIdReplace.replace("#{accountId}", accountId);
        String s = HttpUtil.httpClient(this.esbAddressId + SIGN_ONE_STEP_URL, accountIdReplace);
        HttpRspBO rspHttpRspBO = (HttpRspBO)JSON.parseObject((String)s, (TypeReference)new TypeReference<HttpRspBO<OneStepSignRspBO>>(){}, (Feature[])new Feature[0]);
        log.info("\u4e00\u6b65\u53d1\u8d77\u7b7e\u7f72\uff1a" + rspHttpRspBO);
        if (rspHttpRspBO.getCode() != 0) {
            throw new ZTBusinessException("\u4e00\u6b65\u53d1\u8d77\u7b7e\u7f72\u5408\u540c\u5931\u8d25");
        }
        return ((OneStepSignRspBO)rspHttpRspBO.getData()).getFlowId();
    }

    private String getSignAddress(String accountId, String flowId) {
        String param = "{\n    \"flowId\": \"#{flowId}\",\n    \"accountId\": \"#{accountId}\"\n}";
        String flowIdReplace = param.replace("#{flowId}", flowId);
        String accountIdReplace = flowIdReplace.replace("#{accountId}", accountId);
        String s = HttpUtil.httpClient(this.esbAddressId + GET_SIGN_ADDRESS_URL, accountIdReplace);
        HttpRspBO rspHttpRspBO = (HttpRspBO)JSON.parseObject((String)s, (TypeReference)new TypeReference<HttpRspBO<GetSignAddressRspBO>>(){}, (Feature[])new Feature[0]);
        log.info("\u83b7\u53d6\u7b7e\u7f72\u5730\u5740\uff1a" + rspHttpRspBO);
        if (rspHttpRspBO.getCode() != 0) {
            throw new ZTBusinessException("\u83b7\u53d6\u7b7e\u7f72\u5730\u5740\u5931\u8d25");
        }
        return ((GetSignAddressRspBO)rspHttpRspBO.getData()).getUrl();
    }

    private String getSignAddressByOrg(String accountId, String orgId, String flowId) {
        String param = "{\n    \"flowId\": \"#{flowId}\",\n    \"accountId\": \"#{accountId}\",\n    \"organizeId\" : \"#{orgId}\"\n}";
        String reqJson = param.replace("#{flowId}", flowId).replace("#{accountId}", accountId).replace("#{orgId}", orgId);
        String s = HttpUtil.httpClient(this.esbAddressId + GET_SIGN_ADDRESS_URL, reqJson);
        HttpRspBO rspHttpRspBO = (HttpRspBO)JSON.parseObject((String)s, (TypeReference)new TypeReference<HttpRspBO<GetSignAddressRspBO>>(){}, (Feature[])new Feature[0]);
        log.info("\u83b7\u53d6\u7b7e\u7f72\u5730\u5740\uff1a" + rspHttpRspBO);
        if (rspHttpRspBO.getCode() != 0) {
            throw new ZTBusinessException("\u83b7\u53d6\u7b7e\u7f72\u5730\u5740\u5931\u8d25");
        }
        return ((GetSignAddressRspBO)rspHttpRspBO.getData()).getUrl();
    }
}

