/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.tydic.agreement.ability.api.AgrAgreementGetAgreementService;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrAgreementChangeBO;
import com.tydic.agreement.ability.bo.AgrAgreementGetAgreementReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementGetAgreementRspBO;
import com.tydic.contract.ability.bo.ContractVersionQueryAbilityBO;
import com.tydic.contract.busi.ContractVersionQueryBusiService;
import com.tydic.contract.busi.bo.ContractVersionQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractVersionQueryBusiRspBO;
import com.tydic.contract.busi.bo.JudgeIsPopBusiReqBO;
import com.tydic.contract.busi.bo.JudgeIsPopBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoHistoryLogMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractInfoHistoryLogPO;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractVersionQueryBusiServiceImpl
implements ContractVersionQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractVersionQueryBusiServiceImpl.class);
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private ContractInfoMapper contractInfoeMapper;
    @Autowired
    private CContractInfoHistoryLogMapper cContractInfoHistoryLogMapper;
    @Autowired
    private AgrAgreementGetAgreementService agrAgreementGetAgreementService;

    @Override
    public ContractVersionQueryBusiRspBO contractVersionQuery(ContractVersionQueryBusiReqBO reqBO) {
        ContractVersionQueryBusiRspBO rspBO = new ContractVersionQueryBusiRspBO();
        if (reqBO.getContractId() == null) {
            rspBO.setContractVersionQueryList(null);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ContractInfoPO contractInfoPO = this.contractInfoeMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractInfoPO != null) {
            ContractInfoChangePO contractInfoChangePO = new ContractInfoChangePO();
            contractInfoChangePO.setContractId(contractInfoPO.getContractId());
            contractInfoChangePO.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_EFFECT);
            contractInfoChangePO.setOrderBy("UPDATE_APPLY_TIME");
            contractInfoChangePO.setIsVersionQuery(ContractConstant.DicDelFlag.YES);
            List<ContractInfoChangePO> contractInfoChangePOS = this.contractInfoChangeMapper.getList(contractInfoChangePO);
            log.debug("contractInfoChangePOS\u4e3a\uff1a" + contractInfoChangePOS);
            ArrayList<ContractVersionQueryAbilityBO> contractVersionQueryAbilityBOList = new ArrayList<ContractVersionQueryAbilityBO>();
            int version = 1;
            if (!CollectionUtils.isEmpty(contractInfoChangePOS)) {
                ContractInfoChangePO firstChangePO = contractInfoChangePOS.get(0);
                if (firstChangePO.getContractId() != null) {
                    CContractInfoHistoryLogPO seachPO = new CContractInfoHistoryLogPO();
                    seachPO.setContractId(firstChangePO.getContractId());
                    seachPO.setUpdateApplyId(firstChangePO.getUpdateApplyId());
                    List<CContractInfoHistoryLogPO> logPOS = this.cContractInfoHistoryLogMapper.selectByPO(seachPO);
                    if (!CollectionUtils.isEmpty(logPOS)) {
                        CContractInfoHistoryLogPO originalPO = logPOS.get(0);
                        ContractVersionQueryAbilityBO contractVersionQueryAbilityBO = new ContractVersionQueryAbilityBO();
                        contractVersionQueryAbilityBO.setContractId(originalPO.getContractId());
                        contractVersionQueryAbilityBO.setContractDocUrl(originalPO.getContractDocUrl());
                        contractVersionQueryAbilityBO.setContractDocName(originalPO.getContractDocName());
                        contractVersionQueryAbilityBO.setVersionID("V" + version++ + "\u539f\u59cb\u7248\u672c");
                        contractVersionQueryAbilityBOList.add(contractVersionQueryAbilityBO);
                    }
                }
                for (ContractInfoChangePO infoChangePO : contractInfoChangePOS) {
                    ContractVersionQueryAbilityBO contractVersionQueryAbilityBO = new ContractVersionQueryAbilityBO();
                    BeanUtils.copyProperties((Object)infoChangePO, (Object)contractVersionQueryAbilityBO);
                    contractVersionQueryAbilityBO.setVersionID("V" + version++);
                    contractVersionQueryAbilityBO.setCreateTime(infoChangePO.getUpdateApplyTime());
                    contractVersionQueryAbilityBO.setCreateUserName(infoChangePO.getUpdateApplyOperUserName());
                    contractVersionQueryAbilityBOList.add(contractVersionQueryAbilityBO);
                    contractVersionQueryAbilityBO.setModifyStatusStr(ContractTransFieldUtil.transModifyStatus(contractVersionQueryAbilityBO.getModifyStatus()));
                }
            }
            Collections.reverse(contractVersionQueryAbilityBOList);
            log.debug("contractVersionQueryAbilityBOList\u4e3a\uff1a" + contractVersionQueryAbilityBOList);
            rspBO.setContractVersionQueryList(contractVersionQueryAbilityBOList);
            if (contractInfoPO.getAgencyAgreementId() != null) {
                List agrAgreementChangeBOS;
                AgrAgreementGetAgreementReqBO agrAgreementGetAgreementReqBO = new AgrAgreementGetAgreementReqBO();
                agrAgreementGetAgreementReqBO.setAgreementId(contractInfoPO.getAgencyAgreementId());
                AgrAgreementGetAgreementRspBO agreementRspBO = this.agrAgreementGetAgreementService.getAgreement(agrAgreementGetAgreementReqBO);
                if (agreementRspBO != null && !CollectionUtils.isEmpty((Collection)(agrAgreementChangeBOS = agreementRspBO.getAgreementChangeBOS()))) {
                    Map<String, List<AgrAgreementChangeBO>> relateIdMap = agrAgreementChangeBOS.stream().collect(Collectors.groupingBy(AgrAgreementChangeBO::getChangeCode));
                    if (!CollectionUtils.isEmpty(contractVersionQueryAbilityBOList)) {
                        for (ContractVersionQueryAbilityBO contractVersionQueryAbilityBO : contractVersionQueryAbilityBOList) {
                            AgrAgreementChangeBO agrAgreementChangeBO;
                            List<AgrAgreementChangeBO> agrAgreementChange = relateIdMap.get(contractVersionQueryAbilityBO.getUpdateApplyCode());
                            if (CollectionUtils.isEmpty(agrAgreementChange) || (agrAgreementChangeBO = agrAgreementChange.get(0)) == null) continue;
                            contractVersionQueryAbilityBO.setAgreementId(contractInfoPO.getAgencyAgreementId());
                            contractVersionQueryAbilityBO.setChangeId(agrAgreementChangeBO.getChangeId());
                            contractVersionQueryAbilityBO.setChangeCode(agrAgreementChangeBO.getChangeCode());
                            contractVersionQueryAbilityBO.setSupplierId(agrAgreementChangeBO.getSupplierId());
                            contractVersionQueryAbilityBO.setStatus(agrAgreementChangeBO.getStatus());
                        }
                    }
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public JudgeIsPopBusiRspBO judgeIsPop(JudgeIsPopBusiReqBO reqBO) {
        JudgeIsPopBusiRspBO rspBO = new JudgeIsPopBusiRspBO();
        if (reqBO.getContractId() == null || reqBO.getAgreementId() == null) {
            rspBO.setRespCode("\u5931\u8d25");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        ContractInfoPO contractInfoPO = this.contractInfoeMapper.selectByPrimaryKey(reqBO.getContractId());
        AgrAgreementGetAgreementReqBO agrAgreementGetAgreementReqBO = new AgrAgreementGetAgreementReqBO();
        agrAgreementGetAgreementReqBO.setAgreementId(reqBO.getAgreementId());
        AgrAgreementGetAgreementRspBO agrAgreementGetAgreementRspBO = this.agrAgreementGetAgreementService.getAgreement(agrAgreementGetAgreementReqBO);
        if (agrAgreementGetAgreementRspBO == null || agrAgreementGetAgreementRspBO.getAgrAgreementBO() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u4fe1\u606f");
            return rspBO;
        }
        log.info("agrAgreementGetAgreementRspBO\u7684\u503c\u4e3a" + agrAgreementGetAgreementRspBO);
        AgrAgreementBO agrAgreementBO = agrAgreementGetAgreementRspBO.getAgrAgreementBO();
        String agreementVersion = agrAgreementBO.getAgreementVersion();
        log.info("contractInfoPO\u7684\u503c\u4e3a" + contractInfoPO);
        if (contractInfoPO == null) {
            if (!agreementVersion.equals(reqBO.getAgreementVersion())) {
                rspBO.setPop(true);
            } else {
                rspBO.setPop(false);
            }
        } else if (!agreementVersion.equals(contractInfoPO.getAgreementVersion())) {
            rspBO.setPop(true);
        } else {
            rspBO.setPop(false);
        }
        rspBO.setAgreementVersion(agreementVersion);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

