/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.busi.NoticeContractSignedBusiService;
import com.tydic.contract.busi.bo.NoticeContractSignedBusiReqBO;
import com.tydic.contract.busi.bo.NoticeContractSignedBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.ContractDownloadPo;
import com.tydic.contract.po.ContractDownloadRspPo;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.utils.FileHelper;
import com.tydic.contract.utils.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class NoticeContractSignedBusiServiceImpl
implements NoticeContractSignedBusiService {
    private static final Logger log = LoggerFactory.getLogger(NoticeContractSignedBusiServiceImpl.class);
    @Value(value="${ESB_ACCESS_IP}")
    private String esbAddressId;
    private static final String DOWNLOAD_URL = "/OSN/api/documents/v1";
    private static final Long USER_ID = 8848L;
    private static final String USER_NAME = "e\u7b7e\u5b9d";
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    private static final String ACTION_FLAG = "SIGN_FLOW_FINISH";
    @Autowired
    private FileClient fileClient;
    private static final String OSS_SERVER_URL = "https://dev-zhongtai.oss-cn-beijing.aliyuncs.com/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NoticeContractSignedBusiRspBO noticeSigned(NoticeContractSignedBusiReqBO reqBO) {
        log.info("action\u5b57\u6bb5\u7c7b\u578b\uff1a" + reqBO.getAction());
        if (reqBO.getAction().equals(ACTION_FLAG)) {
            log.info("\u7528\u6237\u7b7e\u7f72\u5408\u540c\u540e\u56de\u8c03\u901a\u77e5-flowId:" + reqBO.getFlowId());
            log.info("\u6839\u636eflowId\u67e5\u8be2\u5408\u540c\u5185\u5bb9");
            ContractPo contractPo = new ContractPo();
            contractPo.setExternalSignSysFlowId(reqBO.getFlowId());
            ContractPo contractByFlowIdPo = this.contractMapper.qryContractByFlowId(contractPo);
            log.info("\u5408\u540c\u539f\u59cb\u6570\u636e\uff1a" + contractByFlowIdPo);
            if (contractByFlowIdPo == null) {
                throw new ZTBusinessException("\u6839\u636eflowId\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u5408\u540c\u6570\u636e");
            }
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost(this.esbAddressId + DOWNLOAD_URL);
            ContractDownloadPo object = new ContractDownloadPo();
            object.setFlowId(reqBO.getFlowId());
            String jsonString = JSON.toJSONString((Object)object);
            StringEntity entity = new StringEntity(jsonString, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Content-Type", "application/json;charset=utf8");
            CloseableHttpResponse response = null;
            ContractDownloadRspPo rspPo = new ContractDownloadRspPo();
            try {
                response = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity responseEntity = response.getEntity();
                log.info("\u54cd\u5e94\u72b6\u6001\u4e3a:" + response.getStatusLine());
                if (responseEntity != null) {
                    String s = EntityUtils.toString((HttpEntity)responseEntity);
                    log.info("\u54cd\u5e94\u5185\u5bb9\u4e3a:" + s);
                    String substring = s.substring(s.indexOf("\"docs\":[") + 8, s.indexOf("]}}"));
                    rspPo = (ContractDownloadRspPo)JSON.parseObject((String)substring, ContractDownloadRspPo.class);
                }
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (httpClient != null) {
                        httpClient.close();
                    }
                    if (response != null) {
                        response.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            String uploadFilePath = this.uploadFile(rspPo);
            log.info("\u66f4\u6539\u5408\u540c\u72b6\u6001");
            ContractPo updatePo = new ContractPo();
            if (contractByFlowIdPo.getSignFlag().equals(ContractConstant.SignFlag.GENERATOR_FIRST_STATUS)) {
                if (contractByFlowIdPo.getContractStatus().equals(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_)) {
                    log.info("\u53d8\u66f4\u72b6\u6001\uff1a1\uff0c6->7");
                    this.recordContractNodeOperLog(contractByFlowIdPo.getContractId(), USER_ID, USER_NAME, "PRODUCER_SIGN", "\u751f\u6210\u65b9\u7b7e\u7ae0");
                    updatePo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
                } else if (contractByFlowIdPo.getContractStatus().equals(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN)) {
                    log.info("\u53d8\u66f4\u72b6\u6001\uff1a1\uff0c12->7");
                    this.recordContractNodeOperLog(contractByFlowIdPo.getContractId(), USER_ID, USER_NAME, "PRODUCER_SIGN", "\u751f\u6210\u65b9\u7b7e\u7ae0");
                    updatePo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
                } else if (contractByFlowIdPo.getContractStatus().equals(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_)) {
                    log.info("\u53d8\u66f4\u72b6\u6001\uff1a1\uff0c7->8");
                    this.recordContractNodeOperLog(contractByFlowIdPo.getContractId(), USER_ID, USER_NAME, "SIGNATORIES_SIGN", "\u7b7e\u8ba2\u65b9\u7b7e\u7ae0");
                    this.recordContractNodeOperLog(contractByFlowIdPo.getContractId(), USER_ID, USER_NAME, "CONTRACT_EFFECT", "\u5408\u540c\u751f\u6548");
                    updatePo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
                }
            } else if (contractByFlowIdPo.getSignFlag().equals(ContractConstant.SignFlag.SINGER_FIRST_STATUS)) {
                if (contractByFlowIdPo.getContractStatus().equals(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_)) {
                    log.info("\u53d8\u66f4\u72b6\u6001\uff1a2\uff0c7->6");
                    this.recordContractNodeOperLog(contractByFlowIdPo.getContractId(), USER_ID, USER_NAME, "SIGNATORIES_SIGN", "\u7b7e\u8ba2\u65b9\u7b7e\u7ae0");
                    updatePo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
                } else if (contractByFlowIdPo.getContractStatus().equals(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN)) {
                    log.info("\u53d8\u66f4\u72b6\u6001\uff1a2\uff0c12->6");
                    this.recordContractNodeOperLog(contractByFlowIdPo.getContractId(), USER_ID, USER_NAME, "SIGNATORIES_SIGN", "\u7b7e\u8ba2\u65b9\u7b7e\u7ae0");
                    updatePo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
                } else if (contractByFlowIdPo.getContractStatus().equals(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_)) {
                    log.info("\u53d8\u66f4\u72b6\u6001\uff1a2\uff0c6->8");
                    this.recordContractNodeOperLog(contractByFlowIdPo.getContractId(), USER_ID, USER_NAME, "PRODUCER_SIGN", "\u751f\u6210\u65b9\u7b7e\u7ae0");
                    this.recordContractNodeOperLog(contractByFlowIdPo.getContractId(), USER_ID, USER_NAME, "CONTRACT_EFFECT", "\u5408\u540c\u751f\u6548");
                    updatePo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
                }
            } else {
                throw new ZTBusinessException("\u6d41\u7a0b\u9519\u8bef");
            }
            updatePo.setContractId(contractByFlowIdPo.getContractId());
            updatePo.setContractDocUrl(uploadFilePath);
            updatePo.setSignStatus(1);
            int i = this.contractMapper.updateByPrimaryKeySelective(updatePo);
            if (i != 1) {
                throw new ZTBusinessException("\u56de\u8c03\u901a\u77e5\uff1a\u56de\u5199\u5408\u540c\u6570\u636e\u5931\u8d25");
            }
            NoticeContractSignedBusiRspBO busiRspBO = new NoticeContractSignedBusiRspBO();
            busiRspBO.setFileUrl(rspPo.getFileUrl());
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u7528\u6237\u7b7e\u7f72\u5408\u540c\u540e\u56de\u8c03\u901a\u77e5\u5f97\u5230\u6587\u4ef6\u5730\u5740\u6210\u529f");
            return busiRspBO;
        }
        return null;
    }

    private void recordContractNodeOperLog(Long contractId, Long userId, String userName, String nodeCode, String nodeName) {
        ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
        contractRecordContractNodeOperLogAtomReqBO.setContractId(contractId);
        contractRecordContractNodeOperLogAtomReqBO.setNodeCode(nodeCode);
        contractRecordContractNodeOperLogAtomReqBO.setNodeName(nodeName);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserId(userId);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserName(userName);
        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
    }

    private String uploadFile(ContractDownloadRspPo rspPo) {
        String preName = "external2internal-";
        String fileName = preName + String.valueOf(Sequence.getInstance().nextId() + ".pdf");
        HttpUtil.httpDownload(rspPo.getFileUrl(), fileName);
        log.info("\u5408\u540c\u7b7e\u7f72\u5b8c\u6210-\u4e0b\u8f7d\u5230\u672c\u5730");
        String path = "";
        try {
            byte[] bytes = FileHelper.getBytes(fileName);
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String uploadPath = sdf.format(new Date());
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)input);
            path = OSS_SERVER_URL + result;
            log.info("\u5408\u540c\u4e0a\u4f20\u81f3oss\u8def\u5f84\uff1a" + path);
        }
        catch (Exception e) {
            log.error("\u5408\u540c\u7b7e\u7f72\u5b8c\u6210-\u5408\u540c\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519");
            throw new ZTBusinessException("\u5408\u540c\u7b7e\u7f72\u5b8c\u6210-\u5408\u540c\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519:" + e.getMessage());
        }
        HttpUtil.deleteFile(fileName);
        return path;
    }
}

