/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.InterFaceContractGetCanOrderNumAtomService;
import com.tydic.contract.atom.InterFaceContractUpdateOrderItemAtomService;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractUpdateOrderItemAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractUpdateOrderItemAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractUpdateOrderItemBO;
import com.tydic.contract.busi.ContractAddNewBusiService;
import com.tydic.contract.busi.bo.ContractAddNewBusiReqBO;
import com.tydic.contract.busi.bo.ContractAddNewBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.po.ContractInfoPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractAddNewBusiServiceImpl
implements ContractAddNewBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractAddNewBusiServiceImpl.class);
    public static final String FIELD_CONTRACT_ID = "contractId";
    public static final String FIELD_CONTRACT_CODE = "contractCode";
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    @Autowired
    private InterFaceContractGetCanOrderNumAtomService interFaceContractGetCanOrderNumAtomService;
    @Autowired
    private InterFaceContractUpdateOrderItemAtomService interFaceContractUpdateOrderItemAtomService;

    @Override
    public ContractAddNewBusiRspBO addContractNew(ContractAddNewBusiReqBO reqBO) {
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("\u5408\u540cid\u5fc5\u4f20");
        }
        ContractAddNewBusiRspBO rspBO = new ContractAddNewBusiRspBO();
        if ("0".equals(reqBO.getOperType())) {
            Map<String, Object> resultMap = this.addContract(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u65b0\u589e\u5408\u540c\u6210\u529f");
            rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
            rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
            return rspBO;
        }
        if ("1".equals(reqBO.getOperType())) {
            this.saveContract(reqBO);
            rspBO.setContractId(reqBO.getContractId());
            rspBO.setContractCode(reqBO.getContractCode());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4fdd\u5b58\u5408\u540c\u6210\u529f");
            return rspBO;
        }
        if ("2".equals(reqBO.getOperType())) {
            reqBO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_IN_CONFIRM);
            this.saveContract(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4fdd\u5b58\u5408\u540c\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("1007");
        rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b");
        return rspBO;
    }

    private Map<String, Object> addContract(ContractAddNewBusiReqBO reqBO) {
        Map<String, Object> addContractResultMap = this.addContractInfo(reqBO);
        this.dealItemInfo(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getAccessoryList())) {
            this.addContractAccessoryInfo(reqBO);
        }
        this.recordContractNodeOperLog(reqBO);
        return addContractResultMap;
    }

    private void saveContract(ContractAddNewBusiReqBO reqBO) {
        this.saveContractInfo(reqBO);
        this.dealItemInfo(reqBO);
        this.updateContractAccessoryInfo(reqBO);
    }

    private void saveContractInfo(ContractAddNewBusiReqBO reqBO) {
        ContractInfoPO oldContractInfoPo = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
        if (oldContractInfoPo != null) {
            int updateResult;
            ContractInfoPO updateContractInfoPo = new ContractInfoPO();
            BeanUtils.copyProperties((Object)oldContractInfoPo, (Object)updateContractInfoPo);
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateContractInfoPo);
            updateContractInfoPo.setUpdateUserId(reqBO.getUserId());
            updateContractInfoPo.setUpdateUserName(reqBO.getUsername());
            updateContractInfoPo.setUpdateTime(new Date());
            if (null != reqBO.getContractAmount()) {
                updateContractInfoPo.setContractAmount(reqBO.getContractAmount() * 10000L);
            }
            if ((updateResult = this.contractInfoMapper.updateByPrimaryKeySelective(updateContractInfoPo)) != 1) {
                throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u6570\u636e\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u539f\u5408\u540c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    private Map<String, Object> addContractInfo(ContractAddNewBusiReqBO reqBO) {
        int addContractResult;
        ContractInfoPO insertContractPo = new ContractInfoPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)insertContractPo);
        insertContractPo.setUpdateUserId(reqBO.getUserId());
        insertContractPo.setUpdateUserName(reqBO.getUsername());
        insertContractPo.setUpdateTime(new Date());
        insertContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT);
        insertContractPo.setContractVersion(1);
        insertContractPo.setContractOrgType(reqBO.getIsprofess());
        if (null != reqBO.getContractAmount()) {
            insertContractPo.setContractAmount(reqBO.getContractAmount() * 10000L);
        }
        if (1 == (addContractResult = this.contractInfoMapper.insertSelective(insertContractPo))) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(FIELD_CONTRACT_ID, insertContractPo.getContractId());
            resultMap.put(FIELD_CONTRACT_CODE, insertContractPo.getContractCode());
            return resultMap;
        }
        throw new ZTBusinessException("\u5408\u540c\u65b0\u589e\u5931\u8d25");
    }

    private void dealItemInfo(ContractAddNewBusiReqBO reqBO) {
        ContractInfoItemTmpPO deleteContractInfoItemTmpPo = new ContractInfoItemTmpPO();
        deleteContractInfoItemTmpPo.setDelFlag("1");
        deleteContractInfoItemTmpPo.setRelateId(reqBO.getContractId());
        this.contractInfoItemTmpMapper.deleteBy(deleteContractInfoItemTmpPo);
        ContractInfoItemTmpPO contractInfoItemTmpPo = new ContractInfoItemTmpPO();
        contractInfoItemTmpPo.setRelateId(reqBO.getContractId());
        List<ContractInfoItemTmpPO> contractInfoItemTmpPOList = this.contractInfoItemTmpMapper.getList(contractInfoItemTmpPo);
        contractInfoItemTmpPOList.forEach(contractInfoItemTmpPO -> {
            if (contractInfoItemTmpPO.getRate() == null) {
                throw new ZTBusinessException("\u660e\u7ec6\u7684\u7a0e\u7387\u3010rate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        try {
            this.operFzItemNum(contractInfoItemTmpPOList, reqBO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        ContractInfoItemPO deleteContractInfoItemPo = new ContractInfoItemPO();
        deleteContractInfoItemPo.setRelateId(reqBO.getContractId());
        this.contractInfoItemMapper.deleteByCondition(deleteContractInfoItemPo);
        ArrayList contractInfoItemPOS = new ArrayList();
        for (ContractInfoItemTmpPO contractInfoItemTmpPO2 : contractInfoItemTmpPOList) {
            ContractInfoItemPO contractInfoItemPO = new ContractInfoItemPO();
            BeanUtils.copyProperties((Object)contractInfoItemTmpPO2, (Object)contractInfoItemPO);
            this.contractInfoItemMapper.insertSelective(contractInfoItemPO);
        }
    }

    private void updateContractAccessoryInfo(ContractAddNewBusiReqBO reqBO) {
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateId(reqBO.getContractId());
        deleteContractAccessoryPo.setRelateCode(reqBO.getContractCode());
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getAccessoryList())) {
            this.addContractAccessoryInfo(reqBO);
        }
    }

    private void addContractAccessoryInfo(ContractAddNewBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getAccessoryList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo contractAccessoryPo : list) {
            contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            contractAccessoryPo.setRelateId(reqBO.getContractId());
            contractAccessoryPo.setRelateCode(reqBO.getContractCode());
            contractAccessoryPo.setCreateUserId(reqBO.getUserId());
            contractAccessoryPo.setCreateUserName(reqBO.getUsername());
            contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT);
        }
        int result = this.contractAccessoryMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void recordContractNodeOperLog(ContractAddNewBusiReqBO reqBO) {
        ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
        contractRecordContractNodeOperLogAtomReqBO.setContractId(reqBO.getContractId());
        contractRecordContractNodeOperLogAtomReqBO.setNodeCode("CREATE_CONTRACT");
        contractRecordContractNodeOperLogAtomReqBO.setNodeName("\u65b0\u5efa\u5408\u540c");
        contractRecordContractNodeOperLogAtomReqBO.setOperUserId(reqBO.getUserId());
        contractRecordContractNodeOperLogAtomReqBO.setOperUserName(reqBO.getUsername());
        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
    }

    private void operFzItemNum(List<ContractInfoItemTmpPO> contractInfoItemTmpPOList, ContractAddNewBusiReqBO reqBO) {
        try {
            List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.getItemsByRelId(reqBO.getContractId());
            Map<Object, Object> oldAwardNumIdAndCount = new HashMap();
            if (!CollectionUtils.isEmpty(contractInfoItemPOS)) {
                oldAwardNumIdAndCount = contractInfoItemPOS.stream().filter(a -> !StringUtils.isEmpty((Object)a.getAwardNumId())).collect(Collectors.toMap(a -> a.getAwardNumId(), b -> b.getAmount(), (first, second) -> first));
            }
            Map<String, BigDecimal> awardNumIdAndCount = contractInfoItemTmpPOList.stream().filter(a -> !StringUtils.isEmpty((Object)a.getAwardNumId())).collect(Collectors.toMap(a -> a.getAwardNumId(), b -> b.getAmount(), (first, second) -> first));
            ArrayList<InterFaceContractUpdateOrderItemBO> operOrderItem = new ArrayList<InterFaceContractUpdateOrderItemBO>();
            for (Map.Entry<Object, Object> each : oldAwardNumIdAndCount.entrySet()) {
                if (awardNumIdAndCount.containsKey(each.getKey())) continue;
                InterFaceContractUpdateOrderItemBO interFaceContractUpdateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                interFaceContractUpdateOrderItemBO.setGoodTypeId((String)each.getKey());
                interFaceContractUpdateOrderItemBO.setType(Integer.valueOf(reqBO.getMaterialSource()));
                interFaceContractUpdateOrderItemBO.setOperateType(0);
                interFaceContractUpdateOrderItemBO.setOrderNum((BigDecimal)each.getValue());
                operOrderItem.add(interFaceContractUpdateOrderItemBO);
            }
            HashMap awardNumIdAndIncy = new HashMap();
            ArrayList<InterFaceContractGetCanOrderNumAtomBO> orderItem = new ArrayList<InterFaceContractGetCanOrderNumAtomBO>();
            for (Map.Entry entry : awardNumIdAndCount.entrySet()) {
                InterFaceContractGetCanOrderNumAtomBO interFaceContractGetCanOrderNumAtomBO = new InterFaceContractGetCanOrderNumAtomBO();
                interFaceContractGetCanOrderNumAtomBO.setType(Integer.valueOf(reqBO.getMaterialSource()));
                interFaceContractGetCanOrderNumAtomBO.setGoodTypeId((String)entry.getKey());
                orderItem.add(interFaceContractGetCanOrderNumAtomBO);
                InterFaceContractUpdateOrderItemBO interFaceContractUpdateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                interFaceContractUpdateOrderItemBO.setGoodTypeId((String)entry.getKey());
                interFaceContractUpdateOrderItemBO.setType(Integer.valueOf(reqBO.getMaterialSource()));
                if (oldAwardNumIdAndCount.containsKey(entry.getKey())) {
                    awardNumIdAndIncy.put(entry.getKey(), ((BigDecimal)entry.getValue()).subtract((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())));
                    if (((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())).compareTo((BigDecimal)entry.getValue()) < 0) {
                        interFaceContractUpdateOrderItemBO.setOperateType(1);
                        interFaceContractUpdateOrderItemBO.setOrderNum(((BigDecimal)entry.getValue()).subtract((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())));
                    } else {
                        interFaceContractUpdateOrderItemBO.setOperateType(0);
                        interFaceContractUpdateOrderItemBO.setOrderNum(((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())).subtract((BigDecimal)entry.getValue()));
                    }
                } else {
                    awardNumIdAndIncy.put(entry.getKey(), (BigDecimal)entry.getValue());
                    interFaceContractUpdateOrderItemBO.setOperateType(1);
                    interFaceContractUpdateOrderItemBO.setOrderNum((BigDecimal)entry.getValue());
                }
                operOrderItem.add(interFaceContractUpdateOrderItemBO);
            }
            if (!CollectionUtils.isEmpty(orderItem)) {
                InterFaceContractGetCanOrderNumAtomReqBO interFaceContractGetCanOrderNumAtomReqBO = new InterFaceContractGetCanOrderNumAtomReqBO();
                interFaceContractGetCanOrderNumAtomReqBO.setOrderItem(orderItem);
                interFaceContractGetCanOrderNumAtomReqBO.setToken(reqBO.getAuthToken());
                InterFaceContractGetCanOrderNumAtomRspBO interFaceContractGetCanOrderNumAtomRspBO = this.interFaceContractGetCanOrderNumAtomService.getCanOrderNum(interFaceContractGetCanOrderNumAtomReqBO);
                if ("0000".equals(interFaceContractGetCanOrderNumAtomRspBO.getRespCode()) && !CollectionUtils.isEmpty(interFaceContractGetCanOrderNumAtomRspBO.getOrderItem())) {
                    Map<String, BigDecimal> resultAwardNumIdAndCount = interFaceContractGetCanOrderNumAtomRspBO.getOrderItem().stream().collect(Collectors.toMap(a -> a.getGoodTypeId(), b -> b.getOrderNum(), (first, second) -> first));
                    for (Map.Entry each : awardNumIdAndIncy.entrySet()) {
                        if (resultAwardNumIdAndCount.containsKey(each.getKey())) {
                            if (((BigDecimal)each.getValue()).compareTo(resultAwardNumIdAndCount.get(each.getKey())) <= 0) continue;
                            throw new ZTBusinessException("\u8be5\u660e\u7ec6:" + (String)each.getKey() + "\u5360\u7528\u6570\u91cf\u5927\u4e8e\u975e\u62db\u660e\u7ec6\u5269\u4f59\u6570\u91cf");
                        }
                        throw new ZTBusinessException("\u975e\u62db\u6570\u636e\u7f3a\u5931\uff1a\u672a\u67e5\u8be2\u5230\u8be5\u660e\u7ec6\u5728\u975e\u62db\u5269\u4f59\u6570\u91cf->" + (String)each.getKey());
                    }
                } else {
                    throw new ZTBusinessException("\u975e\u62db\u67e5\u8be2\u5269\u4f59\u6570\u91cf\u5931\u8d25\uff1a" + interFaceContractGetCanOrderNumAtomRspBO.getRespDesc());
                }
            }
            if (!CollectionUtils.isEmpty(operOrderItem)) {
                InterFaceContractUpdateOrderItemAtomReqBO interFaceContractUpdateOrderItemAtomReqBO = new InterFaceContractUpdateOrderItemAtomReqBO();
                interFaceContractUpdateOrderItemAtomReqBO.setToken(reqBO.getAuthToken());
                interFaceContractUpdateOrderItemAtomReqBO.setOrderItem(operOrderItem);
                InterFaceContractUpdateOrderItemAtomRspBO interFaceContractUpdateOrderItemAtomRspBO = this.interFaceContractUpdateOrderItemAtomService.updateOrderItem(interFaceContractUpdateOrderItemAtomReqBO);
                if (!"0000".equals(interFaceContractUpdateOrderItemAtomRspBO.getRespCode())) {
                    throw new ZTBusinessException("\u975e\u62db\u589e\u51cf\u6570\u91cf\u5931\u8d25\uff1a" + interFaceContractUpdateOrderItemAtomRspBO.getRespDesc());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u975e\u62db\u589e\u51cf\u6570\u91cf\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

