/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.atom.ContractStartApprovalProcessAtomService;
import com.tydic.contract.atom.InterFaceContractGetCanOrderNumAtomService;
import com.tydic.contract.atom.InterFaceContractUpdateOrderItemAtomService;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractUpdateOrderItemAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractUpdateOrderItemAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractUpdateOrderItemBO;
import com.tydic.contract.busi.ContractApplyAddNewBusiService;
import com.tydic.contract.busi.bo.ContractApplyAddNewBusiReqBO;
import com.tydic.contract.busi.bo.ContractApplyAddNewBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoChangeItemMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractInfoChangeItemPO;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.po.ContractInfoPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractApplyAddNewBusiServiceImpl
implements ContractApplyAddNewBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractApplyAddNewBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoChangeItemMapper contractInfoChangeItemMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    private ContractStartApprovalProcessAtomService contractStartApprovalProcessAtomService;
    @Autowired
    private InterFaceContractGetCanOrderNumAtomService interFaceContractGetCanOrderNumAtomService;
    @Autowired
    private InterFaceContractUpdateOrderItemAtomService interFaceContractUpdateOrderItemAtomService;
    private static final String FIELD_UPDATE_APPLY_ID = "updateApplyId";
    private static final String FIELD_UPDATE_APPLY_CODE = "updateApplyCode";
    public static final String PROCESS = "contract_modify_create";

    @Override
    public ContractApplyAddNewBusiRspBO addApplyContract(ContractApplyAddNewBusiReqBO reqBO) {
        if (reqBO.getUpdateApplyId() == null) {
            throw new ZTBusinessException("\u5408\u540c\u53d8\u66f4id\u5fc5\u4f20");
        }
        ContractApplyAddNewBusiRspBO rspBO = new ContractApplyAddNewBusiRspBO();
        if ("0".equals(reqBO.getOperType())) {
            Map<String, Object> resultMap = this.addContractApply(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u65b0\u589e\u5408\u540c\u53d8\u66f4\u6210\u529f");
            rspBO.setUpdateApplyId((Long)resultMap.get(FIELD_UPDATE_APPLY_ID));
            rspBO.setUpdateApplyCode((String)resultMap.get(FIELD_UPDATE_APPLY_CODE));
            return rspBO;
        }
        if ("1".equals(reqBO.getOperType())) {
            this.saveContractApply(reqBO);
            rspBO.setUpdateApplyId(reqBO.getUpdateApplyId());
            rspBO.setUpdateApplyCode(reqBO.getUpdateApplyCode());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4fdd\u5b58\u5408\u540c\u53d8\u66f4\u6210\u529f");
            return rspBO;
        }
        if ("2".equals(reqBO.getOperType())) {
            this.saveContractApply(reqBO);
            rspBO.setUpdateApplyId(reqBO.getUpdateApplyId());
            rspBO.setUpdateApplyCode(reqBO.getUpdateApplyCode());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u63d0\u4ea4\u5408\u540c\u53d8\u66f4\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("1007");
        rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b");
        return rspBO;
    }

    private Map<String, Object> addContractApply(ContractApplyAddNewBusiReqBO reqBO) {
        Map<String, Object> addContractApplyResultMap = this.addContractApplyInfo(reqBO);
        this.dealItemInfo(reqBO, true);
        if (!CollectionUtils.isEmpty(reqBO.getUpdateAccessoryList())) {
            this.addContractApplyAccessoryInfo(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getAccessoryList())) {
            this.addContractAccessoryInfo(reqBO);
        }
        return addContractApplyResultMap;
    }

    private void saveContractApply(ContractApplyAddNewBusiReqBO reqBO) {
        this.saveContractApplyInfo(reqBO);
        this.dealItemInfo(reqBO, false);
        this.updateContractAccessoryInfo(reqBO);
        this.updateContractApplyAccessoryInfo(reqBO);
    }

    private Map<String, Object> addContractApplyInfo(ContractApplyAddNewBusiReqBO reqBO) {
        ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractInfoPO != null) {
            int addContractApplyResult;
            ContractInfoChangePO insertContractChangePo = new ContractInfoChangePO();
            BeanUtils.copyProperties((Object)contractInfoPO, (Object)insertContractChangePo);
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)insertContractChangePo);
            insertContractChangePo.setUpdateApplyOperUserId(reqBO.getUserId());
            insertContractChangePo.setUpdateApplyOperUserName(reqBO.getUsername());
            insertContractChangePo.setUpdateApplyTime(new Date());
            insertContractChangePo.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_DRAFT);
            if (null != reqBO.getContractAmount()) {
                insertContractChangePo.setContractAmount(reqBO.getContractAmount() * 10000L);
            }
            if (1 == (addContractApplyResult = this.contractInfoChangeMapper.insertSelective(insertContractChangePo))) {
                ContractInfoPO updateContractInfoPo = new ContractInfoPO();
                BeanUtils.copyProperties((Object)contractInfoPO, (Object)updateContractInfoPo);
                updateContractInfoPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
                int updateResult = this.contractInfoMapper.updateByPrimaryKeySelective(updateContractInfoPo);
                if (1 == updateResult) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put(FIELD_UPDATE_APPLY_ID, insertContractChangePo.getUpdateApplyId());
                    resultMap.put(FIELD_UPDATE_APPLY_CODE, insertContractChangePo.getUpdateApplyCode());
                    return resultMap;
                }
                throw new ZTBusinessException("\u539f\u5408\u540c\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
            throw new ZTBusinessException("\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u65b0\u589e\u5931\u8d25");
        }
        throw new ZTBusinessException("\u9700\u53d8\u66f4\u7684\u5408\u540c\u4fe1\u606f\u4e0d\u5b58\u5728");
    }

    private void saveContractApplyInfo(ContractApplyAddNewBusiReqBO reqBO) {
        ContractInfoChangePO oldContractInfoChangePO = this.contractInfoChangeMapper.selectByPrimaryKey(reqBO.getUpdateApplyId());
        if (oldContractInfoChangePO != null) {
            int updateResult;
            ContractInfoChangePO updateContractInfoChangePO = new ContractInfoChangePO();
            BeanUtils.copyProperties((Object)oldContractInfoChangePO, (Object)updateContractInfoChangePO);
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateContractInfoChangePO);
            if ("2".equals(reqBO.getOperType())) {
                updateContractInfoChangePO.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_IN_CONFIRM);
            }
            if (null != reqBO.getContractAmount()) {
                updateContractInfoChangePO.setContractAmount(reqBO.getContractAmount() * 10000L);
            }
            if ((updateResult = this.contractInfoChangeMapper.updateByPrimaryKeySelective(updateContractInfoChangePO)) != 1) {
                throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u53d8\u66f4\u6570\u636e\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u539f\u5408\u540c\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    private void dealItemInfo(ContractApplyAddNewBusiReqBO reqBO, boolean addApplyFlag) {
        ContractInfoItemTmpPO deleteContractInfoItemTmpPo = new ContractInfoItemTmpPO();
        deleteContractInfoItemTmpPo.setDelFlag("1");
        deleteContractInfoItemTmpPo.setUpdateApplyId(reqBO.getUpdateApplyId());
        this.contractInfoItemTmpMapper.deleteBy(deleteContractInfoItemTmpPo);
        ContractInfoItemTmpPO contractInfoItemTmpPo = new ContractInfoItemTmpPO();
        contractInfoItemTmpPo.setUpdateApplyId(reqBO.getUpdateApplyId());
        List<ContractInfoItemTmpPO> contractInfoItemTmpPOList = this.contractInfoItemTmpMapper.getList(contractInfoItemTmpPo);
        contractInfoItemTmpPOList.forEach(contractInfoItemTmpPO -> {
            if (contractInfoItemTmpPO.getRate() == null) {
                throw new ZTBusinessException("\u660e\u7ec6\u7684\u7a0e\u7387\u3010rate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        try {
            this.operFzItemNum(contractInfoItemTmpPOList, reqBO, addApplyFlag);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        ContractInfoChangeItemPO deleteContractInfoChangeItemPO = new ContractInfoChangeItemPO();
        deleteContractInfoChangeItemPO.setUpdateApplyId(reqBO.getUpdateApplyId());
        this.contractInfoChangeItemMapper.deleteByCondition(deleteContractInfoChangeItemPO);
        for (ContractInfoItemTmpPO contractInfoItemTmpPO2 : contractInfoItemTmpPOList) {
            ContractInfoChangeItemPO contractInfoChangeItemPO = new ContractInfoChangeItemPO();
            BeanUtils.copyProperties((Object)contractInfoItemTmpPO2, (Object)contractInfoChangeItemPO);
            this.contractInfoChangeItemMapper.insertSelective(contractInfoChangeItemPO);
        }
    }

    private void addContractApplyItemInfo(Long updateApplyId, ContractApplyAddNewBusiReqBO reqBO) {
        ArrayList list = new ArrayList();
        reqBO.getItemList().forEach(x -> {
            ContractInfoChangeItemPO contractInfoChangeItemPO = (ContractInfoChangeItemPO)JSON.parseObject((String)JSON.toJSONString((Object)x), ContractInfoChangeItemPO.class);
            list.add(contractInfoChangeItemPO);
        });
        for (ContractInfoChangeItemPO contractInfoChangeItemPO : list) {
            contractInfoChangeItemPO.setItemChangeId(Sequence.getInstance().nextId());
            contractInfoChangeItemPO.setUpdateApplyId(updateApplyId);
            contractInfoChangeItemPO.setRelateCode(reqBO.getContractCode());
            int result = this.contractInfoChangeItemMapper.insertSelective(contractInfoChangeItemPO);
            if (result >= 1) continue;
            throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u6570\u636e\u53d8\u66f4\u7533\u8bf7\u65b0\u589e\u5931\u8d25");
        }
    }

    private void updateContractApplyItemInfo(ContractApplyAddNewBusiReqBO reqBO) {
        ContractInfoChangeItemPO deleteContractInfoChangeItemPO = new ContractInfoChangeItemPO();
        deleteContractInfoChangeItemPO.setItemChangeId(reqBO.getContractId());
        deleteContractInfoChangeItemPO.setUpdateApplyId(reqBO.getUpdateApplyId());
        this.contractInfoChangeItemMapper.deleteByCondition(deleteContractInfoChangeItemPO);
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractApplyItemInfo(reqBO.getUpdateApplyId(), reqBO);
        }
    }

    private void addContractAccessoryInfo(ContractApplyAddNewBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getAccessoryList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo contractAccessoryPo : list) {
            contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            contractAccessoryPo.setRelateId(reqBO.getUpdateApplyId());
            contractAccessoryPo.setRelateCode(reqBO.getUpdateApplyCode());
            contractAccessoryPo.setCreateUserId(reqBO.getModifyCreateUserId());
            contractAccessoryPo.setCreateUserName(reqBO.getModifyCreateUserName());
            contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT);
        }
        int result = this.contractAccessoryMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void addContractApplyAccessoryInfo(ContractApplyAddNewBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getUpdateAccessoryList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo contractAccessoryPo : list) {
            contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            contractAccessoryPo.setRelateId(reqBO.getUpdateApplyId());
            contractAccessoryPo.setRelateCode(reqBO.getUpdateApplyCode());
            contractAccessoryPo.setCreateUserId(reqBO.getModifyCreateUserId());
            contractAccessoryPo.setCreateUserName(reqBO.getModifyCreateUserName());
            contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_MODIFY_APPLY);
        }
        int result = this.contractAccessoryMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void updateContractAccessoryInfo(ContractApplyAddNewBusiReqBO reqBO) {
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateId(reqBO.getUpdateApplyId());
        deleteContractAccessoryPo.setRelateCode(reqBO.getUpdateApplyCode());
        deleteContractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT);
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getAccessoryList())) {
            this.addContractAccessoryInfo(reqBO);
        }
    }

    private void updateContractApplyAccessoryInfo(ContractApplyAddNewBusiReqBO reqBO) {
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateId(reqBO.getUpdateApplyId());
        deleteContractAccessoryPo.setRelateCode(reqBO.getUpdateApplyCode());
        deleteContractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_MODIFY_APPLY);
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getUpdateAccessoryList())) {
            this.addContractApplyAccessoryInfo(reqBO);
        }
    }

    private void operFzItemNum(List<ContractInfoItemTmpPO> contractInfoItemTmpPOList, ContractApplyAddNewBusiReqBO reqBO, boolean addApplyFlag) {
        try {
            Object interFaceContractUpdateOrderItemBO;
            List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.getItemsByRelId(reqBO.getContractId());
            Map<Object, Object> oldAwardNumIdAndCount = new HashMap();
            if (!CollectionUtils.isEmpty(contractInfoItemPOS)) {
                oldAwardNumIdAndCount = contractInfoItemPOS.stream().filter(a -> !StringUtils.isEmpty((Object)a.getAwardNumId())).collect(Collectors.toMap(a -> a.getAwardNumId(), b -> b.getAmount(), (first, second) -> first));
            }
            ContractInfoChangeItemPO contractInfoChangeItemPO = new ContractInfoChangeItemPO();
            contractInfoChangeItemPO.setUpdateApplyId(reqBO.getUpdateApplyId());
            List<ContractInfoChangeItemPO> contractInfoChangeItemPOS = this.contractInfoChangeItemMapper.selectByUpdateApplyId(contractInfoChangeItemPO);
            Map<Object, Object> changeAwardNumIdAndCount = new HashMap();
            if (!CollectionUtils.isEmpty(contractInfoChangeItemPOS)) {
                changeAwardNumIdAndCount = contractInfoChangeItemPOS.stream().filter(a -> !StringUtils.isEmpty((Object)a.getAwardNumId())).collect(Collectors.toMap(a -> a.getAwardNumId(), b -> b.getAmount(), (first, second) -> first));
            }
            Map<String, BigDecimal> awardNumIdAndCount = contractInfoItemTmpPOList.stream().filter(a -> !StringUtils.isEmpty((Object)a.getAwardNumId())).collect(Collectors.toMap(a -> a.getAwardNumId(), b -> b.getAmount(), (first, second) -> first));
            ArrayList<InterFaceContractUpdateOrderItemBO> operOrderItem = new ArrayList<InterFaceContractUpdateOrderItemBO>();
            if (addApplyFlag) {
                for (Map.Entry<Object, Object> each : oldAwardNumIdAndCount.entrySet()) {
                    if (awardNumIdAndCount.containsKey(each.getKey())) continue;
                    interFaceContractUpdateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                    ((InterFaceContractUpdateOrderItemBO)interFaceContractUpdateOrderItemBO).setGoodTypeId((String)each.getKey());
                    ((InterFaceContractUpdateOrderItemBO)interFaceContractUpdateOrderItemBO).setType(Integer.valueOf(reqBO.getMaterialSource()));
                    ((InterFaceContractUpdateOrderItemBO)interFaceContractUpdateOrderItemBO).setOperateType(0);
                    ((InterFaceContractUpdateOrderItemBO)interFaceContractUpdateOrderItemBO).setOrderNum((BigDecimal)each.getValue());
                    operOrderItem.add((InterFaceContractUpdateOrderItemBO)interFaceContractUpdateOrderItemBO);
                }
            } else {
                for (Map.Entry<Object, Object> each : changeAwardNumIdAndCount.entrySet()) {
                    if (awardNumIdAndCount.containsKey(each.getKey())) continue;
                    interFaceContractUpdateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                    ((InterFaceContractUpdateOrderItemBO)interFaceContractUpdateOrderItemBO).setGoodTypeId((String)each.getKey());
                    ((InterFaceContractUpdateOrderItemBO)interFaceContractUpdateOrderItemBO).setType(Integer.valueOf(reqBO.getMaterialSource()));
                    ((InterFaceContractUpdateOrderItemBO)interFaceContractUpdateOrderItemBO).setOperateType(0);
                    ((InterFaceContractUpdateOrderItemBO)interFaceContractUpdateOrderItemBO).setOrderNum((BigDecimal)each.getValue());
                    operOrderItem.add((InterFaceContractUpdateOrderItemBO)interFaceContractUpdateOrderItemBO);
                }
            }
            HashMap awardNumIdAndIncy = new HashMap();
            ArrayList<InterFaceContractGetCanOrderNumAtomBO> orderItem = new ArrayList<InterFaceContractGetCanOrderNumAtomBO>();
            for (Map.Entry entry : awardNumIdAndCount.entrySet()) {
                InterFaceContractGetCanOrderNumAtomBO interFaceContractGetCanOrderNumAtomBO = new InterFaceContractGetCanOrderNumAtomBO();
                interFaceContractGetCanOrderNumAtomBO.setType(Integer.valueOf(reqBO.getMaterialSource()));
                interFaceContractGetCanOrderNumAtomBO.setGoodTypeId((String)entry.getKey());
                orderItem.add(interFaceContractGetCanOrderNumAtomBO);
                InterFaceContractUpdateOrderItemBO interFaceContractUpdateOrderItemBO2 = new InterFaceContractUpdateOrderItemBO();
                interFaceContractUpdateOrderItemBO2.setGoodTypeId((String)entry.getKey());
                interFaceContractUpdateOrderItemBO2.setType(Integer.valueOf(reqBO.getMaterialSource()));
                if (!changeAwardNumIdAndCount.containsKey(entry.getKey()) && !oldAwardNumIdAndCount.containsKey(entry.getKey())) {
                    awardNumIdAndIncy.put(entry.getKey(), entry.getValue());
                    interFaceContractUpdateOrderItemBO2.setOperateType(1);
                    interFaceContractUpdateOrderItemBO2.setOrderNum((BigDecimal)entry.getValue());
                } else if (addApplyFlag) {
                    awardNumIdAndIncy.put(entry.getKey(), ((BigDecimal)entry.getValue()).subtract((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())));
                    if (((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())).compareTo((BigDecimal)entry.getValue()) < 0) {
                        interFaceContractUpdateOrderItemBO2.setOperateType(1);
                        interFaceContractUpdateOrderItemBO2.setOrderNum(((BigDecimal)entry.getValue()).subtract((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())));
                    } else {
                        interFaceContractUpdateOrderItemBO2.setOperateType(0);
                        interFaceContractUpdateOrderItemBO2.setOrderNum(((BigDecimal)oldAwardNumIdAndCount.get(entry.getKey())).subtract((BigDecimal)entry.getValue()));
                    }
                } else if (changeAwardNumIdAndCount.containsKey(entry.getKey())) {
                    awardNumIdAndIncy.put(entry.getKey(), ((BigDecimal)entry.getValue()).subtract((BigDecimal)changeAwardNumIdAndCount.get(entry.getKey())));
                    if (((BigDecimal)changeAwardNumIdAndCount.get(entry.getKey())).compareTo((BigDecimal)entry.getValue()) < 0) {
                        interFaceContractUpdateOrderItemBO2.setOperateType(1);
                        interFaceContractUpdateOrderItemBO2.setOrderNum(((BigDecimal)entry.getValue()).subtract((BigDecimal)changeAwardNumIdAndCount.get(entry.getKey())));
                    } else {
                        interFaceContractUpdateOrderItemBO2.setOperateType(0);
                        interFaceContractUpdateOrderItemBO2.setOrderNum(((BigDecimal)changeAwardNumIdAndCount.get(entry.getKey())).subtract((BigDecimal)entry.getValue()));
                    }
                } else {
                    awardNumIdAndIncy.put(entry.getKey(), entry.getValue());
                    interFaceContractUpdateOrderItemBO2.setOperateType(1);
                    interFaceContractUpdateOrderItemBO2.setOrderNum((BigDecimal)entry.getValue());
                }
                operOrderItem.add(interFaceContractUpdateOrderItemBO2);
            }
            if (!CollectionUtils.isEmpty(orderItem)) {
                InterFaceContractGetCanOrderNumAtomReqBO interFaceContractGetCanOrderNumAtomReqBO = new InterFaceContractGetCanOrderNumAtomReqBO();
                interFaceContractGetCanOrderNumAtomReqBO.setOrderItem(orderItem);
                interFaceContractGetCanOrderNumAtomReqBO.setToken(reqBO.getAuthToken());
                InterFaceContractGetCanOrderNumAtomRspBO interFaceContractGetCanOrderNumAtomRspBO = this.interFaceContractGetCanOrderNumAtomService.getCanOrderNum(interFaceContractGetCanOrderNumAtomReqBO);
                if ("0000".equals(interFaceContractGetCanOrderNumAtomRspBO.getRespCode()) && !CollectionUtils.isEmpty(interFaceContractGetCanOrderNumAtomRspBO.getOrderItem())) {
                    Map<String, BigDecimal> resultAwardNumIdAndCount = interFaceContractGetCanOrderNumAtomRspBO.getOrderItem().stream().collect(Collectors.toMap(a -> a.getGoodTypeId(), b -> b.getOrderNum(), (first, second) -> first));
                    for (Map.Entry each : awardNumIdAndIncy.entrySet()) {
                        if (resultAwardNumIdAndCount.containsKey(each.getKey())) {
                            if (((BigDecimal)each.getValue()).compareTo(resultAwardNumIdAndCount.get(each.getKey())) <= 0) continue;
                            throw new ZTBusinessException("\u8be5\u660e\u7ec6:" + (String)each.getKey() + "\u5360\u7528\u6570\u91cf\u5927\u4e8e\u975e\u62db\u660e\u7ec6\u5269\u4f59\u6570\u91cf");
                        }
                        throw new ZTBusinessException("\u975e\u62db\u6570\u636e\u7f3a\u5931\uff1a\u672a\u67e5\u8be2\u5230\u8be5\u660e\u7ec6\u5728\u975e\u62db\u5269\u4f59\u6570\u91cf->" + (String)each.getKey());
                    }
                } else {
                    throw new ZTBusinessException("\u975e\u62db\u67e5\u8be2\u5269\u4f59\u6570\u91cf\u5931\u8d25\uff1a" + interFaceContractGetCanOrderNumAtomRspBO.getRespDesc());
                }
            }
            if (!CollectionUtils.isEmpty(operOrderItem)) {
                InterFaceContractUpdateOrderItemAtomReqBO interFaceContractUpdateOrderItemAtomReqBO = new InterFaceContractUpdateOrderItemAtomReqBO();
                interFaceContractUpdateOrderItemAtomReqBO.setToken(reqBO.getAuthToken());
                interFaceContractUpdateOrderItemAtomReqBO.setOrderItem(operOrderItem);
                InterFaceContractUpdateOrderItemAtomRspBO interFaceContractUpdateOrderItemAtomRspBO = this.interFaceContractUpdateOrderItemAtomService.updateOrderItem(interFaceContractUpdateOrderItemAtomReqBO);
                if (!"0000".equals(interFaceContractUpdateOrderItemAtomRspBO.getRespCode())) {
                    throw new ZTBusinessException("\u975e\u62db\u589e\u51cf\u6570\u91cf\u5931\u8d25\uff1a" + interFaceContractUpdateOrderItemAtomRspBO.getRespDesc());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u975e\u62db\u589e\u51cf\u6570\u91cf\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

