/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.bo.ContractChangeInitiateActionsAbilityReqBO;
import com.tydic.contract.ability.bo.ContractChangeInitiateActionsAbilityRspBO;
import com.tydic.contract.atom.ContractDealApprovalAtomService;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.ContractStartApprovalProcessAtomService;
import com.tydic.contract.atom.bo.ContractDealApprovalAtomReqBO;
import com.tydic.contract.atom.bo.ContractDealApprovalAtomRspBO;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.atom.bo.ContractStartApprovalProcessAtomReqBO;
import com.tydic.contract.atom.bo.ContractStartApprovalProcessAtomRspBO;
import com.tydic.contract.busi.ContractChangeInitiateActionsBusiService;
import com.tydic.contract.busi.bo.ContractFreezeStatusSyncAgrBo;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractAgrMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoChangeItemMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.NegotiationLogMapper;
import com.tydic.contract.po.CContractAgrPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractInfoChangeItemPO;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.NegotiationLogPO;
import com.tydic.contract.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractChangeInitiateActionsBusiServiceImpl
implements ContractChangeInitiateActionsBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractChangeInitiateActionsBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoChangeItemMapper contractInfoChangeItemMapper;
    @Autowired
    private ContractStartApprovalProcessAtomService contractStartApprovalProcessAtomService;
    @Autowired
    private NegotiationLogMapper negotiationLogMapper;
    public static final String cgContractChangeApplyAuditProcessKey = "cg_contract_change_apply_audit_process_key";
    public static final String yyContractChangeApplyAuditProcessKey = "yy_contract_change_apply_audit_process_key";
    @Autowired
    private ContractDealApprovalAtomService contractDealApprovalAtomService;
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Resource(name="syncContractFreezeStatusProvider")
    private ProxyMessageProducer syncContractFreezeStatusProvider;
    @Autowired
    private CContractAgrMapper cContractAgrMapper;
    @Value(value="${CONTRACT_FREEZE_SYNC_TOPIC}")
    private String topic;
    @Value(value="${CONTRACT_FREEZE_SYNC_TAG}")
    private String tag;

    @Override
    public ContractChangeInitiateActionsAbilityRspBO dealContractChangeEff(ContractChangeInitiateActionsAbilityReqBO reqBO) {
        ContractChangeInitiateActionsAbilityRspBO rspBO = new ContractChangeInitiateActionsAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String msg = this.checkReq(reqBO, 1);
        if (!StringUtils.isEmpty((Object)msg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(msg);
            return rspBO;
        }
        for (Long updateApplyId : reqBO.getUpdateApplyIds()) {
            ContractInfoChangePO contractInfoChangePO = new ContractInfoChangePO();
            contractInfoChangePO.setUpdateApplyId(updateApplyId);
            contractInfoChangePO.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_EFFECT);
            contractInfoChangePO.setUpdateUserId(reqBO.getUserId());
            contractInfoChangePO.setUpdateUserName(reqBO.getName());
            contractInfoChangePO.setUpdateTime(new Date());
            this.contractInfoChangeMapper.updateByPrimaryKeySelective(contractInfoChangePO);
        }
        return rspBO;
    }

    @Override
    public ContractChangeInitiateActionsAbilityRspBO deleteContractChange(ContractChangeInitiateActionsAbilityReqBO reqBO) {
        ContractChangeInitiateActionsAbilityRspBO rspBO = new ContractChangeInitiateActionsAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String msg = this.checkReq(reqBO, 2);
        if (!StringUtils.isEmpty((Object)msg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(msg);
            return rspBO;
        }
        this.contractInfoChangeMapper.deleteByIds(reqBO.getUpdateApplyIds());
        this.contractInfoChangeItemMapper.deleteByUpdateApplyIds(reqBO.getUpdateApplyIds());
        return rspBO;
    }

    @Override
    public ContractChangeInitiateActionsAbilityRspBO dealContractChangeConfirm(ContractChangeInitiateActionsAbilityReqBO reqBO) {
        ContractChangeInitiateActionsAbilityRspBO rspBO = new ContractChangeInitiateActionsAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String msg = this.checkReq(reqBO, 3);
        if (!StringUtils.isEmpty((Object)msg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(msg);
            return rspBO;
        }
        List<ContractInfoChangePO> contractInfoChangePOS = this.contractInfoChangeMapper.qryListByIds(reqBO.getUpdateApplyIds());
        if (CollectionUtils.isEmpty(contractInfoChangePOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be5\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u6570\u636e\u4e0d\u5b58\u5728");
            return rspBO;
        }
        List<Long> contractIds = contractInfoChangePOS.stream().map(a -> a.getContractId()).distinct().collect(Collectors.toList());
        Map<Long, Long> upAndContractId = contractInfoChangePOS.stream().collect(Collectors.toMap(a -> a.getUpdateApplyId(), b -> b.getContractId(), (first, second) -> first));
        Map<Long, Long> contractAndAmount = contractInfoChangePOS.stream().collect(Collectors.toMap(a -> a.getContractId(), b -> b.getContractAmount(), (first, second) -> first));
        List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getListByContractIds(contractIds);
        if (CollectionUtils.isEmpty(contractInfoPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be5\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u6240\u5bf9\u5e94\u7684\u5408\u540c\u6570\u636e\u4e0d\u5b58\u5728");
            return rspBO;
        }
        Map<Object, Object> contractIdAndOrgType = new HashMap();
        Map<Object, Object> contractIdAndOrgId = new HashMap();
        Map<Object, Object> contractIdAndPo = new HashMap();
        if (!CollectionUtils.isEmpty(contractInfoPOS)) {
            contractIdAndOrgType = contractInfoPOS.stream().filter(a -> !StringUtils.isEmpty((Object)a.getContractOrgType())).collect(Collectors.toMap(a -> a.getContractId(), b -> b.getContractOrgType(), (first, second) -> first));
            contractIdAndOrgId = contractInfoPOS.stream().filter(a -> a.getCreateDeptId() != null).collect(Collectors.toMap(a -> a.getContractId(), b -> b.getCreateDeptId(), (first, second) -> first));
            contractIdAndPo = contractInfoPOS.stream().collect(Collectors.toMap(a -> a.getContractId(), b -> b, (first, second) -> first));
        }
        for (Long updateApplyId : reqBO.getUpdateApplyIds()) {
            Long contractId = upAndContractId.get(updateApplyId);
            if (contractId == null) continue;
            ContractInfoChangePO updatePo = new ContractInfoChangePO();
            updatePo.setUpdateApplyId(updateApplyId);
            if ("0".equals(reqBO.getDealResult().toString())) {
                updatePo.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_IN_NEGOTIATION);
                NegotiationLogPO negotiationLogPO = new NegotiationLogPO();
                negotiationLogPO.setRelId(updateApplyId);
                negotiationLogPO.setId(Sequence.getInstance().nextId());
                negotiationLogPO.setCreateTime(new Date());
                negotiationLogPO.setCreateUserName(reqBO.getName());
                negotiationLogPO.setDealResult(reqBO.getDealResult());
                negotiationLogPO.setRemark(reqBO.getRemark());
                negotiationLogPO.setType(0);
                this.negotiationLogMapper.insert(negotiationLogPO);
            } else {
                updatePo.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE);
                ContractStartApprovalProcessAtomReqBO atomReqBO = new ContractStartApprovalProcessAtomReqBO();
                if (!StringUtils.isEmpty((Object)contractIdAndOrgType.get(contractId))) {
                    if ("0".equals(contractIdAndOrgType.get(contractId))) {
                        atomReqBO.setMenuId("M001006");
                    } else {
                        atomReqBO.setMenuId("M001004");
                    }
                } else {
                    throw new ZTBusinessException("\u8be5\u5408\u540c\u6ca1\u6709\u5408\u540c\u673a\u6784\u7c7b\u578b\u6570\u636e");
                }
                atomReqBO.setContractId(updateApplyId);
                atomReqBO.setObjType(1);
                atomReqBO.setUserId(reqBO.getUserId());
                atomReqBO.setUsername(reqBO.getName());
                atomReqBO.setOrgId((Long)contractIdAndOrgId.get(contractId));
                HashMap<String, Object> variables = new HashMap<String, Object>();
                if (6 == ((ContractInfoPO)contractIdAndPo.get(contractId)).getContractType()) {
                    variables.put("contractMoney", MoneyUtils.haoToYuan(contractAndAmount.get(contractId)));
                } else if (((ContractInfoPO)contractIdAndPo.get(contractId)).getIsNewSupplier() != null && ((ContractInfoPO)contractIdAndPo.get(contractId)).getIsNewSupplier() == 1 || ((ContractInfoPO)contractIdAndPo.get(contractId)).getIsNewBrand() != null && ((ContractInfoPO)contractIdAndPo.get(contractId)).getIsNewBrand() == 1) {
                    variables.put("auditType", "1");
                } else {
                    variables.put("auditType", "2");
                }
                atomReqBO.setVariables(variables);
                ContractStartApprovalProcessAtomRspBO atomRspBO = this.contractStartApprovalProcessAtomService.startApprovalProcess(atomReqBO);
                log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2code\uff1a" + atomRspBO.getRespCode());
                if (!atomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException(atomRspBO.getRespDesc());
                }
                if (StringUtils.isEmpty((Object)atomRspBO.getStepId())) {
                    log.info("\u5ba1\u6279API\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)((Object)atomRspBO)));
                    throw new ZTBusinessException("\u5ba1\u6279\u6d41\u7a0b\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u56fe");
                }
                updatePo.setStepId(atomRspBO.getStepId());
            }
            updatePo.setUpdateUserId(reqBO.getUserId());
            updatePo.setUpdateUserName(reqBO.getName());
            updatePo.setUpdateTime(new Date());
            this.contractInfoChangeMapper.updateByPrimaryKeySelective(updatePo);
        }
        return rspBO;
    }

    @Override
    public ContractChangeInitiateActionsAbilityRspBO dealContractChangeAudit(ContractChangeInitiateActionsAbilityReqBO reqBO) {
        ContractChangeInitiateActionsAbilityRspBO rspBO = new ContractChangeInitiateActionsAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String msg = this.checkReq(reqBO, 4);
        if (!StringUtils.isEmpty((Object)msg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(msg);
            return rspBO;
        }
        for (Long updateApplyId : reqBO.getUpdateApplyIds()) {
            ContractDealApprovalAtomRspBO atomRspBO;
            ContractInfoChangePO contractInfoChangePO = this.contractInfoChangeMapper.selectByPrimaryKey(updateApplyId);
            if (contractInfoChangePO == null) continue;
            ContractInfoPO oldContractPo = this.contractInfoMapper.selectByPrimaryKey(contractInfoChangePO.getContractId());
            ContractInfoChangePO updatecontractInfoChangePo = new ContractInfoChangePO();
            BeanUtils.copyProperties((Object)contractInfoChangePO, (Object)updatecontractInfoChangePo);
            updatecontractInfoChangePo.setContractApprovalUserId(reqBO.getUserId());
            updatecontractInfoChangePo.setContractApprovalUserName(reqBO.getName());
            updatecontractInfoChangePo.setContractApprovalRemark(reqBO.getRemark());
            updatecontractInfoChangePo.setContractApprovalResult("1".equals(reqBO.getDealResult().toString()) ? 1 : 2);
            updatecontractInfoChangePo.setContractApprovalTime(new Date());
            ContractDealApprovalAtomReqBO atomReqBO = new ContractDealApprovalAtomReqBO();
            atomReqBO.setAuditAdvice(reqBO.getRemark());
            atomReqBO.setUsername(reqBO.getName());
            atomReqBO.setStepId(contractInfoChangePO.getStepId());
            atomReqBO.setContractId(updateApplyId);
            atomReqBO.setObjType(1);
            atomReqBO.setDept(reqBO.getOrgName());
            if (reqBO.getUserId() != null) {
                atomReqBO.setOperId(reqBO.getUserId().toString());
            }
            HashMap<String, Object> variables = new HashMap<String, Object>();
            if (6 == oldContractPo.getContractType()) {
                variables.put("contractMoney", MoneyUtils.haoToYuan(contractInfoChangePO.getContractAmount()));
            } else if (oldContractPo.getIsNewSupplier() != null && oldContractPo.getIsNewSupplier() == 1 || oldContractPo.getIsNewBrand() != null && oldContractPo.getIsNewBrand() == 1) {
                variables.put("auditType", "1");
            } else {
                variables.put("auditType", "2");
            }
            if (reqBO.getUserId() != null) {
                atomReqBO.setOperId(reqBO.getUserId().toString());
            }
            atomReqBO.setVariables(variables);
            if ("1".equals(reqBO.getDealResult().toString())) {
                atomReqBO.setAuditResult(ContractConstant.AuditResult.AUDIT_RESULT_YES);
                atomRspBO = this.contractDealApprovalAtomService.dealApproval(atomReqBO);
                log.info("\u5ba1\u6279\u6d41\u7a0b\u6d41\u8f6ccode\uff1a" + atomRspBO.getRespCode());
                if (!atomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException(atomRspBO.getRespDesc());
                }
                updatecontractInfoChangePo.setStepId(atomRspBO.getStepId());
                if (atomRspBO.getFinish().booleanValue()) {
                    updatecontractInfoChangePo.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_EFFECT);
                }
            } else {
                atomReqBO.setAuditResult(ContractConstant.AuditResult.AUDIT_RESULT_NO);
                atomRspBO = this.contractDealApprovalAtomService.dealApproval(atomReqBO);
                log.info("\u5ba1\u6279\u6d41\u7a0b\u6d41\u8f6ccode\uff1a" + atomRspBO.getRespCode());
                if (!atomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException(atomRspBO.getRespDesc());
                }
                updatecontractInfoChangePo.setStepId(atomRspBO.getStepId());
                updatecontractInfoChangePo.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_REJECT);
            }
            updatecontractInfoChangePo.setUpdateUserId(reqBO.getUserId());
            updatecontractInfoChangePo.setUpdateUserName(reqBO.getName());
            updatecontractInfoChangePo.setUpdateTime(new Date());
            int updateResult = this.contractInfoChangeMapper.updateByPrimaryKeySelective(updatecontractInfoChangePo);
            if (updateResult == 1) {
                if ("1".equals(reqBO.getDealResult().toString())) {
                    ContractInfoPO updateContractPo = new ContractInfoPO();
                    BeanUtils.copyProperties((Object)oldContractPo, (Object)updateContractPo);
                    updateContractPo.setContractVersion(oldContractPo.getContractVersion());
                    updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_HIS);
                    int updateContractResult = this.contractInfoMapper.updateByPrimaryKeySelective(updateContractPo);
                    if (updateContractResult == 1) {
                        ContractInfoPO newContractPo = new ContractInfoPO();
                        BeanUtils.copyProperties((Object)oldContractPo, (Object)newContractPo);
                        BeanUtils.copyProperties((Object)contractInfoChangePO, (Object)newContractPo);
                        Long contractId = Sequence.getInstance().nextId();
                        newContractPo.setContractId(contractId);
                        newContractPo.setContractVersion(oldContractPo.getContractVersion() + 1);
                        newContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
                        this.recordContractNodeOperLog(contractId, reqBO.getUserId(), reqBO.getName(), "CREATE_CONTRACT", "\u65b0\u5efa\u5408\u540c");
                        this.recordContractNodeOperLog(contractId, reqBO.getUserId(), reqBO.getName(), "CONTRACT_CONFIRM", "\u5408\u540c\u786e\u8ba4");
                        this.recordContractNodeOperLog(contractId, reqBO.getUserId(), reqBO.getName(), "CONTRACT_APPROVAL", "\u5408\u540c\u5ba1\u6279");
                        this.recordContractNodeOperLog(contractId, reqBO.getUserId(), reqBO.getName(), "CONTRACT_EFFECT", "\u5408\u540c\u751f\u6548");
                        this.contractInfoMapper.insertSelective(newContractPo);
                        CContractAgrPO cContractAgrPO = new CContractAgrPO();
                        cContractAgrPO.setRelateId(contractInfoChangePO.getContractId());
                        List<CContractAgrPO> cContractAgrPOS = this.cContractAgrMapper.getList(cContractAgrPO);
                        if (!CollectionUtils.isEmpty(cContractAgrPOS)) {
                            ArrayList<CContractAgrPO> newCContractAgrPOS = new ArrayList<CContractAgrPO>();
                            cContractAgrPOS.forEach(each -> {
                                CContractAgrPO newCContractAgrPO = new CContractAgrPO();
                                BeanUtils.copyProperties((Object)each, (Object)newCContractAgrPO);
                                newCContractAgrPO.setRelateId(contractId);
                                newCContractAgrPO.setRelateCode(newContractPo.getContractCode());
                                newCContractAgrPO.setId(Sequence.getInstance().nextId());
                                newCContractAgrPOS.add(newCContractAgrPO);
                            });
                            if (!CollectionUtils.isEmpty(newCContractAgrPOS)) {
                                this.cContractAgrMapper.insertBatch(newCContractAgrPOS);
                            }
                        }
                        ContractInfoChangeItemPO contractInfoChangeItemPO = new ContractInfoChangeItemPO();
                        contractInfoChangeItemPO.setUpdateApplyId(contractInfoChangePO.getUpdateApplyId());
                        List<ContractInfoChangeItemPO> contractInfoItemPOS = this.contractInfoChangeItemMapper.getList(contractInfoChangeItemPO);
                        if (!CollectionUtils.isEmpty(contractInfoItemPOS)) {
                            ArrayList<ContractInfoItemPO> newContractItemPos = new ArrayList<ContractInfoItemPO>();
                            for (ContractInfoChangeItemPO contractItemPo : contractInfoItemPOS) {
                                ContractInfoItemPO newContractItemPo = new ContractInfoItemPO();
                                BeanUtils.copyProperties((Object)contractItemPo, (Object)newContractItemPo);
                                newContractItemPo.setItemId(Sequence.getInstance().nextId());
                                newContractItemPo.setRelateId(newContractPo.getContractId());
                                newContractItemPo.setRelateCode(newContractPo.getContractCode());
                                newContractItemPos.add(newContractItemPo);
                            }
                            this.contractInfoItemMapper.insertBatch(newContractItemPos);
                        }
                        ContractAccessoryPo queryContractAccessoryPo = new ContractAccessoryPo();
                        queryContractAccessoryPo.setRelateId(contractInfoChangePO.getUpdateApplyId());
                        queryContractAccessoryPo.setRelateCode(contractInfoChangePO.getUpdateApplyCode());
                        List<ContractAccessoryPo> contractAccessoryPos = this.contractAccessoryMapper.qryByCondition(queryContractAccessoryPo);
                        if (!CollectionUtils.isEmpty(contractAccessoryPos)) {
                            ArrayList<ContractAccessoryPo> newContractAccessoryPos = new ArrayList<ContractAccessoryPo>();
                            for (ContractAccessoryPo contractAccessoryPo : contractAccessoryPos) {
                                ContractAccessoryPo newContractAccessoryPo = new ContractAccessoryPo();
                                BeanUtils.copyProperties((Object)contractAccessoryPo, (Object)newContractAccessoryPo);
                                newContractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
                                newContractAccessoryPo.setRelateId(newContractPo.getContractId());
                                newContractAccessoryPo.setRelateCode(newContractPo.getContractCode());
                                newContractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT);
                                newContractAccessoryPos.add(newContractAccessoryPo);
                            }
                            this.contractAccessoryMapper.insertBatch(newContractAccessoryPos);
                        }
                    }
                }
            } else {
                throw new ZTBusinessException("\u5ba1\u6279\u5931\u8d25");
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5ba1\u6279\u6210\u529f");
            if ("1".equals(reqBO.getDealResult().toString())) continue;
            ContractFreezeStatusSyncAgrBo contractFreezeStatusSyncAgrBo = new ContractFreezeStatusSyncAgrBo();
            try {
                CContractAgrPO cContractAgrPO = new CContractAgrPO();
                cContractAgrPO.setRelateId(contractInfoChangePO.getContractId());
                List<CContractAgrPO> cContractAgrPOS = this.cContractAgrMapper.getList(cContractAgrPO);
                if (CollectionUtils.isEmpty(cContractAgrPOS)) continue;
                contractFreezeStatusSyncAgrBo.setContractId(contractInfoChangePO.getContractId());
                contractFreezeStatusSyncAgrBo.setAgrId(cContractAgrPOS.get(0).getAgreementId());
                contractFreezeStatusSyncAgrBo.setDealType(2);
                log.info("\u53d1\u9001\u534f\u8bae\u51bb\u7ed3\u6d88\u606f\uff1a" + JSON.toJSONString((Object)contractFreezeStatusSyncAgrBo));
                this.syncContractFreezeStatusProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)contractFreezeStatusSyncAgrBo)));
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u534f\u8bae\u51bb\u7ed3\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)contractFreezeStatusSyncAgrBo));
            }
        }
        return rspBO;
    }

    private void recordContractNodeOperLog(Long contractId, Long userId, String userName, String nodeCode, String nodeName) {
        ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
        contractRecordContractNodeOperLogAtomReqBO.setContractId(contractId);
        contractRecordContractNodeOperLogAtomReqBO.setNodeCode(nodeCode);
        contractRecordContractNodeOperLogAtomReqBO.setNodeName(nodeName);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserId(userId);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserName(userName);
        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
    }

    private String checkReq(ContractChangeInitiateActionsAbilityReqBO reqBo, Integer dealType) {
        String msg = "";
        if (CollectionUtils.isEmpty((Collection)reqBo.getUpdateApplyIds())) {
            msg = "\u672a\u4f20\u5165\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u5355ID";
            return msg;
        }
        List<ContractInfoChangePO> contractInfoChangePOS = this.contractInfoChangeMapper.qryListByIds(reqBo.getUpdateApplyIds());
        if (CollectionUtils.isEmpty(contractInfoChangePOS)) {
            msg = "\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u5355\u4e0d\u5b58\u5728";
            return msg;
        }
        Map<Long, ContractInfoChangePO> map = contractInfoChangePOS.stream().collect(Collectors.toMap(a -> a.getUpdateApplyId(), b -> b, (first, second) -> second));
        if (contractInfoChangePOS.size() != reqBo.getUpdateApplyIds().size()) {
            for (Long contractId : reqBo.getUpdateApplyIds()) {
                if (map.containsKey(contractId)) continue;
                msg = "\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u5355" + contractId + "\u4e0d\u5b58\u5728";
                return msg;
            }
        }
        for (ContractInfoChangePO contractInfoChangePO : contractInfoChangePOS) {
            if (dealType == 1) {
                if (ContractConstant.ModifyStatus.MODIFY_STATUS_APPROVED.equals(contractInfoChangePO.getModifyStatus())) continue;
                msg = "\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u4e0d\u662f\u5ba1\u6279\u901a\u8fc7\u72b6\u6001\uff0c\u4e0d\u80fd\u53d1\u8d77\u751f\u6548";
                return msg;
            }
            if (dealType == 2) {
                if (ContractConstant.ModifyStatus.MODIFY_STATUS_DRAFT.equals(contractInfoChangePO.getModifyStatus()) || ContractConstant.ModifyStatus.MODIFY_STATUS_REJECT.equals(contractInfoChangePO.getModifyStatus())) continue;
                msg = "\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u4e0d\u662f\u8349\u7a3f\u6216\u8005\u9a73\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664";
                return msg;
            }
            if (dealType == 3) {
                if (!ContractConstant.ModifyStatus.MODIFY_STATUS_IN_CONFIRM.equals(contractInfoChangePO.getModifyStatus())) {
                    msg = "\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u4e0d\u662f\u786e\u8ba4\u4e2d\u72b6\u6001\uff0c\u4e0d\u80fd\u786e\u8ba4";
                    return msg;
                }
                if (reqBo.getDealResult() != null) continue;
                msg = "\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u672a\u4f20\u5165\u786e\u8ba4\u7ed3\u679c";
                return msg;
            }
            if (dealType != 4) continue;
            if (!ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE.equals(contractInfoChangePO.getModifyStatus())) {
                msg = "\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u4e0d\u662f\u5ba1\u6279\u4e2d\u72b6\u6001\uff0c\u4e0d\u80fd\u5ba1\u6279";
                return msg;
            }
            if (reqBo.getDealResult() != null) continue;
            msg = "\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u672a\u4f20\u5165\u5ba1\u6279\u7ed3\u679c";
            return msg;
        }
        return msg;
    }
}

