/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.bo.ContractAccessoryBO;
import com.tydic.contract.busi.ContractDetailQueryBusiService;
import com.tydic.contract.busi.bo.ContractDetailInfoBO;
import com.tydic.contract.busi.bo.ContractDetailQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractDetailQueryBusiRspBO;
import com.tydic.contract.dao.CContractAgrMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.CContractAgrPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractTermsPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.MoneyUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractDetailQueryBusiServiceImpl
implements ContractDetailQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractDetailQueryBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;
    @Autowired
    private CContractAgrMapper cContractAgrMapper;

    @Override
    public ContractDetailQueryBusiRspBO contractDetailQuery(ContractDetailQueryBusiReqBO contractDetailQueryBusiReqBO) {
        ContractDetailQueryBusiRspBO contractDetailQueryBusiRspBO = new ContractDetailQueryBusiRspBO();
        ContractDetailInfoBO contractDetailInfoBO = new ContractDetailInfoBO();
        BeanUtils.copyProperties((Object)contractDetailQueryBusiReqBO, (Object)contractDetailInfoBO);
        if (contractDetailQueryBusiReqBO == null || contractDetailQueryBusiReqBO.getContractId() == null) {
            contractDetailQueryBusiRspBO.setCode("8888");
            contractDetailQueryBusiRspBO.setMessage("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return contractDetailQueryBusiRspBO;
        }
        ContractDetailInfoBO contractDetailInfoBO1 = this.contractInfoMapper.selectContractDetailInfo(contractDetailInfoBO);
        log.debug("\u5408\u540c\u8be6\u60c5\u67e5\u8be2\u7ed3\u679c" + contractDetailInfoBO1);
        if (contractDetailInfoBO1 == null) {
            contractDetailQueryBusiRspBO.setCode("8888");
            contractDetailQueryBusiRspBO.setMessage("\u5408\u540c\u8be6\u60c5\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return contractDetailQueryBusiRspBO;
        }
        contractDetailQueryBusiRspBO = (ContractDetailQueryBusiRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)contractDetailInfoBO1), ContractDetailQueryBusiRspBO.class));
        CContractAgrPO cContractAgrPO = new CContractAgrPO();
        cContractAgrPO.setRelateId(contractDetailQueryBusiReqBO.getContractId());
        if (this.cContractAgrMapper.contractAgrCount(cContractAgrPO) > 0) {
            contractDetailQueryBusiRspBO.setHaveAgr(1);
        } else {
            contractDetailQueryBusiRspBO.setHaveAgr(0);
        }
        if (contractDetailInfoBO1.getContractAmount() != null) {
            contractDetailQueryBusiRspBO.setContractAmount(MoneyUtils.haoToYuan(contractDetailInfoBO1.getContractAmount()));
        }
        ContractAccessoryPo contractAccessoryPo = new ContractAccessoryPo();
        contractAccessoryPo.setRelateType(1);
        contractAccessoryPo.setRelateCode(contractDetailQueryBusiRspBO.getContractCode());
        List<ContractAccessoryPo> contractAccessoryPoList = this.contractAccessoryMapper.qryByCondition(contractAccessoryPo);
        List<ContractAccessoryBO> contractAccessoryBOList = contractAccessoryPoList.stream().map(temp -> {
            ContractAccessoryBO boTemp = new ContractAccessoryBO();
            BeanUtils.copyProperties((Object)temp, (Object)boTemp);
            return boTemp;
        }).collect(Collectors.toList());
        contractDetailQueryBusiRspBO.setAccessoryList(contractAccessoryBOList);
        if (contractDetailInfoBO1.getTermCode() != null && !contractDetailInfoBO1.getTermCode().equals("")) {
            ContractTermsPo contractTermsPo = new ContractTermsPo();
            contractTermsPo.setTermCode(contractDetailInfoBO1.getTermCode());
            ContractTermsPo contractTermsPo1 = this.contractTermsMapper.selectByTermCode(contractTermsPo);
            if (contractTermsPo1 != null) {
                contractDetailQueryBusiRspBO.setTermText(contractTermsPo1.getTermText());
            }
        }
        this.translate(contractDetailQueryBusiRspBO);
        contractDetailQueryBusiRspBO.setCode("0000");
        contractDetailQueryBusiRspBO.setMessage("\u5408\u540c\u8be6\u60c5\u67e5\u8be2\u6210\u529f\uff01");
        return contractDetailQueryBusiRspBO;
    }

    public void translate(ContractDetailQueryBusiRspBO bo) {
        if (bo.getContractType() != null) {
            bo.setContractTypeStr(ContractTransFieldUtil.transContractType(bo.getContractType()));
        }
        if (bo.getBuerIsTaxIn() != null) {
            bo.setBuerIsTaxInStr(bo.getBuerIsTaxIn().equals(1) ? "\u662f" : (bo.getBuerIsTaxIn().equals(0) ? "\u5426" : "\u7ffb\u8bd1\u5f02\u5e38\uff01"));
        }
        if (bo.getContractStatus() != null) {
            bo.setContractStatusStr(ContractTransFieldUtil.transContractStatus(bo.getContractStatus()));
        }
        if (bo.getApprovalStatus() != null) {
            bo.setApprovalStatusStr(ContractTransFieldUtil.transContractApprovalResult(bo.getApprovalStatus()));
        }
        if (bo.getPayType() != null) {
            bo.setPayTypeStr(ContractTransFieldUtil.transPayType(bo.getPayType()));
        }
        if (bo.getContractEndDate() != null && bo.getContractEffectiveDate() != null) {
            bo.setShelfLife(String.valueOf((bo.getContractEndDate().getTime() - bo.getContractEffectiveDate().getTime()) / 86400000L));
        }
        if (bo.getPurchaseType() != null) {
            bo.setPurchaseTypeStr(ContractTransFieldUtil.transContractPurchaseType(bo.getPurchaseType()));
        }
        if (bo.getContractCategory() != null) {
            bo.setContractCategoryStr(ContractTransFieldUtil.transContractCategory(bo.getContractCategory()));
        }
        if (bo.getMaterialSource() != null && !bo.getMaterialSource().equals("")) {
            bo.setMaterialSourceStr(ContractTransFieldUtil.transContractMaterialSource(bo.getMaterialSource()));
        }
        if (bo.getOrgType() != null && !bo.getOrgType().equals("")) {
            bo.setOrgTypeStr(ContractTransFieldUtil.transContractOrgType(bo.getOrgType()));
        }
        if (bo.getBusinessType() != null) {
            bo.setBusinessTypeStr(ContractTransFieldUtil.transBusinessType(bo.getBusinessType()));
        }
        if (bo.getIsNewSupplier() != null) {
            bo.setIsNewSupplierStr(ContractTransFieldUtil.transIsNewSupplier(bo.getIsNewSupplier()));
        }
        if (bo.getIsNewBrand() != null) {
            bo.setIsNewBrandStr(ContractTransFieldUtil.transIsNewBrand(bo.getIsNewBrand()));
        }
        if (!StringUtils.isBlank((String)bo.getCommunicationType())) {
            bo.setCommunicationTypeStr(ContractTransFieldUtil.transCommunicationType(bo.getCommunicationType()));
        }
        if (bo.getPayNodeRuleAllow() != null) {
            bo.setPayNodeRuleAllowStr(ContractTransFieldUtil.transPayNodeRuleAllow(bo.getPayNodeRuleAllow()));
        }
    }
}

