/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.busi.ContractFddNoticeSignBusiService;
import com.tydic.contract.busi.bo.ContractFddNoticeSignBusiReqBO;
import com.tydic.contract.busi.bo.ContractFddNoticeSignBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.utils.FileHelper;
import com.tydic.contract.utils.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractFddNoticeSignBusiServiceImpl
implements ContractFddNoticeSignBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractFddNoticeSignBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private FileClient fileClient;
    private static final Long USER_ID = 8840L;
    private static final String USER_NAME = "\u6cd5\u5927\u5927";
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    private static final String OSS_SERVER_URL = "https://dev-zhongtai.oss-cn-beijing.aliyuncs.com/";

    @Override
    public ContractFddNoticeSignBusiRspBO noticeSignedContract(ContractFddNoticeSignBusiReqBO reqBO) {
        String downloadUrl = reqBO.getDownload_url();
        String transactionId = reqBO.getTransaction_id();
        log.info("\u5408\u540c\u4e0b\u8f7d\u5730\u5740\uff1a" + downloadUrl);
        log.info("\u5408\u540c\u6d41\u6c34\u53f7\uff1a" + transactionId);
        String ossPath = this.uploadFile(downloadUrl);
        this.changeContractInfo(ossPath, transactionId);
        ContractFddNoticeSignBusiRspBO rspBO = new ContractFddNoticeSignBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6cd5\u5927\u5927\u7b7e\u7ea6\u56de\u8c03\u670d\u52a1\u6210\u529f\u8fc7");
        return rspBO;
    }

    private void changeContractInfo(String ossPath, String transactionId) {
        ContractPo queryContractPo = new ContractPo();
        queryContractPo.setExternalSignSysFlowId(transactionId);
        ContractPo contractPo = this.contractMapper.qryContractByFlowId(queryContractPo);
        if (contractPo == null) {
            throw new ZTBusinessException("\u6839\u7eddflowId\u67e5\u8be2\u539f\u5408\u540c\u4e0d\u5b58\u5728");
        }
        log.info("\u66f4\u6539\u5408\u540c\u72b6\u6001");
        ContractPo updatePo = new ContractPo();
        if (contractPo.getSignFlag().equals(ContractConstant.SignFlag.GENERATOR_FIRST_STATUS)) {
            if (contractPo.getContractStatus().equals(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_)) {
                log.info("\u53d8\u66f4\u72b6\u6001\uff1a1\uff0c7->8");
                this.recordContractNodeOperLog(contractPo.getContractId(), USER_ID, USER_NAME, "SIGNATORIES_SIGN", "\u7b7e\u8ba2\u65b9\u7b7e\u7ae0");
                this.recordContractNodeOperLog(contractPo.getContractId(), USER_ID, USER_NAME, "CONTRACT_EFFECT", "\u5408\u540c\u751f\u6548");
                updatePo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            } else if (contractPo.getContractStatus().equals(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN)) {
                log.info("\u53d8\u66f4\u72b6\u6001\uff1a1\uff0c12->7");
                this.recordContractNodeOperLog(contractPo.getContractId(), USER_ID, USER_NAME, "PRODUCER_SIGN", "\u751f\u6210\u65b9\u7b7e\u7ae0");
                updatePo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
            }
        } else if (contractPo.getSignFlag().equals(ContractConstant.SignFlag.SINGER_FIRST_STATUS)) {
            if (contractPo.getContractStatus().equals(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_)) {
                log.info("\u53d8\u66f4\u72b6\u6001\uff1a2\uff0c6->8");
                this.recordContractNodeOperLog(contractPo.getContractId(), USER_ID, USER_NAME, "PRODUCER_SIGN", "\u751f\u6210\u65b9\u7b7e\u7ae0");
                this.recordContractNodeOperLog(contractPo.getContractId(), USER_ID, USER_NAME, "CONTRACT_EFFECT", "\u5408\u540c\u751f\u6548");
                updatePo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            } else if (contractPo.getContractStatus().equals(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN)) {
                log.info("\u53d8\u66f4\u72b6\u6001\uff1a2\uff0c12->6");
                this.recordContractNodeOperLog(contractPo.getContractId(), USER_ID, USER_NAME, "SIGNATORIES_SIGN", "\u7b7e\u8ba2\u65b9\u7b7e\u7ae0");
                updatePo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
            }
        } else {
            throw new ZTBusinessException("\u6d41\u7a0b\u9519\u8bef");
        }
        updatePo.setContractDocUrl(ossPath);
        updatePo.setContractId(contractPo.getContractId());
        updatePo.setSignStatus(1);
        int i = this.contractMapper.updateByPrimaryKeySelective(updatePo);
        if (i != 1) {
            throw new ZTBusinessException("\u4fee\u6539\u5408\u540c\u4fe1\u606f\u5931\u8d25");
        }
    }

    private String uploadFile(String downloadUrl) {
        String preName = "external2internalFdd-";
        String fileName = preName + String.valueOf(Sequence.getInstance().nextId() + ".pdf");
        HttpUtil.httpDownload(downloadUrl, fileName);
        log.info("\u6cd5\u5927\u5927\u5408\u540c\u7b7e\u7f72\u5b8c\u6210-\u4e0b\u8f7d\u5230\u672c\u5730");
        String path = "";
        try {
            byte[] bytes = FileHelper.getBytes(fileName);
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String uploadPath = sdf.format(new Date());
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)input);
            path = OSS_SERVER_URL + result;
            log.info("\u5408\u540c\u4e0a\u4f20\u81f3oss\u8def\u5f84\uff1a" + path);
        }
        catch (Exception e) {
            log.error("\u5408\u540c\u7b7e\u7f72\u5b8c\u6210-\u5408\u540c\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519");
            throw new ZTBusinessException("\u5408\u540c\u7b7e\u7f72\u5b8c\u6210-\u5408\u540c\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519:" + e.getMessage());
        }
        HttpUtil.deleteFile(fileName);
        return path;
    }

    private void recordContractNodeOperLog(Long contractId, Long userId, String userName, String nodeCode, String nodeName) {
        ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
        contractRecordContractNodeOperLogAtomReqBO.setContractId(contractId);
        contractRecordContractNodeOperLogAtomReqBO.setNodeCode(nodeCode);
        contractRecordContractNodeOperLogAtomReqBO.setNodeName(nodeName);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserId(userId);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserName(userName);
        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
    }
}

