/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.bo.ContractInitiateActionsAbilityReqBO;
import com.tydic.contract.ability.bo.ContractInitiateActionsAbilityRspBO;
import com.tydic.contract.atom.ContractDealApprovalAtomService;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.ContractStartApprovalProcessAtomService;
import com.tydic.contract.atom.bo.ContractDealApprovalAtomReqBO;
import com.tydic.contract.atom.bo.ContractDealApprovalAtomRspBO;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.atom.bo.ContractStartApprovalProcessAtomReqBO;
import com.tydic.contract.atom.bo.ContractStartApprovalProcessAtomRspBO;
import com.tydic.contract.busi.ContractInitiateActionsBusiService;
import com.tydic.contract.busi.bo.ContractFreezeStatusSyncAgrBo;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractAgrMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.NegotiationLogMapper;
import com.tydic.contract.po.CContractAgrPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.NegotiationLogPO;
import com.tydic.contract.utils.MoneyUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractInitiateActionsBusiServiceImpl
implements ContractInitiateActionsBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractInitiateActionsBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private NegotiationLogMapper negotiationLogMapper;
    @Autowired
    private ContractStartApprovalProcessAtomService contractStartApprovalProcessAtomService;
    @Autowired
    private ContractDealApprovalAtomService contractDealApprovalAtomService;
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    @Resource(name="syncContractFreezeStatusProvider")
    private ProxyMessageProducer syncContractFreezeStatusProvider;
    @Autowired
    private CContractAgrMapper cContractAgrMapper;
    @Value(value="${CONTRACT_FREEZE_SYNC_TOPIC}")
    private String topic;
    @Value(value="${CONTRACT_FREEZE_SYNC_TAG}")
    private String tag;

    @Override
    public ContractInitiateActionsAbilityRspBO dealContractEff(ContractInitiateActionsAbilityReqBO reqBo) {
        ContractInitiateActionsAbilityRspBO rspBO = new ContractInitiateActionsAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String msg = this.checkReq(reqBo, 1);
        if (!StringUtils.isEmpty((Object)msg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(msg);
            return rspBO;
        }
        for (Long contractId : reqBo.getContractIds()) {
            ContractInfoPO contractInfoPO1 = new ContractInfoPO();
            contractInfoPO1.setContractId(contractId);
            contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            contractInfoPO1.setUpdateUserId(reqBo.getUserId());
            contractInfoPO1.setUpdateUserName(reqBo.getName());
            contractInfoPO1.setUpdateTime(new Date());
            int updateResult = this.contractInfoMapper.updateContract(contractInfoPO1);
            if (updateResult != 1) continue;
            this.recordContractNodeOperLog(contractId, reqBo.getUserId(), reqBo.getName(), "CONTRACT_EFFECT", "\u5408\u540c\u751f\u6548");
        }
        for (Long contractId : reqBo.getContractIds()) {
            ContractFreezeStatusSyncAgrBo contractFreezeStatusSyncAgrBo = new ContractFreezeStatusSyncAgrBo();
            try {
                CContractAgrPO cContractAgrPO = new CContractAgrPO();
                cContractAgrPO.setRelateId(contractId);
                List<CContractAgrPO> cContractAgrPOS = this.cContractAgrMapper.getList(cContractAgrPO);
                if (CollectionUtils.isEmpty(cContractAgrPOS)) continue;
                contractFreezeStatusSyncAgrBo.setContractId(contractId);
                contractFreezeStatusSyncAgrBo.setAgrId(cContractAgrPOS.get(0).getAgreementId());
                contractFreezeStatusSyncAgrBo.setDealType(1);
                log.info("\u53d1\u9001\u534f\u8bae\u51bb\u7ed3\u6d88\u606f\uff1a" + JSON.toJSONString((Object)contractFreezeStatusSyncAgrBo));
                this.syncContractFreezeStatusProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)contractFreezeStatusSyncAgrBo)));
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u534f\u8bae\u51bb\u7ed3\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)contractFreezeStatusSyncAgrBo));
            }
        }
        return rspBO;
    }

    @Override
    public ContractInitiateActionsAbilityRspBO deleteContract(ContractInitiateActionsAbilityReqBO reqBo) {
        ContractInitiateActionsAbilityRspBO rspBO = new ContractInitiateActionsAbilityRspBO();
        String msg = this.checkReq(reqBo, 2);
        if (!StringUtils.isEmpty((Object)msg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(msg);
            return rspBO;
        }
        this.contractInfoMapper.deleteBatchById(reqBo.getContractIds());
        this.contractInfoItemMapper.deleteBatchByContractId(reqBo.getContractIds());
        return rspBO;
    }

    @Override
    public ContractInitiateActionsAbilityRspBO dealContractAbolish(ContractInitiateActionsAbilityReqBO reqBo) {
        ContractInitiateActionsAbilityRspBO rspBO = new ContractInitiateActionsAbilityRspBO();
        String msg = this.checkReq(reqBo, 3);
        if (!StringUtils.isEmpty((Object)msg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(msg);
            return rspBO;
        }
        for (Long contractId : reqBo.getContractIds()) {
            ContractInfoPO contractInfoPO1 = new ContractInfoPO();
            contractInfoPO1.setContractId(contractId);
            contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_ABOLISH);
            contractInfoPO1.setUpdateUserId(reqBo.getUserId());
            contractInfoPO1.setUpdateUserName(reqBo.getName());
            contractInfoPO1.setUpdateTime(new Date());
            int updateResult = this.contractInfoMapper.updateContract(contractInfoPO1);
            if (updateResult != 1) continue;
            this.recordContractNodeOperLog(contractId, reqBo.getUserId(), reqBo.getName(), "CONTRACT_ABOLISH", "\u5408\u540c\u5e9f\u6b62");
        }
        return rspBO;
    }

    @Override
    public ContractInitiateActionsAbilityRspBO dealContractConfirm(ContractInitiateActionsAbilityReqBO reqBo) {
        ContractInitiateActionsAbilityRspBO rspBO = new ContractInitiateActionsAbilityRspBO();
        String msg = this.checkReq(reqBo, 4);
        if (!StringUtils.isEmpty((Object)msg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(msg);
            return rspBO;
        }
        List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getListByContractIds(reqBo.getContractIds());
        Map<Object, Object> contractIdAndOrgType = new HashMap();
        Map<Object, Object> contractIdAndOrgId = new HashMap();
        Map<Object, Object> contractIdAndPo = new HashMap();
        if (!CollectionUtils.isEmpty(contractInfoPOS)) {
            contractIdAndOrgType = contractInfoPOS.stream().filter(a -> !StringUtils.isEmpty((Object)a.getContractOrgType())).collect(Collectors.toMap(a -> a.getContractId(), b -> b.getContractOrgType(), (first, second) -> first));
            contractIdAndOrgId = contractInfoPOS.stream().filter(a -> a.getCreateDeptId() != null).collect(Collectors.toMap(a -> a.getContractId(), b -> b.getCreateDeptId(), (first, second) -> first));
            contractIdAndPo = contractInfoPOS.stream().collect(Collectors.toMap(a -> a.getContractId(), b -> b, (first, second) -> first));
        }
        for (Long contractId : reqBo.getContractIds()) {
            ContractInfoPO contractInfoPO1 = new ContractInfoPO();
            contractInfoPO1.setContractId(contractId);
            if ("0".equals(reqBo.getDealResult().toString())) {
                contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_IN_NEGOTIATION);
                NegotiationLogPO negotiationLogPO = new NegotiationLogPO();
                negotiationLogPO.setRelId(contractId);
                negotiationLogPO.setId(Sequence.getInstance().nextId());
                negotiationLogPO.setCreateTime(new Date());
                negotiationLogPO.setCreateUserName(reqBo.getName());
                negotiationLogPO.setDealResult(reqBo.getDealResult());
                negotiationLogPO.setRemark(reqBo.getRemark());
                negotiationLogPO.setType(0);
                this.negotiationLogMapper.insert(negotiationLogPO);
            } else {
                contractInfoPO1.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
                ContractStartApprovalProcessAtomReqBO atomReqBO = new ContractStartApprovalProcessAtomReqBO();
                atomReqBO.setContractId(contractId);
                if (!StringUtils.isEmpty((Object)contractIdAndOrgType.get(contractId))) {
                    atomReqBO.setOrgId((Long)contractIdAndOrgId.get(contractId));
                    if ("0".equals(contractIdAndOrgType.get(contractId))) {
                        atomReqBO.setMenuId("M001005");
                    } else {
                        atomReqBO.setMenuId("M001003");
                    }
                } else {
                    throw new ZTBusinessException("\u8be5\u5408\u540c\u6ca1\u6709\u5408\u540c\u673a\u6784\u7c7b\u578b\u6570\u636e");
                }
                atomReqBO.setObjType(1);
                atomReqBO.setDept(reqBo.getOrgName());
                atomReqBO.setUserId(reqBo.getUserId());
                atomReqBO.setUsername(reqBo.getName());
                HashMap<String, Object> variables = new HashMap<String, Object>();
                if (6 == ((ContractInfoPO)contractIdAndPo.get(contractId)).getContractType()) {
                    variables.put("contractMoney", MoneyUtils.haoToYuan(((ContractInfoPO)contractIdAndPo.get(contractId)).getContractAmount()));
                } else if (((ContractInfoPO)contractIdAndPo.get(contractId)).getIsNewSupplier() != null && ((ContractInfoPO)contractIdAndPo.get(contractId)).getIsNewSupplier() == 1 || ((ContractInfoPO)contractIdAndPo.get(contractId)).getIsNewBrand() != null && ((ContractInfoPO)contractIdAndPo.get(contractId)).getIsNewBrand() == 1) {
                    variables.put("auditType", "1");
                } else {
                    variables.put("auditType", "2");
                }
                atomReqBO.setVariables(variables);
                ContractStartApprovalProcessAtomRspBO atomRspBO = this.contractStartApprovalProcessAtomService.startApprovalProcess(atomReqBO);
                log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2code\uff1a" + atomRspBO.getRespCode() + " \u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2stepId\uff1a" + atomRspBO.getStepId());
                if (!atomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException(atomRspBO.getRespDesc());
                }
                if (StringUtils.isEmpty((Object)atomRspBO.getStepId())) {
                    log.info("\u5ba1\u6279API\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)((Object)atomRspBO)));
                    throw new ZTBusinessException("\u5ba1\u6279\u6d41\u7a0b\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u56fe");
                }
                contractInfoPO1.setStepId(atomRspBO.getStepId());
            }
            contractInfoPO1.setUpdateUserId(reqBo.getUserId());
            contractInfoPO1.setUpdateUserName(reqBo.getName());
            contractInfoPO1.setUpdateTime(new Date());
            int updateResult = this.contractInfoMapper.updateContract(contractInfoPO1);
            if (updateResult != 1) continue;
            this.recordContractNodeOperLog(contractId, reqBo.getUserId(), reqBo.getName(), "CONTRACT_CONFIRM", "\u5408\u540c\u786e\u8ba4");
        }
        return rspBO;
    }

    @Override
    public ContractInitiateActionsAbilityRspBO dealContractAudit(ContractInitiateActionsAbilityReqBO reqBo) {
        ContractInitiateActionsAbilityRspBO rspBO = new ContractInitiateActionsAbilityRspBO();
        String msg = this.checkReq(reqBo, 5);
        if (!StringUtils.isEmpty((Object)msg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(msg);
            return rspBO;
        }
        for (Long contractId : reqBo.getContractIds()) {
            ContractDealApprovalAtomRspBO atomRspBO;
            ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(contractId);
            if (contractInfoPO == null) continue;
            ContractInfoPO updateContractPo = new ContractInfoPO();
            BeanUtils.copyProperties((Object)contractInfoPO, (Object)updateContractPo);
            ContractDealApprovalAtomReqBO atomReqBO = new ContractDealApprovalAtomReqBO();
            atomReqBO.setAuditAdvice(reqBo.getRemark());
            atomReqBO.setUsername(reqBo.getName());
            atomReqBO.setStepId(contractInfoPO.getStepId());
            atomReqBO.setContractId(contractInfoPO.getContractId());
            atomReqBO.setObjType(1);
            atomReqBO.setDept(reqBo.getOrgName());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            if (6 == contractInfoPO.getContractType()) {
                variables.put("contractMoney", MoneyUtils.haoToYuan(contractInfoPO.getContractAmount()));
            } else if (contractInfoPO.getIsNewSupplier() != null && contractInfoPO.getIsNewSupplier() == 1 || contractInfoPO.getIsNewBrand() != null && contractInfoPO.getIsNewBrand() == 1) {
                variables.put("auditType", "1");
            } else {
                variables.put("auditType", "2");
            }
            if (reqBo.getUserId() != null) {
                atomReqBO.setOperId(reqBo.getUserId().toString());
            }
            atomReqBO.setVariables(variables);
            if ("1".equals(reqBo.getDealResult().toString())) {
                atomReqBO.setAuditResult(ContractConstant.AuditResult.AUDIT_RESULT_YES);
                atomRspBO = this.contractDealApprovalAtomService.dealApproval(atomReqBO);
                log.info("\u5ba1\u6279\u6d41\u7a0b\u6d41\u8f6ccode\uff1a" + atomRspBO.getRespCode());
                if (!atomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException(atomRspBO.getRespDesc());
                }
                updateContractPo.setStepId(atomRspBO.getStepId());
                if (atomRspBO.getFinish().booleanValue()) {
                    updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
                }
            } else {
                atomReqBO.setAuditResult(ContractConstant.AuditResult.AUDIT_RESULT_NO);
                atomRspBO = this.contractDealApprovalAtomService.dealApproval(atomReqBO);
                log.info("\u5ba1\u6279\u6d41\u7a0b\u6d41\u8f6ccode\uff1a" + atomRspBO.getRespCode());
                if (!atomRspBO.getRespCode().equals("0000")) {
                    throw new ZTBusinessException(atomRspBO.getRespDesc());
                }
                updateContractPo.setStepId(atomRspBO.getStepId());
                updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT);
            }
            updateContractPo.setContractApprovalUserId(reqBo.getUserId());
            updateContractPo.setContractApprovalUserName(reqBo.getName());
            updateContractPo.setContractApprovalResult(reqBo.getDealResult() == 1 ? 1 : 2);
            updateContractPo.setContractApprovalRemark(reqBo.getRemark());
            updateContractPo.setContractApprovalTime(new Date());
            updateContractPo.setUpdateUserId(reqBo.getUserId());
            updateContractPo.setUpdateUserName(reqBo.getName());
            updateContractPo.setUpdateTime(new Date());
            int updateResult = this.contractInfoMapper.updateContract(updateContractPo);
            if (updateResult == 1) {
                if ("1".equals(reqBo.getDealResult().toString())) {
                    this.recordContractNodeOperLog(contractId, reqBo.getUserId(), reqBo.getName(), "CONTRACT_APPROVAL", "\u5408\u540c\u5ba1\u6279");
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5ba1\u6279\u6210\u529f");
                return rspBO;
            }
            throw new ZTBusinessException("\u5ba1\u6279\u5931\u8d25");
        }
        return rspBO;
    }

    private void recordContractNodeOperLog(Long contractId, Long userId, String userName, String nodeCode, String nodeName) {
        ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
        contractRecordContractNodeOperLogAtomReqBO.setContractId(contractId);
        contractRecordContractNodeOperLogAtomReqBO.setNodeCode(nodeCode);
        contractRecordContractNodeOperLogAtomReqBO.setNodeName(nodeName);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserId(userId);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserName(userName);
        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
    }

    private String checkReq(ContractInitiateActionsAbilityReqBO reqBo, Integer dealType) {
        String msg = "";
        if (CollectionUtils.isEmpty((Collection)reqBo.getContractIds())) {
            msg = "\u672a\u4f20\u5165\u5408\u540cID";
            return msg;
        }
        List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getListByContractIds(reqBo.getContractIds());
        if (CollectionUtils.isEmpty(contractInfoPOS)) {
            msg = "\u5408\u540c\u4e0d\u5b58\u5728";
            return msg;
        }
        Map<Long, ContractInfoPO> map = contractInfoPOS.stream().collect(Collectors.toMap(a -> a.getContractId(), b -> b, (first, second) -> second));
        if (contractInfoPOS.size() != reqBo.getContractIds().size()) {
            for (Long contractId : reqBo.getContractIds()) {
                if (map.containsKey(contractId)) continue;
                msg = "\u5408\u540c" + contractId + "\u4e0d\u5b58\u5728";
                return msg;
            }
        }
        for (ContractInfoPO contractInfoPO : contractInfoPOS) {
            if (dealType == 1) {
                if (ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL.equals(contractInfoPO.getContractStatus())) continue;
                msg = "\u5408\u540c\u4e0d\u662f\u5ba1\u6279\u901a\u8fc7\u72b6\u6001\uff0c\u4e0d\u80fd\u53d1\u8d77\u751f\u6548";
                return msg;
            }
            if (dealType == 2) {
                if (ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT.equals(contractInfoPO.getContractStatus()) || ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT.equals(contractInfoPO.getContractStatus())) continue;
                msg = "\u5408\u540c\u4e0d\u662f\u8349\u7a3f\u6216\u8005\u9a73\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664";
                return msg;
            }
            if (dealType == 3) {
                if (ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT.equals(contractInfoPO.getContractStatus())) continue;
                msg = "\u5408\u540c\u4e0d\u662f\u751f\u6548\u72b6\u6001\uff0c\u4e0d\u80fd\u5e9f\u6b62";
                return msg;
            }
            if (dealType == 4) {
                if (!ContractConstant.ContractStatus.CONTRACT_STATUS_IN_CONFIRM.equals(contractInfoPO.getContractStatus())) {
                    msg = "\u5408\u540c\u4e0d\u662f\u786e\u8ba4\u4e2d\u72b6\u6001\uff0c\u4e0d\u80fd\u786e\u8ba4";
                    return msg;
                }
                if (reqBo.getDealResult() != null) continue;
                msg = "\u5408\u540c\u786e\u8ba4\u672a\u4f20\u5165\u786e\u8ba4\u7ed3\u679c";
                return msg;
            }
            if (dealType != 5) continue;
            if (!ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL.equals(contractInfoPO.getContractStatus())) {
                msg = "\u5408\u540c\u4e0d\u662f\u5ba1\u6279\u4e2d\u72b6\u6001\uff0c\u4e0d\u80fd\u5ba1\u6279";
                return msg;
            }
            if (reqBo.getDealResult() != null) continue;
            msg = "\u5408\u540c\u786e\u8ba4\u672a\u4f20\u5165\u5ba1\u6279\u7ed3\u679c";
            return msg;
        }
        return msg;
    }
}

