/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.api.UccMaterialInfoQueryAbilityService;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityBo;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityRspBo;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.busi.ContractItemAddBusiService;
import com.tydic.contract.busi.bo.ContractItemAddBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemAddBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.ExcelUtils;
import com.tydic.contract.utils.HttpUtil;
import com.tydic.uac.exception.BusinessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ContractItemAddBusiServiceImpl
implements ContractItemAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemAddBusiServiceImpl.class);
    @Autowired
    ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    UccMaterialInfoQueryAbilityService uccMaterialInfoQueryAbilityService;

    @Override
    public ContractItemAddBusiRspBO contractItemAdd(ContractItemAddBusiReqBO reqBO) {
        ContractItemAddBusiRspBO rspBO = new ContractItemAddBusiRspBO();
        rspBO.setAddFlag(true);
        List<Object> rspItemList = new ArrayList();
        List<ContractItemAbilityBO> contractItemAbilityBOList = reqBO.getContractItemBOList();
        ArrayList<ContractInfoItemTmpPO> contractInfoItemTmpPOS = new ArrayList<ContractInfoItemTmpPO>();
        if (ContractConstant.ItemAddType.ADD.equals(reqBO.getType())) {
            if (CollectionUtils.isEmpty(contractItemAbilityBOList)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6dfb\u52a0\u5217\u8868\u4e3a\u7a7a");
                return rspBO;
            }
            for (ContractItemAbilityBO x : contractItemAbilityBOList) {
                ContractInfoItemTmpPO contractInfoItemPO = this.getContractInfoItemPO(x);
                contractInfoItemTmpPOS.add(contractInfoItemPO);
            }
        } else if (ContractConstant.ItemAddType.IMPORT.equals(reqBO.getType())) {
            rspItemList = this.importExcelV2(reqBO);
        } else if (ContractConstant.ItemAddType.FZ.equals(reqBO.getType())) {
            ArrayList<ContractInfoItemPO> contractInfoItemPOS = new ArrayList<ContractInfoItemPO>();
            HashMap<String, ContractInfoItemTmpPO> contractItemAbilityBOHashMap = new HashMap<String, ContractInfoItemTmpPO>();
            for (ContractItemAbilityBO x : contractItemAbilityBOList) {
                if (StringUtils.isEmpty((Object)x.getAwardNumId()) || contractItemAbilityBOHashMap.containsKey(x.getAwardNumId())) continue;
                ContractInfoItemTmpPO contractInfoItemTmpPO = this.getContractInfoItemPO(x);
                contractItemAbilityBOHashMap.put(x.getAwardNumId(), contractInfoItemTmpPO);
                contractInfoItemTmpPOS.add(contractInfoItemTmpPO);
                ContractInfoItemPO contractInfoItemPO = new ContractInfoItemPO();
                BeanUtils.copyProperties((Object)contractInfoItemTmpPO, (Object)contractInfoItemPO);
                contractInfoItemPOS.add(contractInfoItemPO);
            }
            if (CollectionUtils.isEmpty(contractInfoItemTmpPOS)) {
                rspBO.setAddFlag(false);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6388\u6807\u660e\u7ec6\u8868id\u90fd\u4e3a\u7a7a");
                return rspBO;
            }
        } else {
            rspBO.setRespCode("1017");
            rspBO.setRespDesc("\u6ca1\u6709\u5f53\u524d\u7c7b\u578b");
            return rspBO;
        }
        List<Object> itemIDS = new ArrayList();
        if (!CollectionUtils.isEmpty(contractInfoItemTmpPOS)) {
            itemIDS = this.insertTmp(contractInfoItemTmpPOS, reqBO.getType());
        }
        rspItemList.addAll(itemIDS);
        rspBO.setAddFlag(true);
        rspBO.setContractItemAbilityBOList(rspItemList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<Long> importExcelV2(ContractItemAddBusiReqBO reqBO) {
        ArrayList<ContractInfoItemTmpPO> contractInfoItemTmpPOS = new ArrayList<ContractInfoItemTmpPO>();
        List<Long> rspItemList = new ArrayList<Long>();
        ArrayList<String> title = new ArrayList<String>();
        JSONObject data = new JSONObject();
        try {
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("6018", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38: " + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("6018", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Map)data)) {
            throw new BusinessException("6018", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<ContractItemAbilityBO> contractItemAbilityBOList = this.getContractItemAbilityBOListFromExcel(data, reqBO.getModelType());
        log.debug("\u6839\u636e\u4e0d\u540c\u6a21\u677f\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff1a" + contractItemAbilityBOList.size());
        if (CollectionUtils.isEmpty(contractItemAbilityBOList)) {
            return rspItemList;
        }
        if (ContractConstant.ModelType.B_TAX_UNIT.equals(reqBO.getModelType()) || ContractConstant.ModelType.B_UNIT_PRICE.equals(reqBO.getModelType())) {
            this.getUccMaterialInfo(contractItemAbilityBOList, reqBO.getModelType());
            contractItemAbilityBOList.forEach(x -> {
                ContractInfoItemTmpPO contractInfoItemPO = this.getContractInfoItemPO((ContractItemAbilityBO)x);
                contractInfoItemPO.setRelateId(reqBO.getContractInfo().getRelateId());
                contractInfoItemPO.setRelateCode(reqBO.getContractInfo().getRelateCode());
                ContractInfoItemTmpPO tax = this.getTax(contractInfoItemPO);
                if (tax != null) {
                    contractInfoItemTmpPOS.add(tax);
                }
            });
            rspItemList = this.insertTmp(contractInfoItemTmpPOS, reqBO.getType());
        } else {
            for (ContractItemAbilityBO x2 : contractItemAbilityBOList) {
                ContractInfoItemTmpPO contractInfoItemPO = this.getContractInfoItemPO(x2);
                contractInfoItemPO.setRelateId(reqBO.getContractInfo().getRelateId());
                contractInfoItemPO.setRelateCode(reqBO.getContractInfo().getRelateCode());
                contractInfoItemPO.setItemId(x2.getItemId());
                contractInfoItemPO.setUuid(null);
                ContractInfoItemTmpPO tax = this.getTax(contractInfoItemPO);
                if (tax == null || tax.getItemId() == null) continue;
                this.contractInfoItemTmpMapper.update(tax);
                rspItemList.add(tax.getItemId());
            }
        }
        return rspItemList;
    }

    private void getUccMaterialInfo(List<ContractItemAbilityBO> contractItemAbilityBOList, Integer modelType) {
        if (modelType == null) {
            log.info("modelType\u4e3a\u7a7a");
            return;
        }
        if (ContractConstant.ModelType.B_TAX_UNIT.equals(modelType) || ContractConstant.ModelType.B_UNIT_PRICE.equals(modelType)) {
            ArrayList materialCodes = new ArrayList();
            contractItemAbilityBOList.forEach(x -> materialCodes.add(x.getMaterialCode()));
            UccMaterialInfoQueryAbilityReqBo reqBo = new UccMaterialInfoQueryAbilityReqBo();
            reqBo.setMaterialCodes(materialCodes);
            reqBo.setQueryErpFlag(true);
            reqBo.setPageNo(1);
            reqBo.setIsprofess("0");
            reqBo.setPageSize(contractItemAbilityBOList.size());
            log.debug("\u67e5\u8be2\u7269\u6599\u4fe1\u606f\u5165\u53c2\uff1a" + reqBo);
            UccMaterialInfoQueryAbilityRspBo uccMaterialInfo = this.uccMaterialInfoQueryAbilityService.getUccMaterialInfo(reqBo);
            log.debug("uccMaterialInfo\u4e3a\uff1a" + uccMaterialInfo);
            List rows = uccMaterialInfo.getRows();
            for (ContractItemAbilityBO contractItemAbilityBO : contractItemAbilityBOList) {
                for (UccMaterialInfoQueryAbilityBo row : rows) {
                    if (!contractItemAbilityBO.getMaterialCode().equals(row.getMaterialCode())) continue;
                    contractItemAbilityBO.setUnitName(row.getUnit());
                    contractItemAbilityBO.setMaterialDesc(row.getMaterialDesc());
                    contractItemAbilityBO.setMaterialLongName(row.getMaterialDesc());
                    contractItemAbilityBO.setMaterialName(row.getMaterialName());
                    contractItemAbilityBO.setMaterialId(Long.valueOf(Long.parseLong(row.getMaterialId())));
                }
            }
        }
    }

    private ContractInfoItemTmpPO getTax(ContractInfoItemTmpPO contractInfoItemTmpPO) {
        if (null == contractInfoItemTmpPO.getRate()) {
            log.info("\u7a0e\u7387\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u91d1\u989d");
            return null;
        }
        if (null != contractInfoItemTmpPO.getTaxUnitPrice()) {
            BigDecimal taxUnitPrice = contractInfoItemTmpPO.getTaxUnitPrice();
            int amount = contractInfoItemTmpPO.getAmount().intValue();
            Integer rate = contractInfoItemTmpPO.getRate();
            BigDecimal bigDecimal = new BigDecimal(100 + rate).divide(BigDecimal.valueOf(100L), 6, 4);
            BigDecimal unitPriceExcludingTax = taxUnitPrice.divide(bigDecimal, 6, 4);
            BigDecimal notIncludingTaxAmount = unitPriceExcludingTax.multiply(new BigDecimal(amount)).setScale(6, RoundingMode.HALF_UP);
            BigDecimal taxAmount = taxUnitPrice.multiply(new BigDecimal(amount)).setScale(6, RoundingMode.HALF_UP);
            BigDecimal tax = taxAmount.subtract(notIncludingTaxAmount);
            contractInfoItemTmpPO.setTax(tax);
            contractInfoItemTmpPO.setTaxAmount(taxAmount);
            contractInfoItemTmpPO.setNotIncludingTaxAmount(notIncludingTaxAmount);
            contractInfoItemTmpPO.setUnitPriceExcludingTax(unitPriceExcludingTax);
        } else if (null != contractInfoItemTmpPO.getUnitPriceExcludingTax()) {
            BigDecimal unitPriceExcludingTax = contractInfoItemTmpPO.getUnitPriceExcludingTax();
            int amount = contractInfoItemTmpPO.getAmount().intValue();
            Integer rate = contractInfoItemTmpPO.getRate();
            BigDecimal bigDecimal = new BigDecimal(100 + rate).divide(BigDecimal.valueOf(100L), 6, 4);
            BigDecimal taxUnitPrice = unitPriceExcludingTax.multiply(bigDecimal).setScale(6, RoundingMode.HALF_UP);
            BigDecimal taxAmount = taxUnitPrice.multiply(new BigDecimal(amount)).setScale(6, RoundingMode.HALF_UP);
            BigDecimal notIncludingTaxAmount = unitPriceExcludingTax.multiply(new BigDecimal(amount)).setScale(6, RoundingMode.HALF_UP);
            BigDecimal tax = taxAmount.subtract(notIncludingTaxAmount);
            contractInfoItemTmpPO.setTax(tax);
            contractInfoItemTmpPO.setNotIncludingTaxAmount(notIncludingTaxAmount);
            contractInfoItemTmpPO.setTaxUnitPrice(taxUnitPrice);
            contractInfoItemTmpPO.setTaxAmount(taxAmount);
        } else {
            log.info("\u542b\u7a0e\u5355\u4ef7\u3001\u4e0d\u542b\u7a0e\u5355\u4ef7\u90fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u91d1\u989d");
        }
        return contractInfoItemTmpPO;
    }

    List<ContractItemAbilityBO> getContractItemAbilityBOListFromExcel(JSONObject excel, Integer type) {
        List<ContractItemAbilityBO> contractItemAbilityBOListFromBTaxUnit = new ArrayList<ContractItemAbilityBO>();
        if (null == type) {
            log.info("\u5bfc\u5165\u6a21\u677f\u7c7b\u578b\u7c7b\u578b\u4e3a\u7a7a");
            return contractItemAbilityBOListFromBTaxUnit;
        }
        if (ContractConstant.ModelType.B_TAX_UNIT.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromBTaxUnit(excel);
        } else if (ContractConstant.ModelType.B_UNIT_PRICE.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromBTaxUnitPrice(excel);
        } else if (ContractConstant.ModelType.Tend_TAX_UNIT.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromExport(excel);
        } else if (ContractConstant.ModelType.Tend_UNIT_PRICE.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromExport(excel);
        } else if (ContractConstant.ModelType.AWAD_TAX_UNIT.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromExport(excel);
        } else if (ContractConstant.ModelType.AWAD_UNIT_PRICE.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromExport(excel);
        } else {
            log.info("\u5bfc\u5165\u6a21\u677f\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        return contractItemAbilityBOListFromBTaxUnit;
    }

    private List<ContractItemAbilityBO> getContractItemAbilityBOListFromBTaxUnit(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        ArrayList<ContractItemAbilityBO> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("*\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("*\u6570\u91cf"));
            contractItemAbilityBO.setTaxUnitPrice(next.getBigDecimal("*\u542b\u7a0e\u5355\u4ef7"));
            contractItemAbilityBO.setRate(next.getInteger("*\u7a0e\u7387"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("*\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setInventoryOrganization(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getContractItemAbilityBOListFromBTaxUnitPrice(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        ArrayList<ContractItemAbilityBO> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("*\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("*\u6570\u91cf"));
            contractItemAbilityBO.setUnitPriceExcludingTax(next.getBigDecimal("*\u4e0d\u542b\u7a0e\u5355\u4ef7"));
            contractItemAbilityBO.setRate(next.getInteger("*\u7a0e\u7387"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("*\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setInventoryOrganization(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getContractItemAbilityBOListFromATaxUnitPrice(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        ArrayList<ContractItemAbilityBO> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("*\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("*\u6570\u91cf"));
            contractItemAbilityBO.setUnitPriceExcludingTax(next.getBigDecimal("*\u4e0d\u542b\u7a0e\u5355\u4ef7"));
            contractItemAbilityBO.setRate(next.getInteger("*\u7a0e\u7387"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("*\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setInventoryOrganization(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getContractItemAbilityBOListFromATaxUnit(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        ArrayList<ContractItemAbilityBO> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("*\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("*\u6570\u91cf"));
            contractItemAbilityBO.setTaxUnitPrice(next.getBigDecimal("*\u542b\u7a0e\u5355\u4ef7"));
            contractItemAbilityBO.setRate(next.getInteger("*\u7a0e\u7387"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("*\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setInventoryOrganization(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getContractItemAbilityBOListFromExport(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        ArrayList<ContractItemAbilityBO> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("\u6570\u91cf"));
            contractItemAbilityBO.setTaxUnitPrice(next.getBigDecimal("\u542b\u7a0e\u5355\u4ef7"));
            contractItemAbilityBO.setUnitPriceExcludingTax(next.getBigDecimal("\u4e0d\u542b\u7a0e\u5355\u4ef7"));
            contractItemAbilityBO.setRate(next.getInteger("\u7a0e\u7387"));
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setErpOrgCode(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setInventoryOrganization(next.getString("\u5e93\u5b58\u7ec4\u7ec7"));
            contractItemAbilityBO.setComponentID(next.getString("\u90e8\u4ef6\u53f7"));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBO.setItemId(next.getLong("\u660e\u7ec6id"));
            contractItemAbilityBO.setItemChangeId(next.getLong("\u660e\u7ec6\u53d8\u66f4ID"));
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        return contractItemAbilityBOList;
    }

    private List<Long> insertTmp(List<ContractInfoItemTmpPO> contractInfoItemTmpPOS, Integer type) {
        List<Object> exists = new ArrayList();
        log.debug("contractInfoItemTmpPOS\u4e3a\uff1a{}", contractInfoItemTmpPOS);
        ContractInfoItemTmpPO po = new ContractInfoItemTmpPO();
        po.setRelateId(contractInfoItemTmpPOS.get(0).getRelateId());
        ArrayList<Long> rspItemList = new ArrayList<Long>();
        ArrayList<ContractInfoItemTmpPO> notExists = new ArrayList<ContractInfoItemTmpPO>();
        if (ContractConstant.ItemAddType.FZ.equals(type)) {
            exists = this.contractInfoItemTmpMapper.getItemsByAwardNumId(po, contractInfoItemTmpPOS);
            log.debug("\u5f53\u524d\u5b58\u5728\u7684\u660e\u7ec6\uff1a {}", exists);
            for (ContractInfoItemTmpPO contractInfoItemTmpPO : contractInfoItemTmpPOS) {
                boolean exFlag = false;
                if (null != contractInfoItemTmpPO.getAwardNumId()) {
                    for (ContractInfoItemTmpPO contractInfoItemTmpPO2 : exists) {
                        if (!contractInfoItemTmpPO.getAwardNumId().equals(contractInfoItemTmpPO2.getAwardNumId())) continue;
                        exFlag = true;
                    }
                    if (exFlag) continue;
                    notExists.add(contractInfoItemTmpPO);
                    rspItemList.add(contractInfoItemTmpPO.getItemId());
                    continue;
                }
                break;
            }
        } else {
            for (ContractInfoItemTmpPO contractInfoItemTmpPO : contractInfoItemTmpPOS) {
                rspItemList.add(contractInfoItemTmpPO.getItemId());
                notExists.add(contractInfoItemTmpPO);
            }
        }
        if (!CollectionUtils.isEmpty(notExists)) {
            this.contractInfoItemTmpMapper.insertBatch(notExists);
        }
        return rspItemList;
    }

    private ContractInfoItemTmpPO getContractInfoItemPO(ContractItemAbilityBO x) {
        ContractInfoItemTmpPO contractInfoItemTmpPO = new ContractInfoItemTmpPO();
        BeanUtils.copyProperties((Object)x, (Object)contractInfoItemTmpPO);
        contractInfoItemTmpPO.setItemId(Sequence.getInstance().nextId());
        contractInfoItemTmpPO.setUuid(Sequence.getInstance().nextId());
        contractInfoItemTmpPO.setDelFlag("0");
        if (null != x.getAmount()) {
            contractInfoItemTmpPO.setAmount(x.getAmount());
        }
        if (null != x.getUnitPrice()) {
            contractInfoItemTmpPO.setUnitPrice(x.getUnitPrice());
        }
        if (null != x.getTotalAmount()) {
            contractInfoItemTmpPO.setTotalAmount(x.getTotalAmount());
        }
        if (null != x.getTaxAmount()) {
            contractInfoItemTmpPO.setTaxAmount(x.getTaxAmount());
        }
        if (null != x.getTaxUnitPrice()) {
            contractInfoItemTmpPO.setTaxUnitPrice(x.getTaxUnitPrice());
        }
        if (null != x.getTax()) {
            contractInfoItemTmpPO.setTax(x.getTax());
        }
        if (null != x.getUnitPriceExcludingTax()) {
            contractInfoItemTmpPO.setUnitPriceExcludingTax(x.getUnitPriceExcludingTax());
        }
        if (null != x.getNotIncludingTaxAmount()) {
            contractInfoItemTmpPO.setNotIncludingTaxAmount(x.getNotIncludingTaxAmount());
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (!StringUtils.isEmpty((Object)x.getUpdateTime())) {
                contractInfoItemTmpPO.setUpdateTime(simpleDateFormat.parse(x.getUpdateTime()));
            }
            if (!StringUtils.isEmpty((Object)x.getNeedArriveTime())) {
                contractInfoItemTmpPO.setNeedArriveTime(simpleDateFormat.parse(x.getNeedArriveTime()));
            }
            if (!StringUtils.isEmpty((Object)x.getCreateTime())) {
                contractInfoItemTmpPO.setCreateTime(simpleDateFormat.parse(x.getCreateTime()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contractInfoItemTmpPO;
    }

    private void validate(List<ContractInfoItemPO> contractInfoItemPOS, List<ContractInfoItemPO> pass, List<ContractInfoItemPO> error) {
    }

    private void getExcelDateByImport(MultipartFile multipartFile, JSONObject jsonData, List<String> title) {
        try {
            Cell cell;
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            Sheet sheet = workbook.getSheetAt(0);
            int rowLength = sheet.getLastRowNum();
            Row row = sheet.getRow(0);
            int colLength = row.getLastCellNum();
            for (int i = 0; i < colLength; ++i) {
                cell = row.getCell(i);
                if (cell == null) continue;
                cell.setCellType(CellType.STRING);
                title.add(cell.getStringCellValue());
            }
            JSONArray jsonArray = new JSONArray();
            jsonData.put("excelJSON", (Object)jsonArray);
            for (int i = 1; i <= rowLength; ++i) {
                row = sheet.getRow(i);
                JSONObject rowJson = new JSONObject();
                for (int j = 0; j < colLength; ++j) {
                    cell = row.getCell(j);
                    if (cell == null) continue;
                    rowJson.put(title.get(j), (Object)ContractItemAddBusiServiceImpl.getCellValueByCell(cell));
                }
                jsonArray.add((Object)rowJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        CellType cellTypeEnum = cell.getCellTypeEnum();
        switch (cellTypeEnum) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    if (format == 20 || format == 32) {
                        sdf = new SimpleDateFormat("HH:mm");
                    } else if (format == 14 || format == 31 || format == 57 || format == 58) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                        double value = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)value);
                        cellValue = sdf.format(date);
                    } else {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                    try {
                        cellValue = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    catch (Exception e) {
                        try {
                            throw new Exception("exception on get date data !".concat(e.toString()));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            break;
                        }
                    }
                    finally {
                        sdf = null;
                    }
                }
                BigDecimal bd = new BigDecimal(cell.getNumericCellValue());
                cellValue = bd.toPlainString();
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            default: {
                cellValue = "UNKNOW VALUE";
            }
        }
        return cellValue;
    }
}

