/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.contract.ability.bo.ContractItemChangeAbilityBO;
import com.tydic.contract.busi.ContractItemChangeQueryBusiService;
import com.tydic.contract.busi.bo.ContractItemChangeQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemChangeQueryBusiRspBO;
import com.tydic.contract.dao.ContractInfoChangeItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractItemChangeQueryBusiServiceImpl
implements ContractItemChangeQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemChangeQueryBusiServiceImpl.class);
    @Autowired
    ContractInfoChangeItemMapper contractInfoChangeItemMapper;
    @Autowired
    ContractInfoItemTmpMapper contractInfoItemTmpMapper;

    @Override
    public ContractItemChangeQueryBusiRspBO contractItemChangeQuery(ContractItemChangeQueryBusiReqBO reqBO) {
        ContractItemChangeQueryBusiRspBO rspBO = new ContractItemChangeQueryBusiRspBO();
        BigDecimal notIncludingTaxAmountTotal = null;
        BigDecimal taxAmountTotal = null;
        BigDecimal taxTotal = null;
        ContractInfoItemTmpPO po = new ContractInfoItemTmpPO();
        po.setUpdateApplyId(reqBO.getUpdateApplyId());
        List<Long> itemChangeIdS = reqBO.getItemChangeIdS();
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemTmpMapper.contractItemChangeQuery(po, itemChangeIdS));
        if (!CollectionUtils.isEmpty((Collection)page.getResult())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u53d8\u66f4\u5217\u8868\u67e5\u8be2\u6210\u529f");
            List result = page.getResult();
            ArrayList<ContractItemChangeAbilityBO> rows = new ArrayList<ContractItemChangeAbilityBO>();
            for (ContractInfoItemTmpPO contractInfoItemTmpPO : result) {
                if (notIncludingTaxAmountTotal == null && null != contractInfoItemTmpPO.getNotIncludingTaxAmountTotal()) {
                    notIncludingTaxAmountTotal = contractInfoItemTmpPO.getNotIncludingTaxAmountTotal();
                }
                if (taxAmountTotal == null && null != contractInfoItemTmpPO.getTaxAmountTotal()) {
                    taxAmountTotal = contractInfoItemTmpPO.getTaxAmountTotal();
                }
                if (taxTotal == null && null != contractInfoItemTmpPO.getTaxTotal()) {
                    taxTotal = contractInfoItemTmpPO.getTaxTotal();
                }
                ContractItemChangeAbilityBO contractItemChangeAbilityBO = this.getContractItemChangeAbilityBO(contractInfoItemTmpPO);
                rows.add(contractItemChangeAbilityBO);
            }
            rspBO.setNotIncludingTaxAmountTotal(notIncludingTaxAmountTotal);
            rspBO.setTaxAmountTotal(taxAmountTotal);
            rspBO.setTaxTotal(taxTotal);
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNum());
            rspBO.setTotal(page.getPages());
            rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return rspBO;
    }

    private ContractItemChangeAbilityBO getContractItemChangeAbilityBO(ContractInfoItemTmpPO x) {
        ContractItemChangeAbilityBO contractItemAbilityBO = new ContractItemChangeAbilityBO();
        BeanUtils.copyProperties((Object)x, (Object)contractItemAbilityBO);
        if (null != x.getAmount()) {
            contractItemAbilityBO.setAmount(x.getAmount());
        }
        if (null != x.getFactoryPrice()) {
            contractItemAbilityBO.setFactoryPriceStr(ContractTransFieldUtil.transFactoryPrice(contractItemAbilityBO.getFactoryPrice()));
        }
        if (null != x.getCreateTime()) {
            contractItemAbilityBO.setCreateTime(DateUtils.dateToStrAsFormat(x.getCreateTime(), "yyyy-MM-dd"));
        }
        if (null != x.getUpdateTime()) {
            contractItemAbilityBO.setUpdateTime(DateUtils.dateToStrAsFormat(x.getUpdateTime(), "yyyy-MM-dd"));
        }
        if (null != x.getNeedArriveTime()) {
            contractItemAbilityBO.setNeedArriveTime(DateUtils.dateToStrAsFormat(x.getNeedArriveTime(), "yyyy-MM-dd"));
        }
        return contractItemAbilityBO;
    }
}

