/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.contract.ability.bo.ContractItemChangeAbilityBO;
import com.tydic.contract.busi.ContractItemChangeUpdateBusiService;
import com.tydic.contract.busi.bo.ContractItemChangeUpdateBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemChangeUpdateBusiRspBO;
import com.tydic.contract.dao.ContractInfoChangeItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractItemChangeUpdateBusiServiceImpl
implements ContractItemChangeUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemChangeUpdateBusiServiceImpl.class);
    @Autowired
    private ContractInfoChangeItemMapper contractInfoChangeItemMapper;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;

    @Override
    public ContractItemChangeUpdateBusiRspBO contractItemChangeUpdate(ContractItemChangeUpdateBusiReqBO reqBO) {
        ContractItemChangeUpdateBusiRspBO rspBO = new ContractItemChangeUpdateBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getContractItemList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u660e\u7ec6\u53d8\u66f4\u5217\u8868\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        for (ContractItemChangeAbilityBO x : reqBO.getContractItemList()) {
            if (StringUtils.isEmpty((Object)x.getItemChangeId())) continue;
            ContractInfoItemTmpPO po = this.getContractInfoItemTmpPO(x);
            this.contractInfoItemTmpMapper.updateByPO(po);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u53d8\u66f4\u4fee\u6539\u6210\u529f\uff01");
        return rspBO;
    }

    private ContractInfoItemTmpPO getContractInfoItemTmpPO(ContractItemChangeAbilityBO x) {
        ContractInfoItemTmpPO contractInfoItemTmpPO = (ContractInfoItemTmpPO)JSON.parseObject((String)JSON.toJSONString((Object)x), ContractInfoItemTmpPO.class);
        contractInfoItemTmpPO.setDelFlag("0");
        if (null != x.getAmount()) {
            contractInfoItemTmpPO.setAmount(x.getAmount());
        }
        if (null != x.getUnitPrice()) {
            contractInfoItemTmpPO.setUnitPrice(x.getUnitPrice());
        }
        if (null != x.getTotalAmount()) {
            contractInfoItemTmpPO.setTotalAmount(x.getTotalAmount());
        }
        if (null != x.getTaxAmount()) {
            contractInfoItemTmpPO.setTaxAmount(x.getTaxAmount());
        }
        if (null != x.getTaxUnitPrice()) {
            contractInfoItemTmpPO.setTaxUnitPrice(x.getTaxUnitPrice());
        }
        if (null != x.getTax()) {
            contractInfoItemTmpPO.setTax(x.getTax());
        }
        if (null != x.getUnitPriceExcludingTax()) {
            contractInfoItemTmpPO.setUnitPriceExcludingTax(x.getUnitPriceExcludingTax());
        }
        if (null != x.getNotIncludingTaxAmount()) {
            contractInfoItemTmpPO.setNotIncludingTaxAmount(x.getNotIncludingTaxAmount());
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (!StringUtils.isEmpty((Object)x.getUpdateTime())) {
                contractInfoItemTmpPO.setUpdateTime(simpleDateFormat.parse(x.getUpdateTime()));
            }
            if (!StringUtils.isEmpty((Object)x.getNeedArriveTime())) {
                contractInfoItemTmpPO.setNeedArriveTime(simpleDateFormat.parse(x.getNeedArriveTime()));
            }
            if (!StringUtils.isEmpty((Object)x.getCreateTime())) {
                contractInfoItemTmpPO.setCreateTime(simpleDateFormat.parse(x.getCreateTime()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contractInfoItemTmpPO;
    }
}

