/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.busi.ContractItemQueryBusiService;
import com.tydic.contract.busi.bo.ContractItemQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemQueryBusiRspBO;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractItemQueryBusiServiceImpl
implements ContractItemQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemQueryBusiServiceImpl.class);
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;

    @Override
    public ContractItemQueryBusiRspBO contractItemQuery(ContractItemQueryBusiReqBO reqBO) {
        ContractItemQueryBusiRspBO contractItemQueryBusiRspBO = new ContractItemQueryBusiRspBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getContractCode()) && reqBO.getContractId() == null) {
            contractItemQueryBusiRspBO.setRespCode("8888");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u7f16\u7f16\u7801\u5408\u540cID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemMapper.selectByRelateCode(reqBO.getContractCode(), reqBO.getContractId(), reqBO.getContractItemBOList()));
        List contractItemPoList = page.getResult();
        log.info("\u5408\u540c\u660e\u7ec6\u67e5\u8be2" + page.toString());
        contractItemQueryBusiRspBO.setPageNo(page.getPageNum());
        contractItemQueryBusiRspBO.setRecordsTotal(Integer.parseInt(String.valueOf(page.getTotal())));
        contractItemQueryBusiRspBO.setTotal(page.getPages());
        if (!(contractItemPoList != null && contractItemPoList.size() >= 1 || reqBO.getPageSize().equals(-1))) {
            contractItemQueryBusiRspBO.setRespCode("8888");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        BigDecimal taxAmountTotal = new BigDecimal(0);
        BigDecimal notIncludingTaxAmountTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);
        List<ContractInfoItemPO> contractItemPoList1 = this.contractInfoItemMapper.selectByRelateCode(reqBO.getContractCode(), reqBO.getContractId(), reqBO.getContractItemBOList());
        if ((contractItemPoList1 == null || contractItemPoList1.size() < 1) && reqBO.getPageSize().equals(-1)) {
            contractItemQueryBusiRspBO.setRespCode("8888");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        for (ContractInfoItemPO po : contractItemPoList1) {
            if (po.getTaxAmount() != null) {
                taxAmountTotal = taxAmountTotal.add(MoneyUtils.haoToYuan(po.getTaxAmount()));
            }
            if (po.getNotIncludingTaxAmount() != null) {
                notIncludingTaxAmountTotal = notIncludingTaxAmountTotal.add(MoneyUtils.haoToYuan(po.getNotIncludingTaxAmount()));
            }
            if (po.getTax() == null) continue;
            taxTotal = taxTotal.add(MoneyUtils.haoToYuan(po.getTax()));
        }
        contractItemQueryBusiRspBO.setTaxAmountTotal(taxAmountTotal);
        contractItemQueryBusiRspBO.setTaxTotal(taxTotal);
        contractItemQueryBusiRspBO.setNotIncludingTaxAmountTotal(notIncludingTaxAmountTotal);
        List<ContractItemAbilityBO> contractItemBusiBOList = !reqBO.getPageSize().equals(-1) ? this.BoParse(contractItemPoList) : this.BoParse(contractItemPoList1);
        this.translate(contractItemBusiBOList);
        contractItemQueryBusiRspBO.setRows(contractItemBusiBOList);
        contractItemQueryBusiRspBO.setRespCode("0000");
        contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return contractItemQueryBusiRspBO;
    }

    @Override
    public ContractItemQueryBusiRspBO contractItemQueryTemp(ContractItemQueryBusiReqBO reqBO) {
        ContractItemQueryBusiRspBO contractItemQueryBusiRspBO = new ContractItemQueryBusiRspBO();
        if (reqBO.getContractId() == null) {
            contractItemQueryBusiRspBO.setRespCode("8888");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        ContractInfoItemTmpPO tmpPO = new ContractInfoItemTmpPO();
        tmpPO.setRelateId(reqBO.getContractId());
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemTmpMapper.contractItemQuery(tmpPO, reqBO.getContractItemBOList()));
        List contractItemTmpPoList = page.getResult();
        log.info("\u5408\u540c\u660e\u7ec6\u67e5\u8be2" + page.toString());
        contractItemQueryBusiRspBO.setPageNo(page.getPageNum());
        contractItemQueryBusiRspBO.setRecordsTotal(Integer.parseInt(String.valueOf(page.getTotal())));
        contractItemQueryBusiRspBO.setTotal(page.getPages());
        if (!(contractItemTmpPoList != null && contractItemTmpPoList.size() >= 1 || reqBO.getPageSize().equals(-1))) {
            contractItemQueryBusiRspBO.setRespCode("0000");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        BigDecimal taxAmountTotal = new BigDecimal(0);
        BigDecimal notIncludingTaxAmountTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);
        List<ContractInfoItemTmpPO> contractItemTmpPoList1 = this.contractInfoItemTmpMapper.contractItemQuery(tmpPO, reqBO.getContractItemBOList());
        if ((contractItemTmpPoList1 == null || contractItemTmpPoList1.size() < 1) && reqBO.getPageSize().equals(-1)) {
            contractItemQueryBusiRspBO.setRespCode("0000");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        for (ContractInfoItemTmpPO po : contractItemTmpPoList1) {
            if (po.getTaxAmount() != null) {
                taxAmountTotal = taxAmountTotal.add(po.getTaxAmount());
            }
            if (po.getNotIncludingTaxAmount() != null) {
                notIncludingTaxAmountTotal = notIncludingTaxAmountTotal.add(po.getNotIncludingTaxAmount());
            }
            if (po.getTax() == null) continue;
            taxTotal = taxTotal.add(po.getTax());
        }
        contractItemQueryBusiRspBO.setTaxAmountTotal(taxAmountTotal);
        contractItemQueryBusiRspBO.setTaxTotal(taxTotal);
        contractItemQueryBusiRspBO.setNotIncludingTaxAmountTotal(notIncludingTaxAmountTotal);
        List<ContractItemAbilityBO> contractItemBusiBOList = !reqBO.getPageSize().equals(-1) ? this.BoTmpParse(contractItemTmpPoList) : this.BoTmpParse(contractItemTmpPoList1);
        this.translate(contractItemBusiBOList);
        contractItemQueryBusiRspBO.setRows(contractItemBusiBOList);
        contractItemQueryBusiRspBO.setRespCode("0000");
        contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return contractItemQueryBusiRspBO;
    }

    public void translate(List<ContractItemAbilityBO> contractItemBusiBOList) {
        for (ContractItemAbilityBO contractItemAbilityBO : contractItemBusiBOList) {
            if (contractItemAbilityBO.getPriceCategories() != null) {
                contractItemAbilityBO.setPriceCategoriesStr(ContractTransFieldUtil.transPriceCategories(contractItemAbilityBO.getPriceCategories()));
            }
            if (contractItemAbilityBO.getFactoryPrice() == null) continue;
            contractItemAbilityBO.setFactoryPriceStr(ContractTransFieldUtil.transFactoryPrice(contractItemAbilityBO.getFactoryPrice()));
        }
    }

    public List<ContractItemAbilityBO> BoParse(List<ContractInfoItemPO> contractItemPoList) {
        List<ContractItemAbilityBO> contractItemBusiBOList = contractItemPoList.stream().map(contractPOTemp -> {
            ContractItemAbilityBO contractItemBusiBOTemp = new ContractItemAbilityBO();
            String jsonString = JSON.toJSONString((Object)contractPOTemp);
            contractItemBusiBOTemp = (ContractItemAbilityBO)JSON.parseObject((String)jsonString, ContractItemAbilityBO.class);
            return contractItemBusiBOTemp;
        }).collect(Collectors.toList());
        return contractItemBusiBOList;
    }

    public List<ContractItemAbilityBO> BoTmpParse(List<ContractInfoItemTmpPO> contractItemPoList) {
        List<ContractItemAbilityBO> contractItemBusiBOList = contractItemPoList.stream().map(contractPOTemp -> {
            ContractItemAbilityBO contractItemBusiBOTemp = new ContractItemAbilityBO();
            String jsonString = JSON.toJSONString((Object)contractPOTemp);
            contractItemBusiBOTemp = (ContractItemAbilityBO)JSON.parseObject((String)jsonString, ContractItemAbilityBO.class);
            return contractItemBusiBOTemp;
        }).collect(Collectors.toList());
        return contractItemBusiBOList;
    }
}

