/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.busi.ContractItemUpdateBusiService;
import com.tydic.contract.busi.bo.ContractItemUpdateBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemUpdateBusiRspBO;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ContractItemUpdateBusiServiceImpl
implements ContractItemUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemUpdateBusiServiceImpl.class);
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;

    @Override
    public ContractItemUpdateBusiRspBO contractItemUpdate(ContractItemUpdateBusiReqBO reqBO) {
        ContractItemUpdateBusiRspBO contractItemUpdateBusiRspBO = new ContractItemUpdateBusiRspBO();
        if (reqBO.getContractDetailList() == null || reqBO.getContractDetailList().size() < 1) {
            contractItemUpdateBusiRspBO.setRespCode("8888");
            contractItemUpdateBusiRspBO.setRespDesc("\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff01");
            return contractItemUpdateBusiRspBO;
        }
        for (ContractItemAbilityBO temp : reqBO.getContractDetailList()) {
            ContractInfoItemPO contractItemPo = new ContractInfoItemPO();
            if (temp.getItemId() == null) {
                contractItemUpdateBusiRspBO.setRespCode("8888");
                contractItemUpdateBusiRspBO.setRespDesc("\u660e\u7ec6Id\u4e3a\u7a7a\uff01");
                return contractItemUpdateBusiRspBO;
            }
            BeanUtils.copyProperties((Object)temp, (Object)contractItemPo);
            int flag = this.contractInfoItemMapper.updateByPrimaryKeySelective(contractItemPo);
            if (flag >= 1) continue;
            contractItemUpdateBusiRspBO.setRespCode("8888");
            contractItemUpdateBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff01");
            return contractItemUpdateBusiRspBO;
        }
        contractItemUpdateBusiRspBO.setRespCode("0000");
        contractItemUpdateBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u4fee\u6539\u6210\u529f\uff01");
        return contractItemUpdateBusiRspBO;
    }

    @Override
    public ContractItemUpdateBusiRspBO contractItemUpdateTemp(ContractItemUpdateBusiReqBO reqBO) {
        ContractItemUpdateBusiRspBO contractItemUpdateBusiRspBO = new ContractItemUpdateBusiRspBO();
        if (reqBO.getContractDetailList() == null || reqBO.getContractDetailList().size() < 1) {
            contractItemUpdateBusiRspBO.setRespCode("8888");
            contractItemUpdateBusiRspBO.setRespDesc("\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff01");
            return contractItemUpdateBusiRspBO;
        }
        for (ContractItemAbilityBO temp : reqBO.getContractDetailList()) {
            if (temp.getItemId() == null && temp.getRelateId() == null) {
                contractItemUpdateBusiRspBO.setRespCode("8888");
                contractItemUpdateBusiRspBO.setRespDesc("\u4e34\u65f6\u8868\u660e\u7ec6Id\u4e0e\u5408\u540cid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
                return contractItemUpdateBusiRspBO;
            }
            this.translate(temp);
            ContractInfoItemTmpPO contractItemTmpPo = (ContractInfoItemTmpPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)temp), ContractInfoItemTmpPO.class);
            int n = this.contractInfoItemTmpMapper.update(contractItemTmpPo);
        }
        contractItemUpdateBusiRspBO.setRespCode("0000");
        contractItemUpdateBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u4fee\u6539\u6210\u529f\uff01");
        return contractItemUpdateBusiRspBO;
    }

    public void translate(ContractItemAbilityBO contractItemAbilityBO) {
        if (contractItemAbilityBO.getTaxAmount() != null && contractItemAbilityBO.getNotIncludingTaxAmount() != null) {
            contractItemAbilityBO.setTax(contractItemAbilityBO.getTaxAmount().subtract(contractItemAbilityBO.getNotIncludingTaxAmount()));
        }
    }
}

