/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.busi.ContractDictionaryBusiService;
import com.tydic.contract.busi.ContractQryAwardResultListBusiService;
import com.tydic.contract.busi.bo.ContractQryAwardResultListBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryAwardResultListBusiRspBO;
import com.tydic.contract.busi.bo.ContractQryAwardResultListEsbReqBO;
import com.tydic.contract.busi.bo.ContractQryAwardResultListEsbRspBO;
import com.tydic.contract.utils.HttpUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ContractQryAwardResultListBusiServiceImpl
implements ContractQryAwardResultListBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryAwardResultListBusiServiceImpl.class);
    @Value(value="${ESB_ACCESS_IP}")
    private String esbAddressId;
    private static final String QUERY_AWARD_RESULT_LIST_URL = "/OSN/api/getAwardResultList/v1";
    @Autowired
    private ContractDictionaryBusiService contractDictionaryBusiService;

    @Override
    public ContractQryAwardResultListBusiRspBO getAwardResultList(ContractQryAwardResultListBusiReqBO reqBO) {
        ContractQryAwardResultListBusiRspBO rspBO = new ContractQryAwardResultListBusiRspBO();
        ContractQryAwardResultListEsbReqBO contractQryAwardResultListEsbReqBO = new ContractQryAwardResultListEsbReqBO();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ESB-TOKEN", (Object)reqBO.getAuthToken());
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)contractQryAwardResultListEsbReqBO);
        contractQryAwardResultListEsbReqBO.setPage(reqBO.getPageNo());
        String s = HttpUtil.doPost(this.esbAddressId + QUERY_AWARD_RESULT_LIST_URL, JSON.toJSONString((Object)contractQryAwardResultListEsbReqBO), jsonObject.toJSONString());
        log.debug("rspStr: " + s);
        JSONObject jsonObj = JSONObject.parseObject((String)s);
        if (jsonObj.getBoolean("success").booleanValue()) {
            ContractQryAwardResultListEsbRspBO contractQryAwardResultListEsbRspBO = (ContractQryAwardResultListEsbRspBO)JSON.parseObject((String)jsonObj.get((Object)"data").toString(), ContractQryAwardResultListEsbRspBO.class);
            rspBO.setPageNo(contractQryAwardResultListEsbRspBO.getPage());
            rspBO.setRecordsTotal(contractQryAwardResultListEsbRspBO.getTotalRecord());
            rspBO.setTotal(contractQryAwardResultListEsbRspBO.getTotalPage());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u8be2\u6bd4\u7ed3\u679c\u5217\u8868\u6210\u529f");
            rspBO.setRows(contractQryAwardResultListEsbRspBO.getData());
            Map<String, String> codeAndDesc = this.contractDictionaryBusiService.queryBypCodeBackMap("REL_PURCHASE_TYPE_FZ");
            rspBO.getRows().forEach(contractAwardResultBO -> {
                contractAwardResultBO.setPurchaserResult(contractAwardResultBO.getBusinessCode() + "_" + contractAwardResultBO.getBusinessName());
                contractAwardResultBO.getItemResultVoList().forEach(contractAwardResultItemBO -> {
                    if (contractAwardResultItemBO.getItemNum() != null && contractAwardResultItemBO.getCanOrderNum() != null) {
                        contractAwardResultItemBO.setItemNumNot(Double.valueOf(contractAwardResultItemBO.getCanOrderNum().doubleValue()));
                        contractAwardResultItemBO.setOrderCount(Double.valueOf(contractAwardResultItemBO.getItemNum() - contractAwardResultItemBO.getCanOrderNum().doubleValue()));
                    }
                    if (!StringUtils.isEmpty((Object)contractAwardResultItemBO.getBuyTypeName()) && codeAndDesc.containsKey(contractAwardResultItemBO.getBuyTypeName())) {
                        contractAwardResultItemBO.setDycBuyType(Integer.valueOf((String)codeAndDesc.get(contractAwardResultItemBO.getBuyTypeName())));
                    }
                });
            });
        } else {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setTotal(0);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(jsonObj.getString("message"));
        }
        return rspBO;
    }
}

