/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractListNewBO;
import com.tydic.contract.busi.ContractQryListNewBusiService;
import com.tydic.contract.busi.bo.ContractQryListNewBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryListNewBusiRspBO;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractQryListNewBusiServiceImpl
implements ContractQryListNewBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryListNewBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ContractQryListNewBusiRspBO qryContractList(ContractQryListNewBusiReqBO reqBO) {
        Page page;
        ContractQryListNewBusiRspBO rspBO = new ContractQryListNewBusiRspBO();
        ContractInfoPO queryContractPo = new ContractInfoPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryContractPo);
        queryContractPo.setCreateTimeStart(DateTimeUtils.Date2String(queryContractPo.getCreateTimeStart()));
        queryContractPo.setCreateTimeEnd(DateTimeUtils.Date2String(queryContractPo.getCreateTimeEnd()));
        queryContractPo.setContractEffectDateStart(DateTimeUtils.Date2String(queryContractPo.getContractEffectDateStart()));
        queryContractPo.setContractEffectDateEnd(DateTimeUtils.Date2String(queryContractPo.getContractEffectDateEnd()));
        queryContractPo.setContractApprovalTimeStart(DateTimeUtils.Date2String(queryContractPo.getContractApprovalTimeStart()));
        queryContractPo.setContractApprovalTimeEnd(DateTimeUtils.Date2String(queryContractPo.getContractApprovalTimeEnd()));
        if (1 == reqBO.getIsApprovalQry()) {
            ArrayList<Long> stationIdList;
            if (2000 == reqBO.getTabId()) {
                stationIdList = new ArrayList<Long>();
                if (!CollectionUtils.isEmpty(reqBO.getUmcStationsListWebExt())) {
                    reqBO.getUmcStationsListWebExt().forEach(busiCommonStationWebBO -> stationIdList.add(busiCommonStationWebBO.getStationId()));
                    queryContractPo.setStationIdList(stationIdList);
                }
                page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByConditionUnderApproval(queryContractPo));
            } else if (2001 == reqBO.getTabId()) {
                page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByConditionApproval(queryContractPo));
            } else {
                if (2002 != reqBO.getTabId()) throw new ZTBusinessException("\u9875\u7b7e\u8f93\u5165\u6709\u8bef");
                stationIdList = new ArrayList();
                if (!CollectionUtils.isEmpty(reqBO.getUmcStationsListWebExt())) {
                    reqBO.getUmcStationsListWebExt().forEach(busiCommonStationWebBO -> stationIdList.add(busiCommonStationWebBO.getStationId()));
                    queryContractPo.setStationIdList(stationIdList);
                }
                page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByConditionAllApproval(queryContractPo));
            }
        } else {
            page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByCondition(queryContractPo));
        }
        List<ContractListNewBO> rows = this.transContractResult(page.getResult());
        rows.forEach(contractListNewBO -> {
            if (contractListNewBO.getTotalTaxAmount() != null) {
                contractListNewBO.setTotalTaxAmount(contractListNewBO.getTotalTaxAmount());
            }
            if (contractListNewBO.getTotalAmountExcludingTax() != null) {
                contractListNewBO.setTotalAmountExcludingTax(contractListNewBO.getTotalAmountExcludingTax());
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNum());
        rspBO.setTotal(page.getPages());
        rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        return rspBO;
    }

    private List<ContractListNewBO> transContractResult(List<ContractInfoPO> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractListNewBO.class);
        for (ContractListNewBO contractListNewBO : rows) {
            contractListNewBO.setCreateTime(DateTimeUtils.Date2String(contractListNewBO.getCreateTime()));
            contractListNewBO.setContractApprovalTime(DateTimeUtils.Date2String(contractListNewBO.getContractApprovalTime()));
            if (contractListNewBO.getContractStatus() != null) {
                contractListNewBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListNewBO.getContractStatus()));
            }
            if (contractListNewBO.getContractType() != null) {
                contractListNewBO.setContractTypeStr(ContractTransFieldUtil.transContractType(contractListNewBO.getContractType()));
            }
            if (contractListNewBO.getPurchaseType() != null) {
                contractListNewBO.setPurchaseTypeStr(ContractTransFieldUtil.transContractPurchaseType(contractListNewBO.getPurchaseType()));
            }
            if (StringUtils.isNotBlank((CharSequence)contractListNewBO.getErpSyncStauts())) {
                contractListNewBO.setErpSyncStautsStr(ContractTransFieldUtil.transContractErpSyncStauts(contractListNewBO.getErpSyncStauts()));
            }
            if (!StringUtils.isNotBlank((CharSequence)contractListNewBO.getMaterialSource())) continue;
            contractListNewBO.setMaterialSourceStr(ContractTransFieldUtil.transContractMaterialSource(contractListNewBO.getMaterialSource()));
        }
        return rows;
    }
}

