/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.busi.ContractDictionaryBusiService;
import com.tydic.contract.busi.ContractQryTenderReportListBusiService;
import com.tydic.contract.busi.bo.ContractQryTenderReportListBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryTenderReportListBusiRspBO;
import com.tydic.contract.busi.bo.ContractQryTenderReportListEsbReqBO;
import com.tydic.contract.busi.bo.ContractQryTenderReportListEsbRspBO;
import com.tydic.contract.utils.HttpUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ContractQryTenderReportListBusiServiceImpl
implements ContractQryTenderReportListBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryTenderReportListBusiServiceImpl.class);
    @Value(value="${ESB_ACCESS_IP}")
    private String esbAddressId;
    private static final String QUERY_AWARD_RESULT_LIST_URL = "/OSN/api/getTenderReportList/v1";
    @Autowired
    private ContractDictionaryBusiService contractDictionaryBusiService;

    @Override
    public ContractQryTenderReportListBusiRspBO getTenderReportList(ContractQryTenderReportListBusiReqBO reqBO) {
        ContractQryTenderReportListBusiRspBO rspBO = new ContractQryTenderReportListBusiRspBO();
        ContractQryTenderReportListEsbReqBO contractQryTenderReportListEsbReqBO = new ContractQryTenderReportListEsbReqBO();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ESB-TOKEN", (Object)reqBO.getAuthToken());
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)contractQryTenderReportListEsbReqBO);
        contractQryTenderReportListEsbReqBO.setPage(reqBO.getPageNo());
        String s = HttpUtil.doPost(this.esbAddressId + QUERY_AWARD_RESULT_LIST_URL, JSON.toJSONString((Object)contractQryTenderReportListEsbReqBO), jsonObject.toJSONString());
        log.debug("rspStr: " + s);
        JSONObject jsonObj = JSONObject.parseObject((String)s);
        if (jsonObj.getBoolean("success").booleanValue()) {
            ContractQryTenderReportListEsbRspBO contractQryTenderReportListEsbRspBO = (ContractQryTenderReportListEsbRspBO)JSON.parseObject((String)jsonObj.get((Object)"data").toString(), ContractQryTenderReportListEsbRspBO.class);
            rspBO.setPageNo(contractQryTenderReportListEsbRspBO.getPage());
            rspBO.setRecordsTotal(contractQryTenderReportListEsbRspBO.getTotalRecord());
            rspBO.setTotal(contractQryTenderReportListEsbRspBO.getTotalPage());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u5b9a\u6807\u7ed3\u679c\u5217\u8868\u6210\u529f");
            rspBO.setRows(contractQryTenderReportListEsbRspBO.getData());
            Map<String, String> codeAndDesc = this.contractDictionaryBusiService.queryBypCodeBackMap("REL_PURCHASE_TYPE_FZ");
            rspBO.getRows().forEach(contractTenderReportBO -> {
                contractTenderReportBO.setPurchaserResult(contractTenderReportBO.getBusinessCode() + "_" + contractTenderReportBO.getBusinessName());
                contractTenderReportBO.getItemResultVoList().forEach(contractTenderReportItemBO -> {
                    if (contractTenderReportItemBO.getItemNum() != null && contractTenderReportItemBO.getCanOrderNum() != null) {
                        contractTenderReportItemBO.setItemNumNot(Double.valueOf(contractTenderReportItemBO.getCanOrderNum().doubleValue()));
                        contractTenderReportItemBO.setOrderCount(Double.valueOf(contractTenderReportItemBO.getItemNum() - contractTenderReportItemBO.getCanOrderNum().doubleValue()));
                    }
                    if (!StringUtils.isEmpty((Object)contractTenderReportItemBO.getBuyTypeName()) && codeAndDesc.containsKey(contractTenderReportItemBO.getBuyTypeName())) {
                        contractTenderReportItemBO.setDycBuyType(Integer.valueOf((String)codeAndDesc.get(contractTenderReportItemBO.getBuyTypeName())));
                    }
                });
            });
        } else {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setTotal(0);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(jsonObj.getString("message"));
        }
        return rspBO;
    }
}

