/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.contract.ability.bo.ContractTermsInfoBO;
import com.tydic.contract.busi.ContractQryTermsListBusiService;
import com.tydic.contract.busi.bo.ContractQryTermsListBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryTermsListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractTermsPo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractQryTermsListBusiServiceImpl
implements ContractQryTermsListBusiService {
    @Autowired
    private ContractTermsMapper contractTermsMapper;

    @Override
    public ContractQryTermsListBusiRspBO qryTermsList(ContractQryTermsListBusiReqBO reqBO) {
        ContractQryTermsListBusiRspBO rspBO = new ContractQryTermsListBusiRspBO();
        ContractTermsPo po = new ContractTermsPo();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)po);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractTermsMapper.qryContractTermsList(po));
        if (!CollectionUtils.isEmpty((Collection)page.getResult())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u6761\u6b3e\u5217\u8868\u67e5\u8be2\u6210\u529f");
            List<ContractTermsInfoBO> rows = this.transResultData(page.getResult());
            for (ContractTermsInfoBO bo : rows) {
                if (bo.getCreateDeptId().equals(reqBO.getCurrentOrgId())) {
                    bo.setIsCurrentData(Boolean.valueOf(true));
                    continue;
                }
                bo.setIsCurrentData(Boolean.valueOf(false));
            }
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNum());
            rspBO.setTotal(page.getPages());
            rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return rspBO;
    }

    private List<ContractTermsInfoBO> transResultData(List<ContractTermsPo> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractTermsInfoBO.class);
        for (ContractTermsInfoBO contractTermsInfoBO : rows) {
            if (ContractConstant.TermType.TERM_TYPE_AGREE_CODE == contractTermsInfoBO.getTermType()) {
                contractTermsInfoBO.setTermTypeStr("\u534f\u8bae\u5408\u540c");
                continue;
            }
            if (ContractConstant.TermType.TERM_TYPE_ORDER_CODE == contractTermsInfoBO.getTermType()) {
                contractTermsInfoBO.setTermTypeStr("\u8ba2\u5355\u5408\u540c");
                continue;
            }
            if (ContractConstant.TermType.TERM_TYPE_ENTRY_CODE == contractTermsInfoBO.getTermType()) {
                contractTermsInfoBO.setTermTypeStr("\u5165\u9a7b\u5408\u540c");
                continue;
            }
            contractTermsInfoBO.setTermTypeStr("\u9519\u8bef\u7684\u6761\u6b3e\u7c7b\u578b");
        }
        return rows;
    }
}

