/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractBatchAdjustTaxUnitPriceAbilityService;
import com.tydic.contract.ability.bo.ContractBatchAdjustTaxUnitPriceAbilityReqBO;
import com.tydic.contract.ability.bo.ContractBatchAdjustTaxUnitPriceAbilityRspBO;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractBatchAdjustTaxUnitPriceAbilityService"})
public class ContractBatchAdjustTaxUnitPriceAbilityServiceImpl
implements ContractBatchAdjustTaxUnitPriceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractBatchAdjustTaxUnitPriceAbilityServiceImpl.class);
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;

    @PostMapping(value={"contractBatchAdjustTaxUnitPrice"})
    public ContractBatchAdjustTaxUnitPriceAbilityRspBO contractBatchAdjustTaxUnitPrice(@RequestBody ContractBatchAdjustTaxUnitPriceAbilityReqBO reqBO) {
        ContractBatchAdjustTaxUnitPriceAbilityRspBO rspBO = new ContractBatchAdjustTaxUnitPriceAbilityRspBO();
        log.info("\u6279\u91cf\u6839\u636e\u8c03\u4ef7\u516c\u5f0f\u8c03\u6574\u542b\u7a0e\u5355\u4ef7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        this.validate(reqBO);
        ArrayList<ContractInfoItemTmpPO> itemChangeIds = new ArrayList();
        if (reqBO.getTabId() == 1) {
            ContractInfoItemTmpPO qryPo = new ContractInfoItemTmpPO();
            qryPo.setUpdateApplyId(reqBO.getUpdateApplyId());
            itemChangeIds = this.contractInfoItemTmpMapper.getList(qryPo);
        } else {
            itemChangeIds = this.contractInfoItemTmpMapper.getListByItemChangeIds(reqBO.getItemChangeId());
        }
        if (CollectionUtils.isEmpty(itemChangeIds)) {
            throw new ZTBusinessException("\u67e5\u8be2\u660e\u7ec6\u4e3a\u7a7a");
        }
        ArrayList<ContractInfoItemTmpPO> updatePo = new ArrayList<ContractInfoItemTmpPO>();
        log.info("\u8c03\u4ef7\u67e5\u8be2\u660e\u6570\u636e\uff1a" + JSON.toJSONString(itemChangeIds));
        List<Map<Integer, String>> maps = this.adjustTaxUnitPrice(itemChangeIds, updatePo, reqBO);
        log.info("\u8c03\u4ef7\u8ba1\u7b97\u540e\u4ef7\u683c\uff1a" + JSON.toJSONString(updatePo));
        if (updatePo.size() > 0) {
            this.updateTaxUnitPrice(updatePo);
        }
        rspBO.setFailList(maps);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void updateTaxUnitPrice(List<ContractInfoItemTmpPO> updatePo) {
        for (ContractInfoItemTmpPO po : updatePo) {
            ContractInfoItemTmpPO set = new ContractInfoItemTmpPO();
            BeanUtils.copyProperties((Object)po, (Object)set);
            ContractInfoItemTmpPO where = new ContractInfoItemTmpPO();
            where.setItemChangeId(po.getItemChangeId());
            this.contractInfoItemTmpMapper.updateBy(set, where);
        }
    }

    public List<Map<Integer, String>> adjustTaxUnitPrice(List<ContractInfoItemTmpPO> itemChangeIds, List<ContractInfoItemTmpPO> updatePo, ContractBatchAdjustTaxUnitPriceAbilityReqBO reqBO) {
        try {
            BigDecimal averagePrice = reqBO.getAveragePrice();
            BigDecimal basePrice = reqBO.getBasePrice();
            BigDecimal releasePrice = reqBO.getReleasePrice();
            BigDecimal metalBenchmarkPrice = reqBO.getMetalBenchmarkPrice();
            BigDecimal inputPrice = reqBO.getInputPrice();
            ArrayList<Map<Integer, String>> retuanList = new ArrayList<Map<Integer, String>>();
            int i = 1;
            if (reqBO.getExpressType() == 1) {
                for (ContractInfoItemTmpPO itemChangeId : itemChangeIds) {
                    if (itemChangeId.getBidderAmount() == null) {
                        throw new ZTBusinessException("\u8c03\u4ef7\u5931\u8d25\uff0c\u4e2d\u6807\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (itemChangeId.getRate() == null) {
                        throw new ZTBusinessException("\u8c03\u4ef7\u5931\u8d25\uff0c\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    ContractInfoItemTmpPO tPo = new ContractInfoItemTmpPO();
                    tPo.setItemChangeId(itemChangeId.getItemChangeId());
                    BigDecimal taxUnitPrice = itemChangeId.getBidderAmount().add(inputPrice.subtract(basePrice));
                    if (taxUnitPrice.compareTo(BigDecimal.ZERO) > 0) {
                        tPo.setTaxUnitPrice(taxUnitPrice.setScale(4, 4));
                        BigDecimal bigDecimal = new BigDecimal(100 + itemChangeId.getRate()).divide(BigDecimal.valueOf(100L), 10, 4);
                        BigDecimal unitPriceExcludingTax = taxUnitPrice.divide(bigDecimal, 10, 4);
                        tPo.setUnitPriceExcludingTax(unitPriceExcludingTax);
                        tPo.setTaxAmount(taxUnitPrice.multiply(itemChangeId.getAmount()));
                        tPo.setNotIncludingTaxAmount(unitPriceExcludingTax.multiply(itemChangeId.getAmount()));
                        updatePo.add(tPo);
                    } else {
                        HashMap<Integer, String> rList = new HashMap<Integer, String>();
                        rList.put(i, itemChangeId.getMaterialCode());
                        retuanList.add(rList);
                    }
                    ++i;
                }
            } else if (reqBO.getExpressType() == 2) {
                for (ContractInfoItemTmpPO itemChangeId : itemChangeIds) {
                    if (itemChangeId.getBidderAmount() == null) {
                        throw new ZTBusinessException("\u8c03\u4ef7\u5931\u8d25\uff0c\u4e2d\u6807\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (itemChangeId.getRate() == null) {
                        throw new ZTBusinessException("\u8c03\u4ef7\u5931\u8d25\uff0c\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    ContractInfoItemTmpPO tPo = new ContractInfoItemTmpPO();
                    tPo.setItemChangeId(itemChangeId.getItemChangeId());
                    BigDecimal subtract = inputPrice.subtract(metalBenchmarkPrice);
                    BigDecimal divide = itemChangeId.getMetalContent().divide(BigDecimal.valueOf(1000L), 10, 4);
                    BigDecimal taxUnitPrice = subtract.multiply(divide).add(itemChangeId.getBidderAmount());
                    if (taxUnitPrice.compareTo(BigDecimal.ZERO) > 0) {
                        tPo.setTaxUnitPrice(taxUnitPrice.setScale(4, 4));
                        BigDecimal bigDecimal = new BigDecimal(100 + itemChangeId.getRate()).divide(BigDecimal.valueOf(100L), 10, 4);
                        BigDecimal unitPriceExcludingTax = taxUnitPrice.divide(bigDecimal, 10, 4);
                        tPo.setUnitPriceExcludingTax(unitPriceExcludingTax);
                        tPo.setTaxAmount(taxUnitPrice.multiply(itemChangeId.getAmount()));
                        tPo.setNotIncludingTaxAmount(unitPriceExcludingTax.multiply(itemChangeId.getAmount()));
                        updatePo.add(tPo);
                    } else {
                        HashMap<Integer, String> rList = new HashMap<Integer, String>();
                        rList.put(i, itemChangeId.getMaterialCode());
                        retuanList.add(rList);
                    }
                    ++i;
                }
            } else if (reqBO.getExpressType() == 3) {
                for (ContractInfoItemTmpPO itemChangeId : itemChangeIds) {
                    if (itemChangeId.getBidderAmount() == null) {
                        throw new ZTBusinessException("\u8c03\u4ef7\u5931\u8d25\uff0c\u4e2d\u6807\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (itemChangeId.getRate() == null) {
                        throw new ZTBusinessException("\u8c03\u4ef7\u5931\u8d25\uff0c\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    ContractInfoItemTmpPO tPo = new ContractInfoItemTmpPO();
                    tPo.setItemChangeId(itemChangeId.getItemChangeId());
                    BigDecimal subtract = inputPrice.subtract(averagePrice);
                    BigDecimal divide = subtract.divide(averagePrice, 8, RoundingMode.HALF_UP);
                    BigDecimal add = divide.add(BigDecimal.ONE);
                    BigDecimal taxUnitPrice = itemChangeId.getBidderAmount().multiply(add);
                    if (taxUnitPrice.compareTo(BigDecimal.ZERO) > 0) {
                        tPo.setTaxUnitPrice(taxUnitPrice.setScale(4, 4));
                        BigDecimal bigDecimal = new BigDecimal(100 + itemChangeId.getRate()).divide(BigDecimal.valueOf(100L), 8, RoundingMode.HALF_UP);
                        BigDecimal unitPriceExcludingTax = taxUnitPrice.divide(bigDecimal, 8, RoundingMode.HALF_UP);
                        tPo.setUnitPriceExcludingTax(unitPriceExcludingTax);
                        tPo.setTaxAmount(taxUnitPrice.multiply(itemChangeId.getAmount()));
                        tPo.setNotIncludingTaxAmount(unitPriceExcludingTax.multiply(itemChangeId.getAmount()));
                        updatePo.add(tPo);
                    } else {
                        HashMap<Integer, String> rList = new HashMap<Integer, String>();
                        rList.put(i, itemChangeId.getMaterialCode());
                        retuanList.add(rList);
                    }
                    ++i;
                }
            } else if (reqBO.getExpressType() == 4) {
                for (ContractInfoItemTmpPO itemChangeId : itemChangeIds) {
                    if (itemChangeId.getBidderAmount() == null) {
                        throw new ZTBusinessException("\u8c03\u4ef7\u5931\u8d25\uff0c\u4e2d\u6807\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (itemChangeId.getRate() == null) {
                        throw new ZTBusinessException("\u8c03\u4ef7\u5931\u8d25\uff0c\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    ContractInfoItemTmpPO tPo = new ContractInfoItemTmpPO();
                    tPo.setItemChangeId(itemChangeId.getItemChangeId());
                    BigDecimal taxUnitPrice = inputPrice.subtract(releasePrice).add(itemChangeId.getBidderAmount());
                    if (taxUnitPrice.compareTo(BigDecimal.ZERO) > 0) {
                        tPo.setTaxUnitPrice(taxUnitPrice.setScale(4, 4));
                        BigDecimal bigDecimal = new BigDecimal(100 + itemChangeId.getRate()).divide(BigDecimal.valueOf(100L), 10, 4);
                        BigDecimal unitPriceExcludingTax = taxUnitPrice.divide(bigDecimal, 10, 4);
                        tPo.setUnitPriceExcludingTax(unitPriceExcludingTax);
                        tPo.setTaxAmount(taxUnitPrice.multiply(itemChangeId.getAmount()));
                        tPo.setNotIncludingTaxAmount(unitPriceExcludingTax.multiply(itemChangeId.getAmount()));
                        updatePo.add(tPo);
                    } else {
                        HashMap<Integer, String> rList = new HashMap<Integer, String>();
                        rList.put(i, itemChangeId.getMaterialCode());
                        retuanList.add(rList);
                    }
                    ++i;
                }
            } else {
                throw new ZTBusinessException("\u516c\u5f0f\u7c7b\u578b\u6709\u8bef");
            }
            return retuanList;
        }
        catch (ZTBusinessException e) {
            log.error("\u516c\u5f0f\u8c03\u4ef7\u5931\u8d25:", (Throwable)e);
            throw new ZTBusinessException("\u516c\u5f0f\u8c03\u4ef7\u5931\u8d25:" + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u516c\u5f0f\u8c03\u4ef7\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u516c\u5f0f\u8c03\u4ef7\u5931\u8d25");
        }
    }

    public void validate(ContractBatchAdjustTaxUnitPriceAbilityReqBO reqBO) {
        if (reqBO.getTabId() == null) {
            throw new ZTBusinessException("\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getExpressType() == null) {
            throw new ZTBusinessException("\u516c\u5f0f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTabId() == 1) {
            if (reqBO.getUpdateApplyId() == null) {
                throw new ZTBusinessException("\u53d8\u66f4ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (reqBO.getTabId() == 2) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getItemChangeId())) {
                throw new ZTBusinessException("\u6240\u9009\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            throw new ZTBusinessException("\u6807\u7b7e\u5165\u53c2\u6709\u8bef");
        }
    }
}

