/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.ContractCceSyncAuditLogAbilityService;
import com.tydic.contract.ability.bo.ContractCceSyncAuditLogAbilityReqBO;
import com.tydic.contract.ability.bo.ContractCceSyncAuditLogAbilityRspBO;
import com.tydic.contract.aop.DuplicateCommitLimit;
import com.tydic.contract.busi.ContractCceSyncAuditLogBusiService;
import com.tydic.contract.busi.bo.ContractCceSyncAuditLogBusiReqBO;
import com.tydic.contract.busi.bo.ContractCceSyncAuditLogBusiRspBO;
import com.tydic.contract.dao.CContractInfoLegalAuditLogAcceptLogMapper;
import com.tydic.contract.po.CContractInfoLegalAuditLogAcceptLogPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractCceSyncAuditLogAbilityService"})
public class ContractCceSyncAuditLogAbilityServiceImpl
implements ContractCceSyncAuditLogAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractCceSyncAuditLogAbilityServiceImpl.class);
    @Autowired
    private ContractCceSyncAuditLogBusiService contractCceSyncAuditLogBusiService;
    @Autowired
    private CContractInfoLegalAuditLogAcceptLogMapper cContractInfoLegalAuditLogAcceptLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @DuplicateCommitLimit
    @PostMapping(value={"cceSyncAuditLog"})
    public ContractCceSyncAuditLogAbilityRspBO cceSyncAuditLog(@RequestBody ContractCceSyncAuditLogAbilityReqBO reqBO) {
        Date acceptTime = new Date();
        long start = System.currentTimeMillis();
        CContractInfoLegalAuditLogAcceptLogPO legalAuditLogAcceptLogPO = new CContractInfoLegalAuditLogAcceptLogPO();
        legalAuditLogAcceptLogPO.setId(this.uccBatchSequence.nextId());
        legalAuditLogAcceptLogPO.setAcceptInfo(JSONObject.toJSONString((Object)reqBO));
        legalAuditLogAcceptLogPO.setAcceptTime(acceptTime);
        ContractCceSyncAuditLogBusiReqBO busiReqBO = (ContractCceSyncAuditLogBusiReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ContractCceSyncAuditLogBusiReqBO.class);
        ContractCceSyncAuditLogBusiRspBO busiRspBO = this.contractCceSyncAuditLogBusiService.recordSyncAuditLog(busiReqBO);
        Date figureOutTime = new Date();
        long end = System.currentTimeMillis();
        legalAuditLogAcceptLogPO.setFigureOutTime(figureOutTime);
        legalAuditLogAcceptLogPO.setTimeSpent("\u8017\u65f6\uff1a" + (double)(end - start) / 1000.0);
        legalAuditLogAcceptLogPO.setFigureOutInfo(busiRspBO.getRespDesc());
        try {
            this.cContractInfoLegalAuditLogAcceptLogMapper.insert(legalAuditLogAcceptLogPO);
        }
        catch (Exception e) {
            log.info("\u8bb0\u5f55\u5ba1\u6279\u8bb0\u5f55\u540c\u6b65\u65e5\u5fd7\u62a5\u9519" + e.getMessage());
        }
        ContractCceSyncAuditLogAbilityRspBO rspBO = (ContractCceSyncAuditLogAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), ContractCceSyncAuditLogAbilityRspBO.class);
        if (busiRspBO.getDealBeginSize() != null && !busiRspBO.getDealBeginSize().equals(busiRspBO.getDealEndSize())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u63a5\u6536\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e3a" + busiRspBO.getDealBeginSize() + "\u6821\u9a8c\u5b8c\u5fc5\u586b\u4e4b\u540e\u5df2\u5904\u7406\u7684\u6570\u636e\u957f\u5ea6\u4e3a" + busiRspBO.getDealEndSize());
        }
        return rspBO;
    }
}

