/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractConsignQueryAbilityService;
import com.tydic.contract.ability.bo.ContractConsignQueryAbilityBO;
import com.tydic.contract.ability.bo.ContractConsignQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractConsignQueryAbilityRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContracRelPushCodeLogMapper;
import com.tydic.contract.dao.CContractLegalPushAuditLogMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.po.CContracRelPushCodeLogPO;
import com.tydic.contract.po.CContractLegalPushAuditLogPO;
import com.tydic.contract.po.ContractConsignQueryPO;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.api.UmcEnterpriseQryListAbilityService;
import com.tydic.umc.general.ability.api.UmcMemDetailQryListAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractConsignQueryAbilityService"})
public class ContractConsignQueryAbilityServiceImpl
implements ContractConsignQueryAbilityService {
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private CContracRelPushCodeLogMapper cContracRelPushCodeLogMapper;
    @Autowired
    private CContractLegalPushAuditLogMapper cContractLegalPushAuditLogMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private UmcEnterpriseQryListAbilityService umcEnterpriseQryListAbilityService;
    private final String YES_STR1 = "\u6b63\u5e38";
    private final String NO_STR1 = "\u53d6\u6d88";
    private final String YES_STR2 = "\u662f";
    private final String NO_STR2 = "\u5426";
    @Autowired
    private UmcMemDetailQryListAbilityService umcMemDetailQryListAbilityService;

    @PostMapping(value={"queryConsign"})
    public ContractConsignQueryAbilityRspBO queryConsign(@RequestBody ContractConsignQueryAbilityReqBO reqBO) {
        List<ContractConsignQueryPO> contractConsignQueryPOS;
        UmcEnterpriseOrgQryDetailAbilityRspBO orgQryDetailAbilityRspBO;
        UmcEnterpriseOrgQryDetailAbilityReqBO orgQryDetailAbilityReqBO;
        ContractConsignQueryAbilityRspBO rspBO = new ContractConsignQueryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getDateFrom() == null) {
            throw new ZTBusinessException("\u5165\u53c2[dateFrom]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDateTo() == null) {
            throw new ZTBusinessException("\u5165\u53c2[dateTo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrgId())) {
            throw new ZTBusinessException("\u5165\u53c2[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractConsignQueryPO searchConsignQueryPO = (ContractConsignQueryPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ContractConsignQueryPO.class);
        if (!StringUtils.isEmpty((Object)reqBO.getOrgId())) {
            orgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            orgQryDetailAbilityReqBO.setErpOrgCode(reqBO.getOrgId());
            orgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(orgQryDetailAbilityReqBO);
            if (orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO() != null && !StringUtils.isEmpty((Object)orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgCode())) {
                String buyerNo = orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgCode();
                searchConsignQueryPO.setBuynerErpNo(reqBO.getOrgId());
                Integer isPushWms = orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getIsPushWms();
                if (isPushWms == null || ContractConstant.ContractPushWmsStatus.NO.equals(isPushWms)) {
                    return rspBO;
                }
            } else {
                throw new ZTBusinessException("\u5165\u53c2[orgId]\u6ca1\u6709\u5bf9\u5e94\u7684\u673a\u6784\u6570\u636e");
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSupplierCode())) {
            orgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            orgQryDetailAbilityReqBO.setErpOrgCode(reqBO.getSupplierCode());
            orgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(orgQryDetailAbilityReqBO);
            if (orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO() != null && !StringUtils.isEmpty((Object)orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgCode())) {
                Long supplierId = orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgId();
                searchConsignQueryPO.setSupplierId(supplierId);
            } else {
                throw new ZTBusinessException("\u5165\u53c2[supplierCode]\u6ca1\u6709\u5bf9\u5e94\u7684\u673a\u6784\u6570\u636e");
            }
        }
        if (!CollectionUtils.isEmpty(contractConsignQueryPOS = this.contractInfoItemMapper.queryConsign(searchConsignQueryPO))) {
            List<CContractLegalPushAuditLogPO> cContractLegalPushAuditLogPOS;
            Set pushContractCodeSet;
            Set buyerNoSet = contractConsignQueryPOS.stream().map(ContractConsignQueryPO::getBuyerNo).collect(Collectors.toSet());
            Set supplierIdSet = contractConsignQueryPOS.stream().map(ContractConsignQueryPO::getSupplierId).collect(Collectors.toSet());
            UmcEnterpriseQryListAbilityReqBO abilityReqBO = new UmcEnterpriseQryListAbilityReqBO();
            abilityReqBO.setOrgCodeWebList(new ArrayList(buyerNoSet));
            abilityReqBO.setOrgIdWebList(new ArrayList(supplierIdSet));
            UmcEnterpriseQryListAbilityRspBO abilityRspBO = this.umcEnterpriseQryListAbilityService.qryList(abilityReqBO);
            if (!"0000".equals(abilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u67e5\u8be2erp\u7f16\u7801\u4fe1\u606f\u5931\u8d25");
            }
            if (CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                throw new ZTBusinessException("\u67e5\u8be2erp\u7f16\u7801\u4fe1\u606f\u7ed3\u679c\u5931\u8d25");
            }
            Map<Long, UmcEnterpriseOrgDetailBO> orgIdMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(UmcEnterpriseOrgDetailBO::getOrgId, o -> o));
            Map<String, UmcEnterpriseOrgDetailBO> orgCodeMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(UmcEnterpriseOrgDetailBO::getOrgCode, o -> o));
            Set contractIdSet = contractConsignQueryPOS.stream().map(ContractConsignQueryPO::getOrderId).collect(Collectors.toSet());
            List<Long> validItemContractId = this.contractInfoItemMapper.qryValidItemContract(new ArrayList<Long>(contractIdSet));
            HashMap<Long, String> legalContractCodeMap = new HashMap<Long, String>();
            List<CContracRelPushCodeLogPO> relPushCodeLogPOS = this.cContracRelPushCodeLogMapper.selectListByRelIds(new ArrayList<Long>(contractIdSet));
            if (!(CollectionUtils.isEmpty(relPushCodeLogPOS) || CollectionUtils.isEmpty(pushContractCodeSet = relPushCodeLogPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getPushContractCode())).map(CContracRelPushCodeLogPO::getPushContractCode).collect(Collectors.toSet())) || CollectionUtils.isEmpty(cContractLegalPushAuditLogPOS = this.cContractLegalPushAuditLogMapper.selectByCodes(new ArrayList<String>(pushContractCodeSet))))) {
                Map<String, List<CContractLegalPushAuditLogPO>> pushContractCodeMap = cContractLegalPushAuditLogPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getReturnLegalContractCode())).collect(Collectors.groupingBy(CContractLegalPushAuditLogPO::getContractCode));
                for (CContracRelPushCodeLogPO relPushCodeLogPO : relPushCodeLogPOS) {
                    if (StringUtils.isEmpty((Object)relPushCodeLogPO.getPushContractCode()) || !pushContractCodeMap.containsKey(relPushCodeLogPO.getPushContractCode())) continue;
                    String returnLegalContractCode = pushContractCodeMap.get(relPushCodeLogPO.getPushContractCode()).get(0).getReturnLegalContractCode();
                    legalContractCodeMap.put(relPushCodeLogPO.getRelateId(), returnLegalContractCode);
                }
            }
            ArrayList<ContractConsignQueryAbilityBO> rows = new ArrayList<ContractConsignQueryAbilityBO>();
            int i = 1;
            StringBuilder failMag = new StringBuilder();
            ArrayList<Long> failContractId = new ArrayList<Long>();
            for (ContractConsignQueryPO queryPO : contractConsignQueryPOS) {
                String erpOrgCode;
                if (failContractId.contains(queryPO.getOrderId())) continue;
                ContractConsignQueryAbilityBO bo = (ContractConsignQueryAbilityBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)queryPO), ContractConsignQueryAbilityBO.class);
                bo.setRowNo(Integer.valueOf(i++));
                if (orgCodeMap.containsKey(queryPO.getBuyerNo())) {
                    erpOrgCode = orgCodeMap.get(queryPO.getBuyerNo()).getErpOrgCode();
                    if (StringUtils.isEmpty((Object)erpOrgCode)) {
                        failMag.append("\u5408\u540c\u7f16\u53f7\uff1a");
                        failMag.append(queryPO.getContractCode());
                        failMag.append("\u4e70\u53d7\u4eba\u673a\u6784\u4fe1\u606f\u672a\u5b58\u5728erp\u5355\u4f4d\u7f16\u7801\u8bf7\u8054\u7cfb\u7ef4\u62a4");
                        failContractId.add(queryPO.getOrderId());
                        continue;
                    }
                } else {
                    failMag.append("\u5408\u540c\u7f16\u53f7\uff1a");
                    failMag.append(queryPO.getContractCode());
                    failMag.append("\u4e70\u53d7\u4eba\u673a\u6784\u4fe1\u606f\u672a\u5b58\u5728\u8bf7\u8054\u7cfb\u7ef4\u62a4");
                    failContractId.add(queryPO.getOrderId());
                    continue;
                }
                bo.setPurchaseOrgId(erpOrgCode);
                if (orgIdMap.containsKey(queryPO.getSupplierId())) {
                    erpOrgCode = orgIdMap.get(queryPO.getSupplierId()).getErpOrgCode();
                    if (StringUtils.isEmpty((Object)erpOrgCode)) {
                        failMag.append("\u5408\u540c\u7f16\u53f7\uff1a");
                        failMag.append(queryPO.getContractCode());
                        failMag.append("\u4f9b\u5e94\u5546\u673a\u6784\u4fe1\u606f\u672a\u5b58\u5728erp\u5355\u4f4d\u7f16\u7801\u8bf7\u8054\u7cfb\u7ef4\u62a4");
                        failContractId.add(queryPO.getOrderId());
                        continue;
                    }
                } else {
                    failMag.append("\u5408\u540c\u7f16\u53f7\uff1a");
                    failMag.append(queryPO.getContractCode());
                    failMag.append("\u4f9b\u5e94\u5546\u673a\u6784\u4fe1\u606f\u672a\u5b58\u5728\u8bf7\u8054\u7cfb\u7ef4\u62a4");
                    failContractId.add(queryPO.getOrderId());
                    continue;
                }
                bo.setSupplierCode(erpOrgCode);
                if (ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER.equals(queryPO.getContractStatus())) {
                    bo.setStatus("\u53d6\u6d88");
                    bo.setOrderRowStatus("\u53d6\u6d88");
                } else {
                    if (ContractConstant.SaleStatus.INVALID.equals(queryPO.getSaleStatus())) {
                        bo.setOrderRowStatus("\u53d6\u6d88");
                    } else {
                        bo.setOrderRowStatus("\u6b63\u5e38");
                    }
                    if (validItemContractId.contains(queryPO.getOrderId())) {
                        bo.setStatus("\u6b63\u5e38");
                    } else {
                        bo.setStatus("\u53d6\u6d88");
                    }
                    if (ContractConstant.SaleStatus.LIMIT.equals(queryPO.getSaleStatus())) {
                        bo.setQtyLimitStatus("\u662f");
                        bo.setDistributeQtyMax(bo.getQty());
                    } else {
                        bo.setQtyLimitStatus("\u5426");
                    }
                }
                if (legalContractCodeMap.containsKey(queryPO.getOrderId())) {
                    bo.setContractCode((String)legalContractCodeMap.get(queryPO.getOrderId()));
                } else {
                    bo.setContractCode(queryPO.getContractCode());
                }
                if (queryPO.getContractAmount() != null) {
                    bo.setContractAmount(MoneyUtils.haoToYuan(queryPO.getContractAmount()));
                }
                if (queryPO.getAmountLimit() != null) {
                    bo.setAmountLimit(MoneyUtils.haoToYuan(queryPO.getAmountLimit()));
                }
                rows.add(bo);
            }
            rspBO.setRows(rows);
            if (!StringUtils.isEmpty((Object)failMag)) {
                rspBO.setResultMessage(failMag.toString());
            }
        }
        return rspBO;
    }
}

