/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.ContractExecutionTaskAbilityService;
import com.tydic.contract.ability.bo.ContractExecutionTaskAbilityReqBO;
import com.tydic.contract.ability.bo.ContractExecutionTaskAbilityRspBO;
import com.tydic.contract.ability.bo.ContractExecutionTaskLogBO;
import com.tydic.contract.atom.ContractSendNotificationExtAtomService;
import com.tydic.contract.atom.bo.ContractSendNotificationExtAtomReqBO;
import com.tydic.contract.busi.ContractExecutionTaskBusiService;
import com.tydic.contract.busi.bo.ContractExecutionTaskBusiReqBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractExecutionTaskLogMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractExecutionTaskLogPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractExecutionTaskAbilityService"})
public class ContractExecutionTaskAbilityServiceImpl
implements ContractExecutionTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractExecutionTaskAbilityServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractExecutionTaskBusiService contractExecutionTaskBusiService;
    @Autowired
    private ContractExecutionTaskLogMapper contractExecutionTaskLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private ContractSendNotificationExtAtomService contractSendNotificationExtAtomService;

    @PostMapping(value={"executionTask"})
    public ContractExecutionTaskAbilityRspBO executionTask(@RequestBody ContractExecutionTaskAbilityReqBO reqBO) {
        ArrayList<Integer> contractTypeList = new ArrayList<Integer>();
        contractTypeList.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
        contractTypeList.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
        Integer contractStatus = ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT;
        Integer pageSize = 100;
        Integer pageNo = 1;
        Page page = PageHelper.startPage((int)pageNo, (int)pageSize).doSelectPage(() -> this.contractInfoMapper.executionTask(contractTypeList, contractStatus));
        if (!CollectionUtils.isEmpty((Collection)page.getResult())) {
            Date nowDate = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(nowDate);
            calendar.add(2, 4);
            Date changeAfter = calendar.getTime();
            for (int count = 0; count < page.getPages(); ++count) {
                page = PageHelper.startPage((int)pageNo, (int)pageSize).doSelectPage(() -> this.contractInfoMapper.executionTask(contractTypeList, contractStatus));
                List contractInfoPOS = page.getResult();
                Integer n = pageNo;
                Integer n2 = pageNo = Integer.valueOf(pageNo + 1);
                if (CollectionUtils.isEmpty((Collection)contractInfoPOS)) break;
                List<Long> contractIds = contractInfoPOS.stream().map(ContractInfoPO::getContractId).collect(Collectors.toList());
                List<ContractExecutionTaskLogPO> taskLogPOS = this.contractExecutionTaskLogMapper.selectListByContractIds(contractIds);
                ArrayList<ContractExecutionTaskLogBO> updateBOS = new ArrayList<ContractExecutionTaskLogBO>();
                ArrayList<ContractExecutionTaskLogBO> addBOS = new ArrayList<ContractExecutionTaskLogBO>();
                Map<Object, Object> contractIdMap = new HashMap();
                if (!CollectionUtils.isEmpty(taskLogPOS)) {
                    contractIdMap = taskLogPOS.stream().collect(Collectors.toMap(ContractExecutionTaskLogPO::getContractId, o -> o));
                }
                for (ContractInfoPO contractInfoPO : contractInfoPOS) {
                    ContractExecutionTaskLogPO taskLogPO = null;
                    if (contractIdMap.containsKey(contractInfoPO.getContractId()) && (taskLogPO = (ContractExecutionTaskLogPO)contractIdMap.get(contractInfoPO.getContractId())).getContractValidTime() != null && contractInfoPO.getContractValidTime() != null && taskLogPO.getContractValidTime().getTime() == contractInfoPO.getContractValidTime().getTime() && (taskLogPO.getAmountLimit() == null && contractInfoPO.getAmountLimit() == null || taskLogPO.getAmountLimit() != null && contractInfoPO.getAmountLimit() != null && taskLogPO.getAmountLimit().equals(contractInfoPO.getAmountLimit()))) continue;
                    Boolean executionStatusNotFlag = false;
                    if (contractInfoPO.getContractValidTime() != null && nowDate.before(contractInfoPO.getContractValidTime()) && changeAfter.after(contractInfoPO.getContractValidTime())) {
                        executionStatusNotFlag = true;
                    }
                    Boolean executionStatusDraftFlag = false;
                    if (contractInfoPO.getAmountLimit() != null && contractInfoPO.getOrderAmount() != null) {
                        BigDecimal amountLimit = MoneyUtils.haoToYuan(contractInfoPO.getAmountLimit());
                        BigDecimal orderAmount = MoneyUtils.haoToYuan(contractInfoPO.getOrderAmount());
                        if (amountLimit.multiply(new BigDecimal("0.7")).compareTo(orderAmount) < 0) {
                            executionStatusDraftFlag = true;
                        }
                    }
                    if (taskLogPO != null) {
                        if (executionStatusNotFlag.booleanValue() && taskLogPO.getContractValidTime() != null && contractInfoPO.getContractValidTime() != null && taskLogPO.getContractValidTime().getTime() == contractInfoPO.getContractValidTime().getTime()) {
                            executionStatusNotFlag = false;
                        }
                        if (executionStatusDraftFlag.booleanValue() && taskLogPO.getAmountLimit() != null && contractInfoPO.getAmountLimit() != null && taskLogPO.getAmountLimit().equals(contractInfoPO.getAmountLimit())) {
                            executionStatusDraftFlag = false;
                        }
                    }
                    if (!executionStatusNotFlag.booleanValue() && !executionStatusDraftFlag.booleanValue()) continue;
                    ContractExecutionTaskLogBO bo = new ContractExecutionTaskLogBO();
                    bo.setContractId(contractInfoPO.getContractId());
                    bo.setAmountLimit(contractInfoPO.getAmountLimit());
                    bo.setContractValidTime(contractInfoPO.getContractValidTime());
                    ArrayList<Long> receiveIds = new ArrayList<Long>();
                    receiveIds.add(contractInfoPO.getCreateUserId());
                    try {
                        String text;
                        if (executionStatusNotFlag.booleanValue()) {
                            text = "\u60a8\u7684\u5408\u540c" + contractInfoPO.getContractName() + contractInfoPO.getContractCode() + "\u5f53\u524d\u534f\u8bae\u6709\u6548\u671f\u4e0d\u8db34\u4e2a\u6708\uff0c\u8bf7\u77e5\u6089";
                            this.sendNotification(text, text, receiveIds, 1L);
                        }
                        if (executionStatusDraftFlag.booleanValue()) {
                            text = "\u60a8\u7684\u5408\u540c" + contractInfoPO.getContractName() + contractInfoPO.getContractCode() + "\u5f53\u524d\u534f\u8bae\u53ef\u6267\u884c\u4f59\u989d\u4e0d\u8db330%\uff0c\u8bf7\u77e5\u6089";
                            this.sendNotification(text, text, receiveIds, 1L);
                        }
                        if (taskLogPO == null) {
                            bo.setLogId(Long.valueOf(this.uccBatchSequence.nextId()));
                            bo.setCreateTime(new Date());
                            addBOS.add(bo);
                            continue;
                        }
                        bo.setLogId(taskLogPO.getLogId());
                        bo.setUpdateTime(new Date());
                        updateBOS.add(bo);
                    }
                    catch (Exception e) {
                        log.error("\u53d1\u9001\u901a\u77e5\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                }
                if (CollectionUtils.isEmpty(updateBOS) && CollectionUtils.isEmpty(addBOS)) continue;
                ContractExecutionTaskBusiReqBO busiReqBO = new ContractExecutionTaskBusiReqBO();
                busiReqBO.setAddBOS(addBOS);
                busiReqBO.setUpdateBOS(updateBOS);
                this.contractExecutionTaskBusiService.dealExecutionTask(busiReqBO);
            }
        }
        ContractExecutionTaskAbilityRspBO rspBO = new ContractExecutionTaskAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendNotification(String text, String titel, List<Long> receiveIds, Long userId) {
        ContractSendNotificationExtAtomReqBO extAtomReqBO = new ContractSendNotificationExtAtomReqBO();
        extAtomReqBO.setText(text);
        extAtomReqBO.setReceiveIds(receiveIds);
        extAtomReqBO.setTitel(titel);
        extAtomReqBO.setUserId(userId);
        this.contractSendNotificationExtAtomService.sendNotification(extAtomReqBO);
    }
}

