/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.ContractChangeDetailQueryAbilityService;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.ContractItemChangeQueryAbilityService;
import com.tydic.contract.ability.ContractItemQueryAbilityService;
import com.tydic.contract.ability.ContractPerchTranslateAbilityService;
import com.tydic.contract.ability.bo.CContractDemanderUnitBO;
import com.tydic.contract.ability.bo.ContractChangeDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractChangeDetailQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractItemChangeQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemChangeQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractItemQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractPerchTranslateAbilityReqBO;
import com.tydic.contract.ability.bo.ContractPerchTranslateAbilityRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractPerchTranslateInitMapper;
import com.tydic.contract.po.ContractPerchTranslateInitPO;
import com.tydic.contract.utils.MoneyUtil2;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractPerchTranslateAbilityService"})
public class ContractPerchTranslateAbilityServiceImpl
implements ContractPerchTranslateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractPerchTranslateAbilityServiceImpl.class);
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private ContractItemQueryAbilityService contractItemQueryAbilityService;
    @Autowired
    private ContractChangeDetailQueryAbilityService contractChangeDetailQueryAbilityService;
    @Autowired
    ContractItemChangeQueryAbilityService contractItemChangeQueryAbilityService;
    private static final Integer OPER_TYPE_MODIFY = 2;
    private static final Integer OPER_TYPE_CONTRACT = 1;
    private final String NOT_INCLUDING_TAX_AMOUNT_TOTAL = "notIncludingTaxAmountTotal";
    private final String TAX_TOTAL = "taxTotal";
    private final String dealString = "string";
    private final String dealDateDay = "dateDay";
    private final String dealBigDecimal = "bigDecimal";
    private final String dealBigDecimal2 = "bigDecimal2";
    private final String dealMoneytoPlainString = "bTPlainString";
    private final String dealMoneyCapital = "moneyCapital";
    private final String dealFixed = "fixed";
    @Autowired
    private ContractPerchTranslateInitMapper contractPerchTranslateInitMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService dycUmcEnterpriseOrgQryDetailService;

    @PostMapping(value={"dealPerchTranslate"})
    public ContractPerchTranslateAbilityRspBO dealPerchTranslate(@RequestBody ContractPerchTranslateAbilityReqBO reqBO) {
        UmcEnterpriseOrgQryDetailAbilityRspBO thirdPartyInfo;
        UmcEnterpriseOrgQryDetailAbilityRspBO secondPartyInfo;
        JSONObject orgJsonObject;
        UmcEnterpriseOrgQryDetailAbilityRspBO firstPartyInfo;
        ContractPerchTranslateAbilityRspBO rspBO = new ContractPerchTranslateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getContractId() == null && reqBO.getChangeId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPerchList())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5360\u4f4d\u7b26\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            rspBO.setPerchMap(new HashMap());
            return rspBO;
        }
        HashMap<String, String> perchMap = new HashMap<String, String>();
        List<ContractPerchTranslateInitPO> contractPerchTranslateInitPOS = this.contractPerchTranslateInitMapper.selectAll();
        Map<Object, Object> titleMap = new HashMap();
        ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO = new ContractDetailQueryAbilityRspBO();
        ContractItemQueryAbilityRspBO contractItemQueryAbilityRspBO = new ContractItemQueryAbilityRspBO();
        if (!CollectionUtils.isEmpty(contractPerchTranslateInitPOS)) {
            titleMap = contractPerchTranslateInitPOS.stream().collect(Collectors.groupingBy(ContractPerchTranslateInitPO::getDealName));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (reqBO.getContractId() != null) {
            contractDetailQueryAbilityRspBO = this.selectContractDetail(reqBO.getContractId(), OPER_TYPE_CONTRACT);
            contractItemQueryAbilityRspBO = this.selectContractItemList(reqBO.getContractId(), null, OPER_TYPE_CONTRACT);
        } else {
            contractDetailQueryAbilityRspBO = this.selectContractDetail(reqBO.getChangeId(), OPER_TYPE_MODIFY);
            contractItemQueryAbilityRspBO = this.selectContractItemList(null, reqBO.getChangeId(), OPER_TYPE_CONTRACT);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)contractDetailQueryAbilityRspBO));
        if (contractDetailQueryAbilityRspBO.getContractType() != null && (ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT.equals(contractDetailQueryAbilityRspBO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractDetailQueryAbilityRspBO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractDetailQueryAbilityRspBO.getContractType()))) {
            jsonObject.put("notIncludingTaxAmountTotal", (Object)contractDetailQueryAbilityRspBO.getContractAmountExcludingTax());
            jsonObject.put("taxTotal", (Object)contractDetailQueryAbilityRspBO.getContractTax());
        } else {
            jsonObject.put("notIncludingTaxAmountTotal", (Object)contractItemQueryAbilityRspBO.getNotIncludingTaxAmountTotal());
            jsonObject.put("taxTotal", (Object)contractItemQueryAbilityRspBO.getTaxTotal());
        }
        if (contractDetailQueryAbilityRspBO.getBuyerId() != null && (firstPartyInfo = this.getOrgInfo(null, "" + contractDetailQueryAbilityRspBO.getBuyerId())) != null && firstPartyInfo.getUmcEnterpriseOrgDetailBO() != null) {
            orgJsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)firstPartyInfo.getUmcEnterpriseOrgDetailBO()));
            for (String key : orgJsonObject.keySet()) {
                jsonObject.put("first_" + key, orgJsonObject.get((Object)key));
            }
        }
        if (contractDetailQueryAbilityRspBO.getSupplierId() != null && (secondPartyInfo = this.getOrgInfo(contractDetailQueryAbilityRspBO.getSupplierId(), null)) != null && secondPartyInfo.getUmcEnterpriseOrgDetailBO() != null) {
            orgJsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)secondPartyInfo.getUmcEnterpriseOrgDetailBO()));
            for (String key : orgJsonObject.keySet()) {
                jsonObject.put("second_" + key, orgJsonObject.get((Object)key));
            }
        }
        if (contractDetailQueryAbilityRspBO.getMultiDealerId() != null && (thirdPartyInfo = this.getOrgInfo(contractDetailQueryAbilityRspBO.getMultiDealerId(), null)) != null && thirdPartyInfo.getUmcEnterpriseOrgDetailBO() != null) {
            orgJsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)thirdPartyInfo.getUmcEnterpriseOrgDetailBO()));
            for (String key : orgJsonObject.keySet()) {
                jsonObject.put("third_" + key, orgJsonObject.get((Object)key));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)contractDetailQueryAbilityRspBO.getCContractDemanderUnitS())) {
            StringBuilder supText = new StringBuilder();
            for (CContractDemanderUnitBO each : contractDetailQueryAbilityRspBO.getCContractDemanderUnitS()) {
                supText.append("\n" + each.getOrgName());
            }
            jsonObject.replace((Object)"cContractDemanderUnitS", (Object)supText);
        }
        for (String perch : reqBO.getPerchList()) {
            if (titleMap.containsKey(perch)) {
                BigDecimal bigDecimal;
                ContractPerchTranslateInitPO po = (ContractPerchTranslateInitPO)((List)titleMap.get(perch)).get(0);
                if (po.getDealType().equals("fixed")) {
                    if (!StringUtils.isEmpty((Object)po.getDealValueName())) {
                        perchMap.put(perch, po.getDealValueName());
                    } else {
                        perchMap.put(perch, "");
                    }
                }
                if (po.getDealType().equals("string")) {
                    if (("[\u7532\u65b9-\u8054\u7cfb\u7535\u8bdd]".equals(perch) || "[\u4e59\u65b9-\u8054\u7cfb\u7535\u8bdd]".equals(perch)) && ContractConstant.purchaseContractTypeList.contains(contractDetailQueryAbilityRspBO.getContractType())) {
                        if ("[\u7532\u65b9-\u8054\u7cfb\u7535\u8bdd]".equals(perch)) {
                            if (!StringUtils.isEmpty((Object)jsonObject.getString("buyerPhone")) && !"null".equals(jsonObject.getString("buyerPhone"))) {
                                perchMap.put(perch, jsonObject.getString("buyerPhone"));
                            } else {
                                perchMap.put(perch, "");
                            }
                        }
                        if ("[\u4e59\u65b9-\u8054\u7cfb\u7535\u8bdd]".equals(perch)) {
                            if (!StringUtils.isEmpty((Object)jsonObject.getString("supplierPhone")) && !"null".equals(jsonObject.getString("supplierPhone"))) {
                                perchMap.put(perch, jsonObject.getString("supplierPhone"));
                            } else {
                                perchMap.put(perch, "");
                            }
                        }
                    } else if ("[\u4e70\u53d7\u4eba]".equals(perch)) {
                        if (!StringUtils.isEmpty((Object)jsonObject.getString(po.getDealValueName())) && !"null".equals(jsonObject.getString(po.getDealValueName()))) {
                            perchMap.put(perch, jsonObject.getString(po.getDealValueName()));
                        } else if (!StringUtils.isEmpty((Object)jsonObject.getString("buyerName")) && !"null".equals(jsonObject.getString("buyerName"))) {
                            perchMap.put(perch, jsonObject.getString("buyerName"));
                        } else {
                            perchMap.put(perch, "");
                        }
                    } else if (!StringUtils.isEmpty((Object)jsonObject.getString(po.getDealValueName())) && !"null".equals(jsonObject.getString(po.getDealValueName()))) {
                        perchMap.put(perch, jsonObject.getString(po.getDealValueName()));
                    } else {
                        perchMap.put(perch, "");
                    }
                }
                if (po.getDealType().equals("dateDay")) {
                    Date date = jsonObject.getDate(po.getDealValueName());
                    if (date != null) {
                        perchMap.put(perch, sdf.format(date));
                    } else {
                        perchMap.put(perch, "");
                    }
                }
                if (po.getDealType().equals("bigDecimal")) {
                    bigDecimal = jsonObject.getBigDecimal(po.getDealValueName());
                    if (bigDecimal != null) {
                        perchMap.put(perch, this.moneyTrans(bigDecimal.stripTrailingZeros()).toPlainString());
                    } else {
                        perchMap.put(perch, "");
                    }
                }
                if (po.getDealType().equals("bigDecimal2")) {
                    bigDecimal = jsonObject.getBigDecimal(po.getDealValueName());
                    if (bigDecimal != null) {
                        perchMap.put(perch, this.moneyTrans(bigDecimal.setScale(2, 4).stripTrailingZeros()).toPlainString());
                    } else {
                        perchMap.put(perch, "");
                    }
                }
                if (po.getDealType().equals("bTPlainString")) {
                    bigDecimal = jsonObject.getBigDecimal(po.getDealValueName());
                    if (bigDecimal != null) {
                        perchMap.put(perch, bigDecimal.toPlainString());
                    } else {
                        perchMap.put(perch, "");
                    }
                }
                if (!po.getDealType().equals("moneyCapital")) continue;
                bigDecimal = jsonObject.getBigDecimal(po.getDealValueName());
                if (bigDecimal != null) {
                    perchMap.put(perch, MoneyUtil2.convert(bigDecimal));
                    continue;
                }
                perchMap.put(perch, "");
                continue;
            }
            perchMap.put(perch, "");
        }
        if (reqBO.getPerchList().contains("[\u670d\u52a1\u8d39\u8d39\u7387]") && contractDetailQueryAbilityRspBO.getServiceRate() != null && contractDetailQueryAbilityRspBO.getServiceRateUnit() != null) {
            perchMap.put("[\u670d\u52a1\u8d39\u8d39\u7387]", contractDetailQueryAbilityRspBO.getServiceRate().toPlainString() + (contractDetailQueryAbilityRspBO.getServiceRateUnit() == 1 ? "\uff05" : "\u2030"));
        }
        rspBO.setPerchMap(perchMap);
        return rspBO;
    }

    private ContractDetailQueryAbilityRspBO selectContractDetail(Long contractId, Integer type) {
        ContractDetailQueryAbilityRspBO rsp = new ContractDetailQueryAbilityRspBO();
        if (OPER_TYPE_MODIFY.equals(type)) {
            ContractChangeDetailQueryAbilityReqBO dycContractQryApplyDetailReqBO = new ContractChangeDetailQueryAbilityReqBO();
            dycContractQryApplyDetailReqBO.setUpdateApplyId(contractId);
            log.debug("\u67e5\u8be2\u53d8\u66f4\u5408\u540c\u8be6\u60c5\u5165\u53c2\uff1a" + JSON.toJSONString((Object)dycContractQryApplyDetailReqBO));
            ContractChangeDetailQueryAbilityRspBO dycContractQryApplyDetailRspBO = this.contractChangeDetailQueryAbilityService.contractChangeDetailQuery(dycContractQryApplyDetailReqBO);
            log.debug("\u67e5\u8be2\u53d8\u66f4\u5408\u540c\u8be6\u60c5\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)dycContractQryApplyDetailRspBO));
            BeanUtils.copyProperties((Object)dycContractQryApplyDetailRspBO, (Object)rsp);
        } else {
            ContractDetailQueryAbilityReqBO dycContractQryDetailReqBO = new ContractDetailQueryAbilityReqBO();
            dycContractQryDetailReqBO.setContractId(contractId);
            log.debug("\u67e5\u8be2\u5408\u540c\u8be6\u60c5\u5165\u53c2\uff1a" + JSON.toJSONString((Object)dycContractQryDetailReqBO));
            rsp = this.contractDetailQueryAbilityService.contractDetailQuery(dycContractQryDetailReqBO);
            log.debug("\u67e5\u8be2\u5408\u540c\u8be6\u60c5\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rsp));
        }
        return rsp;
    }

    private ContractItemQueryAbilityRspBO selectContractItemList(Long contractId, Long updateApplyId, Integer type) {
        ContractItemQueryAbilityRspBO rsp = new ContractItemQueryAbilityRspBO();
        if (OPER_TYPE_MODIFY.equals(type)) {
            ContractItemChangeQueryAbilityReqBO dycContractItemChangeQueryReqBO = new ContractItemChangeQueryAbilityReqBO();
            dycContractItemChangeQueryReqBO.setUpdateApplyId(updateApplyId);
            dycContractItemChangeQueryReqBO.setPageNo(Integer.valueOf(1));
            dycContractItemChangeQueryReqBO.setPageSize(Integer.valueOf(10000));
            ContractItemChangeQueryAbilityRspBO dycContractItemChangeQueryRspBO = this.contractItemChangeQueryAbilityService.contractItemChangeQuery(dycContractItemChangeQueryReqBO);
            rsp = (ContractItemQueryAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dycContractItemChangeQueryRspBO), ContractItemQueryAbilityRspBO.class);
        } else {
            ContractItemQueryAbilityReqBO dycContractQryItemReqBO = new ContractItemQueryAbilityReqBO();
            dycContractQryItemReqBO.setContractId(contractId);
            dycContractQryItemReqBO.setPageNo(Integer.valueOf(1));
            dycContractQryItemReqBO.setPageSize(Integer.valueOf(10000));
            rsp = this.contractItemQueryAbilityService.contractItemQuery(dycContractQryItemReqBO);
            log.debug("\u67e5\u8be2\u5408\u540c\u660e\u7ec6\u4fe1\u606f\u5217\u8868\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rsp));
        }
        return rsp;
    }

    private UmcEnterpriseOrgQryDetailAbilityRspBO getOrgInfo(Long orgIdWeb, String orgCode) {
        UmcEnterpriseOrgQryDetailAbilityReqBO abilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        abilityReqBO.setOrgIdWeb(orgIdWeb);
        abilityReqBO.setOrgCode(orgCode);
        log.debug("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)abilityReqBO));
        UmcEnterpriseOrgQryDetailAbilityRspBO rsp = this.dycUmcEnterpriseOrgQryDetailService.qryEnterpriseOrgDetail(abilityReqBO);
        log.debug("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rsp));
        return rsp;
    }

    private BigDecimal moneyTrans(BigDecimal money) {
        if (money != null) {
            Pattern pattern = Pattern.compile("^[+]?([0-9]+(.[0-9]))$");
            if (!money.toPlainString().contains(".")) {
                return new BigDecimal(money.toPlainString() + ".00");
            }
            if (pattern.matcher(money.toPlainString()).matches()) {
                return money.setScale(2, 4);
            }
            return money;
        }
        return BigDecimal.ZERO;
    }
}

