/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.ContractWmsStockListQryAbilityService;
import com.tydic.contract.ability.bo.ContractWmsStockListQryReqBo;
import com.tydic.contract.ability.bo.ContractWmsStockListQryRspBo;
import com.tydic.contract.ability.bo.ContractWmsStockListQryRspBoMaterialList;
import com.tydic.contract.atom.InterFaceWmsStockListQryAtomService;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractStockTempMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.po.CContractStockTempPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.umc.general.ability.api.UmcEnterpriseQryListAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractWmsStockListQryAbilityService"})
public class ContractWmsStockListQryAbilityServiceImpl
implements ContractWmsStockListQryAbilityService {
    @Autowired
    private InterFaceWmsStockListQryAtomService interFaceWmsStockListQryAtomService;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private CContractStockTempMapper cContractStockTempMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private UmcEnterpriseQryListAbilityService umcEnterpriseQryListAbilityService;
    private static final Integer purchaseOrgIdIndex = 1;
    private static final Integer supplierCodeIndex = 2;

    @PostMapping(value={"qryWmsStockList"})
    public ContractWmsStockListQryRspBo qryWmsStockList(@RequestBody ContractWmsStockListQryReqBo reqBo) {
        this.checkReq(reqBo);
        ContractWmsStockListQryRspBo rspBo = new ContractWmsStockListQryRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        CContractStockTempPO searchPO = new CContractStockTempPO();
        searchPO.setTempId(reqBo.getTempId());
        Page page = PageHelper.startPage((int)reqBo.getPageNo(), (int)reqBo.getPageSize()).doSelectPage(() -> this.cContractStockTempMapper.queryAll(searchPO));
        List stockTempPOS = page.getResult();
        if (!CollectionUtils.isEmpty((Collection)stockTempPOS)) {
            List materialList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)stockTempPOS), ContractWmsStockListQryRspBoMaterialList.class);
            List<String> materialCodes = materialList.stream().filter(e -> !StringUtils.isEmpty((Object)e.getMaterialCode())).map(ContractWmsStockListQryRspBoMaterialList::getMaterialCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(materialCodes)) {
                throw new ZTBusinessException("\u67e5\u8be2\u5230\u7684\u7269\u6599\u660e\u7ec6\u4e2d\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            }
            List<ContractInfoItemPO> itemPOS = this.contractInfoItemMapper.getItemsByRelIdMaterialCode(reqBo.getContractId(), materialCodes);
            Map<Object, Object> itemIdMap = new HashMap();
            Map<Object, Object> orderNumMap = new HashMap();
            if (!CollectionUtils.isEmpty(itemPOS)) {
                itemIdMap = itemPOS.stream().collect(Collectors.toMap(ContractInfoItemPO::getItemId, o -> o));
                List<Long> itemIds = itemPOS.stream().map(ContractInfoItemPO::getItemId).collect(Collectors.toList());
                List<ContractOrderPo> contractOrderPos = this.contractOrderMapper.selectListByItemIds(itemIds);
                if (!CollectionUtils.isEmpty(contractOrderPos)) {
                    orderNumMap = contractOrderPos.stream().collect(Collectors.toMap(ContractOrderPo::getItemId, ContractOrderPo::getSumDoOrderNum));
                }
            }
            int serialNumber = 1;
            for (ContractWmsStockListQryRspBoMaterialList bo : materialList) {
                if (itemIdMap.containsKey(bo.getItemId())) {
                    ContractInfoItemPO infoItemPO = (ContractInfoItemPO)itemIdMap.get(bo.getItemId());
                    bo.setSaleStatus(infoItemPO.getSaleStatus());
                    BigDecimal orderNum = BigDecimal.ZERO;
                    if (orderNumMap.containsKey(bo.getItemId())) {
                        orderNum = (BigDecimal)orderNumMap.get(bo.getItemId());
                    }
                    if (infoItemPO.getAmount() == null) {
                        infoItemPO.setAmount(BigDecimal.ONE);
                    }
                    bo.setCanOrderNum(infoItemPO.getAmount().subtract(orderNum));
                    if (infoItemPO.getSaleStatus() != null) {
                        bo.setStatus(ContractTransFieldUtil.transSaleStatus(infoItemPO.getSaleStatus()));
                        if (ContractConstant.SaleStatus.VALID.equals(infoItemPO.getSaleStatus()) || ContractConstant.SaleStatus.INVALID.equals(infoItemPO.getSaleStatus())) {
                            bo.setCanOrderNumStr("-");
                        } else {
                            bo.setCanOrderNumStr(bo.getCanOrderNum().toString());
                        }
                    } else {
                        bo.setCanOrderNumStr(bo.getCanOrderNum().toString());
                    }
                }
                bo.setSerialNumber(Integer.valueOf(serialNumber++));
            }
            rspBo.setMaterialList(materialList);
        }
        rspBo.setRecordsTotal(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
        rspBo.setTotal(Integer.valueOf(page.getPages()));
        rspBo.setPageNo(Integer.valueOf(reqBo.getPageNo()));
        return rspBo;
    }

    private Map<Integer, String> getErpOrgCode(Long contractId) {
        String purchaseOrgId = null;
        String supplierCode = null;
        ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(contractId);
        if (contractInfoPO == null) {
            throw new ZTBusinessException("\u5408\u540c\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((Object)contractInfoPO.getBuyerNo())) {
            throw new ZTBusinessException("\u4e70\u53d7\u4eba\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)contractInfoPO.getSupplierId())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e3a\u7a7a");
        }
        ArrayList<String> buyerNoList = new ArrayList<String>();
        buyerNoList.add(contractInfoPO.getBuyerNo());
        ArrayList<Long> supplierIdList = new ArrayList<Long>();
        supplierIdList.add(contractInfoPO.getSupplierId());
        UmcEnterpriseQryListAbilityReqBO abilityReqBO = new UmcEnterpriseQryListAbilityReqBO();
        abilityReqBO.setOrgCodeWebList(buyerNoList);
        abilityReqBO.setOrgIdWebList(supplierIdList);
        UmcEnterpriseQryListAbilityRspBO abilityRspBO = this.umcEnterpriseQryListAbilityService.qryList(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2erp\u7f16\u7801\u4fe1\u606f\u5931\u8d25" + abilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
            throw new ZTBusinessException("\u67e5\u8be2erp\u7f16\u7801\u4fe1\u606f\u7ed3\u679c\u4e3a\u7a7a");
        }
        Map<Long, UmcEnterpriseOrgDetailBO> orgIdMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(UmcEnterpriseOrgDetailBO::getOrgId, o -> o));
        Map<String, UmcEnterpriseOrgDetailBO> orgCodeMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(UmcEnterpriseOrgDetailBO::getOrgCode, o -> o));
        if (orgIdMap.containsKey(contractInfoPO.getSupplierId())) {
            supplierCode = orgIdMap.get(contractInfoPO.getSupplierId()).getErpOrgCode();
        }
        if (StringUtils.isEmpty(supplierCode)) {
            throw new ZTBusinessException("\u5408\u540c\u4f9b\u5e94\u5546\u673a\u6784\u4fe1\u606f\u672a\u5b58\u5728erp\u5355\u4f4d\u7f16\u7801\u8bf7\u8054\u7cfb\u7ef4\u62a4");
        }
        if (orgCodeMap.containsKey(contractInfoPO.getBuyerNo())) {
            purchaseOrgId = orgCodeMap.get(contractInfoPO.getBuyerNo()).getErpOrgCode();
        }
        if (StringUtils.isEmpty(purchaseOrgId)) {
            throw new ZTBusinessException("\u5408\u540c\u4e70\u53d7\u4eba\u6784\u4fe1\u606f\u672a\u5b58\u5728erp\u5355\u4f4d\u7f16\u7801\u8bf7\u8054\u7cfb\u7ef4\u62a4");
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(purchaseOrgIdIndex, purchaseOrgId);
        map.put(supplierCodeIndex, supplierCode);
        return map;
    }

    private void checkReq(ContractWmsStockListQryReqBo reqBo) {
        if (reqBo.getContractId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTempId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static int calculateTotalPages(int totalItems, int pageSize) {
        return (int)Math.ceil((double)totalItems / (double)pageSize);
    }
}

