/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.atom.InterFaceContractSignUsersManagerManageAtomService;
import com.tydic.contract.atom.bo.InterFaceContractSignUsersManagerManageAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractSignUsersManagerManageAtomRspBO;
import com.tydic.contract.dao.ContractPushLogMapper;
import com.tydic.contract.po.ContractPushLogPO;
import com.tydic.contract.utils.HttpUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InterFaceContractSignUsersManagerManageAtomServiceImpl
implements InterFaceContractSignUsersManagerManageAtomService {
    private static final Logger log = LoggerFactory.getLogger(InterFaceContractSignUsersManagerManageAtomServiceImpl.class);
    @Value(value="${CONTRACT_SIGN_USERS_MANAGER_MANAGE_URL}")
    private String contractSignUsersManagerManageUrl;
    @Autowired
    private ContractPushLogMapper contractPushLogMapper;

    @Override
    public InterFaceContractSignUsersManagerManageAtomRspBO signUsersManagerManage(InterFaceContractSignUsersManagerManageAtomReqBO reqBO) {
        InterFaceContractSignUsersManagerManageAtomRspBO rspBO = new InterFaceContractSignUsersManagerManageAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String reqStr = JSONObject.toJSONString((Object)reqBO);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ESB-Authorization", (Object)reqBO.getAccessToken());
        try {
            String rspStr = HttpUtil.doPost(this.contractSignUsersManagerManageUrl, reqStr, jsonObject.toJSONString());
            log.info("\u7535\u5b50\u7b7e\u7ae0\u672c\u5730\u4e2a\u4eba\u7ba1\u7406\u67e5\u8be2\u63a5\u53e3\u51fa\u53c2" + rspStr);
            ContractPushLogPO insertContractPushLogPO = new ContractPushLogPO();
            insertContractPushLogPO.setId(Sequence.getInstance().nextId());
            insertContractPushLogPO.setCreateTime(new Date());
            insertContractPushLogPO.setReqJson(reqStr);
            insertContractPushLogPO.setType(7);
            insertContractPushLogPO.setRspJson(rspStr);
            try {
                this.contractPushLogMapper.insert(insertContractPushLogPO);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rspBO = this.resolveRsp(rspStr);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7535\u5b50\u7b7e\u7ae0\u672c\u5730\u4e2a\u4eba\u7ba1\u7406\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
        }
        return rspBO;
    }

    private InterFaceContractSignUsersManagerManageAtomRspBO resolveRsp(String rspStr) {
        JSONObject jsonObject;
        InterFaceContractSignUsersManagerManageAtomRspBO rspBO = new InterFaceContractSignUsersManagerManageAtomRspBO();
        try {
            if (StringUtils.isEmpty((Object)rspStr)) {
                throw new ZTBusinessException("\u62a5\u6587\u8fd4\u56de\u4e3a\u7a7a");
            }
            jsonObject = JSONObject.parseObject((String)rspStr);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7535\u5b50\u7b7e\u7ae0\u672c\u5730\u4e2a\u4eba\u7ba1\u7406\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        if (jsonObject.get((Object)"code") == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7535\u5b50\u7b7e\u7ae0\u672c\u5730\u4e2a\u4eba\u7ba1\u7406\u8fd4\u56de\u72b6\u6001\u62a5\u6587\u4e3a\u7a7a");
            if (StringUtils.isEmpty((Object)jsonObject.getString("message")) || "null".equals(jsonObject.getString("message"))) {
                String resultMessage;
                int i;
                jsonObject.getString("resultMessage");
                if (!StringUtils.isEmpty((Object)jsonObject.getString("resultMessage")) && (i = (resultMessage = jsonObject.getString("resultMessage")).indexOf("{")) != -1) {
                    JSONObject jsonObject1 = JSONObject.parseObject((String)resultMessage.substring(i));
                    rspBO.setRespDesc(jsonObject1.getString("message"));
                }
            }
            return rspBO;
        }
        if ("200".equals(jsonObject.getString("code"))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        throw new ZTBusinessException(jsonObject.getString("message"));
    }
}

