/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.atom.InterFaceContractCancelSignatureAtomService;
import com.tydic.contract.atom.bo.InterFaceContractCancelSignatureAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractCancelSignatureAtomRspBO;
import com.tydic.contract.busi.ContractCancelSignatureBusiService;
import com.tydic.contract.busi.bo.ContractCancelSignatureBusiReqBO;
import com.tydic.contract.busi.bo.ContractCancelSignatureBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractSignInitiatorInfoMapper;
import com.tydic.contract.dao.CContractSignOperLogMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractOperateNodeRecordMapper;
import com.tydic.contract.po.CContractSignInitiatorInfoPO;
import com.tydic.contract.po.CContractSignOperLogPO;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ContractCancelSignatureBusiServiceImpl
implements ContractCancelSignatureBusiService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private CContractSignInitiatorInfoMapper contractSignInitiatorInfoMapper;
    @Autowired
    private InterFaceContractCancelSignatureAtomService interFaceContractCancelSignatureAtomService;
    @Autowired
    private ContractOperateNodeRecordMapper contractOperateNodeRecordMapper;
    @Autowired
    private CContractSignOperLogMapper contractSignOperLogMapper;

    @Override
    public ContractCancelSignatureBusiRspBO cancelSignature(ContractCancelSignatureBusiReqBO reqBO) {
        ContractCancelSignatureBusiRspBO rspBO = new ContractCancelSignatureBusiRspBO();
        if (reqBO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5408\u540c\u64a4\u9500\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByEnvelopeId(reqBO.getEnvelopeId());
        if (contractInfoPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5408\u540c\u4e0d\u5b58\u5728\uff01");
            return rspBO;
        }
        if (reqBO.getEnvelopeId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4fe1\u5c01ID\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (contractInfoPO.getSignInitiatorInfoSocCreCode() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u53d1\u8d77\u65b9\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        CContractSignInitiatorInfoPO signInitiatorInfoPO = this.contractSignInitiatorInfoMapper.selectBySocCreCode(contractInfoPO.getSignInitiatorInfoSocCreCode());
        if (signInitiatorInfoPO == null || StringUtils.isEmpty((Object)signInitiatorInfoPO.getClientId()) || StringUtils.isEmpty((Object)signInitiatorInfoPO.getSecret())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5e94\u7528ID\u548cAPP Secret");
            return rspBO;
        }
        InterFaceContractCancelSignatureAtomReqBO atomReqBO = new InterFaceContractCancelSignatureAtomReqBO();
        atomReqBO.setEnvelopeId(contractInfoPO.getEnvelopeId());
        atomReqBO.setClientId(signInitiatorInfoPO.getClientId());
        atomReqBO.setSecret(signInitiatorInfoPO.getSecret());
        InterFaceContractCancelSignatureAtomRspBO atomRspBO = this.interFaceContractCancelSignatureAtomService.cancelSignature(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(atomRspBO.getRespDesc());
            return rspBO;
        }
        ContractInfoPO updatePO = new ContractInfoPO();
        updatePO.setContractId(contractInfoPO.getContractId());
        updatePO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
        this.contractInfoMapper.updateByPrimaryKeySelective(updatePO);
        CContractSignOperLogPO record = new CContractSignOperLogPO();
        record.setId(Sequence.getInstance().nextId());
        record.setEnvelopeId(contractInfoPO.getEnvelopeId());
        record.setContractId(contractInfoPO.getContractId());
        record.setOperUserId(reqBO.getMemId());
        record.setOperTime(new Date());
        record.setOperUserName(reqBO.getName());
        record.setCompanyCode(reqBO.getCompanyId().toString());
        record.setCompanyName(reqBO.getCompanyName());
        record.setOperType(ContractConstant.SignOperLogType.SIGN_INIT_BACK);
        record.setOperTypeStr("\u53d1\u8d77\u65b9\u64a4\u56de");
        record.setSocCreCode(contractInfoPO.getSignInitiatorInfoSocCreCode());
        record.setClientId(signInitiatorInfoPO.getClientId());
        record.setSecret(signInitiatorInfoPO.getSecret());
        this.contractSignOperLogMapper.insertSelective(record);
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add("SEND_SIGN");
        nodes.add("FIRST_PARTY_SIGN");
        nodes.add("SECOND_PARTY_SIGN");
        this.contractOperateNodeRecordMapper.deleteByContractIdAndNodes(contractInfoPO.getContractId(), nodes);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

