/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.contract.ability.bo.ContractAccessoryBO;
import com.tydic.contract.ability.bo.ContractPayTypeBO;
import com.tydic.contract.busi.ContractQryApplyDetailBusiService;
import com.tydic.contract.busi.bo.ContractQryApplyDetailBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryApplyDetailBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractModifyApplyMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractModifyApplyPo;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.contract.po.ContractPayTypePo;
import com.tydic.contract.po.ContractTermsPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractQryApplyDetailBusiServiceImpl
implements ContractQryApplyDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryApplyDetailBusiServiceImpl.class);
    @Autowired
    private ContractModifyApplyMapper contractModifyApplyMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractPayTypeMapper contractPayTypeMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;

    @Override
    public ContractQryApplyDetailBusiRspBO qryContractApplyDetail(ContractQryApplyDetailBusiReqBO reqBO) {
        ContractQryApplyDetailBusiRspBO rspBO = new ContractQryApplyDetailBusiRspBO();
        ContractModifyApplyPo contractModifyApplyPo = this.contractModifyApplyMapper.selectByPrimaryKey(reqBO.getUpdateApplyId());
        if (contractModifyApplyPo != null) {
            String resultJsonStr;
            BeanUtils.copyProperties((Object)contractModifyApplyPo, (Object)((Object)rspBO));
            rspBO.setContractSignDate(DateTimeUtils.Time2Date(contractModifyApplyPo.getContractSignDate()));
            rspBO.setNeedArriveTime(DateTimeUtils.Time2Date(contractModifyApplyPo.getNeedArriveTime()));
            rspBO.setContractEndDate(DateTimeUtils.Time2Date(contractModifyApplyPo.getContractEndDate()));
            try {
                rspBO.setPrePay(MoneyUtils.BigDecimal2Long((BigDecimal)contractModifyApplyPo.getPrePay()) / 10000L);
                rspBO.setDeliveryPay(MoneyUtils.BigDecimal2Long((BigDecimal)contractModifyApplyPo.getDeliveryPay()) / 10000L);
                rspBO.setInvoicePay(MoneyUtils.BigDecimal2Long((BigDecimal)contractModifyApplyPo.getInvoicePay()) / 10000L);
                rspBO.setQuaAmount(MoneyUtils.BigDecimal2Long((BigDecimal)contractModifyApplyPo.getQuaAmount()) / 10000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u5408\u540c\u53d8\u66f4\u8be6\u60c5\u67e5\u8be2-\u8f6c\u6362\u51fa\u9519\uff1a" + e.getMessage());
            }
            ContractTermsPo selectPo = new ContractTermsPo();
            if (contractModifyApplyPo.getTermCode() != null) {
                selectPo.setTermCode(contractModifyApplyPo.getTermCode());
                ContractTermsPo contractTermsPo = this.contractTermsMapper.selectByTermCode(selectPo);
                if (contractTermsPo != null) {
                    log.info("\u67e5\u8be2\u5408\u540c\u6761\u6b3e:" + contractTermsPo.getTermText());
                    rspBO.setContractTermText(contractTermsPo.getTermText());
                }
            }
            if (ContractConstant.ContractType.ORDER_CONTRACT_TYPE.equals(contractModifyApplyPo.getContractType())) {
                ContractPayTypePo queryContractPayTypePo = new ContractPayTypePo();
                queryContractPayTypePo.setRelateId(contractModifyApplyPo.getUpdateApplyId());
                queryContractPayTypePo.setRelateCode(contractModifyApplyPo.getUpdateApplyCode());
                List<ContractPayTypePo> ContractPayTypePos = this.contractPayTypeMapper.qryByCondition(queryContractPayTypePo);
                if (!CollectionUtils.isEmpty(ContractPayTypePos)) {
                    resultJsonStr = JSON.toJSONString(ContractPayTypePos);
                    List payTypes = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractPayTypeBO.class);
                    rspBO.setPayTypes(payTypes);
                    String payTypeStr = "";
                    for (ContractPayTypeBO payType : payTypes) {
                        payTypeStr = payTypeStr + payType.getPayTypeStr() + ",";
                    }
                    payTypeStr = payTypeStr.substring(0, payTypeStr.length() - 1);
                    rspBO.setPayTypeStr(payTypeStr);
                }
                ContractOrderPo queryContractOrderPo = new ContractOrderPo();
                queryContractOrderPo.setRelateId(contractModifyApplyPo.getUpdateApplyId());
                queryContractOrderPo.setRelateCode(contractModifyApplyPo.getUpdateApplyCode());
                List<ContractOrderPo> contractOrderPos = this.contractOrderMapper.selectByCondition(queryContractOrderPo);
                if (!CollectionUtils.isEmpty(contractOrderPos) && contractOrderPos.size() > 0) {
                    rspBO.setOrderId(contractOrderPos.get(0).getOrderId());
                    rspBO.setOrderCode(contractOrderPos.get(0).getOrderCode());
                }
            }
            ContractAccessoryPo queryContractAccessoryPo = new ContractAccessoryPo();
            queryContractAccessoryPo.setRelateId(contractModifyApplyPo.getUpdateApplyId());
            queryContractAccessoryPo.setRelateCode(contractModifyApplyPo.getUpdateApplyCode());
            queryContractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT);
            List<ContractAccessoryPo> contractAccessoryPos = this.contractAccessoryMapper.qryByCondition(queryContractAccessoryPo);
            if (!CollectionUtils.isEmpty(contractAccessoryPos)) {
                resultJsonStr = JSON.toJSONString(contractAccessoryPos);
                List contractAcceessoryList = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractAccessoryBO.class);
                rspBO.setContractAcceessoryList(contractAcceessoryList);
            }
            ContractAccessoryPo queryModifyAccessoryPo = new ContractAccessoryPo();
            queryModifyAccessoryPo.setRelateId(contractModifyApplyPo.getUpdateApplyId());
            queryModifyAccessoryPo.setRelateCode(contractModifyApplyPo.getUpdateApplyCode());
            queryModifyAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_MODIFY_APPLY);
            List<ContractAccessoryPo> modifyAccessoryPos = this.contractAccessoryMapper.qryByCondition(queryModifyAccessoryPo);
            if (!CollectionUtils.isEmpty(modifyAccessoryPos)) {
                String resultJsonStr2 = JSON.toJSONString(modifyAccessoryPos);
                List updateAcceessoryList = JSONArray.parseArray((String)resultJsonStr2).toJavaList(ContractAccessoryBO.class);
                rspBO.setUpdateAcceessoryList(updateAcceessoryList);
            }
            this.translate(rspBO);
            rspBO.setRespDesc("\u5408\u540c\u53d8\u66f4\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        rspBO.setRespDesc("\u5408\u540c\u53d8\u66f4\u8be6\u60c5\u67e5\u8be2\u6ca1\u6709\u6570\u636e");
        rspBO.setRespCode("1012");
        return rspBO;
    }

    private void translate(ContractQryApplyDetailBusiRspBO rspBO) {
        if (rspBO.getContractAmount() != null) {
            rspBO.setContractAmountMoney(ContractTransFieldUtil.transContractAmount(rspBO.getContractAmount()));
        }
        if (rspBO.getPayType() != null) {
            rspBO.setPayTypeStr(ContractTransFieldUtil.transPayType(rspBO.getPayType()));
        }
        if (rspBO.getOrgType() != null) {
            rspBO.setOrgTypeStr(ContractTransFieldUtil.transContractOrgType(rspBO.getOrgType()));
        }
        if (rspBO.getExpectSettle() != null) {
            rspBO.setExpectSettleStr(ContractTransFieldUtil.transExpectSettle(rspBO.getExpectSettle()));
        }
        if (rspBO.getChargeSaleCategoryFee() != null) {
            rspBO.setChargeSaleCategoryFeeStr(ContractTransFieldUtil.transChargeSaleCategoryFee(rspBO.getChargeSaleCategoryFee()));
        }
        if (rspBO.getChargeSaleCategoryFeeNode() != null) {
            rspBO.setChargeSaleCategoryFeeNodeStr(ContractTransFieldUtil.transChargeSaleCategoryFeeNode(rspBO.getChargeSaleCategoryFeeNode()));
        }
        if (rspBO.getChargeLadderRateFee() != null) {
            rspBO.setChargeLadderRateFeeStr(ContractTransFieldUtil.transChargeLadderRateFee(rspBO.getChargeLadderRateFee()));
        }
        if (rspBO.getContractType() != null) {
            rspBO.setContractTypeStr(ContractTransFieldUtil.transContractType(rspBO.getContractType()));
        }
        if (rspBO.getSupplierType() != null) {
            rspBO.setSupplierTypeStr(ContractTransFieldUtil.transSupplierType(rspBO.getSupplierType()));
        }
        if (rspBO.getContractModifyApprovalResult() != null) {
            rspBO.setContractModifyApprovalResultStr(ContractTransFieldUtil.transContractApprovalResult(rspBO.getContractModifyApprovalResult()));
        }
        if (rspBO.getBussNode() != null) {
            rspBO.setBussNodeStr(ContractTransFieldUtil.transContractBussNode(rspBO.getBussNode()));
        }
    }
}

