/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractAwardResultBO;
import com.tydic.contract.ability.bo.ContractAwardResultItemBO;
import com.tydic.contract.ability.bo.DicDictionaryBO;
import com.tydic.contract.busi.ContractDictionaryBusiService;
import com.tydic.contract.busi.ContractQryAwardResultListBusiService;
import com.tydic.contract.busi.bo.ContractQryAwardResultListBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryAwardResultListBusiRspBO;
import com.tydic.contract.busi.bo.ContractQryAwardResultListEsbReqBO;
import com.tydic.contract.busi.bo.ContractQryAwardResultListEsbRspBO;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.HttpUtil;
import com.tydic.dyc.ssc.service.scheme.SchemeQryPackCreateUserService;
import com.tydic.dyc.ssc.service.scheme.SscSchemeMatGetAwardResultExtService;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeQryPackCreateUserBO;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeQryPackCreateUserReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeQryPackCreateUserRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscGetAwardResultExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscGetAwardResultExtRspBO;
import com.tydic.umc.general.ability.api.DycUmcQueryOrgPermissionService;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionRspBo;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractQryAwardResultListBusiServiceImpl
implements ContractQryAwardResultListBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryAwardResultListBusiServiceImpl.class);
    @Value(value="${ESB_ACCESS_IP}")
    private String esbAddressId;
    private static final String QUERY_AWARD_RESULT_LIST_URL = "/OSN/api/getAwardResultList/v1";
    @Autowired
    private ContractDictionaryBusiService contractDictionaryBusiService;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private SscSchemeMatGetAwardResultExtService sscSchemeMatGetAwardResultExtService;
    @Autowired
    private DycUmcQueryOrgPermissionService dycUmcQueryOrgPermissionService;
    @Autowired
    private SchemeQryPackCreateUserService schemeQryPackCreateUserService;

    @Override
    public ContractQryAwardResultListBusiRspBO getAwardResultList(ContractQryAwardResultListBusiReqBO reqBO) {
        ContractQryAwardResultListBusiRspBO rspBO;
        block14: {
            rspBO = new ContractQryAwardResultListBusiRspBO();
            if (reqBO.getQueryAllStatus() != null && reqBO.getQueryAllStatus() == 1) {
                reqBO.setPageSize(6000);
            }
            if (ObjectUtil.isNotEmpty((Object)reqBO.getQueryType())) {
                this.getSchemeCrcAwardResultList(reqBO, rspBO);
            } else {
                this.getFzAwardResultList(reqBO, rspBO);
                if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
                    ArrayList<SchemeQryPackCreateUserBO> reqBos = new ArrayList<SchemeQryPackCreateUserBO>();
                    for (ContractAwardResultBO row : rspBO.getRows()) {
                        if (row.getSchemeType() == null || StringUtils.isEmpty((Object)row.getPackId())) continue;
                        try {
                            SchemeQryPackCreateUserBO bo = new SchemeQryPackCreateUserBO();
                            bo.setPackId(Long.valueOf(row.getPackId()));
                            bo.setSchemeType(row.getSchemeType());
                            reqBos.add(bo);
                        }
                        catch (Exception bo) {}
                    }
                    if (!CollectionUtils.isEmpty(reqBos)) {
                        log.info("\u67e5\u8be2\u975e\u62db\u5305\u539f\u59cb\u4eba\u5f00\u59cb\uff0c\u5165\u53c2" + JSONObject.toJSONString(reqBos));
                        SchemeQryPackCreateUserReqBO qryPackCreateUserReqBO = new SchemeQryPackCreateUserReqBO();
                        qryPackCreateUserReqBO.setBos(reqBos);
                        try {
                            SchemeQryPackCreateUserRspBO schemeQryPackCreateUserRspBO = this.schemeQryPackCreateUserService.qryPackCreateUser(qryPackCreateUserReqBO);
                            log.info("\u67e5\u8be2\u975e\u62db\u5305\u539f\u59cb\u4eba\u5f00\u59cb\uff0c\u51fa\u53c2" + JSONObject.toJSONString((Object)schemeQryPackCreateUserRspBO));
                            if ("0000".equals(schemeQryPackCreateUserRspBO.getRespCode())) {
                                if (!CollectionUtils.isEmpty((Collection)schemeQryPackCreateUserRspBO.getBos())) {
                                    Map<String, SchemeQryPackCreateUserBO> packIdMap = schemeQryPackCreateUserRspBO.getBos().stream().collect(Collectors.toMap(o -> o.getPackId().toString(), e -> e));
                                    for (ContractAwardResultBO row : rspBO.getRows()) {
                                        if (!packIdMap.containsKey(row.getPackId())) continue;
                                        SchemeQryPackCreateUserBO createUserBO = packIdMap.get(row.getPackId());
                                        for (ContractAwardResultItemBO contractAwardResultItemBO : row.getItemResultVoList()) {
                                            contractAwardResultItemBO.setAwardUserName(createUserBO.getAwardUserName());
                                            contractAwardResultItemBO.setAwardEmployeeNumber(createUserBO.getAwardEmployeeNumber());
                                        }
                                    }
                                }
                                break block14;
                            }
                            throw new ZTBusinessException(schemeQryPackCreateUserRspBO.getRespDesc());
                        }
                        catch (Exception e2) {
                            log.info("\u67e5\u8be2\u975e\u62db\u5305\u539f\u59cb\u4eba\u5f02\u5e38" + e2.getMessage());
                        }
                    }
                }
            }
        }
        return rspBO;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    private void getFzAwardResultList(ContractQryAwardResultListBusiReqBO reqBO, ContractQryAwardResultListBusiRspBO rspBO) {
        JSONObject jsonObject;
        ContractQryAwardResultListEsbReqBO contractQryAwardResultListEsbReqBO;
        block21: {
            contractQryAwardResultListEsbReqBO = new ContractQryAwardResultListEsbReqBO();
            jsonObject = new JSONObject();
            jsonObject.put("ESB-TOKEN", (Object)reqBO.getAuthToken());
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)contractQryAwardResultListEsbReqBO);
            contractQryAwardResultListEsbReqBO.setPage(reqBO.getPageNo());
            try {
                JSONObject jsonObject1 = JSONObject.parseObject((String)JSONObject.toJSONString((Object)contractQryAwardResultListEsbReqBO));
                JSONObject jsonObject2 = new JSONObject();
                for (String key : jsonObject1.keySet()) {
                    if ("".equals(jsonObject1.get((Object)key))) {
                        jsonObject2.put(key, null);
                        continue;
                    }
                    jsonObject2.put(key, jsonObject1.get((Object)key));
                }
                contractQryAwardResultListEsbReqBO = (ContractQryAwardResultListEsbReqBO)JSONObject.parseObject((String)jsonObject2.toJSONString(), ContractQryAwardResultListEsbReqBO.class);
            }
            catch (Exception e2) {
                if (!StringUtils.isEmpty((Object)contractQryAwardResultListEsbReqBO.getType())) break block21;
                contractQryAwardResultListEsbReqBO.setType(null);
            }
        }
        String s = HttpUtil.doPost(this.esbAddressId + QUERY_AWARD_RESULT_LIST_URL, JSON.toJSONString((Object)contractQryAwardResultListEsbReqBO), jsonObject.toJSONString());
        log.debug("rspStr: " + s);
        JSONObject jsonObj = JSONObject.parseObject((String)s);
        if (jsonObj.getBoolean("success").booleanValue()) {
            List<String> awardIds;
            ContractQryAwardResultListEsbRspBO contractQryAwardResultListEsbRspBO = (ContractQryAwardResultListEsbRspBO)JSON.parseObject((String)jsonObj.get((Object)"data").toString(), ContractQryAwardResultListEsbRspBO.class);
            rspBO.setPageNo(contractQryAwardResultListEsbRspBO.getPage());
            rspBO.setRecordsTotal(contractQryAwardResultListEsbRspBO.getTotalRecord());
            rspBO.setTotal(contractQryAwardResultListEsbRspBO.getTotalPage());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u8be2\u6bd4\u7ed3\u679c\u5217\u8868\u6210\u529f");
            rspBO.setRows(contractQryAwardResultListEsbRspBO.getData());
            Map<Object, Object> codeAndDesc = new HashMap();
            List<DicDictionaryBO> dicDictionaryBOS = this.contractDictionaryBusiService.queryBypCodeBackPo("", "REL_PURCHASE_TYPE_FZ", "");
            if (!CollectionUtils.isEmpty(dicDictionaryBOS)) {
                codeAndDesc = dicDictionaryBOS.stream().collect(Collectors.toMap(a -> a.getCode(), b -> b.getDescrip(), (first, second) -> first));
            }
            Map<Object, Object> codeItemTypeAndDesc = new HashMap();
            dicDictionaryBOS = this.contractDictionaryBusiService.queryBypCodeBackPo("", "REL_ITEM_TYPE_FZ", "");
            if (!CollectionUtils.isEmpty(dicDictionaryBOS)) {
                codeItemTypeAndDesc = dicDictionaryBOS.stream().collect(Collectors.toMap(a -> a.getCode(), b -> b.getDescrip(), (first, second) -> first));
            }
            if (!CollectionUtils.isEmpty((Collection)rspBO.getRows()) && !CollectionUtils.isEmpty(awardIds = rspBO.getRows().stream().filter(e -> !StringUtils.isEmpty((Object)e.getAwardId())).map(ContractAwardResultBO::getAwardId).collect(Collectors.toList()))) {
                List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.qryByConditionByAwardIds(awardIds);
                if (!CollectionUtils.isEmpty(contractInfoPOS)) {
                    contractInfoPOS = contractInfoPOS.stream().filter(e -> e.getContractId() != null).collect(Collectors.toList());
                }
                if (!CollectionUtils.isEmpty(contractInfoPOS)) {
                    contractInfoPOS.stream().forEach(e -> {
                        if (e.getMultiDealerFlag() == null) {
                            e.setMultiDealerFlag(0);
                        }
                    });
                    Map<Integer, List<ContractInfoPO>> multiDealerFlagMap = contractInfoPOS.stream().collect(Collectors.groupingBy(ContractInfoPO::getMultiDealerFlag));
                    List<ContractInfoPO> multiDealerPOS = multiDealerFlagMap.get(1);
                    List<Object> multiDealerContractIds = new ArrayList();
                    if (!CollectionUtils.isEmpty(multiDealerPOS)) {
                        multiDealerContractIds = multiDealerPOS.stream().map(ContractInfoPO::getContractId).collect(Collectors.toList());
                    }
                    List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.selectByAwardIds(awardIds);
                    Map<String, List<ContractInfoItemPO>> awardIdMap = contractInfoItemPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getAwardId())).collect(Collectors.groupingBy(ContractInfoItemPO::getAwardId));
                    for (ContractAwardResultBO row : rspBO.getRows()) {
                        if (StringUtils.isEmpty((Object)row.getAwardId()) || !awardIdMap.keySet().contains(row.getAwardId())) continue;
                        Long relateId = awardIdMap.get(row.getAwardId()).get(0).getRelateId();
                        if (multiDealerContractIds.contains(relateId)) {
                            row.setIsDealerFlag(Integer.valueOf(1));
                            continue;
                        }
                        row.setIsDealerFlag(Integer.valueOf(0));
                    }
                }
            }
            for (ContractAwardResultBO contractAwardResultBO : rspBO.getRows()) {
                contractAwardResultBO.setPackId(null);
                contractAwardResultBO.setPurchaserResult(contractAwardResultBO.getBusinessCode() + "_" + contractAwardResultBO.getBusinessName());
                for (ContractAwardResultItemBO contractAwardResultItemBO : contractAwardResultBO.getItemResultVoList()) {
                    if (contractAwardResultItemBO.getItemNum() != null && contractAwardResultItemBO.getCanOrderNum() != null) {
                        contractAwardResultItemBO.setItemNumNot(Double.valueOf(contractAwardResultItemBO.getCanOrderNum().doubleValue()));
                        contractAwardResultItemBO.setOrderCount(Double.valueOf(contractAwardResultItemBO.getItemNum() - contractAwardResultItemBO.getCanOrderNum().doubleValue()));
                    }
                    contractAwardResultItemBO.setAwardEmployeeNumber(contractAwardResultItemBO.getPackageEmployeeNumber());
                    contractAwardResultItemBO.setAwardUserName(contractAwardResultItemBO.getPackageUserName());
                    if (!StringUtils.isEmpty((Object)contractAwardResultItemBO.getBuyTypeName()) && codeAndDesc.containsKey(contractAwardResultItemBO.getBuyTypeName())) {
                        contractAwardResultItemBO.setDycBuyType(Integer.valueOf((String)codeAndDesc.get(contractAwardResultItemBO.getBuyTypeName())));
                    }
                    if (StringUtils.isEmpty((Object)contractAwardResultItemBO.getItemType()) || !codeItemTypeAndDesc.containsKey(contractAwardResultItemBO.getItemType())) continue;
                    contractAwardResultItemBO.setMaterialCategory(Integer.valueOf((String)codeItemTypeAndDesc.get(contractAwardResultItemBO.getItemType())));
                }
                if (!StringUtils.isEmpty((Object)contractAwardResultBO.getSchemePackageId()) && ContractQryAwardResultListBusiServiceImpl.isNumeric(contractAwardResultBO.getSchemePackageId())) {
                    try {
                        contractAwardResultBO.setPackId(Long.valueOf(contractAwardResultBO.getSchemePackageId()).toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                contractAwardResultBO.setSchemeType(contractAwardResultBO.getDycSchemeType());
            }
        } else {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setTotal(0);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(jsonObj.getString("message"));
        }
    }

    private void getSchemeCrcAwardResultList(ContractQryAwardResultListBusiReqBO reqBO, ContractQryAwardResultListBusiRspBO rspBO) {
        SscGetAwardResultExtReqBO sscGetAwardResultExtReqBO = (SscGetAwardResultExtReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), SscGetAwardResultExtReqBO.class);
        this.getAuthOrg(reqBO, sscGetAwardResultExtReqBO);
        SscGetAwardResultExtRspBO sscGetAwardResultExtRspBO = this.sscSchemeMatGetAwardResultExtService.getAwardResultList(sscGetAwardResultExtReqBO);
        if (!"0000".equals(sscGetAwardResultExtRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8be2\u6bd4\u7ed3\u679c\u5217\u8868\u67e5\u8be2|\u8c03\u7528\u91c7\u8d2d\u65b9\u6848\u4e2d\u5fc3|\u91c7\u8d2d\u65b9\u6848\u8be2\u6bd4\u7ed3\u679c\u5217\u8868\u5206\u9875\u67e5\u8be2|\u539f\u56e0: " + sscGetAwardResultExtRspBO.getRespDesc());
        }
        log.error("getSchemeCrcAwardResultList sscGetAwardResultExtRspBO:{}", (Object)JSON.toJSONString((Object)sscGetAwardResultExtRspBO));
        List contractAwardResultBOList = JSON.parseArray((String)JSON.toJSONString((Object)sscGetAwardResultExtRspBO.getRows()), ContractAwardResultBO.class);
        log.error("getSchemeCrcAwardResultList contractAwardResultBOList:{}", (Object)JSON.toJSONString((Object)contractAwardResultBOList));
        rspBO.setPageNo(sscGetAwardResultExtRspBO.getPageNo());
        rspBO.setRecordsTotal(sscGetAwardResultExtRspBO.getRecordsTotal());
        rspBO.setTotal(sscGetAwardResultExtRspBO.getTotal());
        rspBO.setRows(contractAwardResultBOList);
    }

    private void getAuthOrg(ContractQryAwardResultListBusiReqBO reqBO, SscGetAwardResultExtReqBO sscGetAwardResultExtReqBO) {
        if (ObjectUtil.isNotEmpty((Object)reqBO.getUsername())) {
            DycUmcQueryOrgPermissionReqBo dycUmcQueryOrgPermissionReqBo = new DycUmcQueryOrgPermissionReqBo();
            dycUmcQueryOrgPermissionReqBo.setPageFlag(false);
            dycUmcQueryOrgPermissionReqBo.setErpCode(reqBO.getUsername());
            DycUmcQueryOrgPermissionRspBo dycUmcQueryOrgPermissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermissionCtFast(dycUmcQueryOrgPermissionReqBo);
            ArrayList<String> authOrgIds = new ArrayList<String>();
            HashSet<String> erpCodeList = new HashSet<String>();
            if (!CollectionUtils.isEmpty((Collection)dycUmcQueryOrgPermissionRspBo.getOrgInfos())) {
                for (UmcEnterpriseOrgBO umcEnterpriseOrgBO : dycUmcQueryOrgPermissionRspBo.getOrgInfos()) {
                    authOrgIds.add(umcEnterpriseOrgBO.getOrgCode());
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)umcEnterpriseOrgBO.getErpOrgCode())) continue;
                    erpCodeList.add(umcEnterpriseOrgBO.getErpOrgCode());
                }
            } else {
                authOrgIds.add("-999999");
            }
            sscGetAwardResultExtReqBO.setAuthOrgIds(this.coverPath(authOrgIds));
            sscGetAwardResultExtReqBO.setErpCodeList(new ArrayList(erpCodeList));
        }
    }

    private List<String> coverPath(List<String> path) {
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(path)) {
            HashSet<String> delSet = new HashSet<String>();
            for (String s1 : path) {
                for (String s2 : path) {
                    if (s1.equals(s2) || !s2.startsWith(s1)) continue;
                    delSet.add(s2);
                }
            }
            ArrayList delList = new ArrayList(delSet);
            path = path.stream().filter(e -> !delList.contains(e)).collect(Collectors.toList());
        }
        return path;
    }
}

