/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractApprovalListTabAmountInfoBO;
import com.tydic.contract.ability.bo.ContractListNewBO;
import com.tydic.contract.ability.bo.ContractListNewDownBO;
import com.tydic.contract.busi.ContractQryListNewBusiService;
import com.tydic.contract.busi.bo.ContractApprovalListTabAmountBusiRspBO;
import com.tydic.contract.busi.bo.ContractQryListNewBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryListNewBusiRspBO;
import com.tydic.contract.busi.bo.ContractQryListNewDownBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.CContractOrderInfoMapper;
import com.tydic.contract.dao.CRelBuySaleContractMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractPushLogMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.CContractOrderInfoPO;
import com.tydic.contract.po.CRelBuySaleContractPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractPushLogPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.DycUmcQueryBuyerPermissionService;
import com.tydic.umc.general.ability.api.DycUmcQueryMaterialPermissionService;
import com.tydic.umc.general.ability.api.DycUmcQueryOrgPermissionService;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionBO;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionRspBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryMaterialPermissionBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryMaterialPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryMaterialPermissionRspBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryOrgPermissionRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractQryListNewBusiServiceImpl
implements ContractQryListNewBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryListNewBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private DycUmcQueryOrgPermissionService dycUmcQueryOrgPermissionService;
    @Autowired
    private DycUmcQueryMaterialPermissionService dycUmcQueryMaterialPermissionService;
    @Autowired
    private CContractOrderInfoMapper cContractOrderInfoMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private CRelBuySaleContractMapper cRelBuySaleContractMapper;
    @Autowired
    private DycUmcQueryBuyerPermissionService dycUmcQueryBuyerPermissionService;
    @Autowired
    private ContractPushLogMapper contractPushLogMapper;
    @Autowired
    private CContractInfoExtMapper cContractInfoExtMapper;
    private Map<Integer, String> tabMap = new HashMap<Integer, String>();

    ContractQryListNewBusiServiceImpl() {
        this.tabMap.put(ContractConstant.ContractApprovalTabId.TAB_ID_NO_APPROVAL, "\u5f85\u5ba1\u6279");
        this.tabMap.put(ContractConstant.ContractApprovalTabId.TAB_ID_APPROVED, "\u5df2\u5ba1\u6279");
        this.tabMap.put(ContractConstant.ContractApprovalTabId.TAB_ID_ALL, "\u5168\u90e8");
    }

    @Override
    public ContractQryListNewDownBusiRspBO qryContractDataForDown(ContractQryListNewBusiRspBO reqBO) {
        ContractQryListNewDownBusiRspBO contractQryListNewDownBusiRspBO = new ContractQryListNewDownBusiRspBO();
        ArrayList<ContractListNewDownBO> contractListNewDownBOList = new ArrayList<ContractListNewDownBO>();
        Integer recordsTota = 0;
        List rows = reqBO.getRows();
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            for (ContractListNewBO contractListNewBO : rows) {
                List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.getItemsByRelId(contractListNewBO.getContractId());
                if (CollectionUtils.isEmpty(contractInfoItemPOS)) continue;
                for (ContractInfoItemPO contractInfoItemPO : contractInfoItemPOS) {
                    BigDecimal divide;
                    ContractListNewDownBO contractListNewDownBO = new ContractListNewDownBO();
                    this.dealData(contractListNewDownBO, contractListNewBO, contractInfoItemPO);
                    if (!StringUtils.isEmpty((CharSequence)contractListNewDownBO.getCreateUserCode()) && !StringUtils.isEmpty((CharSequence)contractListNewDownBO.getCreateUserName())) {
                        contractListNewDownBO.setCreateUserCode(contractListNewDownBO.getCreateUserCode() + "-" + contractListNewDownBO.getCreateUserName());
                    }
                    if (contractListNewDownBO.getAmountLimit() != null && !contractListNewDownBO.getAmountLimit().equals(BigDecimal.ZERO)) {
                        divide = contractListNewDownBO.getAmountLimit().divide(new BigDecimal(10000));
                        contractListNewDownBO.setAmountLimit(divide);
                    } else {
                        contractListNewDownBO.setAmountLimit(BigDecimal.ZERO);
                    }
                    if (contractListNewDownBO.getContractAmount() != null && !contractListNewDownBO.getContractAmount().equals(BigDecimal.ZERO)) {
                        divide = contractListNewDownBO.getContractAmount().divide(new BigDecimal(10000));
                        contractListNewDownBO.setContractAmount(divide);
                    } else {
                        contractListNewDownBO.setContractAmount(BigDecimal.ZERO);
                    }
                    if (contractListNewDownBO.getContractAmountExcludingTax() != null && !contractListNewDownBO.getContractAmountExcludingTax().equals(BigDecimal.ZERO)) {
                        divide = contractListNewDownBO.getContractAmountExcludingTax().divide(new BigDecimal(10000));
                        contractListNewDownBO.setContractAmountExcludingTax(divide);
                    } else {
                        contractListNewDownBO.setContractAmountExcludingTax(BigDecimal.ZERO);
                    }
                    if (contractListNewDownBO.getTaxUnitPrice() != null && !contractListNewDownBO.getTaxUnitPrice().equals(BigDecimal.ZERO)) {
                        contractListNewDownBO.setTaxUnitPrice(contractListNewDownBO.getTaxUnitPrice().setScale(8, 4));
                    } else {
                        contractListNewDownBO.setTaxUnitPrice(new BigDecimal("0.00000000"));
                    }
                    if (contractListNewDownBO.getUnitPriceExcludingTax() != null && !contractListNewDownBO.getUnitPriceExcludingTax().equals(BigDecimal.ZERO)) {
                        contractListNewDownBO.setUnitPriceExcludingTax(contractListNewDownBO.getUnitPriceExcludingTax().setScale(8, 4));
                    } else {
                        contractListNewDownBO.setUnitPriceExcludingTax(new BigDecimal("0.00000000"));
                    }
                    if (!StringUtils.isEmpty((CharSequence)contractListNewDownBO.getBuyerNo()) && !StringUtils.isEmpty((CharSequence)contractListNewDownBO.getBuyerName())) {
                        contractListNewDownBO.setBuyerNo(contractListNewDownBO.getBuyerNo() + "-" + contractListNewDownBO.getBuyerName());
                    }
                    if (!StringUtils.isEmpty((CharSequence)contractListNewDownBO.getSupplierCode()) && !StringUtils.isEmpty((CharSequence)contractListNewDownBO.getSupplierName())) {
                        contractListNewDownBO.setSupplierCode(contractListNewDownBO.getSupplierCode() + "-" + contractListNewDownBO.getSupplierName());
                    }
                    contractListNewDownBO.setMaterialSourceStr(ContractTransFieldUtil.transContractMaterialSource(contractListNewBO.getMaterialSource()));
                    if (contractListNewDownBO.getContractEffectiveDate() != null && contractListNewDownBO.getContractEndDateStart() != null) {
                        contractListNewDownBO.setContractValidTime(DateTimeUtils.DateChange(contractListNewDownBO.getContractEffectiveDate()) + "\u81f3" + DateTimeUtils.DateChange(contractListNewDownBO.getContractEndDateStart()) + "");
                    }
                    if (null != contractListNewDownBO.getContractStatus()) {
                        contractListNewDownBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListNewDownBO.getContractStatus()));
                    }
                    contractListNewDownBOList.add(contractListNewDownBO);
                    Integer n = recordsTota;
                    Integer n2 = recordsTota = Integer.valueOf(recordsTota + 1);
                }
            }
        }
        contractQryListNewDownBusiRspBO.setRows(contractListNewDownBOList);
        contractQryListNewDownBusiRspBO.setRecordsTotal(recordsTota);
        return contractQryListNewDownBusiRspBO;
    }

    @Override
    public ContractApprovalListTabAmountBusiRspBO qryContractApprovalListTabAmount(ContractQryListNewBusiReqBO reqBO) {
        ArrayList<ContractApprovalListTabAmountInfoBO> infoBOList;
        DycUmcQueryMaterialPermissionRspBo dycUmcQueryMaterialPermissionRspBo;
        DycUmcQueryMaterialPermissionReqBo dycUmcQueryMaterialPermissionReqBo;
        ContractApprovalListTabAmountBusiRspBO rspBO = new ContractApprovalListTabAmountBusiRspBO();
        ContractInfoPO queryContractPo = new ContractInfoPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryContractPo);
        queryContractPo.setCreateTimeStart(DateTimeUtils.Date2String(queryContractPo.getCreateTimeStart()));
        queryContractPo.setCreateTimeEnd(DateTimeUtils.Date2String(queryContractPo.getCreateTimeEnd()));
        queryContractPo.setContractEffectDateStart(DateTimeUtils.Date2String(queryContractPo.getContractEffectDateStart()));
        queryContractPo.setContractEffectDateEnd(DateTimeUtils.Date2String(queryContractPo.getContractEffectDateEnd()));
        queryContractPo.setContractApprovalTimeStart(DateTimeUtils.Date2String(queryContractPo.getContractApprovalTimeStart()));
        queryContractPo.setContractApprovalTimeEnd(DateTimeUtils.Date2String(queryContractPo.getContractApprovalTimeEnd()));
        ArrayList purchaseContractTypes = Lists.newArrayList((Object[])new Integer[]{11, 12, 13, 20, 21, 30, 31});
        queryContractPo.setPurchaseContractTypes(purchaseContractTypes);
        if (ObjectUtil.isNotEmpty((Object)reqBO.getConfirmTabFlag()) && reqBO.getConfirmTabFlag() == 0) {
            queryContractPo.setConfirmTabNoOrgCode(String.valueOf(reqBO.getSupId()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getConfirmTabFlag()) && reqBO.getConfirmTabFlag() == 1) {
            queryContractPo.setConfirmTabYesOrgId(reqBO.getSupId());
            List<Integer> contractStatusList = queryContractPo.getContractStatusList();
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_IN_CONFIRM);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_IN_NEGOTIATION);
            queryContractPo.setContractStatusList(contractStatusList);
        }
        queryContractPo.setIsUnitMenuFlag(reqBO.getIsUnitMenuFlag());
        if (reqBO.getMaterialPermissionStatus() != null && reqBO.getMaterialPermissionStatus() == 1) {
            if (StringUtils.isEmpty((CharSequence)reqBO.getOccupation())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u7528\u6237\u7684Occupation\u7f16\u7801\u4e3a\u7a7a");
                return rspBO;
            }
            dycUmcQueryMaterialPermissionReqBo = new DycUmcQueryMaterialPermissionReqBo();
            dycUmcQueryMaterialPermissionReqBo.setErpCode(reqBO.getOccupation());
            dycUmcQueryMaterialPermissionReqBo.setNotTree("1");
            dycUmcQueryMaterialPermissionRspBo = this.dycUmcQueryMaterialPermissionService.queryMaterialPermission(dycUmcQueryMaterialPermissionReqBo);
            if ("0000".equals(dycUmcQueryMaterialPermissionRspBo.getRespCode())) {
                List materialPermissionRspBoRows = dycUmcQueryMaterialPermissionRspBo.getRows();
                List<Object> materialPermissions = new ArrayList();
                materialPermissions = materialPermissionRspBoRows.stream().filter(e -> !StringUtils.isEmpty((CharSequence)e.getCatalogCode())).map(DycUmcQueryMaterialPermissionBo::getCatalogCode).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(materialPermissions)) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u7528\u6237\u7684\u7269\u6599\u6743\u9650\u4e3a\u7a7a");
                    return rspBO;
                }
                queryContractPo.setCatalogCodes(materialPermissions);
            } else {
                throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u7269\u6599\u6743\u9650\u5931\u8d25" + dycUmcQueryMaterialPermissionRspBo.getRespDesc());
            }
        }
        if (reqBO.getOrgPermissionStatus() != null && reqBO.getOrgPermissionStatus() == 1) {
            if (StringUtils.isEmpty((CharSequence)reqBO.getOccupation())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u7528\u6237\u7684Occupation\u7f16\u7801\u4e3a\u7a7a");
                return rspBO;
            }
            dycUmcQueryMaterialPermissionReqBo = new DycUmcQueryOrgPermissionReqBo();
            dycUmcQueryMaterialPermissionReqBo.setErpCode(reqBO.getOccupation());
            dycUmcQueryMaterialPermissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermission((DycUmcQueryOrgPermissionReqBo)dycUmcQueryMaterialPermissionReqBo);
            if ("0000".equals(dycUmcQueryMaterialPermissionRspBo.getRespCode())) {
                List orgPermissions = dycUmcQueryMaterialPermissionRspBo.getRows();
                List<String> orgCodes = orgPermissions.stream().filter(e -> !StringUtils.isEmpty((CharSequence)e.getOrgCode())).map(DycUmcQueryOrgPermissionBo::getOrgCode).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgCodes)) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u7528\u6237\u7684\u5355\u4f4d\u6743\u9650\u4e3a\u7a7a");
                    return rspBO;
                }
                queryContractPo.setOrgCodes(orgCodes);
            } else {
                throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u5355\u4f4d\u6743\u9650\u5931\u8d25" + dycUmcQueryMaterialPermissionRspBo.getRespDesc());
            }
        }
        if (1 == reqBO.getIsApprovalQry()) {
            if (CollectionUtils.isEmpty(reqBO.getUmcStationsListWebExt())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u7528\u6237\u7684\u5c97\u4f4d\u6743\u9650\u4e3a\u7a7a");
                return rspBO;
            }
            Set<Integer> tabIds = this.tabMap.keySet();
            int i = 0;
            infoBOList = new ArrayList<ContractApprovalListTabAmountInfoBO>();
            for (Integer tabId : tabIds) {
                Page page;
                ArrayList<Long> stationIdList;
                if (CollectionUtils.isEmpty(reqBO.getContractStatusList())) {
                    queryContractPo.setContractStatusList(this.transTabIdToContractStatus(tabId));
                } else {
                    List<Integer> statusList = this.transTabIdToContractStatus(tabId);
                    int a = 0;
                    for (Integer integer : statusList) {
                        for (Integer integer1 : reqBO.getContractStatusList()) {
                            if (!integer1.equals(integer)) continue;
                            ++a;
                        }
                    }
                    if (a == 0) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u6210\u529f");
                        return rspBO;
                    }
                }
                if (2000 == tabId) {
                    stationIdList = new ArrayList<Long>();
                    if (!CollectionUtils.isEmpty(reqBO.getUmcStationsListWebExt())) {
                        reqBO.getUmcStationsListWebExt().forEach(busiCommonStationWebBO -> stationIdList.add(busiCommonStationWebBO.getStationId()));
                        queryContractPo.setStationIdList(stationIdList);
                    }
                    queryContractPo.setApprovalQryUserId(reqBO.getUserId());
                    page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByConditionUnderApproval(queryContractPo));
                } else if (2001 == tabId) {
                    page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByConditionApproval(queryContractPo));
                } else if (2002 == tabId) {
                    stationIdList = new ArrayList();
                    if (!CollectionUtils.isEmpty(reqBO.getUmcStationsListWebExt())) {
                        reqBO.getUmcStationsListWebExt().forEach(busiCommonStationWebBO -> stationIdList.add(busiCommonStationWebBO.getStationId()));
                        queryContractPo.setStationIdList(stationIdList);
                    }
                    queryContractPo.setApprovalQryUserId(reqBO.getUserId());
                    page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByConditionAllApproval(queryContractPo));
                } else {
                    throw new ZTBusinessException("\u9875\u7b7e\u8f93\u5165\u6709\u8bef");
                }
                ContractApprovalListTabAmountInfoBO infoBO = new ContractApprovalListTabAmountInfoBO();
                infoBO.setTabAmount(Integer.valueOf(String.valueOf(page.getTotal())));
                infoBO.setTabId(tabId);
                infoBO.setTabName(this.tabMap.get(tabId));
                infoBO.setTabOrder(Integer.valueOf(++i));
                infoBOList.add(infoBO);
            }
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5165\u53c2\u9519\u8bef\uff0c\u6ca1\u6709\u662f\u5426\u5ba1\u6279\u67e5\u8be2\u6807\u8bc6");
            return rspBO;
        }
        rspBO.setRows(infoBOList);
        return rspBO;
    }

    public void dealData(ContractListNewDownBO contractListNewDownBO, ContractListNewBO contractListNewBO, ContractInfoItemPO contractInfoItemPO) {
        BeanUtils.copyProperties((Object)contractListNewBO, (Object)contractListNewDownBO);
        contractListNewDownBO.setMaterialCode(contractInfoItemPO.getMaterialCode());
        contractListNewDownBO.setMaterialName(contractInfoItemPO.getMaterialName());
        contractListNewDownBO.setModel(contractInfoItemPO.getModel());
        contractListNewDownBO.setBuyCount(contractInfoItemPO.getAmount());
        contractListNewDownBO.setTaxUnitPrice(contractInfoItemPO.getTaxUnitPrice());
        contractListNewDownBO.setUnitPriceExcludingTax(contractInfoItemPO.getUnitPriceExcludingTax());
        contractListNewDownBO.setRate(contractInfoItemPO.getRate());
        contractListNewDownBO.setInventoryOrganization(contractInfoItemPO.getInventoryOrganization());
        contractListNewDownBO.setAmountLimit(contractListNewBO.getAmountLimit() == null ? BigDecimal.ZERO : contractListNewBO.getAmountLimit());
        contractListNewDownBO.setBrandOrigin(contractInfoItemPO.getBrandOrigin());
        contractListNewDownBO.setRemark(contractInfoItemPO.getRemark());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ContractQryListNewBusiRspBO qryContractList(ContractQryListNewBusiReqBO reqBO) {
        Page page;
        ContractQryListNewBusiRspBO rspBO;
        block54: {
            ContractInfoPO queryContractPo;
            block55: {
                ArrayList<Long> stationIdList;
                DycUmcQueryMaterialPermissionRspBo dycUmcQueryMaterialPermissionRspBo;
                DycUmcQueryMaterialPermissionReqBo dycUmcQueryMaterialPermissionReqBo;
                rspBO = new ContractQryListNewBusiRspBO();
                queryContractPo = new ContractInfoPO();
                BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryContractPo);
                queryContractPo.setCreateTimeStart(DateTimeUtils.Date2String(queryContractPo.getCreateTimeStart()));
                queryContractPo.setCreateTimeEnd(DateTimeUtils.Date2String(queryContractPo.getCreateTimeEnd()));
                queryContractPo.setContractEffectDateStart(DateTimeUtils.Date2String(queryContractPo.getContractEffectDateStart()));
                queryContractPo.setContractEffectDateEnd(DateTimeUtils.Date2String(queryContractPo.getContractEffectDateEnd()));
                queryContractPo.setContractApprovalTimeStart(DateTimeUtils.Date2String(queryContractPo.getContractApprovalTimeStart()));
                queryContractPo.setContractApprovalTimeEnd(DateTimeUtils.Date2String(queryContractPo.getContractApprovalTimeEnd()));
                ArrayList purchaseContractTypes = Lists.newArrayList((Object[])new Integer[]{11, 12, 13, 20, 21, 30, 31});
                queryContractPo.setPurchaseContractTypes(purchaseContractTypes);
                if (ObjectUtil.isNotEmpty((Object)reqBO.getConfirmTabFlag()) && reqBO.getConfirmTabFlag() == 0) {
                    queryContractPo.setConfirmTabNoOrgCode(String.valueOf(reqBO.getSupId()));
                }
                if (ObjectUtil.isNotEmpty((Object)reqBO.getConfirmTabFlag()) && reqBO.getConfirmTabFlag() == 1) {
                    queryContractPo.setConfirmTabYesOrgId(reqBO.getSupId());
                    List<Integer> contractStatusList = queryContractPo.getContractStatusList();
                    contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_IN_CONFIRM);
                    contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_IN_NEGOTIATION);
                    queryContractPo.setContractStatusList(contractStatusList);
                }
                queryContractPo.setIsUnitMenuFlag(reqBO.getIsUnitMenuFlag());
                if (reqBO.getMaterialPermissionStatus() != null && reqBO.getMaterialPermissionStatus() == 1) {
                    if (StringUtils.isEmpty((CharSequence)reqBO.getOccupation())) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u7528\u6237\u7684Occupation\u7f16\u7801\u4e3a\u7a7a");
                        rspBO.setRows(null);
                        rspBO.setPageNo(1);
                        rspBO.setTotal(0);
                        rspBO.setRecordsTotal(0);
                        return rspBO;
                    }
                    dycUmcQueryMaterialPermissionReqBo = new DycUmcQueryMaterialPermissionReqBo();
                    dycUmcQueryMaterialPermissionReqBo.setErpCode(reqBO.getOccupation());
                    dycUmcQueryMaterialPermissionReqBo.setNotTree("1");
                    dycUmcQueryMaterialPermissionRspBo = this.dycUmcQueryMaterialPermissionService.queryMaterialPermission(dycUmcQueryMaterialPermissionReqBo);
                    if (!"0000".equals(dycUmcQueryMaterialPermissionRspBo.getRespCode())) {
                        throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u7269\u6599\u6743\u9650\u5931\u8d25" + dycUmcQueryMaterialPermissionRspBo.getRespDesc());
                    }
                    List materialPermissionRspBoRows = dycUmcQueryMaterialPermissionRspBo.getRows();
                    ArrayList arrayList = new ArrayList();
                    List<String> list = materialPermissionRspBoRows.stream().filter(e -> !StringUtils.isEmpty((CharSequence)e.getCatalogCode())).map(DycUmcQueryMaterialPermissionBo::getCatalogCode).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(list)) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u7528\u6237\u7684\u7269\u6599\u6743\u9650\u4e3a\u7a7a");
                        rspBO.setRows(null);
                        rspBO.setPageNo(1);
                        rspBO.setTotal(0);
                        rspBO.setRecordsTotal(0);
                        return rspBO;
                    }
                    queryContractPo.setCatalogCodes(list);
                }
                if (reqBO.getOrgPermissionStatus() != null && reqBO.getOrgPermissionStatus() == 1) {
                    if (StringUtils.isEmpty((CharSequence)reqBO.getOccupation())) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u7528\u6237\u7684Occupation\u7f16\u7801\u4e3a\u7a7a");
                        rspBO.setRows(null);
                        rspBO.setPageNo(1);
                        rspBO.setTotal(0);
                        rspBO.setRecordsTotal(0);
                        return rspBO;
                    }
                    dycUmcQueryMaterialPermissionReqBo = new DycUmcQueryOrgPermissionReqBo();
                    dycUmcQueryMaterialPermissionReqBo.setErpCode(reqBO.getOccupation());
                    dycUmcQueryMaterialPermissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermission((DycUmcQueryOrgPermissionReqBo)dycUmcQueryMaterialPermissionReqBo);
                    if (!"0000".equals(dycUmcQueryMaterialPermissionRspBo.getRespCode())) {
                        throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u5355\u4f4d\u6743\u9650\u5931\u8d25" + dycUmcQueryMaterialPermissionRspBo.getRespDesc());
                    }
                    List orgPermissions = dycUmcQueryMaterialPermissionRspBo.getRows();
                    List<String> list = orgPermissions.stream().filter(e -> !StringUtils.isEmpty((CharSequence)e.getOrgCode())).map(DycUmcQueryOrgPermissionBo::getOrgCode).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(list)) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u7528\u6237\u7684\u5355\u4f4d\u6743\u9650\u4e3a\u7a7a");
                        rspBO.setRows(null);
                        rspBO.setPageNo(1);
                        rspBO.setTotal(0);
                        rspBO.setRecordsTotal(0);
                        return rspBO;
                    }
                    queryContractPo.setOrgCodes(list);
                }
                if (1 != reqBO.getIsApprovalQry()) break block55;
                if (CollectionUtils.isEmpty(reqBO.getUmcStationsListWebExt())) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u7528\u6237\u7684\u5c97\u4f4d\u6743\u9650\u4e3a\u7a7a");
                    rspBO.setRows(null);
                    rspBO.setPageNo(1);
                    rspBO.setTotal(0);
                    rspBO.setRecordsTotal(0);
                    return rspBO;
                }
                if (2000 == reqBO.getTabId()) {
                    stationIdList = new ArrayList<Long>();
                    if (!CollectionUtils.isEmpty(reqBO.getUmcStationsListWebExt())) {
                        reqBO.getUmcStationsListWebExt().forEach(busiCommonStationWebBO -> stationIdList.add(busiCommonStationWebBO.getStationId()));
                        queryContractPo.setStationIdList(stationIdList);
                    }
                    queryContractPo.setApprovalQryUserId(reqBO.getUserId());
                    page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByConditionUnderApproval(queryContractPo));
                    break block54;
                } else if (2001 == reqBO.getTabId()) {
                    page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByConditionApproval(queryContractPo));
                    break block54;
                } else {
                    if (2002 != reqBO.getTabId()) {
                        throw new ZTBusinessException("\u9875\u7b7e\u8f93\u5165\u6709\u8bef");
                    }
                    stationIdList = new ArrayList();
                    if (!CollectionUtils.isEmpty(reqBO.getUmcStationsListWebExt())) {
                        reqBO.getUmcStationsListWebExt().forEach(busiCommonStationWebBO -> stationIdList.add(busiCommonStationWebBO.getStationId()));
                        queryContractPo.setStationIdList(stationIdList);
                    }
                    page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByConditionAllApproval(queryContractPo));
                }
                break block54;
            }
            if (reqBO.getIsAdmin() == null || !"1".equals(reqBO.getIsAdmin().toString())) {
                if ("1".equals(reqBO.getOrgPermissionFlag())) {
                    if (StringUtils.isEmpty((CharSequence)reqBO.getOccupation())) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("erp\u7528\u6237\u7f16\u7801\u4e3a\u7a7a");
                        rspBO.setRows(new ArrayList());
                        return rspBO;
                    }
                    DycUmcQueryOrgPermissionReqBo dycUmcQueryOrgPermissionReqBo = new DycUmcQueryOrgPermissionReqBo();
                    dycUmcQueryOrgPermissionReqBo.setErpCode(reqBO.getOccupation());
                    DycUmcQueryOrgPermissionRspBo dycUmcQueryOrgPermissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermission(dycUmcQueryOrgPermissionReqBo);
                    if (!"0000".equals(dycUmcQueryOrgPermissionRspBo.getRespCode())) {
                        throw new ZTBusinessException("\u67e5\u8be2\u5355\u4f4d\u6743\u9650\u5f02\u5e38\uff1a" + dycUmcQueryOrgPermissionRspBo.getRespDesc());
                    }
                    if (CollectionUtils.isEmpty((Collection)dycUmcQueryOrgPermissionRspBo.getRows())) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u6ca1\u6709\u5355\u4f4d\u6743\u9650");
                        rspBO.setRows(new ArrayList());
                        return rspBO;
                    }
                    List<String> list = dycUmcQueryOrgPermissionRspBo.getRows().stream().filter(a -> !StringUtils.isEmpty((CharSequence)a.getOrgCode())).map(a -> a.getOrgCode()).distinct().collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(list)) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u6ca1\u6709\u5355\u4f4d\u6743\u9650");
                        rspBO.setRows(new ArrayList());
                        return rspBO;
                    }
                    queryContractPo.setCreateDeptCodes(list);
                }
                if (reqBO.getBuyerPermission() != null && reqBO.getBuyerPermission() == 1) {
                    if (StringUtils.isEmpty((CharSequence)reqBO.getOccupation())) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u7528\u6237\u7684Occupation\u7f16\u7801\u4e3a\u7a7a");
                        rspBO.setRows(null);
                        rspBO.setPageNo(1);
                        rspBO.setTotal(0);
                        rspBO.setRecordsTotal(0);
                        return rspBO;
                    }
                    DycUmcQueryBuyerPermissionReqBo dycUmcQueryBuyerPermissionReqBo = new DycUmcQueryBuyerPermissionReqBo();
                    dycUmcQueryBuyerPermissionReqBo.setErpCode(reqBO.getOccupation());
                    DycUmcQueryBuyerPermissionRspBo dycUmcQueryBuyerPermissionRspBo = this.dycUmcQueryBuyerPermissionService.queryBuyerPermission(dycUmcQueryBuyerPermissionReqBo);
                    if (!"0000".equals(dycUmcQueryBuyerPermissionRspBo.getRespCode())) {
                        throw new ZTBusinessException("\u67e5\u8be2\u4e70\u53d7\u4eba\u6743\u9650\u5931\u8d25" + dycUmcQueryBuyerPermissionRspBo.getRespDesc());
                    }
                    List list = dycUmcQueryBuyerPermissionRspBo.getRows();
                    List<String> list2 = list.stream().filter(e -> !StringUtils.isEmpty((CharSequence)e.getOrgCode())).map(DycUmcQueryBuyerPermissionBO::getOrgCode).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(list2)) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u4e70\u53d7\u4eba\u6743\u9650\u6743\u9650\u4e3a\u7a7a");
                        rspBO.setRows(null);
                        rspBO.setPageNo(1);
                        rspBO.setTotal(0);
                        rspBO.setRecordsTotal(0);
                        return rspBO;
                    }
                    if (ObjectUtil.isNotEmpty((Object)reqBO.getConfirmTabFlag()) && reqBO.getConfirmTabFlag() == 0) {
                        queryContractPo.setConfirmTabNoOrgCode(null);
                        queryContractPo.setConfirmTabNoOrgCodes(list2);
                    } else if (ObjectUtil.isNotEmpty((Object)reqBO.getConfirmTabFlag()) && reqBO.getConfirmTabFlag() == 1) {
                        queryContractPo.setConfirmTabYesOrgId(null);
                        queryContractPo.setConfirmTabYesOrgCodes(list2);
                    } else {
                        queryContractPo.setBuyerNos(list2);
                    }
                }
            }
            if (ObjectUtil.isNotEmpty((Object)reqBO.getIsAdmin()) && "1".equals(reqBO.getIsAdmin().toString()) && ObjectUtil.isNotEmpty((Object)reqBO.getBuyerPermission()) && reqBO.getBuyerPermission() == 1) {
                queryContractPo.setConfirmTabNoOrgCode(null);
                queryContractPo.setConfirmTabYesOrgId(null);
            }
            if (1008 == reqBO.getTabId() || 1009 == reqBO.getTabId()) {
                ArrayList<Integer> contractTypes;
                if (StringUtils.isEmpty((CharSequence)reqBO.getIsprofess())) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u7528\u6237\u7684\u673a\u6784\u7c7b\u578b\u4e3a\u7a7a");
                    rspBO.setRows(null);
                    rspBO.setPageNo(1);
                    rspBO.setTotal(0);
                    rspBO.setRecordsTotal(0);
                    return rspBO;
                }
                if (reqBO.getIsListNoApprovalQryUnitMenuFlag() == null) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u83dc\u5355\u7c7b\u578b\u4e3a\u7a7a");
                    rspBO.setRows(null);
                    rspBO.setPageNo(1);
                    rspBO.setTotal(0);
                    rspBO.setRecordsTotal(0);
                    return rspBO;
                }
                if (reqBO.getIsListNoApprovalQryUnitMenuFlag() == 0) {
                    if (!"0".equals(reqBO.getIsprofess())) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u5e73\u53f0\u5408\u540c\u7684\u9500\u552e\u5408\u540c\u53ea\u80fd\u662f\u8fd0\u8425\u5355\u4f4d\u53bb\u786e\u8ba4");
                        rspBO.setRows(null);
                        rspBO.setPageNo(1);
                        rspBO.setTotal(0);
                        rspBO.setRecordsTotal(0);
                        return rspBO;
                    }
                    if (StringUtils.isEmpty((CharSequence)reqBO.getSellerUserCode())) {
                        if (StringUtils.isEmpty((CharSequence)reqBO.getOccupation())) {
                            rspBO.setRespCode("0000");
                            rspBO.setRespDesc("\u7528\u6237\u7684Occupation\u7f16\u7801\u4e3a\u7a7a");
                            rspBO.setRows(null);
                            rspBO.setPageNo(1);
                            rspBO.setTotal(0);
                            rspBO.setRecordsTotal(0);
                            return rspBO;
                        }
                        DycUmcQueryMaterialPermissionReqBo dycUmcQueryMaterialPermissionReqBo = new DycUmcQueryMaterialPermissionReqBo();
                        dycUmcQueryMaterialPermissionReqBo.setErpCode(reqBO.getOccupation());
                        dycUmcQueryMaterialPermissionReqBo.setNotTree("1");
                        DycUmcQueryMaterialPermissionRspBo dycUmcQueryMaterialPermissionRspBo = this.dycUmcQueryMaterialPermissionService.queryMaterialPermission(dycUmcQueryMaterialPermissionReqBo);
                        if (!"0000".equals(dycUmcQueryMaterialPermissionRspBo.getRespCode())) {
                            throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u7269\u6599\u6743\u9650\u5931\u8d25" + dycUmcQueryMaterialPermissionRspBo.getRespDesc());
                        }
                        List list = dycUmcQueryMaterialPermissionRspBo.getRows();
                        ArrayList arrayList = new ArrayList();
                        List<String> list3 = list.stream().filter(e -> !StringUtils.isEmpty((CharSequence)e.getCatalogCode())).map(DycUmcQueryMaterialPermissionBo::getCatalogCode).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(list3)) {
                            rspBO.setRespCode("0000");
                            rspBO.setRespDesc("\u7528\u6237\u7684\u7269\u6599\u6743\u9650\u4e3a\u7a7a");
                            rspBO.setRows(null);
                            rspBO.setPageNo(1);
                            rspBO.setTotal(0);
                            rspBO.setRecordsTotal(0);
                            return rspBO;
                        }
                        queryContractPo.setCatalogCodes(list3);
                        if (StringUtils.isEmpty((CharSequence)reqBO.getOccupation())) {
                            rspBO.setRespCode("0000");
                            rspBO.setRespDesc("\u7528\u6237\u7684Occupation\u7f16\u7801\u4e3a\u7a7a");
                            rspBO.setRows(null);
                            rspBO.setPageNo(1);
                            rspBO.setTotal(0);
                            rspBO.setRecordsTotal(0);
                            return rspBO;
                        }
                        dycUmcQueryMaterialPermissionReqBo = new DycUmcQueryOrgPermissionReqBo();
                        dycUmcQueryMaterialPermissionReqBo.setErpCode(reqBO.getOccupation());
                        dycUmcQueryMaterialPermissionRspBo = this.dycUmcQueryOrgPermissionService.queryOrgPermission((DycUmcQueryOrgPermissionReqBo)dycUmcQueryMaterialPermissionReqBo);
                        if (!"0000".equals(dycUmcQueryMaterialPermissionRspBo.getRespCode())) {
                            throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u5355\u4f4d\u6743\u9650\u5931\u8d25" + dycUmcQueryMaterialPermissionRspBo.getRespDesc());
                        }
                        List list4 = dycUmcQueryMaterialPermissionRspBo.getRows();
                        List<String> list5 = list4.stream().filter(e -> !StringUtils.isEmpty((CharSequence)e.getOrgCode())).map(DycUmcQueryOrgPermissionBo::getOrgCode).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(list5)) {
                            rspBO.setRespCode("0000");
                            rspBO.setRespDesc("\u7528\u6237\u7684\u5355\u4f4d\u6743\u9650\u4e3a\u7a7a");
                            rspBO.setRows(null);
                            rspBO.setPageNo(1);
                            rspBO.setTotal(0);
                            rspBO.setRecordsTotal(0);
                            return rspBO;
                        }
                        queryContractPo.setOrgCodes(list5);
                    }
                    contractTypes = new ArrayList();
                    contractTypes.add(20);
                    queryContractPo.setContractTypes(contractTypes);
                    queryContractPo.setPurchaseContractStatusList(queryContractPo.getContractStatusList());
                    queryContractPo.setContractStatusList(null);
                    queryContractPo.setIsUnitMenuFlag(null);
                } else {
                    if (StringUtils.isEmpty((CharSequence)reqBO.getUsername())) {
                        rspBO.setRespCode("0000");
                        rspBO.setRespDesc("\u7528\u6237\u7684username\u4e3a\u7a7a");
                        rspBO.setRows(null);
                        rspBO.setPageNo(1);
                        rspBO.setTotal(0);
                        rspBO.setRecordsTotal(0);
                        return rspBO;
                    }
                    contractTypes = new ArrayList<Integer>();
                    contractTypes.add(10);
                    queryContractPo.setContractTypes(contractTypes);
                    queryContractPo.setBuyerUserCode(reqBO.getUsername());
                    queryContractPo.setPurchaseContractStatusList(queryContractPo.getContractStatusList());
                    queryContractPo.setContractStatusList(null);
                    queryContractPo.setIsUnitMenuFlag(null);
                }
                queryContractPo.setBuyerNos(null);
            }
            if (reqBO.getPushErpFlag() != null && reqBO.getPushErpFlag() == 0) {
                ArrayList<Integer> excludePushErpStatusList = new ArrayList<Integer>();
                excludePushErpStatusList.add(ContractConstant.PushErpStatus.IN_SYNC);
                excludePushErpStatusList.add(ContractConstant.PushErpStatus.ALREADY_SYNC);
                queryContractPo.setExcludePushErpStatusList(excludePushErpStatusList);
                queryContractPo.setPushErpFlag(null);
            }
            log.info("-----------\u67e5\u8be2\u5408\u540c\u5217\u8868\u5165\u53c2\uff1a" + JSON.toJSONString((Object)queryContractPo));
            page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryByCondition(queryContractPo));
        }
        List<ContractListNewBO> rows = this.transContractResult(page.getResult());
        rows.forEach(contractListNewBO -> {
            this.dealData((ContractListNewBO)contractListNewBO);
            if (contractListNewBO.getTotalTaxAmount() != null) {
                contractListNewBO.setTotalTaxAmount(contractListNewBO.getTotalTaxAmount().setScale(2, 4));
            }
            if (contractListNewBO.getTotalAmountExcludingTax() != null) {
                contractListNewBO.setTotalAmountExcludingTax(contractListNewBO.getTotalAmountExcludingTax().setScale(2, 4));
            }
            if (contractListNewBO.getPurchaseTotalTaxAmount() != null) {
                contractListNewBO.setPurchaseTotalTaxAmount(contractListNewBO.getPurchaseTotalTaxAmount().setScale(2, 4));
            }
            if (contractListNewBO.getAmountLimit() != null) {
                contractListNewBO.setAmountLimit(MoneyUtils.haoToYuan(contractListNewBO.getAmountLimit()));
            }
            if (contractListNewBO.getOrderAmount() != null) {
                contractListNewBO.setOrderAmount(MoneyUtils.haoToYuan(contractListNewBO.getOrderAmount()));
            }
        });
        if (!CollectionUtils.isEmpty(rows)) {
            List<Long> orderIds = rows.stream().filter(e -> e.getOrderId() != null && e.getContractType() != null && e.getContractType().equals(ContractConstant.ContractType.ORDER_CONTRACT)).map(ContractListNewBO::getOrderId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(orderIds)) {
                CContractOrderInfoPO cContractOrderInfoPO = new CContractOrderInfoPO();
                cContractOrderInfoPO.setOrderIds(orderIds);
                List<CContractOrderInfoPO> list = this.cContractOrderInfoMapper.getList(cContractOrderInfoPO);
                if (!CollectionUtils.isEmpty(list)) {
                    Map<Long, CContractOrderInfoPO> orderIdMap = list.stream().collect(Collectors.toMap(CContractOrderInfoPO::getOrderId, e -> e));
                    for (ContractListNewBO e2 : rows) {
                        if (e2.getOrderId() == null || e2.getContractType() == null || !e2.getContractType().equals(ContractConstant.ContractType.ORDER_CONTRACT) || !orderIdMap.containsKey(e2.getOrderId())) continue;
                        CContractOrderInfoPO orderInfoPO = orderIdMap.get(e2.getOrderId());
                        BeanUtils.copyProperties((Object)orderInfoPO, (Object)e2);
                    }
                }
            }
            for (ContractListNewBO contractListNewBO2 : rows) {
                ContractInfoPO infoPO;
                if (contractListNewBO2.getContractType() == null || !contractListNewBO2.getContractType().equals(ContractConstant.ContractType.SALE_CONTRACT)) continue;
                CRelBuySaleContractPO po = new CRelBuySaleContractPO();
                po.setSaleContractId(contractListNewBO2.getContractId());
                List<CRelBuySaleContractPO> list = this.cRelBuySaleContractMapper.getList(po);
                if (CollectionUtils.isEmpty(list) || (infoPO = this.contractInfoMapper.selectByPrimaryKey(list.get(0).getBuyContractId())) == null) continue;
                contractListNewBO2.setPurchaseContractId(infoPO.getContractId());
                contractListNewBO2.setPurchaseContractCode(infoPO.getContractCode());
            }
        }
        if (!CollectionUtils.isEmpty(rows)) {
            this.setIsPushWms(rows);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNum());
        rspBO.setTotal(page.getPages());
        rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        return rspBO;
    }

    private void setIsPushWms(List<ContractListNewBO> rows) {
        List<Long> contractIds = rows.stream().filter(e -> e.getContractId() != null && ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(e.getContractType())).map(ContractListNewBO::getContractId).collect(Collectors.toList());
        Map<Object, Object> contractIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(contractIds)) {
            CContractInfoExtPO searchPO = new CContractInfoExtPO();
            searchPO.setRelateIds(contractIds);
            List<CContractInfoExtPO> list = this.cContractInfoExtMapper.getList(searchPO);
            if (!CollectionUtils.isEmpty(list)) {
                contractIdMap = list.stream().collect(Collectors.groupingBy(CContractInfoExtPO::getRelateId));
            }
        }
        for (ContractListNewBO row : rows) {
            if (!contractIdMap.containsKey(row.getContractId())) continue;
            CContractInfoExtPO cContractInfoExtBO = (CContractInfoExtPO)((List)contractIdMap.get(row.getContractId())).get(0);
            row.setIsPushWms(cContractInfoExtBO.getIsPushWms());
            row.setReplenishmentAuthority(cContractInfoExtBO.getReplenishmentAuthority());
            row.setSupRepLinkman(cContractInfoExtBO.getSupRepLinkman());
            row.setSupRepPhone(cContractInfoExtBO.getSupRepPhone());
            row.setSupRepBuyer(cContractInfoExtBO.getSupRepBuyer());
            row.setSupRepBuyerId(cContractInfoExtBO.getSupRepBuyerId());
            row.setSupRepBuyerCode(cContractInfoExtBO.getSupRepBuyerCode());
        }
    }

    protected void dealData(ContractListNewBO contractListNewBO) {
        ArrayList<Integer> executionStatus = new ArrayList<Integer>();
        ArrayList<String> executionStatusStr = new ArrayList<String>();
        if (contractListNewBO.getAmountLimit() != null && contractListNewBO.getOrderAmount() != null) {
            if (contractListNewBO.getOrderAmount().compareTo(contractListNewBO.getAmountLimit()) > 0) {
                executionStatus.add(ContractConstant.ExecutionStatus.EXECUTION_STATUS_CHAO);
                executionStatusStr.add("\u534f\u8bae\u6267\u884c\u989d\u5df2\u8d85");
            }
            if (contractListNewBO.getAmountLimit().multiply(new BigDecimal("0.7")).compareTo(contractListNewBO.getOrderAmount()) < 0) {
                executionStatus.add(ContractConstant.ExecutionStatus.EXECUTION_STATUS_DRAFT);
                executionStatusStr.add("\u534f\u8bae\u53ef\u6267\u884c\u4f59\u989d\u4e0d\u8db330%");
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 4);
        Date changeAfter = calendar.getTime();
        if (contractListNewBO.getContractValidTime() != null && new Date().before(contractListNewBO.getContractValidTime()) && changeAfter.after(contractListNewBO.getContractValidTime())) {
            executionStatus.add(ContractConstant.ExecutionStatus.EXECUTION_STATUS_NOT);
            executionStatusStr.add("\u534f\u8bae\u5230\u671f\u4e0d\u8db34\u6708");
        }
        contractListNewBO.setExecutionStatus(executionStatus);
        contractListNewBO.setExecutionStatusStr(executionStatusStr);
    }

    private List<ContractListNewBO> transContractResult(List<ContractInfoPO> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractListNewBO.class);
        for (ContractListNewBO contractListNewBO : rows) {
            contractListNewBO.setCreateTime(DateTimeUtils.Date2String(contractListNewBO.getCreateTime()));
            contractListNewBO.setContractApprovalTime(DateTimeUtils.Date2String(contractListNewBO.getContractApprovalTime()));
            if (contractListNewBO.getContractStatus() != null) {
                contractListNewBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListNewBO.getContractStatus()));
            }
            if (contractListNewBO.getPurchaseContractStatus() != null) {
                contractListNewBO.setPurchaseContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListNewBO.getPurchaseContractStatus()));
            }
            if (contractListNewBO.getContractType() != null) {
                contractListNewBO.setContractTypeStr(ContractTransFieldUtil.transContractType(contractListNewBO.getContractType()));
            }
            if (contractListNewBO.getPurchaseType() != null) {
                contractListNewBO.setPurchaseTypeStr(ContractTransFieldUtil.transContractPurchaseType(contractListNewBO.getPurchaseType()));
            }
            if (contractListNewBO.getPushErpStatus() != null) {
                contractListNewBO.setPushErpStatusStr(ContractTransFieldUtil.transPushErpStatus(contractListNewBO.getPushErpStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)contractListNewBO.getErpSyncStauts())) {
                contractListNewBO.setErpSyncStautsStr(ContractTransFieldUtil.transContractErpSyncStauts(contractListNewBO.getErpSyncStauts()));
            }
            if (contractListNewBO.getPushPlanStatus() != null) {
                contractListNewBO.setPushPlanStatusStr(ContractTransFieldUtil.transPushErpStatus(contractListNewBO.getPushPlanStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)contractListNewBO.getMaterialSource())) {
                contractListNewBO.setMaterialSourceStr(ContractTransFieldUtil.transContractMaterialSource(contractListNewBO.getMaterialSource()));
            }
            if (contractListNewBO.getBusinessType() != null) {
                contractListNewBO.setBusinessTypeStr(ContractTransFieldUtil.transBusinessType(contractListNewBO.getBusinessType()));
            }
            if (contractListNewBO.getArchiveStatus() != null) {
                ContractPushLogPO contractPushLogPO;
                contractListNewBO.setArchiveStatusStr(ContractConstant.ArchiveStatusEnum.getValueByCode(contractListNewBO.getArchiveStatus()));
                if (contractListNewBO.getArchiveStatus() == 2 && (contractPushLogPO = this.contractPushLogMapper.selectByTypeAndContractId("13", contractListNewBO.getContractId().toString())) != null) {
                    contractListNewBO.setArchiveFailStr(contractPushLogPO.getRspJson());
                }
            }
            if (contractListNewBO.getSignatureFlag() != null) {
                contractListNewBO.setSignatureFlagStr(contractListNewBO.getSignatureFlag() == 1 ? "\u662f" : "\u5426");
            }
            if (contractListNewBO.getEffectWay() == null) continue;
            contractListNewBO.setEffectWayStr(contractListNewBO.getEffectWay() == 0 ? "\u624b\u52a8\u751f\u6548" : "\u7535\u5b50\u7b7e\u7ae0");
        }
        return rows;
    }

    private List<Integer> transTabIdToContractStatus(Integer tabId) {
        ArrayList<Integer> contractStatusList = new ArrayList<Integer>();
        if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_NO_APPROVAL)) {
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
        } else if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_APPROVED)) {
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_ABOLISH);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN);
        } else if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_ALL)) {
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_ABOLISH);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN);
        } else {
            throw new ZTBusinessException("\u8f93\u5165\u7684\u9875\u7b7eid\u6709\u8bef");
        }
        return contractStatusList;
    }
}

