/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractRspBaseBO;
import com.tydic.contract.ability.bo.other.ContractSendLetterOfContractChangedBO;
import com.tydic.contract.atom.ContractSendNotificationExtAtomService;
import com.tydic.contract.atom.bo.ContractSendNotificationExtAtomReqBO;
import com.tydic.contract.busi.ContractSendLetterService;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.thread.SendNotificationRunnable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractSendLetterServiceImpl
implements ContractSendLetterService {
    private static final Logger log = LoggerFactory.getLogger(ContractSendLetterServiceImpl.class);
    @Autowired
    private ContractSendNotificationExtAtomService contractSendNotificationExtAtomService;
    @Autowired
    private ContractMapper contractMapper;

    @Override
    public ContractRspBaseBO sendLetterOfContractChangedNotify(ContractSendLetterOfContractChangedBO contractSendLetterOfContractChangedBO) {
        ContractRspBaseBO rspBaseBO = new ContractRspBaseBO();
        ArrayList<Long> userList = new ArrayList<Long>();
        try {
            if (contractSendLetterOfContractChangedBO == null) {
                throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<ContractSendNotificationExtAtomReqBO> sendNotifications = new ArrayList<ContractSendNotificationExtAtomReqBO>();
            String createUserId = this.contractMapper.selectContractUserId(contractSendLetterOfContractChangedBO.getContractId());
            if (createUserId == null || createUserId.trim().equals("")) {
                throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u63a5\u6536\u6d88\u606f\u7528\u6237");
            }
            ContractSendNotificationExtAtomReqBO bo = new ContractSendNotificationExtAtomReqBO();
            if (ContractConstant.SendType.OTHER.equals(contractSendLetterOfContractChangedBO.getSendType())) {
                bo.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u5408\u540c\u7f16\u7801:" + contractSendLetterOfContractChangedBO.getContractNo() + "\u53d1\u751f\u53d8\u66f4\uff0c\u7531\u4e8e\u5173\u8054\u7684\u96c6\u91c7\u5206\u7b7e\u534f\u8bae\u53d8\u66f4\uff08\u53d8\u66f4\u7533\u8bf7\u7f16\u53f7\uff1a" + contractSendLetterOfContractChangedBO.getChangeCode() + "\uff09\uff0c\u7cfb\u7edf\u5df2\u81ea\u52a8\u66f4\u65b0\u91c7\u8d2d\u6846\u67b6\u534f\u8bae\u7684\u76f8\u5173\u5b57\u6bb5\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u53d8\u66f4\u7ebf\u4e0b\u7eb8\u8d28\u5408\u540c");
                bo.setTitel("\u5408\u540c\u6709\u66f4\u65b0");
            } else {
                bo.setTitel("\u5173\u8054\u534f\u8bae\u7ec8\u6b62");
                bo.setText("\u60a8\u521b\u5efa\u7684\u91c7\u8d2d\u6846\u67b6\u534f\u8bae: " + contractSendLetterOfContractChangedBO.getContractNo() + "\u5173\u8054\u7684\u96c6\u91c7\u5206\u7b7e\u534f\u8bae:" + contractSendLetterOfContractChangedBO.getAgencyContractCode() + "\u5df2\u7ec8\u6b62\uff0c\u8bf7\u786e\u8ba4\u91c7\u8d2d\u6846\u67b6\u534f\u8bae\u72b6\u6001\u662f\u5426\u9700\u8981\u53d8\u66f4");
            }
            bo.setUserId(1L);
            userList.add(Long.valueOf(createUserId));
            bo.setReceiveIds(userList);
            if (bo.getText() != null) {
                sendNotifications.add(bo);
            }
            if (sendNotifications.size() > 0) {
                List<List<ContractSendNotificationExtAtomReqBO>> lists = SendNotificationRunnable.splitList(sendNotifications, 10);
                for (List<ContractSendNotificationExtAtomReqBO> list : lists) {
                    new SendNotificationRunnable(list, this.contractSendNotificationExtAtomService).run();
                }
            }
        }
        catch (Exception e) {
            rspBaseBO.setRespCode("8888");
            rspBaseBO.setRespDesc("\u53d1\u9001\u59d4\u6258\u4e66\u5df2\u7acb\u9879\u901a\u77e5\u5931\u8d25\uff0c" + e.getMessage());
            return rspBaseBO;
        }
        return rspBaseBO;
    }
}

